/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.net.security.AbstractEncryptionFilter;
import com.tangosol.run.xml.XmlElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

@Deprecated
public class SymmetricEncryptionFilter
extends AbstractEncryptionFilter {
    protected SecretKey m_key;
    public static final String DEFAULT_KEYSTORE_TYPE = "JCEKS";
    public static final String DEFAULT_ALGORITHM = "ARCFOUR";
    public static final int DEFAULT_KEY_LENGTH = 128;

    @Override
    public InputStream getInputStream(InputStream stream) {
        try {
            return new CipherInputStream(stream, this.getCipher(2, this.getKey()));
        }
        catch (Exception e) {
            throw SymmetricEncryptionFilter.ensureRuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream(OutputStream stream) {
        try {
            return new CipherOutputStream(stream, this.getCipher(1, this.getKey()));
        }
        catch (Exception e) {
            throw SymmetricEncryptionFilter.ensureRuntimeException(e);
        }
    }

    @Override
    public void setConfig(XmlElement xml) {
        String sAlias = xml.getSafeElement("keyAlias").getString();
        String sKeyPassword = xml.getSafeElement("keyPassword").getString();
        String sTrans = xml.getSafeElement("transformation").getString();
        String sStoreType = xml.getSafeElement("storeType").getString(DEFAULT_KEYSTORE_TYPE);
        String sStorePath = xml.getSafeElement("store").getString(".keystore");
        String sStorePassword = xml.getSafeElement("storePassword").getString(sKeyPassword);
        if (sAlias.length() == 0) {
            throw new IllegalArgumentException("keyAlias required");
        }
        if (sKeyPassword.length() == 0) {
            throw new IllegalArgumentException("keyPassword required");
        }
        char[] acKeyPassword = new char[sKeyPassword.length()];
        sKeyPassword.getChars(0, acKeyPassword.length, acKeyPassword, 0);
        char[] acStorePassword = new char[sStorePassword.length()];
        sStorePassword.getChars(0, acStorePassword.length, acStorePassword, 0);
        try {
            KeyStore keyStore = SymmetricEncryptionFilter.getKeyStore(sStoreType, sStorePath, acStorePassword);
            SecretKey key = (SecretKey)keyStore.getKey(sAlias, acKeyPassword);
            if (key == null) {
                throw new RuntimeException("key not found");
            }
            this.setKey(key);
            if (sTrans != null && sTrans.length() > 0) {
                this.setCipherTransformation(sTrans);
            }
        }
        catch (Exception e) {
            throw SymmetricEncryptionFilter.ensureRuntimeException(e, "Error reading " + sAlias + " from keystore: " + sStorePath);
        }
    }

    public void setKey(SecretKey key) {
        SymmetricEncryptionFilter.azzert(this.m_key == null, "key already specified");
        this.m_key = key;
        this.setCipherTransformation(key.getAlgorithm());
    }

    public SecretKey getKey() {
        return this.m_key;
    }

    public static SecretKey generateKey(String sAlgorithm, int nKeySize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(sAlgorithm);
            keyGenerator.init(nKeySize);
            return keyGenerator.generateKey();
        }
        catch (Exception e) {
            throw SymmetricEncryptionFilter.ensureRuntimeException(e);
        }
    }

    public static void main(String[] asArgv) {
        String sAlias;
        String sKeyPassword;
        String sHelp = "parameters: alias keyPassword [keyStorePath] [keyStorePassword] [algorithm] [keySize] [keyStoreType]";
        String sStorePassword = null;
        String sKeyStoreType = DEFAULT_KEYSTORE_TYPE;
        String sKeyStorePath = ".keystore";
        String sAlgorithm = DEFAULT_ALGORITHM;
        int nKeyLength = 128;
        switch (asArgv.length) {
            case 7: {
                sKeyStoreType = asArgv[6];
            }
            case 6: {
                nKeyLength = Integer.parseInt(asArgv[5]);
            }
            case 5: {
                sAlgorithm = asArgv[4];
            }
            case 4: {
                sStorePassword = asArgv[3];
            }
            case 3: {
                sKeyStorePath = asArgv[2];
            }
            case 1: 
            case 2: {
                sKeyPassword = asArgv[1];
                sAlias = asArgv[0];
                break;
            }
            default: {
                SymmetricEncryptionFilter.err(sHelp);
                return;
            }
        }
        if (sStorePassword == null) {
            sStorePassword = sKeyPassword;
        }
        char[] acKeyPassword = new char[sKeyPassword.length()];
        sKeyPassword.getChars(0, acKeyPassword.length, acKeyPassword, 0);
        char[] acStorePassword = new char[sStorePassword.length()];
        sStorePassword.getChars(0, acStorePassword.length, acStorePassword, 0);
        try {
            SymmetricEncryptionFilter.out(new File(sKeyStorePath).exists() ? "loading existing " : "creating new ");
            SymmetricEncryptionFilter.out(sKeyStoreType + " KeyStore \"" + sKeyStorePath + '\"');
            KeyStore keyStore = SymmetricEncryptionFilter.getKeyStore(sKeyStoreType, sKeyStorePath, acStorePassword);
            SymmetricEncryptionFilter.out("generating " + nKeyLength + " bit " + sAlgorithm + " key");
            SecretKey key = SymmetricEncryptionFilter.generateKey(sAlgorithm, nKeyLength);
            SymmetricEncryptionFilter.out("adding key under alias \"" + sAlias + '\"');
            keyStore.setKeyEntry(sAlias, key, acKeyPassword, null);
            SymmetricEncryptionFilter.out("saving KeyStore");
            FileOutputStream streamOut = new FileOutputStream(sKeyStorePath);
            keyStore.store(streamOut, acStorePassword);
            ((OutputStream)streamOut).close();
        }
        catch (Exception e) {
            SymmetricEncryptionFilter.err("Error while adding key to store: " + e);
            SymmetricEncryptionFilter.err(sHelp);
        }
    }
}

