/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.IterableAdapter;
import com.tangosol.run.xml.PropertyAdapter;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapAdapter
extends IterableAdapter {
    private Class m_clzMap;
    private PropertyAdapter m_adapterKey;
    private PropertyAdapter m_adapterValue;

    public MapAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
        MapAdapter.azzert(Map.class.isAssignableFrom(clzType));
        Class clzMap = this.getType();
        XmlElement xmlClz = xml.getElement("class");
        if (xmlClz != null) {
            clzMap = infoBean.resolveClass(xmlClz.getString());
        }
        this.m_clzMap = clzMap;
        this.m_adapterKey = this.findAdapter(infoBean, xml.findElement("element/key"));
        this.m_adapterValue = this.findAdapter(infoBean, xml.findElement("element/value"));
    }

    @Override
    public Object clone(Object o) {
        if (o == null) {
            return null;
        }
        PropertyAdapter adapterKey = this.m_adapterKey;
        PropertyAdapter adapterValue = this.m_adapterValue;
        Map mapOld = (Map)o;
        Map mapNew = this.instantiateMap();
        for (Map.Entry entry : mapOld.entrySet()) {
            Object oValue;
            Object oKey = entry.getKey();
            if (oKey != null) {
                oKey = adapterKey.clone(oKey);
            }
            if ((oValue = entry.getValue()) != null) {
                oValue = adapterValue.clone(oValue);
            }
            mapNew.put(oKey, oValue);
        }
        return mapNew;
    }

    @Override
    protected Object readElements(XmlElement xml) {
        String sElement = this.getElementName();
        if (sElement == null) {
            sElement = "entry";
        }
        PropertyAdapter adapterKey = this.m_adapterKey;
        PropertyAdapter adapterValue = this.m_adapterValue;
        Map map = this.instantiateMap();
        Iterator iter = XmlHelper.getElements(xml, sElement, this.getNamespaceUri());
        while (iter.hasNext()) {
            XmlElement xmlEntry = (XmlElement)iter.next();
            XmlElement xmlKey = adapterKey.findElement(xmlEntry);
            Object oKey = null;
            if (xmlKey != null) {
                oKey = adapterKey.fromXml(xmlKey);
            }
            XmlElement xmlValue = adapterValue.findElement(xmlEntry);
            Object oValue = null;
            if (xmlValue != null) {
                oValue = adapterValue.fromXml(xmlValue);
            }
            map.put(oKey, oValue);
        }
        return map;
    }

    @Override
    protected void writeElements(XmlElement xml, Object o) {
        String sElement = XmlHelper.getUniversalName(this.getElementName(), this.getNamespacePrefix());
        if (sElement == null) {
            sElement = "entry";
        }
        PropertyAdapter adapterKey = this.m_adapterKey;
        PropertyAdapter adapterValue = this.m_adapterValue;
        for (Map.Entry entry : ((Map)o).entrySet()) {
            Object oValue;
            XmlElement xmlEntry = xml.addElement(sElement);
            List list = xmlEntry.getElementList();
            Object oKey = entry.getKey();
            if (oKey != null) {
                list.add(adapterKey.toXml(oKey));
            }
            if ((oValue = entry.getValue()) == null) continue;
            list.add(adapterValue.toXml(oValue));
        }
    }

    @Override
    public Object readExternal(DataInput in) throws IOException {
        Map map = this.instantiateMap();
        PropertyAdapter adapterKey = this.getKeyAdapter();
        PropertyAdapter adapterVal = this.getValueAdapter();
        int c = MapAdapter.readInt(in);
        for (int i = 0; i < c; ++i) {
            Object oKey = in.readBoolean() ? adapterKey.readExternal(in) : null;
            Object oVal = in.readBoolean() ? adapterVal.readExternal(in) : null;
            map.put(oKey, oVal);
        }
        return map;
    }

    @Override
    public void writeExternal(DataOutput out, Object o) throws IOException {
        Map map = (Map)o;
        PropertyAdapter adapterKey = this.getKeyAdapter();
        PropertyAdapter adapterVal = this.getValueAdapter();
        int c = map.size();
        MapAdapter.writeInt(out, c);
        int cActual = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object oKey = entry.getKey();
            Object oVal = entry.getValue();
            boolean fExists = oKey != null;
            out.writeBoolean(fExists);
            if (fExists) {
                adapterKey.writeExternal(out, oKey);
            }
            fExists = oVal != null;
            out.writeBoolean(fExists);
            if (fExists) {
                adapterVal.writeExternal(out, oVal);
            }
            ++cActual;
        }
        if (c != cActual) {
            throw new IOException("expected " + c + " entries, but wrote " + cActual);
        }
    }

    @Override
    public boolean isEmpty(Object o) {
        return o == null || this.isEmptyIsNull() && ((Map)o).isEmpty();
    }

    public PropertyAdapter getKeyAdapter() {
        return this.m_adapterKey;
    }

    public PropertyAdapter getValueAdapter() {
        return this.m_adapterValue;
    }

    protected Map instantiateMap() {
        try {
            return (Map)this.m_clzMap.newInstance();
        }
        catch (Throwable e) {
            throw MapAdapter.ensureRuntimeException(e);
        }
    }
}

