/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleValue;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PropertyAdapter
extends ExternalizableHelper
implements Serializable {
    protected static final Class[] NOPARAMS = new Class[0];
    protected XmlBean.BeanInfo m_infoBean;
    protected String m_sName;
    protected String m_sXml;
    protected boolean m_fAttribute;
    protected Class m_clzType;
    protected Method m_methodGet;
    protected Method m_methodSet;
    protected Method m_methodClone;
    protected String m_sNmsUri;
    protected String m_sNmsPrefix;

    protected PropertyAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        this.m_infoBean = infoBean;
        this.m_sName = sName;
        this.m_clzType = clzType;
        this.m_sXml = sXml == null || sXml.length() == 0 ? null : sXml;
        this.m_fAttribute = "attribute".equals(xml.getSafeAttribute("type").getString());
        XmlElement xmlNms = xml.getElement("xmlns");
        if (xmlNms != null) {
            this.m_sNmsUri = xmlNms.getSafeElement("uri").getString(null);
            this.m_sNmsPrefix = xmlNms.getSafeElement("prefix").getString(null);
        } else {
            this.m_sNmsUri = infoBean.getNamespaceUri();
            this.m_sNmsPrefix = infoBean.getNamespacePrefix();
        }
        if (sName != null) {
            Class clzBean = infoBean.getType();
            try {
                Method methodGet = null;
                if (clzType == Boolean.TYPE) {
                    try {
                        methodGet = clzBean.getMethod("is" + sName, NOPARAMS);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (methodGet == null) {
                    try {
                        methodGet = clzBean.getMethod("get" + sName, NOPARAMS);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("Unable to find method " + (clzType == Boolean.TYPE ? "is" : "get") + sName + "()");
                    }
                }
                this.m_methodGet = methodGet;
                Class<?> clzGet = this.m_methodGet.getReturnType();
                if (!clzType.equals(clzGet)) {
                    if (clzType.isAssignableFrom(clzGet)) {
                        this.m_clzType = clzType = clzGet;
                    } else {
                        throw new RuntimeException("The property \"" + sName + "\" was specified to be of type \"" + clzType.getName() + "\" which is not assignment compatible with the " + "return type (\"" + clzGet.getName() + "\") of its accessor.");
                    }
                }
                try {
                    this.m_methodSet = clzBean.getMethod("set" + sName, clzType);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Unable to find method set" + sName + '(' + clzType.getName() + ')');
                }
                try {
                    int nModifiers;
                    Method methodClone = clzType.getMethod("clone", NOPARAMS);
                    if (methodClone != null && methodClone.getReturnType() == Object.class && Modifier.isPublic(nModifiers = methodClone.getModifiers()) && !Modifier.isStatic(nModifiers)) {
                        this.m_methodClone = methodClone;
                    }
                }
                catch (NoSuchMethodException e) {}
            }
            catch (Exception e) {
                throw PropertyAdapter.ensureRuntimeException(e);
            }
        }
    }

    public XmlBean.BeanInfo getBeanInfo() {
        return this.m_infoBean;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getLocalXmlName() {
        String sXml = this.m_sXml;
        return sXml == null ? "anonymous" : sXml;
    }

    public String getXmlName() {
        return XmlHelper.getUniversalName(this.getLocalXmlName(), this.getNamespacePrefix());
    }

    public boolean isElementMatch(XmlElement xml) {
        return XmlHelper.isElementMatch(xml, this.getLocalXmlName(), this.getNamespaceUri());
    }

    public XmlElement findElement(XmlElement xml) {
        return XmlHelper.getElement(xml, this.getLocalXmlName(), this.getNamespaceUri());
    }

    public Iterator getElements(XmlElement xml) {
        return XmlHelper.getElements(xml, this.getLocalXmlName(), this.getNamespaceUri());
    }

    public XmlValue findAttribute(XmlElement xml) {
        return XmlHelper.getAttribute(xml, this.getLocalXmlName(), this.getNamespaceUri());
    }

    public String getNamespaceUri() {
        return this.m_sNmsUri;
    }

    public String getNamespacePrefix() {
        return this.m_sNmsPrefix;
    }

    public void setNamespacePrefix(String sPrefix) {
        this.m_sNmsPrefix = sPrefix;
    }

    public Class getType() {
        return this.m_clzType;
    }

    public Method getAccessor() {
        return this.m_methodGet;
    }

    public Method getMutator() {
        return this.m_methodSet;
    }

    public Method getCloner() {
        return this.m_methodClone;
    }

    public boolean isAnonymous() {
        return this.m_sXml == null;
    }

    public boolean isAttribute() {
        return this.m_fAttribute;
    }

    public abstract boolean isCloneRequired();

    public Object get(XmlBean bean) {
        try {
            return this.getAccessor().invoke((Object)bean, (Object[])NOPARAMS);
        }
        catch (Exception e) {
            throw PropertyAdapter.ensureRuntimeException(e, "error invoking get" + this.getName() + "()");
        }
    }

    public boolean isEmpty(Object o) {
        return o == null;
    }

    public void set(XmlBean bean, Object o) {
        try {
            this.getMutator().invoke((Object)bean, o);
        }
        catch (Exception e) {
            throw PropertyAdapter.ensureRuntimeException(e, "error invoking set" + this.getName() + "()");
        }
    }

    public int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public boolean equalsValue(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        try {
            return o1.equals(o2);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public Object clone(Object o) {
        if (o == null) {
            return null;
        }
        if (!this.isCloneRequired()) {
            return o;
        }
        Method methodClone = this.getCloner();
        if (methodClone != null) {
            try {
                return methodClone.invoke(o, (Object[])NOPARAMS);
            }
            catch (Exception e) {
                throw PropertyAdapter.ensureRuntimeException(e);
            }
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object fromXml(XmlElement xml) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public XmlElement toXml(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readXml(XmlElement xml) {
        if (this.isAnonymous()) {
            return this.fromXml(xml);
        }
        if (this.isAttribute()) {
            XmlValue xmlValue = this.findAttribute(xml);
            if (xmlValue == null) {
                return null;
            }
            SimpleElement xmlStub = new SimpleElement("attribute");
            xmlStub.setString(xmlValue.getString());
            List list = xml.getElementList();
            list.add(xmlStub);
            try {
                Object object = this.fromXml(xmlStub);
                return object;
            }
            finally {
                list.remove(xmlStub);
            }
        }
        XmlElement xmlValue = this.findElement(xml);
        return xmlValue == null ? null : this.fromXml(xmlValue);
    }

    public void writeXml(XmlElement xml, Object o) {
        if (!this.isEmpty(o)) {
            XmlElement xmlValue = this.toXml(o);
            if (this.isAnonymous()) {
                if (xmlValue.getValue() != null) {
                    xml.setString(xmlValue.getString());
                }
                xml.getElementList().addAll(xmlValue.getElementList());
            } else if (this.isAttribute()) {
                xml.setAttribute(this.getLocalXmlName(), new SimpleValue(xmlValue.getString()));
                for (Map.Entry entry : xmlValue.getAttributeMap().entrySet()) {
                    String sAttr = (String)entry.getKey();
                    if (!sAttr.startsWith("xmlns:")) continue;
                    String sPrefix = sAttr.substring(6);
                    String sUri = ((XmlValue)entry.getValue()).getString();
                    XmlHelper.ensureNamespace(xml, sPrefix, sUri);
                }
            } else {
                xmlValue.setName(this.getXmlName());
                xml.getElementList().add(xmlValue);
                String sNmsPrefix = this.getNamespacePrefix();
                if (sNmsPrefix != null) {
                    XmlHelper.ensureNamespace(xml, sNmsPrefix, this.getNamespaceUri());
                    XmlHelper.purgeChildrenNamespace(xml);
                }
            }
        }
    }

    public Object fromUri(String sUri) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toUri(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object readExternal(DataInput in) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void writeExternal(DataOutput out, Object o) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassHelper.getSimpleName(this.getClass())).append(" for ").append(this.getName()).append(", type=").append(this.getType().getName()).append(", xml-name=").append(this.getLocalXmlName()).append(", NamespaceUri=").append(this.getNamespaceUri()).append(", NamespacePrefix=").append(this.getNamespacePrefix()).append(", isCloneRequired=").append(this.isCloneRequired()).append(", accessor=").append(this.getAccessor()).append(", mutator=").append(this.getMutator()).append(", cloner=").append(this.getCloner());
        return sb.toString();
    }
}

