/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import com.tangosol.util.WrapperException;

public abstract class AbstractLongArray
extends Base
implements LongArray {
    @Override
    public Object get(long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        if (iter.hasNext()) {
            Object o = iter.next();
            return iter.getIndex() == lIndex ? o : null;
        }
        return null;
    }

    @Override
    public long add(Object oValue) {
        long lIndex = this.getLastIndex() + 1L;
        this.set(lIndex, oValue);
        return lIndex;
    }

    @Override
    public boolean exists(long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        if (iter.hasNext()) {
            iter.next();
            return iter.getIndex() == lIndex;
        }
        return false;
    }

    @Override
    public Object remove(long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        if (iter.hasNext()) {
            Object o = iter.next();
            if (iter.getIndex() == lIndex) {
                iter.remove();
                return o;
            }
        }
        return null;
    }

    @Override
    public boolean contains(Object o) {
        LongArray.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!Base.equals(o, iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        LongArray.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public int getSize() {
        int cItems = 0;
        LongArray.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++cItems;
        }
        return cItems;
    }

    @Override
    public long getFirstIndex() {
        LongArray.Iterator iter = this.iterator();
        if (iter.hasNext()) {
            iter.next();
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public long getLastIndex() {
        LongArray.Iterator iter = this.reverseIterator();
        if (iter.hasNext()) {
            iter.next();
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public long indexOf(Object oValue) {
        return this.indexOf(oValue, this.getFirstIndex());
    }

    @Override
    public long indexOf(Object oValue, long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        while (iter.hasNext()) {
            if (!Base.equals(oValue, iter.next())) continue;
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(Object oValue) {
        return this.lastIndexOf(oValue, this.getLastIndex());
    }

    @Override
    public long lastIndexOf(Object oValue, long lIndex) {
        LongArray.Iterator iter = this.reverseIterator(lIndex);
        while (iter.hasNext()) {
            if (!Base.equals(oValue, iter.next())) continue;
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public String toString() {
        String sClass = this.getClass().getName();
        sClass = sClass.substring(sClass.lastIndexOf(46) + 1);
        StringBuffer sb = new StringBuffer();
        sb.append(sClass).append('{');
        boolean fFirst = true;
        LongArray.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(", ");
            }
            Object o = iter.next();
            sb.append('[').append(iter.getIndex()).append("]=").append(o);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LongArray) {
            LongArray that = (LongArray)o;
            if (this.getSize() == that.getSize()) {
                if (this.isEmpty()) {
                    return true;
                }
                LongArray.Iterator iterThis = this.iterator();
                LongArray.Iterator iterThat = that.iterator();
                while (iterThis.hasNext() && iterThat.hasNext()) {
                    if (Base.equals(iterThis.next(), iterThat.next()) && iterThis.getIndex() == iterThat.getIndex()) continue;
                    return false;
                }
                return iterThis.hasNext() == iterThat.hasNext();
            }
        }
        return false;
    }

    public int hashCode() {
        int nHash = 0;
        LongArray.Iterator iter = this.iterator();
        while (iter.hasNext()) {
            nHash += Base.hashCode(iter.next());
        }
        return nHash;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WrapperException(e);
        }
    }
}

