/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractLongArray;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class AbstractSparseArray
extends AbstractLongArray {
    protected Node m_head = null;
    protected int m_size = 0;

    @Override
    public Object get(long lIndex) {
        Node node = this.find(lIndex);
        return node == null ? null : node.getValue();
    }

    @Override
    public Object set(long lIndex, Object oValue) {
        Node node = this.findInsertionPoint(lIndex);
        if (node != null && node.key == lIndex) {
            return node.setValue(oValue);
        }
        this.balancedInsertion(node, this.instantiateNode(lIndex, oValue));
        return null;
    }

    @Override
    public boolean exists(long lIndex) {
        return this.find(lIndex) != null;
    }

    @Override
    public Object remove(long lIndex) {
        Node node = this.find(lIndex);
        if (node == null) {
            return null;
        }
        this.remove(node);
        return node.getValue();
    }

    @Override
    public void clear() {
        this.m_head = null;
        this.m_size = 0;
    }

    @Override
    public int getSize() {
        return this.m_size;
    }

    @Override
    public LongArray.Iterator iterator() {
        return this.instantiateCrawler(this.m_head, 0, true);
    }

    @Override
    public LongArray.Iterator iterator(long lIndex) {
        Node closest = null;
        Node current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                closest = current;
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return this.instantiateCrawler(current, 1, true);
        }
        return this.instantiateCrawler(closest, 1, true);
    }

    @Override
    public LongArray.Iterator reverseIterator() {
        return this.instantiateCrawler(this.m_head, 0, false);
    }

    @Override
    public LongArray.Iterator reverseIterator(long lIndex) {
        Node closest = null;
        Node current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                closest = current;
                current = current.right;
                continue;
            }
            return this.instantiateCrawler(current, 3, false);
        }
        return this.instantiateCrawler(closest, 3, false);
    }

    @Override
    public long getFirstIndex() {
        Node nodeCur = this.m_head;
        if (nodeCur == null) {
            return -1L;
        }
        Node nodeNext = nodeCur.left;
        while (nodeNext != null) {
            nodeCur = nodeNext;
            nodeNext = nodeCur.left;
        }
        return nodeCur.key;
    }

    @Override
    public long getLastIndex() {
        Node nodeCur = this.m_head;
        if (nodeCur == null) {
            return -1L;
        }
        Node nodeNext = nodeCur.right;
        while (nodeNext != null) {
            nodeCur = nodeNext;
            nodeNext = nodeCur.right;
        }
        return nodeCur.key;
    }

    @Override
    public Object clone() {
        AbstractSparseArray that = (AbstractSparseArray)super.clone();
        that.m_head = this.m_head == null ? null : (Node)this.m_head.clone();
        return that;
    }

    public void print() {
        if (this.m_head != null) {
            this.m_head.print();
        }
    }

    public void validate() {
        if (this.m_head == null) {
            AbstractSparseArray.azzert(this.m_size == 0);
        } else {
            AbstractSparseArray.azzert(this.m_head.parent == null);
            this.m_head.validate();
        }
    }

    protected Node find(long lIndex) {
        Node current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    protected void remove(Node node) {
        if (node.left == null || node.right == null) {
            Node child = node.left == null ? node.right : node.left;
            Node parent = this.replace(node, child);
            if (parent != null) {
                this.balancePostRemove(parent, node.key < parent.key);
            }
        } else {
            Node heir = node.right;
            while (heir.left != null) {
                heir = heir.left;
            }
            heir.balance = node.balance;
            if (heir.parent == node) {
                heir.adopt(node.left, true);
                this.replace(node, heir);
                this.balancePostRemove(heir, false);
            } else {
                heir.parent.adopt(heir.right, true);
                heir.adopt(node.left, true);
                heir.adopt(node.right, false);
                Node pruned = heir.parent;
                this.replace(node, heir);
                this.balancePostRemove(pruned, true);
            }
        }
        node.left = null;
        node.right = null;
        node.parent = null;
        --this.m_size;
    }

    protected Node replace(Node nodeA, Node nodeB) {
        Node parent = nodeA.parent;
        if (parent == null) {
            this.m_head = nodeB;
        } else if (parent.left == nodeA) {
            parent.left = nodeB;
        } else {
            parent.right = nodeB;
        }
        if (nodeB != null) {
            nodeB.parent = parent;
        }
        return parent;
    }

    protected Node rotate(Node node, boolean fLeft) {
        Node parent = node.parent;
        Node child = fLeft ? node.right : node.left;
        this.replace(child, fLeft ? child.left : child.right);
        child.adopt(node, fLeft);
        node.parent = parent;
        this.replace(node, child);
        node.parent = child;
        return node.parent;
    }

    protected Node doubleRotate(Node node, boolean fLeft) {
        this.rotate(fLeft ? node.right : node.left, !fLeft);
        return this.rotate(node, fLeft);
    }

    protected void adjustDoubleBalance(Node node, Node child, int iBal) {
        Node grand;
        Node node2 = grand = child == node.left ? child.right : child.left;
        if (grand.balance == 0) {
            child.balance = 0;
            node.balance = 0;
        } else if (grand.balance == iBal) {
            node.balance = -iBal;
            child.balance = 0;
        } else {
            node.balance = 0;
            child.balance = iBal;
        }
        grand.balance = 0;
    }

    protected Node findInsertionPoint(long lIndex) {
        Node node = this.m_head;
        if (node == null) {
            return null;
        }
        while (true) {
            long lCurr;
            if (lIndex > (lCurr = node.key)) {
                if (node.right == null) {
                    return node;
                }
                node = node.right;
                continue;
            }
            if (lIndex >= lCurr) break;
            if (node.left == null) {
                return node;
            }
            node = node.left;
        }
        return node;
    }

    protected void balancedInsertion(Node parent, Node child) {
        if (parent == null) {
            this.m_head = child;
            this.m_size = 1;
            return;
        }
        if (child.key < parent.key) {
            parent.adopt(child, true);
            --parent.balance;
        } else {
            parent.adopt(child, false);
            ++parent.balance;
        }
        ++this.m_size;
        block5: while (true) {
            switch (parent.balance) {
                case 0: {
                    return;
                }
                case -1: 
                case 1: {
                    child = parent;
                    parent = child.parent;
                    if (parent == null) {
                        return;
                    }
                    parent.balance = parent.balance + (parent.left == child ? -1 : 1);
                    continue block5;
                }
                case -2: 
                case 2: {
                    int iBal;
                    boolean fLeftChild = parent.left == child;
                    int n = iBal = fLeftChild ? -1 : 1;
                    if (child.balance == iBal) {
                        child.balance = 0;
                        parent.balance = 0;
                        this.rotate(parent, !fLeftChild);
                    } else {
                        this.adjustDoubleBalance(parent, child, iBal);
                        this.doubleRotate(parent, !fLeftChild);
                    }
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void balancePostRemove(Node pruned, boolean fPrunedLeft) {
        block5: while (true) {
            pruned.balance = pruned.balance + (fPrunedLeft ? 1 : -1);
            switch (pruned.balance) {
                case -1: 
                case 1: {
                    return;
                }
                case -2: 
                case 2: {
                    int iBal;
                    Node child;
                    if (fPrunedLeft) {
                        child = pruned.right;
                        iBal = -1;
                    } else {
                        child = pruned.left;
                        iBal = 1;
                    }
                    if (child.balance == -iBal) {
                        child.balance = 0;
                        pruned.balance = 0;
                        pruned = this.rotate(pruned, fPrunedLeft);
                    } else {
                        if (child.balance != iBal) {
                            pruned.balance = -iBal;
                            child.balance = iBal;
                            this.rotate(pruned, fPrunedLeft);
                            return;
                        }
                        this.adjustDoubleBalance(pruned, child, -iBal);
                        pruned = this.doubleRotate(pruned, fPrunedLeft);
                    }
                }
                case 0: {
                    if (pruned.parent == null) {
                        return;
                    }
                    fPrunedLeft = pruned.parent.left == pruned;
                    pruned = pruned.parent;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected abstract Node instantiateNode(long var1, Object var3);

    protected Crawler instantiateCrawler(Node head, int fromdir, boolean fForward) {
        return new Crawler(head, fromdir, fForward);
    }

    protected class Crawler
    implements LongArray.Iterator,
    Cloneable {
        protected static final int ABOVE = 0;
        protected static final int LEFT = 1;
        protected static final int SITTING = 2;
        protected static final int RIGHT = 3;
        protected Node current;
        protected int fromdir;
        protected boolean fForward;

        protected Crawler(Node head, int fromdir, boolean fForward) {
            this.current = head;
            this.fromdir = fromdir;
            this.fForward = fForward;
        }

        @Override
        public boolean hasNext() {
            if (this.fForward) {
                this.crawlForwardToNext();
            } else {
                this.crawlReverseToNext();
            }
            return this.current != null;
        }

        private void crawlForwardToNext() {
            if (this.current == null) {
                return;
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.left != null) {
                            this.current = this.current.left;
                            continue block6;
                        }
                        this.fromdir = 1;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        if (this.current.right != null) {
                            this.fromdir = 0;
                            this.current = this.current.right;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (this.current.parent != null) {
                            this.fromdir = this.current == this.current.parent.left ? 1 : 3;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = null;
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        private void crawlReverseToNext() {
            if (this.current == null) {
                return;
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.right != null) {
                            this.current = this.current.right;
                            continue block6;
                        }
                        this.fromdir = 3;
                    }
                    case 3: {
                        return;
                    }
                    case 2: {
                        if (this.current.left != null) {
                            this.fromdir = 0;
                            this.current = this.current.left;
                            continue block6;
                        }
                    }
                    case 1: {
                        if (this.current.parent != null) {
                            this.fromdir = this.current == this.current.parent.right ? 3 : 1;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = null;
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        @Override
        public Object next() {
            return this.nextNode().getValue();
        }

        @Override
        public long getIndex() {
            return this.currentNode().key;
        }

        @Override
        public Object getValue() {
            return this.currentNode().getValue();
        }

        @Override
        public Object setValue(Object oValue) {
            return this.currentNode().setValue(oValue);
        }

        @Override
        public void remove() {
            Node node = this.currentNode();
            if (this.hasNext()) {
                this.next();
                int n = this.fromdir = this.fForward ? 1 : 3;
            }
            if (!node.isLinked() && AbstractSparseArray.this.m_head != node) {
                throw new IllegalStateException("the node has already been removed");
            }
            AbstractSparseArray.this.remove(node);
        }

        public String toString() {
            String key = String.valueOf(this.current.key);
            switch (this.fromdir) {
                case 0: {
                    return "crawled into " + key;
                }
                case 1: {
                    return "returned to " + key + " from the left child";
                }
                case 2: {
                    return "sitting in " + key;
                }
                case 3: {
                    return "returned to " + key + " from the right child";
                }
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        protected Node nextNode() {
            if (this.fForward) {
                this.crawlForwardToNext();
            } else {
                this.crawlReverseToNext();
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.fromdir = 2;
            return this.current;
        }

        protected Node currentNode() {
            Node node = this.current;
            if (node == null || this.fromdir != 2) {
                throw new IllegalStateException();
            }
            return node;
        }
    }

    protected static abstract class Node
    implements Cloneable,
    Serializable {
        protected long key;
        protected Node parent;
        protected Node left;
        protected Node right;
        protected int balance;

        protected Node() {
        }

        protected void adopt(Node child, boolean fLeft) {
            if (fLeft) {
                this.left = child;
            } else {
                this.right = child;
            }
            if (child != null) {
                child.parent = this;
            }
        }

        public abstract Object getValue();

        public abstract Object setValue(Object var1);

        public String toString() {
            return (this.left == null ? "" : this.left.toString() + ',') + this.key + (this.right == null ? "" : ',' + this.right.toString());
        }

        public Object clone() {
            try {
                Node right;
                Node that = (Node)super.clone();
                that.key = this.key;
                that.balance = this.balance;
                that.setValue(this.getValue());
                Node left = this.left;
                if (left != null) {
                    that.left = left = (Node)left.clone();
                    left.parent = that;
                }
                if ((right = this.right) != null) {
                    that.right = right = (Node)right.clone();
                    right.parent = that;
                }
                return that;
            }
            catch (CloneNotSupportedException e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeLong(this.key);
            out.writeByte(this.balance);
            out.writeObject(this.getValue());
            boolean fLeft = this.left != null;
            out.writeBoolean(fLeft);
            if (fLeft) {
                out.writeObject(this.left);
            }
            boolean fRight = this.right != null;
            out.writeBoolean(fRight);
            if (fRight) {
                out.writeObject(this.right);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.key = in.readLong();
            this.balance = in.readByte();
            this.setValue(in.readObject());
            if (in.readBoolean()) {
                this.left = (Node)in.readObject();
                this.left.parent = this;
            }
            if (in.readBoolean()) {
                this.right = (Node)in.readObject();
                this.right.parent = this;
            }
        }

        protected boolean isLeaf() {
            return this.left == null || this.right == null;
        }

        protected boolean isLinked() {
            return this.parent != null || this.left != null || this.right != null;
        }

        protected void print() {
            Base.out(this.key + ", balance " + this.balance + ", left " + (this.left == null ? "-" : Long.toString(this.left.key)) + ", right " + (this.right == null ? "-" : Long.toString(this.right.key)) + ", parent " + (this.parent == null ? "-" : Long.toString(this.parent.key)));
            if (this.left != null) {
                this.left.print();
            }
            if (this.right != null) {
                this.right.print();
            }
        }

        protected int validate() {
            int nLeft = 0;
            if (this.left != null) {
                Base.azzert(this.left.parent == this);
                Base.azzert(this.left.key < this.key);
                nLeft = this.left.validate();
            }
            int nRight = 0;
            if (this.right != null) {
                Base.azzert(this.right.parent == this);
                Base.azzert(this.right.key > this.key);
                nRight = this.right.validate();
            }
            Base.azzert(nRight - nLeft == this.balance);
            Base.azzert(Math.abs(this.balance) <= 1);
            return Math.max(nRight, nLeft) + 1;
        }
    }
}

