/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.WriteBuffer;
import com.tangosol.util.AbstractByteSequence;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.AbstractStableIterator;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.NullFilter;
import com.tangosol.util.NullImplementation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinaryRadixTree {
    private Node m_nodeRoot;
    private int m_cKeys;

    public BinaryRadixTree() {
        this.clear();
    }

    public long get(Binary binKey) {
        long lValue = this.m_nodeRoot.findValue(binKey, 0);
        return lValue;
    }

    public void put(Binary binKey, long lValue) {
        if (lValue == 0L) {
            this.remove(binKey);
        } else if (this.m_nodeRoot.modifyValue(binKey, 0, 0L, lValue, true)) {
            ++this.m_cKeys;
        }
        assert (this.m_nodeRoot.check());
    }

    public boolean putIfAbsent(Binary binKey, long lValue) {
        boolean fAdded;
        boolean bl = fAdded = lValue != 0L && this.m_nodeRoot.modifyValue(binKey, 0, 0L, lValue, false);
        if (fAdded) {
            ++this.m_cKeys;
        }
        assert (this.m_nodeRoot.check());
        return fAdded;
    }

    public boolean replace(Binary binKey, long lValueOld, long lValueNew) {
        if (lValueOld == 0L) {
            return this.putIfAbsent(binKey, lValueNew);
        }
        if (lValueNew == 0L) {
            return this.remove(binKey, lValueOld);
        }
        boolean fReplaced = this.m_nodeRoot.modifyValue(binKey, 0, lValueOld, lValueNew, false);
        assert (this.m_nodeRoot.check());
        return fReplaced;
    }

    public void remove(Binary binKey) {
        if (this.m_nodeRoot.removeValue(binKey, 0, 0L, true)) {
            --this.m_cKeys;
        }
        assert (this.m_nodeRoot.check());
    }

    public boolean remove(Binary binKey, long lValue) {
        boolean fRemoved;
        boolean bl = fRemoved = lValue != 0L && this.m_nodeRoot.removeValue(binKey, 0, lValue, false);
        if (fRemoved) {
            --this.m_cKeys;
        }
        assert (this.m_nodeRoot.check());
        return fRemoved;
    }

    public void clear() {
        this.m_nodeRoot = new SimpleParentValueNode(null, Binary.NO_BINARY, 0L);
        this.m_cKeys = 0;
    }

    public int size() {
        return this.m_cKeys;
    }

    public Iterator<Binary> keys() {
        return this.size() == 0 ? NullImplementation.getIterator() : new AllKeyIterator();
    }

    public Iterator<Binary> findAll(long lMask, long lValue) {
        return this.size() == 0 ? NullImplementation.getIterator() : new FilteredIterator(lMask, lValue);
    }

    public void internKeys(byte[][] aab) {
        this.m_nodeRoot.dedupe(aab);
        assert (this.m_nodeRoot.check());
    }

    private static class CompactLeafNode
    extends LeafNode {
        private long m_lBytes;

        public CompactLeafNode(Node nodeParent, ByteSequence seq, long lValue) {
            super(nodeParent, lValue);
            int cb = seq.length();
            assert (cb <= 7);
            long lBytes = (long)cb << 56;
            for (int of = 0; of < cb; ++of) {
                lBytes |= (long)(seq.byteAt(of) & 0xFF) << (of << 3);
            }
            this.m_lBytes = lBytes;
        }

        @Override
        public byte getFirstByte() {
            return (byte)((int)this.m_lBytes & 0xFF);
        }

        @Override
        public int length() {
            return (int)(this.m_lBytes >>> 56);
        }

        @Override
        public byte byteAt(int of) {
            long lBytes = this.m_lBytes;
            int cb = (int)(lBytes >>> 56);
            if (of >= cb) {
                throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb);
            }
            return (byte)((int)(lBytes >>> (of << 3)) & 0xFF);
        }

        @Override
        protected void appendBytesTo(WriteBuffer.BufferOutput out) throws IOException {
            int cb = this.length();
            long lBytes = this.m_lBytes;
            for (int of = 0; of < cb; ++of) {
                out.write((int)lBytes);
                lBytes >>>= 8;
            }
        }
    }

    private static class SimpleLeafNode
    extends LeafNode {
        private byte[] m_ab;

        public SimpleLeafNode(Node nodeParent, ByteSequence seq, long lValue) {
            super(nodeParent, lValue);
            int cb = seq.length();
            byte[] ab = new byte[cb];
            for (int of = 0; of < cb; ++of) {
                ab[of] = seq.byteAt(of);
            }
            this.m_ab = ab;
        }

        @Override
        public int length() {
            return this.m_ab.length;
        }

        @Override
        public byte byteAt(int of) {
            return this.m_ab[of];
        }

        @Override
        protected byte[] getByteArray() {
            return this.m_ab;
        }

        @Override
        protected void setByteArray(byte[] ab) {
            this.m_ab = ab;
        }

        @Override
        protected void appendBytesTo(WriteBuffer.BufferOutput out) throws IOException {
            out.write(this.m_ab);
        }
    }

    private static abstract class LeafNode
    extends Node {
        private long m_lValue;

        protected LeafNode(Node nodeParent, long lValue) {
            super(nodeParent);
            this.m_lValue = lValue;
        }

        public static LeafNode instantiateLeaf(Node nodeParent, ByteSequence seq, long lValue) {
            return seq.length() <= 7 ? new CompactLeafNode(nodeParent, seq, lValue) : new SimpleLeafNode(nodeParent, seq, lValue);
        }

        @Override
        public long getValue() {
            return this.m_lValue;
        }

        @Override
        public Node setValue(long lValue) {
            this.m_lValue = lValue;
            return this;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public Node getChild(byte b) {
            return null;
        }

        @Override
        public Iterator<Node> iterateChildren() {
            return NullImplementation.getIterator();
        }

        @Override
        public Node addChild(Node node) {
            ParentNode that = ParentNode.instantiateParent(this.getParent(), this, this.getValue());
            this.replaceSelf(that);
            ((Node)that).addChild(node);
            return that;
        }

        @Override
        public Node replaceChild(Node nodeOld, Node nodeNew) {
            throw new IllegalArgumentException("child=" + nodeOld);
        }

        @Override
        public Node removeChild(Node node) {
            throw new IllegalArgumentException("child=" + node);
        }
    }

    private static class CompactParentValueNode
    extends CompactParentNode {
        private long m_lValue;

        public CompactParentValueNode(Node nodeParent, ByteSequence seq, long lValue) {
            super(nodeParent, seq);
            this.m_lValue = lValue;
        }

        public CompactParentValueNode(CompactParentNode that, long lValue) {
            super(that);
            this.m_lValue = lValue;
        }

        @Override
        public long getValue() {
            return this.m_lValue;
        }

        @Override
        public Node setValue(long lValue) {
            this.m_lValue = lValue;
            return this;
        }
    }

    private static class CompactParentNode
    extends ParentNode {
        private long m_lBytes;

        public CompactParentNode(Node nodeParent, ByteSequence seq) {
            super(nodeParent);
            int cb = seq.length();
            assert (cb <= 6);
            long lBytes = (long)cb << 60;
            for (int of = 0; of < cb; ++of) {
                lBytes |= (long)(seq.byteAt(of) & 0xFF) << (of << 3);
            }
            this.m_lBytes = lBytes;
        }

        protected CompactParentNode(CompactParentNode that) {
            super(that.getParent(), that);
            this.m_lBytes = that.m_lBytes;
        }

        @Override
        public byte getFirstByte() {
            return (byte)((int)this.m_lBytes & 0xFF);
        }

        @Override
        public int length() {
            return (int)(this.m_lBytes >>> 60);
        }

        @Override
        public byte byteAt(int of) {
            long lBytes = this.m_lBytes;
            int cb = this.length();
            if (of >= cb) {
                throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb);
            }
            return (byte)((int)(lBytes >>> (of << 3)) & 0xFF);
        }

        @Override
        public Node setValue(long lValue) {
            return this.replaceSelf(new CompactParentValueNode(this, lValue));
        }

        @Override
        public int getChildCount() {
            return (int)(this.m_lBytes >>> 48) & 0xFFF;
        }

        @Override
        protected void setChildCount(int cChildren) {
            this.m_lBytes = (long)(cChildren & 0xFFF) << 48 | this.m_lBytes & 0xF000FFFFFFFFFFFFL;
        }

        @Override
        protected void appendBytesTo(WriteBuffer.BufferOutput out) throws IOException {
            int cb = this.length();
            long lBytes = this.m_lBytes;
            for (int of = 0; of < cb; ++of) {
                out.write((int)lBytes);
                lBytes >>>= 8;
            }
        }
    }

    private static class SimpleParentValueNode
    extends SimpleParentNode {
        private long m_lValue;

        public SimpleParentValueNode(Node nodeParent, ByteSequence seq, long lValue) {
            super(nodeParent, seq);
            this.m_lValue = lValue;
        }

        public SimpleParentValueNode(SimpleParentNode that, long lValue) {
            super(that);
            this.m_lValue = lValue;
        }

        @Override
        public long getValue() {
            return this.m_lValue;
        }

        @Override
        public Node setValue(long lValue) {
            this.m_lValue = lValue;
            return this;
        }
    }

    private static class SimpleParentNode
    extends ParentNode {
        private byte[] m_ab;
        private short m_cChildren;

        public SimpleParentNode(Node nodeParent, ByteSequence seq) {
            super(nodeParent);
            int cb = seq.length();
            byte[] ab = new byte[cb];
            for (int of = 0; of < cb; ++of) {
                ab[of] = seq.byteAt(of);
            }
            this.m_ab = ab;
        }

        protected SimpleParentNode(SimpleParentNode that) {
            super(that.getParent());
            this.m_ab = that.m_ab;
            this.m_cChildren = that.m_cChildren;
        }

        @Override
        public int length() {
            return this.m_ab.length;
        }

        @Override
        public byte byteAt(int of) {
            return this.m_ab[of];
        }

        @Override
        protected byte[] getByteArray() {
            return this.m_ab;
        }

        @Override
        protected void setByteArray(byte[] ab) {
            this.m_ab = ab;
        }

        @Override
        public Node setValue(long lValue) {
            return this.replaceSelf(new SimpleParentValueNode(this, lValue));
        }

        @Override
        public int getChildCount() {
            return this.m_cChildren;
        }

        @Override
        protected void setChildCount(int cChildren) {
            this.m_cChildren = (short)cChildren;
        }

        @Override
        protected void appendBytesTo(WriteBuffer.BufferOutput out) throws IOException {
            out.write(this.m_ab);
        }
    }

    private static abstract class ParentNode
    extends Node {
        private Node[] m_anodeChildren = new Node[4];

        protected ParentNode(Node nodeParent) {
            super(nodeParent);
        }

        protected ParentNode(Node nodeParent, ParentNode that) {
            this(nodeParent);
            this.m_anodeChildren = that.m_anodeChildren;
        }

        public static ParentNode instantiateParent(Node nodeParent, ByteSequence seq, long lValue) {
            if (seq.length() <= 6) {
                return lValue == 0L ? new CompactParentNode(nodeParent, seq) : new CompactParentValueNode(nodeParent, seq, lValue);
            }
            return lValue == 0L ? new SimpleParentNode(nodeParent, seq) : new SimpleParentValueNode(nodeParent, seq, lValue);
        }

        @Override
        public abstract int getChildCount();

        protected abstract void setChildCount(int var1);

        @Override
        public Node getChild(byte b) {
            Node[] anode = this.m_anodeChildren;
            int cNodes = anode.length;
            if (cNodes == 256) {
                return anode[b & 0xFF];
            }
            int iNode = this.findChildIndex(b);
            return iNode < 0 ? null : anode[iNode];
        }

        @Override
        public Iterator<Node> iterateChildren() {
            return new FilterEnumerator(this.m_anodeChildren, (Filter)NullFilter.getInstance());
        }

        @Override
        public Node addChild(Node node) {
            int bNode = node.getFirstByte() & 0xFF;
            Node[] anode = this.m_anodeChildren;
            int cElements = anode.length;
            int cNodes = this.getChildCount();
            if (cElements == 256) {
                assert (anode[bNode] == null);
                anode[bNode] = node;
            } else if (cNodes >= cElements) {
                assert (cElements < 256);
                int cElementsNew = cElements * 2;
                Node[] anodeNew = new Node[cElementsNew];
                if (cElementsNew == 256) {
                    for (int iElement = 0; iElement < cElements; ++iElement) {
                        Node nodeCopy = anode[iElement];
                        int bNodeCopy = nodeCopy.getFirstByte() & 0xFF;
                        assert (anodeNew[bNodeCopy] == null);
                        anodeNew[bNodeCopy] = nodeCopy;
                    }
                    assert (anodeNew[bNode] == null);
                    anodeNew[bNode] = node;
                } else {
                    boolean fInserted = false;
                    int iFrom = 0;
                    int iTo = 0;
                    while (iFrom < cElements) {
                        Node nodeCopy = anode[iFrom];
                        if (!fInserted && (nodeCopy.getFirstByte() & 0xFF) >= bNode) {
                            assert ((nodeCopy.getFirstByte() & 0xFF) != bNode);
                            anodeNew[iTo++] = node;
                            fInserted = true;
                        }
                        anodeNew[iTo] = nodeCopy;
                        ++iFrom;
                        ++iTo;
                    }
                    if (!fInserted) {
                        anodeNew[cElements] = node;
                    }
                }
                this.m_anodeChildren = anodeNew;
            } else {
                int iLow = 0;
                int iHigh = cNodes - 1;
                int iIns = 0;
                while (iLow <= iHigh) {
                    int iRoot = iLow + iHigh >> 1;
                    Node nodeRoot = anode[iRoot];
                    int bRoot = nodeRoot.getFirstByte() & 0xFF;
                    assert (bRoot != bNode);
                    if (bNode < bRoot) {
                        iHigh = iRoot - 1;
                        continue;
                    }
                    iIns = iLow = iRoot + 1;
                }
                if (iIns < cNodes) {
                    System.arraycopy(anode, iIns, anode, iIns + 1, cNodes - iIns);
                }
                anode[iIns] = node;
            }
            Node nodeOldParent = node.getParent();
            if (nodeOldParent != this) {
                node.replaceParent(nodeOldParent, this);
            }
            this.setChildCount(cNodes + 1);
            return this;
        }

        @Override
        public Node replaceChild(Node nodeOld, Node nodeNew) {
            byte b = nodeOld.getFirstByte();
            assert (b == nodeNew.getFirstByte());
            int iNode = this.findChildIndex(b);
            assert (iNode >= 0);
            Node[] anode = this.m_anodeChildren;
            assert (anode[iNode] == nodeOld);
            anode[iNode] = nodeNew;
            return this;
        }

        @Override
        public Node removeChild(Node node) {
            byte b = node.getFirstByte();
            int iNode = this.findChildIndex(b);
            assert (iNode >= 0);
            Node[] anode = this.m_anodeChildren;
            assert (anode[iNode] == node);
            int cElements = anode.length;
            if (cElements == 256) {
                anode[iNode] = null;
            } else {
                int iLast = cElements - 1;
                if (iNode < iLast) {
                    System.arraycopy(anode, iNode + 1, anode, iNode, iLast - iNode);
                }
                anode[iLast] = null;
            }
            this.setChildCount(this.getChildCount() - 1);
            return this;
        }

        protected int findChildIndex(byte b) {
            Node[] anode = this.m_anodeChildren;
            int cNodes = anode.length;
            int bNode = b & 0xFF;
            if (cNodes == 256) {
                return anode[bNode] == null ? -1 : bNode;
            }
            int iLow = 0;
            int iHigh = this.getChildCount() - 1;
            while (iLow <= iHigh) {
                int iRoot = iLow + iHigh >> 1;
                Node nodeRoot = anode[iRoot];
                int bRoot = nodeRoot.getFirstByte() & 0xFF;
                if (bRoot == bNode) {
                    return iRoot;
                }
                if (bNode < bRoot) {
                    iHigh = iRoot - 1;
                    continue;
                }
                iLow = iRoot + 1;
            }
            return -1;
        }

        @Override
        public boolean check() {
            boolean fSuccess = true;
            try {
                Node[] anode = this.m_anodeChildren;
                int cChildren = 0;
                Iterator<Node> iter = this.iterateChildren();
                int c = anode.length;
                int bPrev = -1;
                for (int i = 0; i < c; ++i) {
                    int bChild;
                    Node node = anode[i];
                    if (node == null) continue;
                    ++cChildren;
                    if (node != iter.next()) {
                        Base.out("iterator mismatch: " + this.toDebugString());
                        fSuccess = false;
                    }
                    if ((bChild = node.getFirstByte() & 0xFF) <= bPrev) {
                        Base.out("child starting with byte " + bChild + " out of order: " + this.toDebugString());
                        fSuccess = false;
                    }
                    bPrev = bChild;
                }
                if (iter.hasNext()) {
                    Base.out("iterator mismatch: " + this.toDebugString());
                    fSuccess = false;
                }
                if (cChildren != this.getChildCount()) {
                    Base.out("count mismatch: actual=" + cChildren + ", ChildCount=" + this.getChildCount());
                    fSuccess = false;
                }
                fSuccess &= super.check();
            }
            catch (Exception e) {
                Base.out(e);
                fSuccess = false;
            }
            return fSuccess;
        }
    }

    private static abstract class Node
    extends AbstractByteSequence {
        private Node m_nodeParent;

        protected Node(Node nodeParent) {
            this.m_nodeParent = nodeParent;
        }

        public long findValue(Binary binKey, int ofKey) {
            int cbThis = this.length();
            int cbKey = binKey.length() - ofKey;
            assert (cbKey >= 0);
            if (cbThis > cbKey || cbKey > cbThis && !this.hasChildren()) {
                return 0L;
            }
            for (int of = 0; of < cbThis; ++of) {
                if (binKey.byteAt(ofKey + of) == this.byteAt(of)) continue;
                return 0L;
            }
            if (cbThis == cbKey) {
                return this.getValue();
            }
            int ofNext = ofKey + cbThis;
            Node nodeChild = this.getChild(binKey.byteAt(ofNext));
            return nodeChild == null ? 0L : nodeChild.findValue(binKey, ofNext);
        }

        public boolean modifyValue(Binary binKey, int ofKey, long lValueOld, long lValueNew, boolean fForce) {
            int cbThis = this.length();
            int cbKey = binKey.length() - ofKey;
            assert (cbKey >= 0);
            int cb = Math.min(cbThis, cbKey);
            for (int of = 0; of < cb; ++of) {
                if (binKey.byteAt(ofKey + of) == this.byteAt(of)) continue;
                if (fForce || lValueOld == 0L) {
                    Node that = this.split(of, 0L);
                    that.addChild(LeafNode.instantiateLeaf(that, binKey.toBinary(ofKey + of, cbKey - of), lValueNew));
                    return true;
                }
                return false;
            }
            if (cbKey == cbThis) {
                long lValuePrev = this.getValue();
                if (fForce || lValueOld == lValuePrev) {
                    this.setValue(lValueNew);
                    return !fForce || lValuePrev == 0L;
                }
                return false;
            }
            if (cbThis > cbKey) {
                if (fForce || lValueOld == 0L) {
                    this.split(cb, lValueNew);
                    return true;
                }
                return false;
            }
            int ofNext = ofKey + cbThis;
            Node nodeChild = this.getChild(binKey.byteAt(ofNext));
            if (nodeChild == null) {
                if (fForce || lValueOld == 0L) {
                    this.addChild(LeafNode.instantiateLeaf(this, binKey.getReadBuffer(ofNext, cbKey - cbThis), lValueNew));
                    return true;
                }
                return false;
            }
            return nodeChild.modifyValue(binKey, ofNext, lValueOld, lValueNew, fForce);
        }

        public boolean removeValue(Binary binKey, int ofKey, long lValue, boolean fForce) {
            int cbThis = this.length();
            int cbKey = binKey.length() - ofKey;
            assert (cbKey >= 0);
            if (cbThis > cbKey || cbKey > cbThis && !this.hasChildren()) {
                return false;
            }
            for (int of = 0; of < cbThis; ++of) {
                if (binKey.byteAt(ofKey + of) == this.byteAt(of)) continue;
                return false;
            }
            if (cbThis == cbKey) {
                if (fForce || lValue == this.getValue()) {
                    if (this.hasChildren()) {
                        if (this.getValue() != 0L) {
                            this.setValue(0L);
                        }
                        if (this.getChildCount() == 1) {
                            this.merge(this.iterateChildren().next());
                        }
                    } else {
                        this.getParent().removeChild(this);
                    }
                    return true;
                }
                return false;
            }
            int ofNext = ofKey + cbThis;
            Node nodeChild = this.getChild(binKey.byteAt(ofNext));
            return nodeChild == null ? false : nodeChild.removeValue(binKey, ofNext, lValue, fForce);
        }

        public Node getParent() {
            return this.m_nodeParent;
        }

        public void replaceParent(Node nodeOldParent, Node nodeNewParent) {
            assert (this.getParent() == nodeOldParent);
            this.m_nodeParent = nodeNewParent;
        }

        public byte getFirstByte() {
            return this.byteAt(0);
        }

        @Override
        public abstract int length();

        @Override
        public abstract byte byteAt(int var1);

        public void dedupe(byte[][] aab) {
            int nHash;
            byte[] abPrev;
            byte[] ab = this.getByteArray();
            if (ab != null && (abPrev = aab[nHash = (int)(((long)Base.toCrc(ab) & 0xFFFFFFFFL) % (long)aab.length)]) != ab) {
                if (abPrev == null) {
                    aab[nHash] = ab;
                } else {
                    int cb = ab.length;
                    int cbPrev = abPrev.length;
                    if (cb == cbPrev && Binary.equals(ab, 0, abPrev, 0, cb)) {
                        this.setByteArray(abPrev);
                    }
                }
            }
            if (this.hasChildren()) {
                Iterator<Node> iter = this.iterateChildren();
                while (iter.hasNext()) {
                    iter.next().dedupe(aab);
                }
            }
        }

        protected byte[] getByteArray() {
            return null;
        }

        protected void setByteArray(byte[] ab) {
            throw new UnsupportedOperationException();
        }

        public long getValue() {
            return 0L;
        }

        public abstract Node setValue(long var1);

        public boolean hasChildren() {
            return this.getChildCount() > 0;
        }

        public abstract int getChildCount();

        public abstract Node getChild(byte var1);

        public abstract Iterator<Node> iterateChildren();

        public abstract Node addChild(Node var1);

        public abstract Node replaceChild(Node var1, Node var2);

        public abstract Node removeChild(Node var1);

        @Override
        public Binary toBinary() {
            return this.populateBinaryWriteBuffer(0).getBuffer().toBinary();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(ClassHelper.getSimpleName(this.getClass())).append("{").append(super.toString());
            sb.append(", ChildCount=").append(this.getChildCount()).append(", Value=").append(this.getValue()).append("}");
            return sb.toString();
        }

        public void print() {
            this.printWithIndent(Base.getOut(), "");
        }

        public void printWithIndent(PrintWriter out, String sIndent) {
            out.println(this.toString());
            sIndent = sIndent + "  ";
            Iterator<Node> iter = this.iterateChildren();
            while (iter.hasNext()) {
                iter.next().printWithIndent(out, sIndent);
            }
        }

        public String toDebugString() {
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)writer, true);
            this.printWithIndent(out, "* ");
            return writer.toString();
        }

        public boolean check() {
            boolean fSuccess = true;
            try {
                Iterator<Node> iter = this.iterateChildren();
                while (iter.hasNext()) {
                    Node child = iter.next();
                    if (child.getParent() != this) {
                        Base.out("parent/child incorrect:");
                        this.printWithIndent(Base.getOut(), "* ");
                        fSuccess = false;
                    }
                    fSuccess &= child.check();
                }
            }
            catch (Exception e) {
                Base.out(e);
                fSuccess = false;
            }
            return fSuccess;
        }

        protected Node split(int ofSplit, long lValue) {
            Node nodeChild;
            Node nodeParent = this.getParent();
            ParentNode that = ParentNode.instantiateParent(nodeParent, new AbstractByteSequence.PartialByteSequence(this, 0, ofSplit), lValue);
            AbstractByteSequence.PartialByteSequence seqChild = new AbstractByteSequence.PartialByteSequence(this, ofSplit, this.length() - ofSplit);
            long lChildValue = this.getValue();
            if (this.hasChildren()) {
                nodeChild = ParentNode.instantiateParent(that, seqChild, lChildValue);
                Iterator<Node> iter = this.iterateChildren();
                while (iter.hasNext()) {
                    nodeChild.addChild(iter.next());
                }
            } else {
                nodeChild = LeafNode.instantiateLeaf(that, seqChild, lChildValue);
            }
            ((Node)that).addChild(nodeChild);
            if (nodeParent != null) {
                nodeParent.replaceChild(this, that);
            }
            return that;
        }

        protected Node merge(Node nodeChild) {
            Node that;
            assert (nodeChild != null);
            assert (this.getChild(nodeChild.getFirstByte()) == nodeChild);
            assert (nodeChild.getParent() == this);
            assert (this.getChildCount() == 1);
            assert (this.getValue() == 0L);
            Node nodeParent = this.getParent();
            AbstractByteSequence.AggregateByteSequence seqThat = new AbstractByteSequence.AggregateByteSequence(this, nodeChild);
            long lValue = nodeChild.getValue();
            if (nodeChild.hasChildren()) {
                that = ParentNode.instantiateParent(nodeParent, seqThat, lValue);
                Iterator<Node> iter = nodeChild.iterateChildren();
                while (iter.hasNext()) {
                    that.addChild(iter.next());
                }
            } else {
                that = LeafNode.instantiateLeaf(nodeParent, seqThat, lValue);
            }
            if (nodeParent != null) {
                nodeParent.replaceChild(this, that);
            }
            return that;
        }

        protected Node replaceSelf(Node that) {
            Iterator<Node> iter = that.iterateChildren();
            while (iter.hasNext()) {
                iter.next().replaceParent(this, that);
            }
            Node nodeParent = this.getParent();
            if (nodeParent != null) {
                nodeParent.replaceChild(this, that);
            }
            return that;
        }

        protected WriteBuffer.BufferOutput populateBinaryWriteBuffer(int cbDescendents) {
            int cbTotal = cbDescendents + this.length();
            Node parent = this.getParent();
            WriteBuffer.BufferOutput out = parent == null ? new BinaryWriteBuffer(cbTotal, cbTotal).getBufferOutput() : parent.populateBinaryWriteBuffer(cbTotal);
            try {
                this.appendBytesTo(out);
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            return out;
        }

        protected abstract void appendBytesTo(WriteBuffer.BufferOutput var1) throws IOException;
    }

    protected class FilteredIterator
    extends KeyIterator {
        private long m_lMask;
        private long m_lValue;

        public FilteredIterator(long lMask, long lValue) {
            this.m_lMask = lMask;
            this.m_lValue = lValue;
        }

        @Override
        protected int getEstimatedSize() {
            return BinaryRadixTree.this.size() / 8;
        }

        @Override
        protected boolean includeNode(Node node) {
            return ((node.getValue() ^ this.m_lValue) & this.m_lMask) == 0L;
        }
    }

    protected class AllKeyIterator
    extends KeyIterator {
        protected AllKeyIterator() {
        }

        @Override
        protected boolean includeNode(Node node) {
            return node.getValue() != 0L;
        }
    }

    protected abstract class KeyIterator
    extends AbstractStableIterator {
        protected final Iterator<Node> m_iter;

        public KeyIterator() {
            ArrayList<Node> list = new ArrayList<Node>(this.getEstimatedSize());
            this.append(list, BinaryRadixTree.this.m_nodeRoot);
            this.m_iter = list.iterator();
        }

        @Override
        protected void advance() {
            Iterator<Node> iter = this.m_iter;
            if (iter.hasNext()) {
                this.setNext(iter.next().toBinary());
            }
        }

        protected void remove(Binary oPrev) {
            BinaryRadixTree.this.remove(oPrev);
        }

        protected void append(List<Node> list, Node node) {
            if (this.includeNode(node)) {
                list.add(node);
            }
            if (node.hasChildren()) {
                Iterator<Node> iter = node.iterateChildren();
                while (iter.hasNext()) {
                    this.append(list, iter.next());
                }
            }
        }

        protected int getEstimatedSize() {
            return BinaryRadixTree.this.size();
        }

        protected abstract boolean includeNode(Node var1);
    }

    public static class BinaryLongMap
    extends AbstractKeyBasedMap {
        private final BinaryRadixTree m_tree = new BinaryRadixTree();

        @Override
        public void clear() {
            this.m_tree.clear();
        }

        @Override
        public boolean containsKey(Object oKey) {
            return this.m_tree.get((Binary)oKey) != 0L;
        }

        @Override
        public Long get(Object oKey) {
            long l = this.m_tree.get((Binary)oKey);
            return l == 0L ? null : new Long(l);
        }

        @Override
        public Long put(Object oKey, Object oValue) {
            Long oOrig = this.get(oKey);
            this.m_tree.put((Binary)oKey, (Long)oValue);
            return oOrig;
        }

        @Override
        public Long remove(Object oKey) {
            Long oOrig = this.get(oKey);
            this.m_tree.remove((Binary)oKey);
            return oOrig;
        }

        @Override
        public int size() {
            return this.m_tree.size();
        }

        @Override
        protected Iterator iterateKeys() {
            return this.m_tree.keys();
        }
    }
}

