/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.CacheCollator;
import com.tangosol.util.StringTable;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Locale;

public abstract class CommandLine
extends Base
implements Runnable {
    protected static final Class[] NO_PARAMS = new Class[0];
    protected static final Class[] VAR_PARAMS = new Class[]{String[].class};
    protected static final Object[] NO_ARGS = new Object[0];
    protected Collator m_collatorCmd;
    protected String[] m_asArg;
    protected boolean m_fDone = false;
    protected StringTable m_tblCmd;
    protected StringTable m_tblCmdHelp;

    protected CommandLine() {
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        collator.setStrength(0);
        this.m_collatorCmd = new CacheCollator(collator);
        this.m_tblCmd = new StringTable(this.m_collatorCmd);
        this.m_tblCmdHelp = new StringTable(this.m_collatorCmd);
    }

    protected CommandLine(String[] asArg) {
        this();
        this.m_asArg = asArg;
    }

    public int getArgCount() {
        String[] asArg = this.m_asArg;
        return asArg == null ? 0 : asArg.length;
    }

    public String getArg(int i) {
        String[] asArg = this.m_asArg;
        return asArg == null || i < 0 || i >= asArg.length ? null : asArg[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.init();
        try {
            PrintStream out = System.out;
            LineNumberReader in = new LineNumberReader(new InputStreamReader(System.in));
            block11: do {
                CommandLine.out();
                out.print("Command: ");
                out.flush();
                String sLine = in.readLine().trim();
                CommandLine.out();
                if (sLine == null || sLine.length() <= 0) continue;
                String[] asParts = CommandLine.parseDelimitedString(sLine, ' ');
                String sCmd = asParts[0];
                Method method = (Method)this.m_tblCmd.get(sCmd);
                if (method == null) {
                    CommandLine.out("Unknown command \"" + sCmd + "\"; try \"help\".");
                    continue;
                }
                Class<?>[] aclz = method.getParameterTypes();
                Object[] ao = NO_ARGS;
                switch (aclz == null ? 0 : aclz.length) {
                    case 1: {
                        ao = new Object[]{asParts};
                    }
                    case 0: {
                        try {
                            method.invoke((Object)this, ao);
                        }
                        catch (Throwable e) {
                            CommandLine.err("An error occurred processing the command:");
                            CommandLine.err(e);
                        }
                        continue block11;
                    }
                    default: {
                        CommandLine.out("unsupported number of arguments (" + aclz.length + ") for invocation");
                    }
                }
            } while (!this.m_fDone);
        }
        catch (Throwable e) {
            CommandLine.err(e);
        }
        finally {
            this.exit();
        }
    }

    public void register(String sCmd, String sMethod) {
        this.register(sCmd, sMethod, null);
    }

    public void register(String sCmd, String sMethod, String sHelp) {
        Class<?> clz = this.getClass();
        Method method = null;
        try {
            method = clz.getMethod(sMethod, VAR_PARAMS);
        }
        catch (Throwable e) {
            try {
                method = clz.getMethod(sMethod, NO_PARAMS);
            }
            catch (Throwable e2) {
                // empty catch block
            }
        }
        if (method == null) {
            CommandLine.err("unable to locate method \"" + sMethod + "\"; command \"" + sCmd + "\" will be unavailable.");
        } else {
            this.m_tblCmd.put(sCmd, method);
        }
        if (sHelp != null) {
            this.m_tblCmdHelp.put(sCmd, sHelp);
        }
    }

    public void init() {
        this.register("bye", "doQuit");
        this.register("exit", "doQuit");
        this.register("quit", "doQuit", "Exits the command-line tool");
        this.register("q", "doQuit");
        this.register("help", "doHelp", "Displays a list of possible commands");
        this.register("?", "doHelp");
    }

    public void exit() {
    }

    public void doHelp() {
        CommandLine.out("Possible commands:");
        Enumeration enmr = this.m_tblCmdHelp.keys();
        while (enmr.hasMoreElements()) {
            String sCmd = (String)enmr.nextElement();
            String sHelp = (String)this.m_tblCmdHelp.get(sCmd);
            if (sCmd.length() < 10) {
                sCmd = (sCmd + "          ").substring(0, 10);
            }
            CommandLine.out(sCmd + " - " + sHelp);
        }
    }

    public void doQuit() {
        this.m_fDone = true;
    }

    public static boolean toBoolean(String s) {
        return CommandLine.toBoolean(s, false);
    }

    public static boolean toBoolean(String s, boolean f) {
        if (s == null) {
            return f;
        }
        Boolean B = (Boolean)XmlHelper.convert(s, 1);
        return B == null ? f : B;
    }

    public static int toInt(String s) {
        return CommandLine.toInt(s, 0);
    }

    public static int toInt(String s, int n) {
        if (s == null) {
            return n;
        }
        Integer I = (Integer)XmlHelper.convert(s, 2);
        return I == null ? n : I;
    }

    public static long toLong(String s) {
        return CommandLine.toLong(s, 0L);
    }

    public static long toLong(String s, long n) {
        if (s == null) {
            return n;
        }
        Long L = (Long)XmlHelper.convert(s, 3);
        return L == null ? n : L;
    }

    public static double toDouble(String s) {
        return CommandLine.toDouble(s, 0.0);
    }

    public static double toDouble(String s, double dfl) {
        if (s == null) {
            return dfl;
        }
        Double D = (Double)XmlHelper.convert(s, 4);
        return D == null ? dfl : D;
    }
}

