/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ObjectStreamFactory;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Resolving;
import com.tangosol.io.ResolvingMarshalInputStream;
import com.tangosol.io.ResolvingMarshalOutputStream;
import com.tangosol.io.ResolvingObjectInputStream;
import com.tangosol.io.ResolvingObjectOutputStream;
import com.tangosol.io.Serializer;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperObjectOutputStream;
import com.tangosol.io.WrapperOutputStream;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofInputStream;
import com.tangosol.io.pof.PofOutputStream;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawTime;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.BitHelper;
import com.tangosol.util.Converter;
import com.tangosol.util.Resources;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

public abstract class ExternalizableHelper
extends BitHelper {
    protected static final int FMT_NONE = 255;
    protected static final int FMT_UNKNOWN = 255;
    protected static final int FMT_NULL = 0;
    protected static final int FMT_INT = 1;
    protected static final int FMT_LONG = 2;
    protected static final int FMT_DOUBLE = 3;
    protected static final int FMT_INTEGER = 4;
    protected static final int FMT_DECIMAL = 5;
    protected static final int FMT_STRING = 6;
    protected static final int FMT_BINARY = 7;
    protected static final int FMT_B_ARRAY = 8;
    protected static final int FMT_XML_SER = 9;
    protected static final int FMT_OBJ_EXT = 10;
    protected static final int FMT_OBJ_SER = 11;
    protected static final int FMT_XML_BEAN = 12;
    protected static final int FMT_IDO = 13;
    protected static final int FMT_FLOAT = 14;
    protected static final int FMT_SHORT = 15;
    protected static final int FMT_BYTE = 16;
    protected static final int FMT_BOOLEAN = 17;
    protected static final int FMT_BIN_DECO = 18;
    protected static final int FMT_BIN_EXT_DECO = 19;
    protected static final int FMT_EXT = 21;
    public static final int DECO_ID_MIN = 0;
    public static final int DECO_ID_MAX = 63;
    public static final int DECO_VALUE = 0;
    public static final int DECO_EXPIRY = 1;
    public static final int DECO_STORE = 2;
    public static final int DECO_TX = 3;
    public static final int DECO_PUSHREP = 4;
    public static final int DECO_RSVD_2 = 5;
    public static final int DECO_RSVD_1 = 6;
    public static final int DECO_CUSTOM = 7;
    public static final int DECO_TOPLINK = 8;
    public static final int DECO_WLS = 9;
    public static final int DECO_APP_1 = 10;
    public static final int DECO_APP_2 = 11;
    public static final int DECO_APP_3 = 12;
    protected static final int MAX_DECO_HEADER_BYTES = 7;
    public static final int TRINT_DOMAIN_SPAN = 0x1000000;
    public static final int TRINT_MAX_VALUE = 0xFFFFFF;
    public static final int TRINT_MAX_VARIANCE = 0x800000;
    public static final Binary[] EMPTY_BINARY_ARRAY = new Binary[0];
    public static final Converter CONVERTER_TO_BINARY = new Converter(){

        @Override
        public Object convert(Object o) {
            return ExternalizableHelper.toBinary(o, ExternalizableHelper.ensureSerializer(null));
        }
    };
    public static final Converter CONVERTER_FROM_BINARY = new Converter(){

        @Override
        public Object convert(Object o) {
            return o == null ? null : ExternalizableHelper.fromBinary((Binary)o, ExternalizableHelper.ensureSerializer(null));
        }
    };
    public static final Converter CONVERTER_STRIP_INTDECO = new Converter(){

        @Override
        public Object convert(Object o) {
            Binary bin;
            if (o != null && ExternalizableHelper.isIntDecorated(bin = (Binary)o)) {
                return ExternalizableHelper.removeIntDecoration(bin);
            }
            return o;
        }
    };
    public static final String PROPERTY_CONFIG = "tangosol.externalizable.config";
    public static final boolean FORCE_RESOLVING_STREAMS;
    public static final boolean USE_MARSHAL_STREAMS;
    public static final boolean USE_XMLBEAN_CLASS_CACHE;
    public static final XmlBeanClassCache XMLBEAN_CLASS_CACHE;
    private static final int MAX_BUFFER;
    public static final boolean USE_POF_STREAMS;
    public static ObjectStreamFactory s_streamfactory;
    private static final Stats[] s_astats;
    private static final Map s_mapSerializerByClassLoader;

    public static byte[] toByteArray(Object o) {
        return ExternalizableHelper.toByteArray(o, ExternalizableHelper.ensureSerializer(null));
    }

    public static byte[] toByteArray(Object o, Serializer serializer) {
        try {
            return ExternalizableHelper.serializeInternal(serializer, o, false).toByteArray();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Object fromByteArray(byte[] ab) {
        return ExternalizableHelper.fromByteArray(ab, null);
    }

    public static Object fromByteArray(byte[] ab, ClassLoader loader) {
        try {
            return ExternalizableHelper.deserializeInternal(ExternalizableHelper.ensureSerializer(loader), new ByteArrayReadBuffer(ab));
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Binary toBinary(Object o) {
        return ExternalizableHelper.toBinary(o, ExternalizableHelper.ensureSerializer(null));
    }

    public static Binary toBinary(Object o, Serializer serializer) {
        try {
            return ExternalizableHelper.serializeInternal(serializer, o, true).toBinary();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Object fromBinary(Binary bin) {
        return ExternalizableHelper.fromBinary(bin, ExternalizableHelper.ensureSerializer(null));
    }

    public static Object fromBinary(Binary bin, ClassLoader loader) {
        return ExternalizableHelper.fromBinary(bin, ExternalizableHelper.ensureSerializer(loader));
    }

    public static Object fromBinary(Binary bin, Serializer serializer) {
        try {
            return ExternalizableHelper.deserializeInternal(serializer, bin);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Serializer ensureSerializer(ClassLoader loader) {
        Map map = s_mapSerializerByClassLoader;
        Serializer serializer = (Serializer)map.get(loader = ExternalizableHelper.ensureClassLoader(loader));
        if (serializer == null) {
            serializer = USE_POF_STREAMS ? new ConfigurablePofContext() : new DefaultSerializer();
            ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(loader);
            map.put(loader, serializer);
        }
        return serializer;
    }

    public static Binary toLiteBinary(ExternalizableLite o) {
        try {
            BinaryWriteBuffer buffer = new BinaryWriteBuffer(64);
            o.writeExternal(buffer.getBufferOutput());
            return buffer.toBinary();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static int readTrint(DataInput in) throws IOException {
        int n;
        if (in instanceof PofInputStream) {
            n = ((PofInputStream)in).readInt();
        } else {
            n = in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
            if ((n & 0x800000) != 0) {
                n |= 0xFF000000;
            }
        }
        return n;
    }

    public static int readUnsignedTrint(DataInput in) throws IOException {
        int n = in instanceof PofInputStream ? ((PofInputStream)in).readInt() : in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
        return n;
    }

    public static void writeTrint(DataOutput out, int n) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeInt(n);
        } else {
            out.writeByte(n >>> 16);
            out.writeByte(n >>> 8);
            out.writeByte(n);
        }
    }

    public static void writeTrint(DataOutput out, long l) throws IOException {
        ExternalizableHelper.writeTrint(out, (int)(l & 0xFFFFFFL));
    }

    public static int makeTrint(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public static long translateTrint(int nTrint, long lCurrent) {
        long lLo = lCurrent - 0x800000L;
        long lHi = lCurrent + 0x800000L;
        nTrint &= 0xFFFFFF;
        long lBase = lCurrent >>> 24;
        for (int i = -1; i <= 1; ++i) {
            long lGuess = lBase + (long)i << 24 | (long)nTrint;
            if (lGuess < lLo || lGuess > lHi) continue;
            if (lGuess < 1L) {
                if (lCurrent >= 256L) {
                    throw new IllegalStateException("translateTrint failed because (lCurrent >= 0x100L): nTrint=" + nTrint + ", lCurrent=" + lCurrent + ", lGuess=" + lGuess);
                }
                if ((lGuess += 0x1000000L) < 1L) {
                    throw new IllegalStateException("translateTrint failed because (lGuess < 1L): nTrint=" + nTrint + ", lCurrent=" + lCurrent + ", lGuess=" + lGuess);
                }
            }
            return lGuess;
        }
        throw new IllegalStateException("translateTrint failed: nTrint=" + nTrint + ", lCurrent=" + lCurrent);
    }

    public static int readInt(DataInput in) throws IOException {
        int n;
        if (in instanceof ReadBuffer.BufferInput) {
            n = ((ReadBuffer.BufferInput)in).readPackedInt();
        } else if (in instanceof PofInputStream) {
            n = ((PofInputStream)in).readInt();
        } else {
            boolean fNeg;
            int b = in.readUnsignedByte();
            n = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = in.readUnsignedByte();
                n |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                n ^= 0xFFFFFFFF;
            }
        }
        return n;
    }

    public static int calculatePackedLength(int n) {
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        return n < 64 ? 1 : (39 - Integer.numberOfLeadingZeros(n)) / 7;
    }

    public static void writeInt(DataOutput out, int n) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writePackedInt(n);
        } else if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeInt(n);
        } else {
            int b = 0;
            if (n < 0) {
                b = 64;
                n ^= 0xFFFFFFFF;
            }
            b |= (byte)(n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                out.writeByte(b |= 0x80);
                b = n & 0x7F;
                n >>>= 7;
            }
            out.writeByte(b);
        }
    }

    public static long readLong(DataInput in) throws IOException {
        long l;
        if (in instanceof ReadBuffer.BufferInput) {
            l = ((ReadBuffer.BufferInput)in).readPackedLong();
        } else if (in instanceof PofInputStream) {
            l = ((PofInputStream)in).readLong();
        } else {
            boolean fNeg;
            int b = in.readUnsignedByte();
            l = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = in.readUnsignedByte();
                l |= (long)(b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return l;
    }

    public static int calculatePackedLength(long l) {
        if (l < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return l < 64L ? 1 : (71 - Long.numberOfLeadingZeros(l)) / 7;
    }

    public static void writeLong(DataOutput out, long l) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writePackedLong(l);
        } else if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeLong(l);
        } else {
            int b = 0;
            if (l < 0L) {
                b = 64;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            b |= (byte)((int)l & 0x3F);
            l >>>= 6;
            while (l != 0L) {
                out.writeByte(b |= 0x80);
                b = (int)l & 0x7F;
                l >>>= 7;
            }
            out.writeByte(b);
        }
    }

    public static boolean[] readBooleanArray(DataInput in) throws IOException {
        boolean[] af;
        if (in instanceof PofInputStream) {
            af = (boolean[])((PofInputStream)in).readObject();
        } else {
            int c = ExternalizableHelper.readInt(in);
            af = new boolean[c];
            int cb = (c + 7) / 8;
            int i = 0;
            for (int of = 0; of < cb; ++of) {
                int nBits = in.readUnsignedByte();
                for (int nMask = 1; i < c && nMask <= 255; nMask <<= 1) {
                    af[i++] = (nBits & nMask) != 0;
                }
            }
        }
        return af;
    }

    public static void writeBooleanArray(DataOutput out, boolean[] af) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(af);
        } else {
            int c = af.length;
            ExternalizableHelper.writeInt(out, c);
            int cb = (c + 7) / 8;
            int i = 0;
            for (int of = 0; of < cb; ++of) {
                int nBits = 0;
                for (int nMask = 1; i < c && nMask <= 255; nMask <<= 1) {
                    if (!af[i++]) continue;
                    nBits |= nMask;
                }
                out.writeByte(nBits);
            }
        }
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        byte[] ab;
        if (in instanceof PofInputStream) {
            ab = (byte[])((PofInputStream)in).readObject();
        } else {
            int cb = ExternalizableHelper.readInt(in);
            ab = new byte[cb];
            in.readFully(ab);
        }
        return ab;
    }

    public static void writeByteArray(DataOutput out, byte[] ab) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(ab);
        } else {
            int cb = ab.length;
            ExternalizableHelper.writeInt(out, cb);
            out.write(ab, 0, cb);
        }
    }

    public static String readUTF(DataInput in) throws IOException {
        String s;
        if (in instanceof ReadBuffer.BufferInput) {
            s = ((ReadBuffer.BufferInput)in).readSafeUTF();
        } else if (in instanceof PofInputStream) {
            s = ((PofInputStream)in).readUTF();
        } else {
            int cb = ExternalizableHelper.readInt(in);
            if (cb < 0) {
                return null;
            }
            if (cb == 0) {
                return "";
            }
            byte[] ab = new byte[cb];
            in.readFully(ab);
            s = ExternalizableHelper.convertUTF(ab, 0, cb, new char[cb]);
        }
        return s;
    }

    public static String convertUTF(byte[] ab, int of, int cb, char[] ach) throws UTFDataFormatException {
        int ofAsc;
        boolean fAscii = true;
        int ofch = 0;
        int ofEnd = of + cb;
        for (ofAsc = of; ofAsc < ofEnd; ++ofAsc) {
            int n = ab[ofAsc] & 0xFF;
            if (n >= 128) {
                fAscii = false;
                break;
            }
            ach[ofch++] = (char)n;
        }
        if (!fAscii) {
            while (ofAsc < ofEnd) {
                int ch = ab[ofAsc] & 0xFF;
                switch ((ch & 0xF0) >>> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ach[ofch++] = (char)ch;
                        break;
                    }
                    case 12: 
                    case 13: {
                        int ch2 = ab[++ofAsc] & 0xFF;
                        if ((ch2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        ach[ofch++] = (char)((ch & 0x1F) << 6 | ch2 & 0x3F);
                        break;
                    }
                    case 14: {
                        int ch2 = ab[++ofAsc] & 0xFF;
                        int ch3 = ab[++ofAsc] & 0xFF;
                        if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        ach[ofch++] = (char)((ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | ch3 & 0x3F);
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException("illegal leading UTF byte: " + ch);
                    }
                }
                ++ofAsc;
            }
        }
        return new String(ach, 0, ofch);
    }

    public static void writeUTF(DataOutput out, String s) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writeSafeUTF(s);
        } else if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeUTF(s);
        } else if (s == null) {
            ExternalizableHelper.writeInt(out, -1);
        } else {
            int cch = s.length();
            if (cch == 0) {
                ExternalizableHelper.writeInt(out, 0);
            } else {
                int cb = cch;
                for (int ofch = 0; ofch < cch; ++ofch) {
                    char ch = s.charAt(ofch);
                    if (ch <= '\u007f') {
                        if (ch != '\u0000') continue;
                        ++cb;
                        continue;
                    }
                    cb += ch <= '\u07ff' ? 1 : 2;
                }
                ExternalizableHelper.writeInt(out, cb);
                byte[] ab = new byte[cb];
                if (cb == cch) {
                    s.getBytes(0, cch, ab, 0);
                } else {
                    int ofb = 0;
                    for (int ofch = 0; ofch < cch; ++ofch) {
                        char ch = s.charAt(ofch);
                        if (ch >= '\u0001' && ch <= '\u007f') {
                            ab[ofb++] = (byte)ch;
                            continue;
                        }
                        if (ch <= '\u07ff') {
                            ab[ofb++] = (byte)(0xC0 | ch >>> 6 & 0x1F);
                            ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                            continue;
                        }
                        ab[ofb++] = (byte)(0xE0 | ch >>> 12 & 0xF);
                        ab[ofb++] = (byte)(0x80 | ch >>> 6 & 0x3F);
                        ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                    }
                }
                out.write(ab, 0, cb);
            }
        }
    }

    public static String readSafeUTF(DataInput in) throws IOException {
        return ExternalizableHelper.readUTF(in);
    }

    public static void writeSafeUTF(DataOutput out, String s) throws IOException {
        ExternalizableHelper.writeUTF(out, s);
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        String[] as;
        if (in instanceof PofInputStream) {
            Object[] ao = (Object[])((PofInputStream)in).readObject();
            if (ao == null) {
                as = null;
            } else {
                int co = ao.length;
                as = new String[co];
                System.arraycopy(ao, 0, as, 0, co);
            }
        } else {
            int c = ExternalizableHelper.readInt(in);
            as = new String[c];
            for (int i = 0; i < c; ++i) {
                as[i] = ExternalizableHelper.readSafeUTF(in);
            }
        }
        return as;
    }

    public static void writeStringArray(DataOutput out, String[] as) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(as);
        } else {
            int c = as.length;
            ExternalizableHelper.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                ExternalizableHelper.writeSafeUTF(out, as[i]);
            }
        }
    }

    public static BigInteger readBigInteger(DataInput in) throws IOException {
        BigInteger n = in instanceof PofInputStream ? (BigInteger)((PofInputStream)in).readObject() : new BigInteger(ExternalizableHelper.readByteArray(in));
        return n;
    }

    public static void writeBigInteger(DataOutput out, BigInteger bigint) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(bigint);
        } else {
            ExternalizableHelper.writeByteArray(out, bigint.toByteArray());
        }
    }

    public static BigDecimal readBigDecimal(DataInput in) throws IOException {
        BigDecimal dec = in instanceof PofInputStream ? (BigDecimal)((PofInputStream)in).readObject() : new BigDecimal(ExternalizableHelper.readBigInteger(in), ExternalizableHelper.readInt(in));
        return dec;
    }

    public static void writeBigDecimal(DataOutput out, BigDecimal dec) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(dec);
        } else {
            ExternalizableHelper.writeBigInteger(out, dec.unscaledValue());
            ExternalizableHelper.writeInt(out, dec.scale());
        }
    }

    public static Date readDate(DataInput in) throws IOException {
        PofInputStream inPof;
        RawDate dateRaw;
        Date date = in instanceof PofInputStream ? ((dateRaw = (inPof = (PofInputStream)in).getPofReader().readRawDate(inPof.nextIndex())) == null ? null : dateRaw.toSqlDate()) : new Date(ExternalizableHelper.readLong(in));
        return date;
    }

    public static void writeDate(DataOutput out, Date date) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(date);
        } else {
            ExternalizableHelper.writeLong(out, date.getTime());
        }
    }

    public static Time readTime(DataInput in) throws IOException {
        PofInputStream inPof;
        RawTime timeRaw;
        Time time = in instanceof PofInputStream ? ((timeRaw = (inPof = (PofInputStream)in).getPofReader().readRawTime(inPof.nextIndex())) == null ? null : timeRaw.toSqlTime()) : new Time(ExternalizableHelper.readLong(in));
        return time;
    }

    public static void writeTime(DataOutput out, Time time) throws IOException {
        if (out instanceof PofOutputStream) {
            PofOutputStream outPof = (PofOutputStream)out;
            outPof.getPofWriter().writeTimeWithZone(outPof.nextIndex(), time);
        } else {
            ExternalizableHelper.writeLong(out, time.getTime());
        }
    }

    public static Timestamp readTimestamp(DataInput in) throws IOException {
        Timestamp dt;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            RawDateTime dtRaw = inPof.getPofReader().readRawDateTime(inPof.nextIndex());
            dt = dtRaw == null ? null : dtRaw.toSqlTimestamp();
        } else {
            dt = new Timestamp(ExternalizableHelper.readLong(in));
            dt.setNanos(ExternalizableHelper.readInt(in));
        }
        return dt;
    }

    public static void writeTimestamp(DataOutput out, Timestamp dt) throws IOException {
        if (out instanceof PofOutputStream) {
            PofOutputStream outPof = (PofOutputStream)out;
            outPof.getPofWriter().writeDateTimeWithZone(outPof.nextIndex(), dt);
        } else {
            ExternalizableHelper.writeLong(out, dt.getTime());
            ExternalizableHelper.writeInt(out, dt.getNanos());
        }
    }

    public static float[] readFloatArray(DataInput in) throws IOException {
        float[] afl;
        if (in instanceof PofInputStream) {
            afl = (float[])((PofInputStream)in).readObject();
        } else {
            int cfl = in.readInt();
            afl = new float[cfl];
            if (cfl > 0) {
                byte[] ab = new byte[cfl << 2];
                in.readFully(ab);
                int of = 0;
                for (int i = 0; i < cfl; ++i) {
                    int iValue = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
                    afl[i] = Float.intBitsToFloat(iValue);
                }
            }
        }
        return afl;
    }

    public static void writeFloatArray(DataOutput out, float[] afl) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(afl);
        } else {
            int cfl = afl.length;
            out.writeInt(cfl);
            if (cfl > 0) {
                byte[] ab = new byte[cfl << 2];
                int of = 0;
                for (int i = 0; i < cfl; ++i) {
                    int iValue = Float.floatToIntBits(afl[i]);
                    ab[of++] = (byte)(iValue >>> 24);
                    ab[of++] = (byte)(iValue >>> 16);
                    ab[of++] = (byte)(iValue >>> 8);
                    ab[of++] = (byte)iValue;
                }
                out.write(ab);
            }
        }
    }

    public static double[] readDoubleArray(DataInput in) throws IOException {
        double[] adfl;
        if (in instanceof PofInputStream) {
            adfl = (double[])((PofInputStream)in).readObject();
        } else {
            int cdfl = in.readInt();
            adfl = new double[cdfl];
            if (cdfl > 0) {
                byte[] ab = new byte[cdfl << 3];
                in.readFully(ab);
                int of = 0;
                for (int i = 0; i < cdfl; ++i) {
                    int iUpper = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
                    int iLower = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
                    adfl[i] = Double.longBitsToDouble(((long)iUpper << 32) + ((long)iLower & 0xFFFFFFFFL));
                }
            }
        }
        return adfl;
    }

    public static void writeDoubleArray(DataOutput out, double[] ad) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(ad);
        } else {
            int cd = ad.length;
            out.writeInt(cd);
            if (cd > 0) {
                byte[] ab = new byte[cd << 3];
                int of = 0;
                for (int i = 0; i < cd; ++i) {
                    long lValue = Double.doubleToLongBits(ad[i]);
                    int iUpper = (int)(lValue >>> 32);
                    int iLower = (int)lValue;
                    ab[of++] = (byte)(iUpper >>> 24);
                    ab[of++] = (byte)(iUpper >>> 16);
                    ab[of++] = (byte)(iUpper >>> 8);
                    ab[of++] = (byte)iUpper;
                    ab[of++] = (byte)(iLower >>> 24);
                    ab[of++] = (byte)(iLower >>> 16);
                    ab[of++] = (byte)(iLower >>> 8);
                    ab[of++] = (byte)iLower;
                }
                out.write(ab);
            }
        }
    }

    public static int readMap(DataInput in, Map map, ClassLoader loader) throws IOException {
        int cEntries;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            inPof.getPofReader().readMap(inPof.nextIndex(), map);
            cEntries = map.size();
        } else {
            cEntries = in.readInt();
            for (int i = 0; i < cEntries; ++i) {
                Object oKey = ExternalizableHelper.readObject(in, loader);
                Object oVal = ExternalizableHelper.readObject(in, loader);
                map.put(oKey, oVal);
            }
        }
        return cEntries;
    }

    public static int readMap(DataInput in, Map map, int cBlock, ClassLoader loader) throws IOException {
        int cEntries;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            Map mapTemp = inPof.getPofReader().readMap(inPof.nextIndex(), null);
            if (mapTemp == null) {
                cEntries = 0;
            } else {
                cEntries = mapTemp.size();
                map.putAll(mapTemp);
            }
        } else {
            if (cBlock <= 0) {
                throw new IllegalArgumentException("Illegal block size: " + cBlock);
            }
            cEntries = in.readInt();
            HashMap<Object, Object> mapTmp = new HashMap<Object, Object>(Math.min(cEntries, cBlock));
            int cTmp = 0;
            for (int i = 0; i < cEntries; ++i) {
                Object oKey = ExternalizableHelper.readObject(in, loader);
                Object oVal = ExternalizableHelper.readObject(in, loader);
                mapTmp.put(oKey, oVal);
                if (++cTmp != cBlock) continue;
                map.putAll(mapTmp);
                mapTmp.clear();
                cTmp = 0;
            }
            if (cTmp > 0) {
                map.putAll(mapTmp);
            }
        }
        return cEntries;
    }

    public static void writeMap(DataOutput out, Map map) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(map);
        } else {
            int cEntries = map.size();
            int cCheck = 0;
            out.writeInt(cEntries);
            try {
                for (Map.Entry entry : map.entrySet()) {
                    ExternalizableHelper.writeObject(out, entry.getKey());
                    ExternalizableHelper.writeObject(out, entry.getValue());
                    ++cCheck;
                }
            }
            catch (ConcurrentModificationException e) {
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (cCheck != cEntries) {
                throw new IOException("Expected to write " + cEntries + " objects but actually wrote " + cCheck);
            }
        }
    }

    public static int readCollection(DataInput in, Collection collection, ClassLoader loader) throws IOException {
        int cItems;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            inPof.getPofReader().readCollection(inPof.nextIndex(), collection);
            cItems = collection.size();
        } else {
            cItems = in.readInt();
            for (int i = 0; i < cItems; ++i) {
                collection.add(ExternalizableHelper.readObject(in, loader));
            }
        }
        return cItems;
    }

    public static void writeCollection(DataOutput out, Collection collection) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(collection);
        } else {
            int cItems = collection.size();
            int cCheck = 0;
            out.writeInt(cItems);
            try {
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    ExternalizableHelper.writeObject(out, iter.next());
                    ++cCheck;
                }
            }
            catch (ConcurrentModificationException e) {
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (cCheck != cItems) {
                throw new IOException("Expected to write " + cItems + " objects but actually wrote " + cCheck);
            }
        }
    }

    public static XmlSerializable readXmlSerializable(DataInput in) throws IOException {
        return ExternalizableHelper.readXmlSerializable(in, null);
    }

    public static XmlSerializable readXmlSerializable(DataInput in, ClassLoader loader) throws IOException {
        XmlSerializable value;
        if (in instanceof PofInputStream) {
            value = (XmlSerializable)((PofInputStream)in).readObject();
        } else {
            String sClass = ExternalizableHelper.readUTF(in);
            try {
                value = (XmlSerializable)ExternalizableHelper.loadClass(sClass, loader, null).newInstance();
            }
            catch (Exception e) {
                throw new IOException("Class initialization failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            String sXml = ExternalizableHelper.readUTF(in);
            XmlDocument xml = new SimpleParser().parseXml(sXml);
            value.fromXml(xml);
        }
        return value;
    }

    public static void writeXmlSerializable(DataOutput out, XmlSerializable o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            StringWriter writerRaw = new StringWriter();
            PrintWriter writerPrn = new PrintWriter(writerRaw);
            o.toXml().writeXml(writerPrn, false);
            writerPrn.close();
            ExternalizableHelper.writeUTF(out, o.getClass().getName());
            ExternalizableHelper.writeUTF(out, writerRaw.toString());
        }
    }

    public static ExternalizableLite readExternalizableLite(DataInput in) throws IOException {
        return ExternalizableHelper.readExternalizableLite(in, null);
    }

    public static ExternalizableLite readExternalizableLite(DataInput in, ClassLoader loader) throws IOException {
        ExternalizableLite value;
        if (in instanceof PofInputStream) {
            value = (ExternalizableLite)((PofInputStream)in).readObject();
        } else {
            String sClass = ExternalizableHelper.readUTF(in);
            try {
                value = (ExternalizableLite)ExternalizableHelper.loadClass(sClass, loader, null).newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("Unable to instantiate an instance of class '" + sClass + "'; this is most likely due to a missing public " + "no-args constructor: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            catch (Exception e) {
                throw new IOException("Class initialization failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            value.readExternal(in);
        }
        return value;
    }

    public static void writeExternalizableLite(DataOutput out, ExternalizableLite o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            ExternalizableHelper.writeUTF(out, o.getClass().getName());
            o.writeExternal(out);
        }
    }

    public static XmlBean readXmlBean(DataInput in, ClassLoader loader) throws IOException {
        XmlBean bean;
        if (in instanceof PofInputStream) {
            bean = (XmlBean)((PofInputStream)in).readObject();
        } else if (USE_XMLBEAN_CLASS_CACHE) {
            int nBeanId = ExternalizableHelper.readInt(in);
            if (nBeanId < 0) {
                bean = (XmlBean)ExternalizableHelper.readExternalizableLite(in, loader);
            } else {
                try {
                    Class clz = XMLBEAN_CLASS_CACHE.getClass(nBeanId, loader);
                    bean = (XmlBean)clz.newInstance();
                }
                catch (Exception e) {
                    throw new IOException("Class instantiation failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nXmlBean ID: " + nBeanId + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
                }
                bean.readExternal(in);
            }
        } else {
            bean = (XmlBean)ExternalizableHelper.readExternalizableLite(in, loader);
        }
        return bean;
    }

    public static void writeXmlBean(DataOutput out, XmlBean bean) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(bean);
        } else if (USE_XMLBEAN_CLASS_CACHE) {
            int nBeanId = bean.getBeanInfo().getBeanId();
            ExternalizableHelper.writeInt(out, nBeanId);
            if (nBeanId < 0) {
                ExternalizableHelper.writeExternalizableLite(out, bean);
            } else {
                bean.writeExternal(out);
            }
        } else {
            ExternalizableHelper.writeExternalizableLite(out, bean);
        }
    }

    public static Object readSerializable(DataInput in) throws IOException {
        return ExternalizableHelper.readSerializable(in, null);
    }

    public static Object readSerializable(DataInput in, ClassLoader loader) throws IOException {
        Object o;
        if (in instanceof PofInputStream) {
            o = ((PofInputStream)in).readObject();
        } else {
            ObjectInput streamObj = ExternalizableHelper.getObjectInput(in, loader);
            try {
                o = streamObj.readObject();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("readObject failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClassLoader: " + loader);
            }
        }
        return o;
    }

    public static void writeSerializable(DataOutput out, Object o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            ObjectOutput streamObj = ExternalizableHelper.getObjectOutput(out);
            streamObj.writeObject(o);
            streamObj.close();
        }
    }

    public static Object readObject(DataInput in) throws IOException {
        return ExternalizableHelper.readObject(in, null);
    }

    public static Object readObject(DataInput in, ClassLoader loader) throws IOException {
        if (in instanceof PofInputStream) {
            return ((PofInputStream)in).readObject();
        }
        return ExternalizableHelper.readObjectInternal(in, in.readUnsignedByte(), loader);
    }

    private static Object readObjectInternal(DataInput in, int nType, ClassLoader loader) throws IOException {
        switch (nType) {
            default: {
                throw new StreamCorruptedException("invalid type: " + nType);
            }
            case 255: {
                return ExternalizableHelper.readSerializable(in, loader);
            }
            case 0: {
                return null;
            }
            case 1: {
                return ExternalizableHelper.makeInteger(ExternalizableHelper.readInt(in));
            }
            case 2: {
                return ExternalizableHelper.makeLong(ExternalizableHelper.readLong(in));
            }
            case 6: {
                return ExternalizableHelper.readUTF(in);
            }
            case 3: {
                return new Double(in.readDouble());
            }
            case 4: {
                return ExternalizableHelper.readBigInteger(in);
            }
            case 5: {
                return ExternalizableHelper.readBigDecimal(in);
            }
            case 7: {
                Binary bin = new Binary();
                bin.readExternal(in);
                return bin;
            }
            case 8: {
                return ExternalizableHelper.readByteArray(in);
            }
            case 9: {
                return ExternalizableHelper.readXmlSerializable(in, loader);
            }
            case 10: {
                return ExternalizableHelper.readExternalizableLite(in, loader);
            }
            case 11: {
                return ExternalizableHelper.readSerializable(in, loader);
            }
            case 12: {
                return ExternalizableHelper.readXmlBean(in, loader);
            }
            case 14: {
                return new Float(in.readFloat());
            }
            case 15: {
                return new Short(in.readShort());
            }
            case 16: {
                return new Byte(in.readByte());
            }
            case 17: 
        }
        return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static void writeObject(DataOutput out, Object o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            int nType = ExternalizableHelper.getStreamFormat(o);
            out.writeByte(nType);
            switch (nType) {
                case 255: {
                    ExternalizableHelper.writeSerializable(out, o);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    ExternalizableHelper.writeInt(out, (Integer)o);
                    break;
                }
                case 2: {
                    ExternalizableHelper.writeLong(out, (Long)o);
                    break;
                }
                case 6: {
                    ExternalizableHelper.writeUTF(out, (String)o);
                    break;
                }
                case 3: {
                    out.writeDouble((Double)o);
                    break;
                }
                case 4: {
                    ExternalizableHelper.writeBigInteger(out, (BigInteger)o);
                    break;
                }
                case 5: {
                    ExternalizableHelper.writeBigDecimal(out, (BigDecimal)o);
                    break;
                }
                case 7: {
                    ((Binary)o).writeExternal(out);
                    break;
                }
                case 8: {
                    ExternalizableHelper.writeByteArray(out, (byte[])o);
                    break;
                }
                case 9: {
                    ExternalizableHelper.writeXmlSerializable(out, (XmlSerializable)o);
                    break;
                }
                case 10: {
                    ExternalizableHelper.writeExternalizableLite(out, (ExternalizableLite)o);
                    break;
                }
                case 11: {
                    ExternalizableHelper.writeSerializable(out, o);
                    break;
                }
                case 12: {
                    ExternalizableHelper.writeXmlBean(out, (XmlBean)o);
                    break;
                }
                case 14: {
                    out.writeFloat(((Float)o).floatValue());
                    break;
                }
                case 15: {
                    out.writeShort(((Short)o).shortValue());
                    break;
                }
                case 16: {
                    out.writeByte(((Byte)o).byteValue());
                    break;
                }
                case 17: {
                    out.writeBoolean((Boolean)o);
                    break;
                }
                default: {
                    throw ExternalizableHelper.azzert();
                }
            }
        }
    }

    private static WriteBuffer serializeInternal(Serializer serializer, Object o, boolean fBinary) throws IOException {
        boolean fDeco = false;
        int nDeco = 0;
        int cb = 1;
        boolean fUser = false;
        Stats stats = null;
        if (o instanceof IntDecoratedObject) {
            IntDecoratedObject ido = (IntDecoratedObject)o;
            fDeco = true;
            nDeco = ido.getDecoration();
            cb += 5;
            o = ido.getValue();
        }
        int nType = serializer instanceof DefaultSerializer ? ExternalizableHelper.getStreamFormat(o) : 21;
        switch (nType) {
            case 0: {
                break;
            }
            case 16: 
            case 17: {
                ++cb;
                break;
            }
            case 15: {
                cb += 2;
                break;
            }
            case 1: {
                cb += 5;
                break;
            }
            case 2: {
                cb += 10;
                break;
            }
            case 4: {
                cb += ((BigInteger)o).bitLength() / 8 + 1;
                break;
            }
            case 14: {
                cb += 4;
                break;
            }
            case 3: {
                cb += 8;
                break;
            }
            case 5: {
                cb += ((BigDecimal)o).unscaledValue().bitLength() / 8 + 2;
                break;
            }
            case 7: {
                cb += ((Binary)o).length() + 4;
                break;
            }
            case 8: {
                cb += ((byte[])o).length + 5;
                break;
            }
            case 6: {
                cb += ((String)o).length() + 5;
                break;
            }
            case 21: {
                ExternalizableHelper.azzert(serializer != null);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 255: {
                fUser = true;
                stats = ExternalizableHelper.findStats(o);
                if (stats != null) break;
                cb = 64;
                break;
            }
            default: {
                throw ExternalizableHelper.azzert();
            }
        }
        WriteBuffer buf = stats == null ? (fBinary ? new BinaryWriteBuffer(cb) : new ByteArrayWriteBuffer(cb)) : stats.instantiateBuffer(fBinary);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        if (fDeco) {
            out.writeByte(13);
            out.writePackedInt(nDeco);
        }
        out.writeByte(nType);
        if (nType == 21) {
            serializer.serialize(out, o);
        } else {
            ExternalizableHelper.writeObjectInternal(out, nType, o);
        }
        if (fUser) {
            ExternalizableHelper.updateStats(o, stats, buf.length());
        }
        return buf;
    }

    private static void writeObjectInternal(WriteBuffer.BufferOutput out, int nType, Object o) throws IOException {
        switch (nType) {
            case 0: {
                break;
            }
            case 1: {
                out.writePackedInt((Integer)o);
                break;
            }
            case 2: {
                out.writePackedLong((Long)o);
                break;
            }
            case 6: {
                out.writeSafeUTF((String)o);
                break;
            }
            case 3: {
                out.writeDouble((Double)o);
                break;
            }
            case 4: {
                ExternalizableHelper.writeBigInteger(out, (BigInteger)o);
                break;
            }
            case 5: {
                ExternalizableHelper.writeBigDecimal(out, (BigDecimal)o);
                break;
            }
            case 7: {
                ((Binary)o).writeExternal(out);
                break;
            }
            case 8: {
                ExternalizableHelper.writeByteArray(out, (byte[])o);
                break;
            }
            case 9: {
                ExternalizableHelper.writeXmlSerializable(out, (XmlSerializable)o);
                break;
            }
            case 10: {
                ExternalizableHelper.writeExternalizableLite(out, (ExternalizableLite)o);
                break;
            }
            case 11: {
                ExternalizableHelper.writeSerializable(out, o);
                break;
            }
            case 12: {
                ExternalizableHelper.writeXmlBean(out, (XmlBean)o);
                break;
            }
            case 14: {
                out.writeFloat(((Float)o).floatValue());
                break;
            }
            case 15: {
                out.writeShort(((Short)o).shortValue());
                break;
            }
            case 16: {
                out.writeByte(((Byte)o).byteValue());
                break;
            }
            case 17: {
                out.writeBoolean((Boolean)o);
                break;
            }
            case 255: {
                ExternalizableHelper.writeSerializable(out, o);
                break;
            }
            default: {
                throw ExternalizableHelper.azzert();
            }
        }
    }

    private static Object deserializeInternal(Serializer serializer, ReadBuffer buf) throws IOException {
        ReadBuffer.BufferInput in = buf.getBufferInput();
        int nType = in.readUnsignedByte();
        switch (nType) {
            case 13: {
                ExternalizableHelper.readInt(in);
                nType = in.readUnsignedByte();
                break;
            }
            case 18: 
            case 19: {
                long nMask;
                long l = nMask = nType == 18 ? (long)in.readByte() : in.readPackedLong();
                if ((nMask & 1L) == 0L) {
                    throw new EOFException("Decorated value is missing a value");
                }
                int cb = in.readPackedInt();
                in = buf.getReadBuffer(in.getOffset(), cb).getBufferInput();
                nType = in.readUnsignedByte();
            }
        }
        return nType == 21 ? serializer.deserialize(in) : ExternalizableHelper.readObjectInternal(in, nType, ((ClassLoaderAware)((Object)serializer)).getContextClassLoader());
    }

    public static void validateBufferSize(int cb) {
        int cbMax = MAX_BUFFER;
        if (cbMax > 0 && cb > cbMax) {
            BufferOverflowException e = new BufferOverflowException();
            e.initCause(new IOException("serialization exceeded maximum size (" + cb + " out of " + cbMax + ")"));
            throw e;
        }
    }

    private static Stats findStats(Object o) {
        return s_astats[ExternalizableHelper.calculateStatsId(o)];
    }

    private static void updateStats(Object o, Stats stats, int cb) {
        if (stats == null) {
            ExternalizableHelper.s_astats[ExternalizableHelper.calculateStatsId((Object)o)] = stats = new Stats();
        }
        stats.update(cb);
    }

    private static int calculateStatsId(Object o) {
        if (o == null) {
            return 0;
        }
        int n = o.getClass().hashCode();
        return ((n >>> 1) + (n & 1)) % s_astats.length;
    }

    public static DeltaCompressor getDeltaCompressor(Serializer serializer, DeltaCompressor compressor) {
        return serializer instanceof DefaultSerializer ? compressor : new FormatAwareCompressor(compressor);
    }

    public static Class loadClass(String sClass, ClassLoader loader1, ClassLoader loader2) throws ClassNotFoundException {
        for (int i = 1; i <= 3; ++i) {
            ClassLoader loader;
            switch (i) {
                case 1: {
                    loader = loader1;
                    break;
                }
                case 2: {
                    loader = loader2;
                    break;
                }
                case 3: {
                    loader = ExternalizableHelper.getContextClassLoader();
                    if (loader != loader1 && loader != loader2) break;
                    loader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            try {
                if (loader == null) continue;
                return Class.forName(sClass, false, loader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return Class.forName(sClass);
    }

    public static URL loadResource(String sName, ClassLoader loader1, ClassLoader loader2) {
        for (int i = 1; i <= 3; ++i) {
            URL url;
            ClassLoader loader;
            switch (i) {
                case 1: {
                    loader = loader1;
                    break;
                }
                case 2: {
                    loader = loader2;
                    break;
                }
                case 3: {
                    loader = ExternalizableHelper.getContextClassLoader();
                    if (loader != loader1 && loader != loader2) break;
                    loader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (loader == null || (url = loader.getResource(sName)) == null) continue;
            return url;
        }
        return null;
    }

    public static InputStream getInputStream(final DataInput in) {
        return in instanceof InputStream ? (InputStream)((Object)in) : new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    return in.readUnsignedByte();
                }
                catch (EOFException e) {
                    return -1;
                }
            }
        };
    }

    public static OutputStream getOutputStream(DataOutput out) {
        return out instanceof ObjectOutput ? new ShieldedObjectOutputStream((ObjectOutput)out) : new ShieldedDataOutputStream(out);
    }

    public static OutputStream getShieldedOutputStream(OutputStream out) {
        return out instanceof Shielded ? out : (out instanceof ObjectOutput ? new ShieldedObjectOutputStream((ObjectOutput)((Object)out)) : (out instanceof DataOutput ? new ShieldedDataOutputStream((DataOutput)((Object)out)) : new ShieldedOutputStream(out)));
    }

    public static ObjectInput getObjectInput(DataInput in, ClassLoader loader) throws IOException {
        return s_streamfactory.getObjectInput(in, loader, false);
    }

    public static ObjectInput getNewObjectInput(DataInput in, ClassLoader loader) throws IOException {
        return s_streamfactory.getObjectInput(in, loader, true);
    }

    public static ObjectOutput getObjectOutput(DataOutput out) throws IOException {
        return s_streamfactory.getObjectOutput(out);
    }

    public static boolean isMarshalled(DataOutput out) {
        return out instanceof MarshalOutputStream || out instanceof ShieldedObjectOutputStream && ((ShieldedObjectOutputStream)out).isMarshalled();
    }

    public static boolean isResolving(DataOutput out) {
        return out instanceof Resolving || out instanceof ShieldedObjectOutputStream && ((ShieldedObjectOutputStream)out).isResolving();
    }

    public static ObjectStreamFactory getObjectStreamFactory() {
        return s_streamfactory;
    }

    public static void setObjectStreamFactory(ObjectStreamFactory factory) {
        s_streamfactory = factory;
    }

    public static boolean isSerializable(Object o) {
        return ExternalizableHelper.getStreamFormat(o) != 255;
    }

    protected static int getStreamFormat(Object o) {
        return o == null ? 0 : (o instanceof Binary ? 7 : (o instanceof String ? 6 : (o instanceof Number ? (o instanceof Integer ? 1 : (o instanceof Long ? 2 : (o instanceof Double ? 3 : (o instanceof BigInteger ? 4 : (o instanceof BigDecimal ? 5 : (o instanceof Float ? 14 : (o instanceof Short ? 15 : (o instanceof Byte ? 16 : 11)))))))) : (o instanceof byte[] ? 8 : (o instanceof XmlBean ? 12 : (o instanceof IntDecoratedObject ? 13 : (o instanceof ExternalizableLite ? 10 : (o instanceof Boolean ? 17 : (o instanceof Serializable ? 11 : (o instanceof XmlSerializable ? 9 : 255))))))))));
    }

    public static boolean isSerializerCompatible(Serializer serializerThis, Serializer serializerThat) {
        return serializerThis instanceof PofContext ? serializerThat instanceof PofContext : (serializerThis == null || serializerThat == null ? serializerThis == serializerThat : serializerThis.getClass() == serializerThat.getClass());
    }

    public static void reportIncompatibleSerializers(NamedCache cache, String sService, Serializer serializer) {
        CacheFactory.log("The serializer used by cache \"" + cache.getCacheName() + "\" (" + cache.getCacheService().getSerializer() + ") is incompatible with the" + " serializer configured for service \"" + sService + "\" (" + serializer + "); therefore, cached keys and values will be" + " converted via serialization. This will result in" + " increased CPU and memory utilization. If possible," + " consider reconfiguring either serializer.", 2);
    }

    public static boolean isDecorated(Binary bin) {
        if (bin != null && bin.length() > 1) {
            byte b = bin.byteAt(0);
            return b == 18 || b == 19;
        }
        return false;
    }

    public static Binary decorate(Binary bin, int nId, Binary binDecoration) {
        if (binDecoration == null) {
            return ExternalizableHelper.undecorate(bin, nId);
        }
        if (nId < 0 || nId > 63) {
            throw new IndexOutOfBoundsException("decoration index is out of range: index=" + nId + ", min=" + 0 + ", max=" + 63);
        }
        boolean fDecorated = ExternalizableHelper.isDecorated(bin);
        if (!fDecorated && nId == 0 && !ExternalizableHelper.isDecorated(binDecoration)) {
            return binDecoration;
        }
        long nBits = 1L << nId;
        int ofFront = -1;
        int cbFront = 0;
        int ofBack = -1;
        int cbBack = 0;
        boolean fEncodeFrontLength = false;
        boolean fExtended = false;
        if (bin == null) {
            bin = Binary.NO_BINARY;
        } else if (fDecorated) {
            try {
                ReadBuffer.BufferInput in = bin.getBufferInput();
                fExtended = in.readByte() != 18;
                long nPrevBits = fExtended ? in.readPackedLong() : (long)in.readUnsignedByte();
                ofFront = in.getOffset();
                nBits |= nPrevBits;
                int nLastFront = ExternalizableHelper.indexOfMSB(nPrevBits & (1L << nId) - 1L);
                int nFirstBack = ExternalizableHelper.indexOfLSB(nPrevBits & -1L << nId + 1);
                int iCurrentId = 0;
                while (nPrevBits != 0L) {
                    if ((nPrevBits & 1L) != 0L) {
                        if (iCurrentId == nFirstBack) {
                            ofBack = in.getOffset();
                            cbBack = bin.length() - ofBack;
                        }
                        in.skipBytes(in.readPackedInt());
                        if (iCurrentId == nLastFront) {
                            cbFront = in.getOffset() - ofFront;
                        }
                    }
                    nPrevBits >>>= 1;
                    ++iCurrentId;
                }
            }
            catch (IOException e) {
                throw ExternalizableHelper.ensureRuntimeException(e);
            }
        } else {
            nBits |= 1L;
            ofFront = 0;
            cbFront = bin.length();
            fEncodeFrontLength = true;
        }
        boolean bl = nId >= 8;
        int cbNew = binDecoration.length();
        int cbTotal = 1 + ((fExtended |= bl) ? ExternalizableHelper.calculatePackedLength(nBits) : 1) + cbFront + ExternalizableHelper.calculatePackedLength(cbNew) + cbNew + cbBack;
        if (fEncodeFrontLength) {
            cbTotal += ExternalizableHelper.calculatePackedLength(cbFront);
        }
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cbTotal, cbTotal);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        try {
            if (fExtended) {
                out.writeByte(19);
                out.writePackedLong(nBits);
            } else {
                out.writeByte(18);
                out.writeByte((byte)nBits);
            }
            if (fEncodeFrontLength) {
                out.writePackedInt(cbFront);
            }
            if (cbFront > 0) {
                out.writeBuffer(bin, ofFront, cbFront);
            }
            out.writePackedInt(cbNew);
            out.writeBuffer(binDecoration);
            if (cbBack > 0) {
                out.writeBuffer(bin, ofBack, cbBack);
            }
            assert (out.getOffset() == cbTotal);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        return buf.toBinary();
    }

    public static Binary decorate(Binary bin, Binary[] abinDecorations) {
        if (ExternalizableHelper.isDecorated(bin)) {
            int i;
            Binary[] abinNew;
            int cbinOver;
            Binary[] abinOrig = ExternalizableHelper.getDecorations(bin);
            int cbinOrig = abinOrig.length;
            if (cbinOrig >= (cbinOver = (abinNew = abinDecorations).length)) {
                abinDecorations = abinOrig;
                for (i = 0; i < cbinOver; ++i) {
                    if (abinNew[i] == null) continue;
                    abinDecorations[i] = abinNew[i];
                }
            } else {
                abinDecorations = (Binary[])abinDecorations.clone();
                for (i = 0; i < cbinOrig; ++i) {
                    if (abinDecorations[i] != null) continue;
                    abinDecorations[i] = abinOrig[i];
                }
            }
        } else if (bin != null && (abinDecorations.length < 1 || abinDecorations[0] == null)) {
            Binary[] abinOverride = abinDecorations;
            int cbinOverride = abinOverride.length;
            abinDecorations = new Binary[Math.max(1, cbinOverride)];
            if (cbinOverride > 0) {
                System.arraycopy(abinOverride, 0, abinDecorations, 0, cbinOverride);
            }
            abinDecorations[0] = bin;
        }
        int cbTotal = 1;
        int cDecorations = 0;
        int nLastId = -1;
        long nBits = 0L;
        int cbinDecorations = abinDecorations.length;
        for (int i = 0; i < cbinDecorations; ++i) {
            Binary binDecoration = abinDecorations[i];
            if (binDecoration == null) continue;
            int cb = binDecoration.length();
            cbTotal += ExternalizableHelper.calculatePackedLength(cb) + cb;
            ++cDecorations;
            nLastId = i;
            nBits |= 1L << i;
        }
        if (cDecorations == 0) {
            return null;
        }
        if (cDecorations == 1 && nLastId == 0 && !ExternalizableHelper.isDecorated(abinDecorations[0])) {
            return abinDecorations[0];
        }
        if (nLastId > 63) {
            throw new IndexOutOfBoundsException("decoration id out of bounds: " + nLastId);
        }
        boolean fExtended = nLastId >= 8;
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cbTotal += fExtended ? ExternalizableHelper.calculatePackedLength(nBits) : 1, cbTotal);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        try {
            out.writeByte(fExtended ? 19 : 18);
            if (fExtended) {
                out.writePackedLong(nBits);
            } else {
                out.write((byte)nBits);
            }
            for (int i = 0; i <= nLastId; ++i) {
                Binary binDecoration = abinDecorations[i];
                if (binDecoration == null) continue;
                out.writePackedInt(binDecoration.length());
                out.writeBuffer(binDecoration);
            }
            assert (out.getOffset() == cbTotal);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        return buf.toBinary();
    }

    public static Binary getDecoration(Binary bin, int nId) {
        if (!ExternalizableHelper.isDecorated(bin) || nId < 0 || nId > 63) {
            return nId == 0 ? bin : null;
        }
        ReadBuffer.BufferInput in = bin.getBufferInput();
        try {
            int nFmt = in.readUnsignedByte();
            long nBits = nFmt == 18 ? (long)in.readUnsignedByte() : in.readPackedLong();
            long nMask = 1L << nId;
            if ((nBits & nMask) == 0L) {
                return null;
            }
            for (int i = 0; i < nId; ++i) {
                if ((nBits & 1L) != 0L) {
                    in.skipBytes(in.readPackedInt());
                }
                nBits >>>= 1;
            }
            int cb = in.readPackedInt();
            int of = in.getOffset();
            return bin.toBinary(of, cb);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static Binary[] getDecorations(Binary bin) {
        if (!ExternalizableHelper.isDecorated(bin)) {
            return new Binary[]{bin};
        }
        ReadBuffer.BufferInput in = bin.getBufferInput();
        try {
            int nFmt = in.readUnsignedByte();
            long nBits = nFmt == 18 ? (long)in.readUnsignedByte() : in.readPackedLong();
            int ofMSB = ExternalizableHelper.indexOfMSB(nBits);
            assert (ofMSB >= 0 && ofMSB <= 63);
            int cbinDecorations = ofMSB + 1;
            Binary[] abinDecorations = new Binary[cbinDecorations];
            for (int i = 0; i < cbinDecorations; ++i) {
                if ((nBits & 1L) != 0L) {
                    int cb = in.readPackedInt();
                    int of = in.getOffset();
                    abinDecorations[i] = bin.toBinary(of, cb);
                    in.skipBytes(cb);
                }
                nBits >>>= 1;
            }
            return abinDecorations;
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static Binary undecorate(Binary bin, int nId) {
        Binary binValue;
        long nBits;
        if (!ExternalizableHelper.isDecorated(bin) || nId < 0 || nId > 63) {
            return nId == 0 ? null : bin;
        }
        try {
            ReadBuffer.BufferInput in = bin.getBufferInput();
            int nFmt = in.readUnsignedByte();
            nBits = nFmt == 18 ? (long)in.readUnsignedByte() : in.readPackedLong();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        long nMask = 1L << nId;
        if ((nBits & nMask) == 0L) {
            return bin;
        }
        long nRemains = nBits & (nMask ^ 0xFFFFFFFFFFFFFFFFL);
        if (nRemains == 0L) {
            return null;
        }
        if (nRemains == 1L && !ExternalizableHelper.isDecorated(binValue = ExternalizableHelper.getUndecorated(bin))) {
            return binValue;
        }
        Binary[] abinDecorations = ExternalizableHelper.getDecorations(bin);
        abinDecorations[nId] = null;
        return ExternalizableHelper.decorate(null, abinDecorations);
    }

    public static Binary getUndecorated(Binary bin) {
        return ExternalizableHelper.getDecoration(bin, 0);
    }

    public static Binary asBinary(ReadBuffer buf) {
        return buf == null ? null : buf.toBinary();
    }

    public static void main(String[] asArgs) {
        if (asArgs.length == 0) {
            ExternalizableHelper.out("Usage:");
            ExternalizableHelper.out("java com.tangosol.util.ExternalizableHelper <hex string>");
        } else {
            Object o = ExternalizableHelper.fromByteArray(ExternalizableHelper.parseHex(asArgs[0]));
            if (o != null) {
                ExternalizableHelper.out("Class: " + o.getClass().getName());
            }
            ExternalizableHelper.out("Value: " + o);
        }
    }

    public static IntDecoratedObject decorate(Object oValue, int nDecoration) {
        return new IntDecoratedObject(oValue, nDecoration);
    }

    public static Binary decorateBinary(Binary binValue, int nDecoration) {
        try {
            BinaryWriteBuffer buf = new BinaryWriteBuffer(6 + binValue.length());
            WriteBuffer.BufferOutput out = buf.getBufferOutput();
            out.writeByte(13);
            out.writePackedInt(nDecoration);
            out.writeBuffer(binValue);
            return buf.toBinary();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static boolean isIntDecorated(Binary bin) {
        try {
            return bin.byteAt(0) == 13;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static int extractIntDecoration(Binary bin) {
        try {
            ReadBuffer.BufferInput in = bin.getBufferInput();
            in.readUnsignedByte();
            return ExternalizableHelper.readInt(in);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid binary");
        }
    }

    public static Binary removeIntDecoration(Binary bin) {
        try {
            ReadBuffer.BufferInput in = bin.getBufferInput();
            in.readUnsignedByte();
            ExternalizableHelper.readInt(in);
            int of = in.getOffset();
            return bin.toBinary(of, bin.length() - of);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid binary");
        }
    }

    static {
        boolean fResolve = true;
        boolean fMarshal = false;
        boolean fCache = false;
        XmlBeanClassCache cache = null;
        int cbStats = 1024;
        int cbMax = 0;
        boolean fPof = false;
        XmlDocument xml = null;
        String sConfig = System.getProperty(PROPERTY_CONFIG);
        ObjectStreamFactory factory = new DefaultObjectStreamFactory();
        if (sConfig != null && sConfig.length() > 0) {
            URL url = Resources.findResource(sConfig, null);
            Throwable e = null;
            if (url != null) {
                try {
                    xml = XmlHelper.loadXml(url.openStream());
                }
                catch (Throwable t) {
                    e = t;
                }
            }
            if (xml == null) {
                ExternalizableHelper.err("Unable to load ExternalizableHelper configuration file \"" + sConfig + "\";");
                if (e != null) {
                    ExternalizableHelper.err(e);
                }
                ExternalizableHelper.err("Using default configuration.");
            }
        }
        try {
            XmlElement xmlCfg;
            if (xml == null) {
                xml = XmlHelper.loadXml(ExternalizableHelper.class, "ISO-8859-1");
            }
            XmlHelper.replaceSystemProperties(xml, "system-property");
            XmlElement xmlFactory = xml.getSafeElement("object-stream-factory");
            try {
                if (!XmlHelper.isInstanceConfigEmpty(xmlFactory)) {
                    factory = (ObjectStreamFactory)XmlHelper.createInstance(xmlFactory, ExternalizableHelper.class.getClassLoader(), null);
                }
            }
            catch (Exception e) {
                ExternalizableHelper.err("Unable to instantiate an ObjectStreamFactory \"" + xmlFactory + "\":");
                ExternalizableHelper.err(e);
            }
            fResolve = xml.getSafeElement("force-classloader-resolving").getBoolean(fResolve);
            fMarshal = xml.getSafeElement("enable-rmi-marshalling").getBoolean(fMarshal);
            fCache = xml.getSafeElement("enable-xmlbean-class-cache").getBoolean(fCache);
            if (fCache && (xmlCfg = xml.getElement("xmlbean-class-cache-config")) != null) {
                String sImpl = xml.getSafeElement("cache-class").getString(null);
                try {
                    cache = sImpl == null ? new SimpleXmlBeanClassCache() : (XmlBeanClassCache)Class.forName(sImpl).newInstance();
                    cache.init(xmlCfg);
                }
                catch (Throwable e) {
                    fCache = false;
                    ExternalizableHelper.err("Unable to instantiate and configure class cache \"" + sImpl + "\":");
                    ExternalizableHelper.err(e);
                }
            }
            String sMax = xml.getSafeElement("serialization-maxbuffer").getString("0");
            cbMax = (int)ExternalizableHelper.parseMemorySize(sMax, 0);
            fPof = xml.getSafeElement("enable-pof-serialization").getBoolean(fPof);
        }
        catch (Throwable e) {
            // empty catch block
        }
        FORCE_RESOLVING_STREAMS = fResolve;
        USE_MARSHAL_STREAMS = fMarshal;
        USE_XMLBEAN_CLASS_CACHE = fCache;
        XMLBEAN_CLASS_CACHE = cache;
        MAX_BUFFER = cbMax;
        USE_POF_STREAMS = fPof;
        s_streamfactory = factory;
        s_astats = new Stats[6451];
        s_mapSerializerByClassLoader = Collections.synchronizedMap(new WeakHashMap());
    }

    public static class SimpleXmlBeanClassCache
    extends Base
    implements XmlBeanClassCache {
        private boolean m_fAware;
        private String[] m_asBeans;
        private Class[] m_aclzBeans;
        private WeakHashMap m_mapBeanClasses;

        @Override
        public void init(XmlElement xml) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = xml.getSafeElement("xmlbean-list").getElements("xmlbean-class");
            while (iter.hasNext()) {
                XmlElement xmlClassName = (XmlElement)iter.next();
                String sClass = xmlClassName.getString(null);
                list.add(sClass == null ? null : sClass.intern());
            }
            this.m_asBeans = list.toArray(new String[list.size()]);
            if (xml.getSafeElement("classloader-aware").getBoolean()) {
                this.m_fAware = true;
                this.m_mapBeanClasses = new WeakHashMap(101, 1000.0f);
            }
        }

        @Override
        public int getClassId(Class clz) {
            String sName = clz.getName();
            String[] asBeans = this.m_asBeans;
            int c = asBeans.length;
            for (int i = 0; i < c; ++i) {
                if (!SimpleXmlBeanClassCache.equals(asBeans[i], sName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Class getClass(int nId, ClassLoader loader) {
            Class clz = null;
            if (this.m_fAware) {
                WeakReference[] aref = (WeakReference[])this.m_mapBeanClasses.get(loader);
                if (aref == null) {
                    aref = this.initClassLoader(loader);
                }
                try {
                    clz = (Class)aref[nId].get();
                }
                catch (NullPointerException e) {}
            } else {
                Class[] aclz = this.m_aclzBeans;
                if (aclz == null) {
                    this.m_aclzBeans = aclz = this.initClasses(loader);
                }
                try {
                    clz = aclz[nId];
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            if (clz == null) {
                if (nId < 0) {
                    throw new IndexOutOfBoundsException("Class ID=" + nId + "; a negative XmlBean ID is used to indicate" + " an \"unknown\" XmlBean class");
                }
                throw new IndexOutOfBoundsException("Class ID=" + nId + ", Max ID=" + (this.m_aclzBeans.length - 1));
            }
            return clz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WeakReference[] initClassLoader(ClassLoader loader) {
            WeakHashMap map;
            SimpleXmlBeanClassCache.azzert(this.m_fAware);
            Class[] aclz = this.initClasses(loader);
            int c = aclz.length;
            WeakReference[] aref = new WeakReference[c];
            for (int i = 0; i < c; ++i) {
                aref[i] = new WeakReference<Class>(aclz[i]);
            }
            WeakHashMap weakHashMap = map = this.m_mapBeanClasses;
            synchronized (weakHashMap) {
                map.put(loader, aref);
            }
            return aref;
        }

        private Class[] initClasses(ClassLoader loader) {
            String[] asBeans = this.m_asBeans;
            int cBeans = asBeans.length;
            Class[] aclz = new Class[cBeans];
            for (int i = 0; i < cBeans; ++i) {
                String sBean = asBeans[i];
                if (sBean == null || sBean.length() <= 0) continue;
                try {
                    aclz[i] = ExternalizableHelper.loadClass(sBean, loader, null);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new WrapperException(e);
                }
            }
            return aclz;
        }
    }

    public static interface XmlBeanClassCache {
        public void init(XmlElement var1);

        public int getClassId(Class var1);

        public Class getClass(int var1, ClassLoader var2);
    }

    protected static final class IntDecoratedObject
    extends ExternalizableHelper
    implements Serializable {
        private Object m_oValue;
        private int m_nDecoration;

        public IntDecoratedObject(Object oValue, int nDecoration) {
            IntDecoratedObject.azzert(!(oValue instanceof IntDecoratedObject));
            this.m_oValue = oValue;
            this.m_nDecoration = nDecoration;
        }

        public Object getValue() {
            return this.m_oValue;
        }

        public int getDecoration() {
            return this.m_nDecoration;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            throw new IOException("not allowed");
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            throw new IOException("not allowed");
        }
    }

    public static class DefaultObjectStreamFactory
    implements ObjectStreamFactory {
        @Override
        public ObjectInput getObjectInput(DataInput in, ClassLoader loader, boolean fForceNew) throws IOException {
            if (!(fForceNew || !(in instanceof ObjectInput) || FORCE_RESOLVING_STREAMS && !(in instanceof Resolving) || USE_MARSHAL_STREAMS && !(in instanceof MarshalInputStream))) {
                return (ObjectInput)in;
            }
            InputStream stream = ExternalizableHelper.getInputStream(in);
            loader = Base.ensureClassLoader(loader);
            return USE_MARSHAL_STREAMS ? new ResolvingMarshalInputStream(stream, loader) : new ResolvingObjectInputStream(stream, loader);
        }

        @Override
        public ObjectOutput getObjectOutput(DataOutput out) throws IOException {
            if (!(!(out instanceof ObjectOutput) || FORCE_RESOLVING_STREAMS && !ExternalizableHelper.isResolving(out) || USE_MARSHAL_STREAMS && !ExternalizableHelper.isMarshalled(out))) {
                return out instanceof Shielded ? (ObjectOutput)out : new ShieldedObjectOutputStream((ObjectOutput)out);
            }
            OutputStream stream = ExternalizableHelper.getOutputStream(out);
            return USE_MARSHAL_STREAMS ? new ResolvingMarshalOutputStream(stream) : new ResolvingObjectOutputStream(stream);
        }
    }

    public static class ShieldedObjectOutputStream
    extends WrapperObjectOutputStream
    implements Shielded {
        public ShieldedObjectOutputStream(ObjectOutput out) {
            super(out);
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }

        boolean isMarshalled() {
            return ExternalizableHelper.isMarshalled(this.getObjectOutput());
        }

        boolean isResolving() {
            return ExternalizableHelper.isResolving(this.getObjectOutput());
        }
    }

    public static class ShieldedDataOutputStream
    extends WrapperDataOutputStream
    implements Shielded {
        public ShieldedDataOutputStream(DataOutput out) {
            super(out);
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }
    }

    public static class ShieldedOutputStream
    extends WrapperOutputStream
    implements Shielded {
        public ShieldedOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }
    }

    public static class ShieldedInputStream
    extends FilterInputStream
    implements InputStreaming,
    Shielded {
        public ShieldedInputStream(InputStream in) {
            super(in);
        }

        @Override
        public final void close() {
        }
    }

    public static interface Shielded {
    }

    public static class FormatAwareCompressor
    implements DeltaCompressor {
        protected DeltaCompressor m_compressor;

        public FormatAwareCompressor(DeltaCompressor compressor) {
            this.m_compressor = compressor;
        }

        @Override
        public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
            if (bufOld != null) {
                Base.azzert(bufOld.byteAt(0) == 21);
                bufOld = bufOld.getReadBuffer(1, bufOld.length() - 1);
            }
            Base.azzert(bufNew.byteAt(0) == 21);
            bufNew = bufNew.getReadBuffer(1, bufNew.length() - 1);
            return this.m_compressor.extractDelta(bufOld, bufNew);
        }

        @Override
        public ReadBuffer applyDelta(ReadBuffer bufOld, ReadBuffer bufDelta) {
            if (bufOld != null) {
                Base.azzert(bufOld.byteAt(0) == 21);
                bufOld = bufOld.getReadBuffer(1, bufOld.length() - 1);
            }
            ReadBuffer bufNew = this.m_compressor.applyDelta(bufOld, bufDelta);
            BinaryWriteBuffer buffer = new BinaryWriteBuffer(bufNew.length() + 1);
            try {
                WriteBuffer.BufferOutput out = buffer.getBufferOutput();
                out.writeByte(21);
                bufNew.toBinary().writeTo(out);
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            return buffer.toBinary();
        }

        public String toString() {
            return "FormatAwareCompressor {" + this.m_compressor + "}";
        }
    }

    private static final class Stats
    implements MultiBufferWriteBuffer.WriteBufferPool {
        private static final int MIN_ALLOC = 128;
        private static final int MAX_ALLOC = 0x100000;
        private static final int EXPIRY_MILLIS = 600000;
        private volatile long m_lAccum;
        private volatile long m_lStats;
        private volatile long m_ldtCreated;

        private Stats() {
        }

        void update(int cb) {
            long ldtNow;
            int cbMax = (int)(this.m_lStats >>> 32);
            long lAccum = this.m_lAccum;
            int cItems = (int)(lAccum >>> 48);
            if ((cItems & 0x3FF) == 0 && ((ldtNow = Base.getSafeTimeMillis()) > this.m_ldtCreated + 600000L || (cItems & 0xFFFF) == 0)) {
                cbMax = 0;
                lAccum = 0L;
                cItems = 0;
                this.m_ldtCreated = ldtNow;
            }
            long cbTotal = lAccum + (long)cb & 0xFFFFFFFFFFFFL;
            int cbAvg = (int)(cbTotal / (long)(++cItems));
            if (cb > cbMax) {
                cbMax = cb;
            }
            this.m_lAccum = (long)cItems << 48 | cbTotal;
            this.m_lStats = (long)cbMax << 32 | (long)cbAvg;
        }

        WriteBuffer instantiateBuffer(boolean fBinary) {
            long lStats = this.m_lStats;
            int cbMax = (int)(lStats >>> 32);
            int cbAvg = (int)(lStats & 0xFFFFFFFFL);
            return cbMax > 1024 && cbMax > cbAvg + (cbAvg >>> 3) ? new MultiBufferWriteBuffer(this) : (fBinary ? new BinaryWriteBuffer(cbMax + 15 & 0xFFFFFFF0) : new ByteArrayWriteBuffer(cbMax + 15 & 0xFFFFFFF0));
        }

        @Override
        public int getMaximumCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public WriteBuffer allocate(int cbPreviousTotal) {
            int cb;
            if (cbPreviousTotal <= 0) {
                long lStats = this.m_lStats;
                int cbMax = (int)(lStats >>> 32);
                int cbAvg = (int)(lStats & 0xFFFFFFFFL);
                cb = Math.min(0x100000, Math.min(cbMax, cbAvg + (cbAvg >>> 3)));
            } else {
                cb = cbPreviousTotal <= 1024 ? Math.max(128, cbPreviousTotal) : (cbPreviousTotal <= 4096 ? cbPreviousTotal >>> 1 : Math.min(0x100000, cbPreviousTotal >>> 2));
            }
            ExternalizableHelper.validateBufferSize(cb + cbPreviousTotal);
            return new BinaryWriteBuffer(cb);
        }

        @Override
        public void release(WriteBuffer buffer) {
        }
    }
}

