/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.EnumerationIterator;
import com.tangosol.util.Filter;
import com.tangosol.util.SimpleEnumerator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterEnumerator
extends Base
implements Enumeration,
Iterator {
    protected Iterator m_iter;
    protected Filter m_test;
    protected boolean m_fNext;
    protected boolean m_fPrev;
    protected Object m_oNext;

    public FilterEnumerator(Enumeration enmr, Filter test) {
        this(new EnumerationIterator(enmr), test);
    }

    public FilterEnumerator(Iterator iter, Filter test) {
        this.m_iter = iter;
        this.m_test = test;
        this.m_fNext = false;
    }

    public FilterEnumerator(Object[] aoItem, Filter test) {
        this(new SimpleEnumerator(aoItem), test);
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }

    @Override
    public boolean hasNext() {
        boolean fNext = this.m_fNext;
        if (fNext) {
            return true;
        }
        Iterator iter = this.m_iter;
        Filter test = this.m_test;
        while (iter.hasNext()) {
            Object oNext = iter.next();
            if (!test.evaluate(oNext)) continue;
            this.m_oNext = oNext;
            fNext = true;
            break;
        }
        this.m_fPrev = false;
        this.m_fNext = fNext;
        return fNext;
    }

    public Object next() {
        if (this.hasNext()) {
            this.m_fNext = false;
            this.m_fPrev = true;
            return this.m_oNext;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (!this.m_fPrev) {
            throw new IllegalStateException();
        }
        this.m_fPrev = false;
        this.m_iter.remove();
    }
}

