/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

public class SafeClock {
    protected long m_ldtLastSafe;
    protected long m_ldtLastUnsafe;
    protected final long m_lJitter;
    public static final long DEFAULT_JITTER_THRESHOLD = Long.parseLong(System.getProperty("tangosol.coherence.safeclock.jitter", "16"));

    public SafeClock(long ldtUnsafe) {
        this(ldtUnsafe, DEFAULT_JITTER_THRESHOLD);
    }

    public SafeClock(long ldtUnsafe, long lJitter) {
        this.m_ldtLastSafe = this.m_ldtLastUnsafe = ldtUnsafe;
        this.m_lJitter = lJitter;
    }

    public final long getSafeTimeMillis(long ldtUnsafe) {
        long lDelta = ldtUnsafe - this.m_ldtLastUnsafe;
        return lDelta == 0L || lDelta < 0L && lDelta >= -this.m_lJitter ? this.m_ldtLastSafe : this.updateSafeTimeMillis(ldtUnsafe);
    }

    public final long getLastSafeTimeMillis() {
        return this.m_ldtLastSafe;
    }

    protected synchronized long updateSafeTimeMillis(long ldtUnsafe) {
        long lJitter = this.m_lJitter;
        long ldtLastSafe = this.m_ldtLastSafe;
        long lDelta = ldtUnsafe - this.m_ldtLastUnsafe;
        long ldtNewSafe = ldtLastSafe;
        if (lDelta > 0L) {
            if (ldtUnsafe >= ldtLastSafe) {
                ldtNewSafe = ldtUnsafe;
            } else {
                if (lDelta > lJitter && ldtLastSafe - ldtUnsafe <= lJitter) {
                    return ldtLastSafe;
                }
                ldtNewSafe += lDelta == 1L ? ldtUnsafe % 2L : lDelta / 2L;
            }
        } else if (lDelta >= -lJitter) {
            return ldtLastSafe;
        }
        this.m_ldtLastUnsafe = ldtUnsafe;
        this.m_ldtLastSafe = ldtNewSafe;
        return this.m_ldtLastSafe;
    }
}

