/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public class SimpleMapEntry
extends Base
implements MapTrigger.Entry,
Cloneable,
Serializable {
    protected static final Object NO_VALUE = new Object();
    protected Object m_oKey;
    protected Object m_oValue;
    protected Object m_oOrigValue;

    protected SimpleMapEntry() {
        this(null, null, NO_VALUE);
    }

    protected SimpleMapEntry(Object oKey) {
        this(oKey, null, NO_VALUE);
    }

    public SimpleMapEntry(Map.Entry entry) {
        this(entry.getKey(), entry.getValue(), entry instanceof MapTrigger.Entry && ((MapTrigger.Entry)entry).isOriginalPresent() ? ((MapTrigger.Entry)entry).getOriginalValue() : NO_VALUE);
    }

    public SimpleMapEntry(Object oKey, Object oValue) {
        this(oKey, oValue, NO_VALUE);
    }

    public SimpleMapEntry(Object oKey, Object oValue, Object oOrigValue) {
        this.m_oKey = oKey;
        this.m_oValue = oValue;
        this.m_oOrigValue = oOrigValue;
    }

    @Override
    public Object getKey() {
        return this.m_oKey;
    }

    @Override
    public Object getValue() {
        return this.m_oValue;
    }

    @Override
    public Object setValue(Object oValue) {
        Object oPrev = this.m_oValue;
        this.m_oValue = oValue;
        return oPrev;
    }

    @Override
    public Object getOriginalValue() {
        Object oOrig = this.m_oOrigValue;
        return oOrig == NO_VALUE ? null : oOrig;
    }

    @Override
    public boolean isOriginalPresent() {
        return this.m_oOrigValue != NO_VALUE;
    }

    @Override
    public void setValue(Object oValue, boolean fSynthetic) {
        this.setValue(oValue);
    }

    @Override
    public void update(ValueUpdater updater, Object oValue) {
        InvocableMapHelper.updateEntry(updater, this, oValue);
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public void remove(boolean fSynthetic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object extract(ValueExtractor extractor) {
        return InvocableMapHelper.extractFromEntry(extractor, this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry that = (Map.Entry)o;
        if (this == that || that == null) {
            return this == that;
        }
        return SimpleMapEntry.equals(this.getKey(), that.getKey()) && SimpleMapEntry.equals(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        Object oKey = this.getKey();
        Object oValue = this.getValue();
        return (oKey == null ? 0 : oKey.hashCode()) ^ (oValue == null ? 0 : oValue.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry{Key=\"").append(this.getKey()).append("\", Value=\"").append(this.getValue());
        if (this.isOriginalPresent()) {
            sb.append("\", OrigValue=\"").append(this.getOriginalValue());
        }
        sb.append("\"}");
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw SimpleMapEntry.ensureRuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_oKey);
        out.writeObject(this.m_oValue);
        if (this.isOriginalPresent()) {
            out.writeBoolean(true);
            out.writeObject(this.m_oOrigValue);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_oKey = in.readObject();
        this.m_oValue = in.readObject();
        this.m_oOrigValue = in.readBoolean() ? in.readObject() : NO_VALUE;
    }
}

