/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.BackingMapContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.SimpleMemoryCalculator;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Converter;
import com.tangosol.util.InflatableSet;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SafeSortedMap;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.MultiExtractor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleMapIndex
extends Base
implements MapIndex {
    protected ValueExtractor m_extractor;
    protected Comparator m_comparator;
    protected boolean m_fOrdered;
    protected Map m_mapForward;
    protected Map m_mapInverse;
    protected boolean m_fSplitCollection;
    protected final AtomicLong m_cUnits;
    protected ConfigurableCacheMap.UnitCalculator m_calculator;
    protected BackingMapContext m_ctx;

    public SimpleMapIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator, BackingMapContext ctx) {
        this(extractor, fOrdered, comparator, true, ctx);
    }

    protected SimpleMapIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator, boolean fInit, BackingMapContext ctx) {
        SimpleMapIndex.azzert(extractor != null);
        this.m_extractor = extractor;
        this.m_fOrdered = fOrdered;
        this.m_comparator = comparator;
        this.m_fSplitCollection = !(extractor instanceof MultiExtractor);
        this.m_ctx = ctx;
        this.m_cUnits = new AtomicLong(0L);
        this.m_calculator = this.instantiateCalculator();
        if (fInit) {
            this.initialize();
        }
    }

    @Override
    public ValueExtractor getValueExtractor() {
        return this.m_extractor;
    }

    @Override
    public boolean isOrdered() {
        return this.m_fOrdered;
    }

    @Override
    public boolean isPartial() {
        return false;
    }

    @Override
    public Comparator getComparator() {
        return this.m_comparator;
    }

    @Override
    public Map getIndexContents() {
        return this.m_mapInverse;
    }

    @Override
    public Object get(Object oKey) {
        return this.m_mapForward.get(oKey);
    }

    @Override
    public void insert(Map.Entry entry) {
        this.insertInternal(entry);
    }

    @Override
    public void update(Map.Entry entry) {
        this.updateInternal(entry);
    }

    @Override
    public void delete(Map.Entry entry) {
        this.deleteInternal(entry);
    }

    public long getUnits() {
        return this.getUnitsCounter().get();
    }

    protected AtomicLong getUnitsCounter() {
        return this.m_cUnits;
    }

    public ConfigurableCacheMap.UnitCalculator getCalculator() {
        return this.m_calculator;
    }

    protected void initialize() {
        this.m_mapInverse = this.instantiateInverseIndex(this.m_fOrdered, this.m_comparator);
        this.m_mapForward = this.instantiateForwardIndex();
    }

    protected Map.Entry getForwardEntry(Object oKey) {
        return ((SegmentedHashMap)this.m_mapForward).getEntry(oKey);
    }

    protected Map instantiateForwardIndex() {
        return new SegmentedHashMap();
    }

    protected Map instantiateInverseIndex(boolean fOrdered, Comparator comparator) {
        if (fOrdered) {
            if (!(comparator instanceof SafeComparator)) {
                comparator = new SafeComparator(comparator);
            }
            return new SafeSortedMap(comparator);
        }
        return new SegmentedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertInternal(Map.Entry entry) {
        Object oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        Object oIxValue = InvocableMapHelper.extractFromEntry(this.m_extractor, entry);
        SimpleMapIndex simpleMapIndex = this;
        synchronized (simpleMapIndex) {
            oIxValue = this.addInverseMapping(oIxValue, oKey);
            Map mapForward = this.m_mapForward;
            if (mapForward != null) {
                mapForward.put(oKey, oIxValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateInternal(Map.Entry entry) {
        Object object = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        Object oIxValueNew = InvocableMapHelper.extractFromEntry(this.m_extractor, entry);
        SimpleMapIndex simpleMapIndex = this;
        synchronized (simpleMapIndex) {
            void var2_4;
            void var5_10;
            Map.Entry entryFwd = this.getForwardEntry(object);
            if (entryFwd == null) {
                if (!(entry instanceof MapTrigger.Entry)) throw new IllegalStateException("Cannot extract the old value");
                Object object2 = InvocableMapHelper.extractOriginalFromEntry(this.m_extractor, (MapTrigger.Entry)entry);
            } else {
                Object k = entryFwd.getKey();
                Object v = entryFwd.getValue();
            }
            if (SimpleMapIndex.equals(var5_10, oIxValueNew)) return;
            this.removeInverseMapping(var5_10, var2_4);
            oIxValueNew = this.addInverseMapping(oIxValueNew, var2_4);
            if (entryFwd == null) {
                Map mapForward = this.m_mapForward;
                if (mapForward == null) return;
                mapForward.put(var2_4, oIxValueNew);
            } else {
                entryFwd.setValue(oIxValueNew);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deleteInternal(Map.Entry entry) {
        Object object = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        SimpleMapIndex simpleMapIndex = this;
        synchronized (simpleMapIndex) {
            void var4_7;
            Map mapForward = this.m_mapForward;
            if (mapForward == null) {
                if (!(entry instanceof MapTrigger.Entry)) throw new IllegalStateException("Cannot extract the old value");
                Object object2 = InvocableMapHelper.extractOriginalFromEntry(this.m_extractor, (MapTrigger.Entry)entry);
            } else {
                Object v = mapForward.remove(object);
            }
            this.removeInverseMapping(var4_7, object);
            return;
        }
    }

    protected Object addInverseMapping(Object oIxValue, Object oKey) {
        Map mapInverse = this.m_mapInverse;
        oIxValue = this.m_fSplitCollection && oIxValue instanceof Collection || oIxValue instanceof Object[] ? this.addInverseCollectionMapping(mapInverse, oIxValue, oKey) : this.addInverseMapping(mapInverse, oIxValue, oKey);
        return oIxValue;
    }

    protected Object addInverseMapping(Map mapIndex, Object oIxValue, Object oKey) {
        Set setKeys;
        Map.Entry entry;
        Map.Entry entry2 = entry = this.m_fOrdered ? ((SafeSortedMap)mapIndex).getEntry(oIxValue) : ((SegmentedHashMap)mapIndex).getEntry(oIxValue);
        if (entry == null) {
            setKeys = this.instantiateSet();
            mapIndex.put(oIxValue, setKeys);
            this.addUnits(oIxValue);
        } else {
            setKeys = (Set)entry.getValue();
            oIxValue = entry.getKey();
        }
        setKeys.add(oKey);
        return oIxValue;
    }

    protected Object addInverseCollectionMapping(Map mapIndex, Object oIxValue, Object oKey) {
        Iterator iterator;
        Set setCandidateKeys = null;
        boolean fCandidate = true;
        boolean fScanForward = false;
        Iterator iterator2 = iterator = oIxValue instanceof Object[] ? new SimpleEnumerator((Object[])oIxValue) : ((Collection)oIxValue).iterator();
        while (iterator.hasNext()) {
            Object oValue = iterator.next();
            Set setKeys = (Set)mapIndex.get(oValue);
            if (setKeys == null) {
                fCandidate = false;
                setKeys = this.instantiateSet();
                mapIndex.put(oValue, setKeys);
                this.addUnits(oValue);
            } else if (fCandidate) {
                if (setCandidateKeys == null) {
                    int cThreshold = 50;
                    if (this.m_mapForward != null && setKeys.size() > cThreshold) {
                        fScanForward = true;
                        break;
                    }
                    setCandidateKeys = new LiteSet(setKeys);
                } else {
                    setCandidateKeys.retainAll(setKeys);
                }
            }
            setKeys.add(oKey);
        }
        if (fCandidate) {
            Iterator<Object> iter;
            Iterator<Object> iterator3 = fScanForward ? this.m_mapForward.values().iterator() : (iter = setCandidateKeys == null ? NullImplementation.getIterator() : setCandidateKeys.iterator());
            while (iter.hasNext()) {
                Object oCandidateValue = fScanForward ? iter.next() : this.get(iter.next());
                if (!Base.equalsDeep(oCandidateValue, oIxValue)) continue;
                return oCandidateValue;
            }
        }
        return oIxValue;
    }

    protected void removeInverseMapping(Object oIxValue, Object oKey) {
        Map mapInverse = this.m_mapInverse;
        if (oIxValue instanceof Collection && this.m_fSplitCollection) {
            Iterator iter = ((Collection)oIxValue).iterator();
            while (iter.hasNext()) {
                this.removeInverseMapping(mapInverse, iter.next(), oKey);
            }
        } else if (oIxValue instanceof Object[]) {
            Object[] aoIxValueOld = (Object[])oIxValue;
            int c = aoIxValueOld.length;
            for (int i = 0; i < c; ++i) {
                this.removeInverseMapping(mapInverse, aoIxValueOld[i], oKey);
            }
        } else {
            this.removeInverseMapping(mapInverse, oIxValue, oKey);
        }
    }

    protected void removeInverseMapping(Map mapIndex, Object oIxValue, Object oKey) {
        Set setKeys = (Set)mapIndex.get(oIxValue);
        if (setKeys == null) {
            if (!this.isPartial()) {
                SimpleMapIndex.log("Missing inverse index: value=" + oIxValue + ", key=" + oKey);
            }
        } else {
            setKeys.remove(oKey);
            if (setKeys.isEmpty()) {
                mapIndex.remove(oIxValue);
                this.removeUnits(oIxValue);
            }
        }
    }

    protected Set instantiateSet() {
        return new InflatableSet();
    }

    protected ConfigurableCacheMap.UnitCalculator instantiateCalculator() {
        return new IndexCalculator(this.m_ctx, this);
    }

    protected void removeUnits(Object oValue) {
        this.getUnitsCounter().addAndGet(-this.getCalculator().calculateUnits(null, oValue));
    }

    protected void addUnits(Object oValue) {
        this.getUnitsCounter().addAndGet(this.getCalculator().calculateUnits(null, oValue));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fVerbose) {
        return ClassHelper.getSimpleName(this.getClass()) + ": Extractor=" + this.getValueExtractor() + ", Ordered=" + this.isOrdered() + ", Footprint=" + Base.toMemorySizeString(this.getUnits(), false) + ", Content=" + (fVerbose ? this.getIndexContents().keySet() : Integer.valueOf(this.getIndexContents().size()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleMapIndex)) {
            return false;
        }
        SimpleMapIndex that = (SimpleMapIndex)o;
        return SimpleMapIndex.equals(this.getComparator(), that.getComparator()) && SimpleMapIndex.equals(this.getValueExtractor(), that.getValueExtractor()) && this.isOrdered() == that.isOrdered();
    }

    public int hashCode() {
        return this.m_comparator == null ? 0 : this.m_comparator.hashCode() + ((Object)this.m_extractor).hashCode() + (this.m_fOrdered ? 1 : 0);
    }

    public static class IndexCalculator
    extends SimpleMemoryCalculator {
        protected SimpleMapIndex m_index;
        protected CalculatorState m_state = CalculatorState.UNINITIALIZED;
        protected int m_cbFixed;
        protected final Converter m_converter;
        protected final ConfigurableCacheMap.UnitCalculator m_calculator;
        protected static final int DEFAULT_SIZE = 32;

        public IndexCalculator(BackingMapContext ctx, SimpleMapIndex index) {
            this.m_index = index;
            if (ctx == null) {
                this.m_converter = null;
                this.m_calculator = null;
                return;
            }
            this.m_converter = ctx.getManagerContext().getValueToInternalConverter();
            this.m_calculator = ctx.getBackingMap() instanceof ConfigurableCacheMap ? ((ConfigurableCacheMap)ctx.getBackingMap()).getUnitCalculator() : null;
        }

        protected CalculatorState getCalculatorState(Class clz) {
            if (MAP_FIXED_SIZES.containsKey(clz)) {
                return CalculatorState.FIXED;
            }
            if (clz == String.class || clz == Binary.class) {
                return CalculatorState.STANDARD;
            }
            if (clz.isArray()) {
                switch (this.getCalculatorState(clz.getComponentType())) {
                    case FIXED: 
                    case STANDARD: {
                        return CalculatorState.STANDARD;
                    }
                }
            }
            return CalculatorState.UNKNOWN;
        }

        protected synchronized CalculatorState initialize(Object o) {
            CalculatorState state;
            ConfigurableCacheMap.UnitCalculator calculator = this.m_calculator;
            if (calculator != null) {
                try {
                    calculator.calculateUnits(null, o);
                    this.m_state = CalculatorState.CONFIGURED;
                    return this.m_state;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if ((state = this.m_state) == CalculatorState.UNINITIALIZED) {
                state = this.getCalculatorState(o.getClass());
                switch (state) {
                    case UNKNOWN: {
                        String sMsg = calculator == null ? "There is no configured calculator for " + o.getClass().getCanonicalName() + "; this " + this.m_index + " will" + " estimate the index size using serialization," + " which could impact its performance" : "The configured calculator " + calculator.getClass().getCanonicalName() + " cannot be used to estimate the size of " + o.getClass().getCanonicalName() + "; this " + this.m_index + " will" + " estimate the index size using serialization," + " which could impact its performance";
                        CacheFactory.log(sMsg, 5);
                        this.m_state = state;
                        break;
                    }
                    case FIXED: {
                        this.m_cbFixed = super.sizeOf(o);
                    }
                    default: {
                        this.m_state = state;
                    }
                }
            }
            return state;
        }

        @Override
        public int sizeOf(Object o) {
            try {
                switch (this.m_state) {
                    case UNINITIALIZED: {
                        this.initialize(o);
                        return this.sizeOf(o);
                    }
                    case FIXED: {
                        return this.m_cbFixed;
                    }
                    case STANDARD: {
                        return super.sizeOf(o);
                    }
                    case CONFIGURED: {
                        return this.m_calculator.calculateUnits(null, o);
                    }
                    case UNKNOWN: {
                        Converter conv = this.getConverter();
                        return conv == null ? 32 : super.sizeOf(conv.convert(o));
                    }
                }
                throw new IllegalStateException();
            }
            catch (Exception e) {
                return 32;
            }
        }

        protected Converter getConverter() {
            return this.m_converter;
        }

        public static enum CalculatorState {
            UNINITIALIZED,
            UNKNOWN,
            FIXED,
            STANDARD,
            CONFIGURED;

        }
    }
}

