/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.Gate;
import com.tangosol.util.WrapperException;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadGate
extends Base
implements Gate {
    public static final int GATE_OPEN = 0;
    public static final int GATE_CLOSING = 1;
    public static final int GATE_CLOSED = 2;
    public static final int GATE_DESTROYED = 3;
    private static final int STATUS_OFFSET = 60;
    private static final long ACTIVE_COUNT_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long EMPTY_GATE_OPEN = 0L;
    private static final long EMPTY_GATE_CLOSING = 0x1000000000000000L;
    private static final long EMPTY_GATE_CLOSED = 0x2000000000000000L;
    private AtomicLong m_atomicState = new AtomicLong();
    private int m_cClose;
    private volatile transient Thread m_threadClosing;
    private volatile long m_cVersion;
    private ThreadLocalCounter m_tlcEnters = new ThreadLocalCounter();
    private ThreadLocalCounter m_tlcVersion = new ThreadLocalCounter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean barEntry(long cMillis) {
        Thread thread = Thread.currentThread();
        if (this.getClosingThread() == thread) {
            this.setCloseCount(this.getCloseCount() + 1);
            return true;
        }
        ThreadGate threadGate = this;
        synchronized (threadGate) {
            do {
                if (this.getClosingThread() != null) continue;
                if (this.updateStatus(1) == 3) {
                    this.updateStatus(3);
                    throw new IllegalStateException("ThreadGate.close: ThreadGate has been destroyed.");
                }
                this.setClosingThread(thread);
                this.setCloseCount(1);
                return true;
            } while ((cMillis = this.doWait(cMillis)) != 0L);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean close(long cMillis) {
        Thread thread = Thread.currentThread();
        if (this.getClosingThread() == thread && this.getStatus() == 2) {
            this.setCloseCount(this.getCloseCount() + 1);
            return true;
        }
        AtomicLong atomicState = this.m_atomicState;
        long cEnterThis = (Long)this.m_tlcEnters.get();
        long lStatusReq = 0L | cEnterThis;
        long lStatusEnd = 0x2000000000000000L | cEnterThis;
        boolean fReenter = false;
        boolean fReopen = false;
        ThreadGate threadGate = this;
        synchronized (threadGate) {
            try {
                if (this.getClosingThread() == thread) {
                    lStatusReq = 0x1000000000000000L;
                    if (cEnterThis > 0L) {
                        fReenter = true;
                        atomicState.addAndGet(-cEnterThis);
                    }
                }
                while (true) {
                    if (atomicState.compareAndSet(lStatusReq, lStatusEnd)) {
                        this.setCloseCount(this.getCloseCount() + 1);
                        this.setClosingThread(thread);
                        fReopen = false;
                        fReenter = false;
                        boolean bl = true;
                        return bl;
                    }
                    if (this.getClosingThread() == null) {
                        if (this.updateStatus(1) == 3) {
                            this.updateStatus(3);
                            throw new IllegalStateException("ThreadGate.close: ThreadGate has been destroyed.");
                        }
                        this.setClosingThread(thread);
                        lStatusReq = 0x1000000000000000L;
                        fReopen = true;
                        if (cEnterThis <= 0L) continue;
                        fReenter = true;
                        atomicState.addAndGet(-cEnterThis);
                        continue;
                    }
                    if ((cMillis = this.doWait(cMillis)) == 0L) break;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (fReenter) {
                    atomicState.addAndGet(cEnterThis);
                }
                if (fReopen) {
                    this.setClosingThread(null);
                    this.updateStatus(0);
                    this.notifyAll();
                }
            }
        }
    }

    public synchronized void destroy() {
        switch (this.getStatus()) {
            case 2: {
                Thread thread = Thread.currentThread();
                if (thread != this.getClosingThread()) {
                    throw new IllegalStateException("ThreadGate.destroy: Gate was not closed by this thread! " + this);
                }
                this.updateStatus(3);
                this.setClosingThread(null);
                this.notifyAll();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("ThreadGate.destroy: Gate is not closed! " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean enter(long cMillis) {
        AtomicLong atomicState = this.m_atomicState;
        ThreadLocalCounter tlcEnters = this.m_tlcEnters;
        if (tlcEnters.increment() > 1L || this.getClosingThread() == Thread.currentThread()) {
            if ((atomicState.incrementAndGet() & 0xFFFFFFFFFFFFFFFL) <= Integer.MAX_VALUE) return true;
            atomicState.decrementAndGet();
            tlcEnters.decrement();
            throw new IllegalStateException("The ThreadGate is full.");
        }
        ThreadLocalCounter tlcVersion = this.m_tlcVersion;
        boolean fSuccess = false;
        try {
            block15: while (true) {
                long lStatus = atomicState.get();
                switch ((int)(lStatus >>> 60)) {
                    case 0: {
                        if (!atomicState.compareAndSet(lStatus, lStatus + 1L)) continue block15;
                        long cVersion = this.getVersion();
                        if (cVersion > (Long)tlcVersion.get()) {
                            ThreadGate threadGate = this;
                            // MONITORENTER : threadGate
                            // MONITOREXIT : threadGate
                            tlcVersion.set(cVersion);
                        }
                        fSuccess = true;
                        boolean bl = true;
                        return bl;
                    }
                    case 1: 
                    case 2: {
                        ThreadGate threadGate = this;
                        // MONITORENTER : threadGate
                        long nStatus = this.getStatus();
                        if ((nStatus == 1L || nStatus == 2L) && (cMillis = this.doWait(cMillis)) == 0L) {
                            boolean bl = false;
                            // MONITOREXIT : threadGate
                            return bl;
                        }
                        tlcVersion.set(this.getVersion());
                        // MONITOREXIT : threadGate
                        continue block15;
                    }
                    case 3: {
                        tlcEnters.decrement();
                        throw new IllegalStateException("ThreadGate.enter: ThreadGate has been destroyed.");
                    }
                }
                tlcEnters.decrement();
                throw new IllegalStateException("ThreadGate.enter: ThreadGate has an invalid status. " + this);
            }
        }
        finally {
            if (!fSuccess) {
                tlcEnters.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit() {
        ThreadLocalCounter tlcEnters = this.m_tlcEnters;
        if (tlcEnters.decrement() < 0L) {
            tlcEnters.increment();
            throw new IllegalMonitorStateException("ThreadGate.exit: Thread has already exited! " + this);
        }
        if (this.m_atomicState.decrementAndGet() == 0x1000000000000000L) {
            ThreadGate threadGate = this;
            synchronized (threadGate) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        int cClosed;
        if (Thread.currentThread() == this.getClosingThread() && (cClosed = this.getCloseCount() - 1) >= 0) {
            this.setCloseCount(cClosed);
            if (cClosed == 0) {
                long cVersion = this.getVersion() + 1L;
                this.setVersion(cVersion);
                this.m_tlcVersion.set(cVersion);
                ThreadGate threadGate = this;
                synchronized (threadGate) {
                    this.updateStatus(0);
                    this.setClosingThread(null);
                    this.notifyAll();
                }
            }
            return;
        }
        throw new IllegalMonitorStateException("ThreadGate.open: Gate was not closed by this thread! " + this);
    }

    @Override
    public boolean isClosedByCurrentThread() {
        return this.getClosingThread() == Thread.currentThread() && this.getStatus() == 2;
    }

    @Override
    public boolean isEnteredByCurrentThread() {
        return (Long)this.m_tlcEnters.get() > 0L;
    }

    @Override
    public boolean isClosed() {
        return this.getStatus() == 2;
    }

    protected long doWait(long cMillis) {
        if (cMillis == 0L) {
            return 0L;
        }
        long lTime = ThreadGate.getSafeTimeMillis();
        try {
            this.wait(Math.max(0L, cMillis));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WrapperException(e, this.toString());
        }
        return cMillis < 0L ? cMillis : Math.max(0L, cMillis - (ThreadGate.getSafeTimeMillis() - lTime));
    }

    public int getActiveCount() {
        return (int)(this.m_atomicState.get() & 0xFFFFFFFFFFFFFFFL);
    }

    protected long getVersion() {
        return this.m_cVersion;
    }

    protected void setVersion(long cVersion) {
        this.m_cVersion = cVersion;
    }

    public int getCloseCount() {
        return this.m_cClose;
    }

    protected void setCloseCount(int cClose) {
        this.m_cClose = cClose;
    }

    protected Thread getClosingThread() {
        return this.m_threadClosing;
    }

    protected void setClosingThread(Thread thread) {
        this.m_threadClosing = thread;
    }

    public int getStatus() {
        return (int)(this.m_atomicState.get() >>> 60);
    }

    protected int updateStatus(int nStatus) {
        long lNew;
        long lCurr;
        AtomicLong atomicState = this.m_atomicState;
        long lStatus = (long)nStatus << 60;
        while (!atomicState.compareAndSet(lCurr = atomicState.get(), lNew = lStatus | lCurr & 0xFFFFFFFFFFFFFFFL)) {
        }
        return (int)(lCurr >>> 60);
    }

    public synchronized String toString() {
        String sState;
        switch (this.getStatus()) {
            case 0: {
                sState = "GATE_OPEN";
                break;
            }
            case 1: {
                sState = "GATE_CLOSING";
                break;
            }
            case 2: {
                sState = "GATE_CLOSED";
                break;
            }
            case 3: {
                sState = "GATE_DESTROYED";
                break;
            }
            default: {
                sState = "INVALID";
            }
        }
        return "ThreadGate{State=" + sState + ", ActiveCount=" + this.getActiveCount() + ", CloseCount=" + this.getCloseCount() + ", ClosingThread= " + this.getClosingThread() + '}';
    }

    public static class ThreadLocalCounter
    extends ThreadLocal<Long> {
        public ThreadLocalCounter() {
            this.set(0L);
        }

        public long increment() {
            long c = (Long)this.get() + 1L;
            this.set(c);
            return c;
        }

        public long decrement() {
            long c = (Long)this.get() - 1L;
            this.set(c);
            return c;
        }

        @Override
        protected Long initialValue() {
            return 0L;
        }
    }
}

