/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.SubSet;
import com.tangosol.util.WrapperCollections;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UnsafeSubSet<E>
extends SubSet {
    private boolean m_fModified;

    public UnsafeSubSet(Set<E> set) {
        super(new WrapperSet<E>(set));
    }

    @Override
    public WrapperSet<E> getOriginal() {
        return (WrapperSet)super.getOriginal();
    }

    @Override
    public void resolve() {
        throw new UnsupportedOperationException("Resolve is not supported by UnsafeSubSet.");
    }

    @Override
    public boolean isModified() {
        return this.m_fModified || super.isModified();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Reset is not supported by UnsafeSubSet.");
    }

    @Override
    public boolean removeAll(Collection col) {
        if (((WrapperSet)this.getOriginal()).isInitialized()) {
            return super.removeAll(col);
        }
        this.resetState(this.getOriginal(), col instanceof Set ? (Set)col : new HashSet(col), false);
        ((WrapperSet)this.getOriginal()).initialize();
        return !col.isEmpty();
    }

    @Override
    public boolean retainAll(Collection col) {
        if (((WrapperSet)this.getOriginal()).isInitialized()) {
            return super.retainAll(col);
        }
        this.m_fModified = true;
        WrapperSet setRetained = new WrapperSet(col instanceof Set ? (Set)col : new HashSet(col));
        this.resetState(setRetained, null, false);
        return !setRetained.isEmpty();
    }

    protected static class WrapperSet<E>
    extends WrapperCollections.AbstractWrapperSet<E> {
        boolean m_fInitialized;

        protected WrapperSet(Set<E> set) {
            super(set);
        }

        @Override
        protected Set<E> getDelegate() {
            if (!this.isInitialized()) {
                this.initialize();
            }
            return super.getDelegate();
        }

        protected void initialize() {
            this.m_fInitialized = true;
        }

        public boolean isInitialized() {
            return this.m_fInitialized;
        }
    }
}

