/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Gate;
import com.tangosol.util.ThreadGateLite;

public class WrapperReentrantGate
implements Gate {
    private final Gate m_gate;
    private int m_cLocked = 0;
    private final ThreadLocal<int[]> m_cEntered = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[]{0};
        }
    };

    public WrapperReentrantGate() {
        this(new ThreadGateLite());
    }

    public WrapperReentrantGate(Gate gate) {
        this.m_gate = gate;
    }

    @Override
    public boolean close(long cMillis) {
        if (this.m_gate.isClosedByCurrentThread() || this.m_gate.close(cMillis)) {
            ++this.m_cLocked;
            return true;
        }
        return false;
    }

    @Override
    public void open() {
        if (!this.m_gate.isClosedByCurrentThread() || --this.m_cLocked == 0) {
            this.m_gate.open();
        }
    }

    @Override
    public boolean enter(long cMillis) {
        if (this.m_gate.isEnteredByCurrentThread() || this.m_gate.enter(cMillis)) {
            int[] nArray = this.m_cEntered.get();
            nArray[0] = nArray[0] + 1;
            return true;
        }
        return false;
    }

    @Override
    public void exit() {
        block3: {
            block2: {
                if (!this.m_gate.isEnteredByCurrentThread()) break block2;
                int[] nArray = this.m_cEntered.get();
                nArray[0] = nArray[0] - 1;
                if (nArray[0] != 0) break block3;
            }
            this.m_gate.exit();
        }
    }

    @Override
    public boolean isClosedByCurrentThread() {
        return this.m_gate.isClosedByCurrentThread();
    }

    @Override
    public boolean isEnteredByCurrentThread() {
        return this.m_gate.isEnteredByCurrentThread();
    }

    @Override
    public boolean isClosed() {
        return this.m_gate.isClosed();
    }
}

