/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.aggregator.AbstractBigDecimalAggregator;
import java.io.IOException;
import java.math.BigDecimal;

public class BigDecimalAverage
extends AbstractBigDecimalAggregator {
    public BigDecimalAverage() {
    }

    public BigDecimalAverage(ValueExtractor extractor) {
        super(extractor);
    }

    public BigDecimalAverage(String sMethod) {
        super(sMethod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void process(Object o, boolean fFinal) {
        if (o == null) return;
        BigDecimal decResult = this.m_decResult;
        if (fFinal) {
            try {
                ByteArrayReadBuffer buff = new ByteArrayReadBuffer((byte[])o);
                ReadBuffer.BufferInput in = buff.getBufferInput();
                int c = in.readInt();
                if (c <= 0) return;
                BigDecimal dec = ExternalizableHelper.readBigDecimal(in);
                this.m_count += c;
                this.m_decResult = decResult == null ? dec : decResult.add(dec);
                return;
            }
            catch (IOException e) {
                throw new WrapperException(e);
            }
        } else {
            BigDecimal dec = BigDecimalAverage.ensureBigDecimal((Number)o);
            ++this.m_count;
            this.m_decResult = decResult == null ? dec : decResult.add(dec);
        }
    }

    @Override
    protected Object finalizeResult(boolean fFinal) {
        int c = this.m_count;
        BigDecimal decResult = this.m_decResult;
        if (fFinal) {
            return c == 0 ? null : decResult.divide(BigDecimal.valueOf(c), decResult.scale() + 8, 4);
        }
        try {
            ByteArrayWriteBuffer buff = new ByteArrayWriteBuffer(32);
            WriteBuffer.BufferOutput out = buff.getBufferOutput();
            out.writeInt(c);
            if (c > 0) {
                ExternalizableHelper.writeBigDecimal(out, decResult);
            }
            return buff.getRawByteArray();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }
}

