/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.comparator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.QueryMap;
import com.tangosol.util.comparator.EntryAwareComparator;
import com.tangosol.util.comparator.QueryMapComparator;
import com.tangosol.util.extractor.KeyExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;

public class SafeComparator
extends Base
implements Comparator,
QueryMapComparator,
EntryAwareComparator,
Serializable,
ExternalizableLite,
PortableObject {
    public static final SafeComparator INSTANCE = new SafeComparator();
    protected Comparator m_comparator;

    public SafeComparator() {
    }

    public SafeComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public int compare(Object o1, Object o2) {
        return SafeComparator.compareSafe(this.getComparator(), o1, o2);
    }

    @Override
    public int compareEntries(QueryMap.Entry entry1, QueryMap.Entry entry2) {
        Comparator comparator = this.getComparator();
        return comparator instanceof QueryMapComparator ? ((QueryMapComparator)comparator).compareEntries(entry1, entry2) : SafeComparator.compareSafe(comparator, entry1.getValue(), entry2.getValue());
    }

    @Override
    public boolean isKeyComparator() {
        return SafeComparator.isKeyComparator(this.getComparator());
    }

    public static boolean isKeyComparator(Comparator comparator) {
        return comparator instanceof KeyExtractor || comparator instanceof EntryAwareComparator && ((EntryAwareComparator)comparator).isKeyComparator();
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public static int compareSafe(Comparator comparator, Object o1, Object o2) {
        if (comparator != null) {
            try {
                return comparator.compare(o1, o2);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return ((Comparable)o1).compareTo((Comparable)o2);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + " (" + this.m_comparator + ')';
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SafeComparator && SafeComparator.equals(this.m_comparator, ((SafeComparator)o).m_comparator);
    }

    public int hashCode() {
        Comparator comparator = this.m_comparator;
        return comparator == null ? 17 : comparator.hashCode();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_comparator = (Comparator)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_comparator);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_comparator = (Comparator)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_comparator);
    }
}

