/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueManipulator;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.ReflectionUpdater;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CompositeUpdater
extends Base
implements ValueUpdater,
ValueManipulator,
ExternalizableLite,
PortableObject {
    protected ValueExtractor m_extractor;
    protected ValueUpdater m_updater;

    public CompositeUpdater() {
    }

    public CompositeUpdater(ValueExtractor extractor, ValueUpdater updater) {
        CompositeUpdater.azzert(extractor != null && updater != null);
        this.m_extractor = extractor;
        this.m_updater = updater;
    }

    public CompositeUpdater(String sName) {
        CompositeUpdater.azzert(sName != null && sName.length() > 0);
        int ofLast = sName.lastIndexOf(46);
        this.m_extractor = ofLast == -1 ? IdentityExtractor.INSTANCE : new ChainedExtractor(sName.substring(0, ofLast));
        this.m_updater = new ReflectionUpdater(sName.substring(ofLast + 1));
    }

    @Override
    public void update(Object oTarget, Object oValue) {
        this.getUpdater().update(this.getExtractor().extract(oTarget), oValue);
    }

    @Override
    public ValueExtractor getExtractor() {
        return this.m_extractor;
    }

    @Override
    public ValueUpdater getUpdater() {
        return this.m_updater;
    }

    public String toString() {
        return "CompositeUpdater(" + this.m_extractor + ", " + this.m_updater + ')';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject(in);
        this.m_updater = (ValueUpdater)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_extractor);
        ExternalizableHelper.writeObject(out, this.m_updater);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_updater = (ValueUpdater)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeObject(1, this.m_updater);
    }
}

