/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.QueryMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.AbstractCompositeExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.util.Map;

public class MultiExtractor
extends AbstractCompositeExtractor {
    public MultiExtractor() {
    }

    public MultiExtractor(ValueExtractor[] aExtractor) {
        super(aExtractor);
    }

    public MultiExtractor(String sNames) {
        super(MultiExtractor.createExtractors(sNames));
    }

    @Override
    public Object extract(Object oTarget) {
        if (oTarget == null) {
            return null;
        }
        ValueExtractor[] aExtractor = this.getExtractors();
        int cExtractors = aExtractor.length;
        Object[] aValue = new Object[cExtractors];
        for (int i = 0; i < cExtractors; ++i) {
            aValue[i] = aExtractor[i].extract(oTarget);
        }
        return new ImmutableArrayList(aValue);
    }

    @Override
    public Object extractFromEntry(Map.Entry entry) {
        ValueExtractor[] aExtractor = this.getExtractors();
        int cExtractors = aExtractor.length;
        Object[] aValue = new Object[cExtractors];
        for (int i = 0; i < cExtractors; ++i) {
            aValue[i] = InvocableMapHelper.extractFromEntry(aExtractor[i], entry);
        }
        return new ImmutableArrayList(aValue);
    }

    @Override
    public Object extractOriginalFromEntry(MapTrigger.Entry entry) {
        ValueExtractor[] aExtractor = this.getExtractors();
        int cExtractors = aExtractor.length;
        Object[] aValue = new Object[cExtractors];
        for (int i = 0; i < cExtractors; ++i) {
            aValue[i] = InvocableMapHelper.extractOriginalFromEntry(aExtractor[i], entry);
        }
        return new ImmutableArrayList(aValue);
    }

    @Override
    public int compareEntries(QueryMap.Entry entry1, QueryMap.Entry entry2) {
        for (ValueExtractor extractor : this.getExtractors()) {
            int iResult = SafeComparator.compareSafe(null, entry1.extract(extractor), entry2.extract(extractor));
            if (iResult == 0) continue;
            return iResult;
        }
        return 0;
    }

    public static ValueExtractor[] createExtractors(String sNames) {
        String[] asMethod = MultiExtractor.parseDelimitedString(sNames, ',');
        int cMethods = asMethod.length;
        ValueExtractor[] aExtractor = new ValueExtractor[cMethods];
        for (int i = 0; i < cMethods; ++i) {
            String sMethod = asMethod[i];
            aExtractor[i] = sMethod.indexOf(46) < 0 ? new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod);
        }
        return aExtractor;
    }
}

