/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.reflect.PofNavigationException;
import com.tangosol.io.pof.reflect.PofNavigator;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.io.pof.reflect.PofValueParser;
import com.tangosol.io.pof.reflect.SimplePofPath;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.AbstractUpdater;
import java.io.IOException;
import java.io.NotActiveException;
import java.util.Map;

public class PofUpdater
extends AbstractUpdater
implements ValueUpdater,
PortableObject {
    private PofNavigator m_navigator;

    public PofUpdater() {
    }

    public PofUpdater(int iProp) {
        this(new SimplePofPath(iProp));
    }

    public PofUpdater(PofNavigator navigator) {
        PofUpdater.azzert(navigator != null, "Navigator must not be null.");
        this.m_navigator = navigator;
    }

    @Override
    public void update(Object oTarget, Object oValue) {
        if (oTarget instanceof Map.Entry) {
            this.updateEntry((Map.Entry)oTarget, oValue);
        } else {
            super.update(oTarget, oValue);
        }
    }

    @Override
    public void updateEntry(Map.Entry entry, Object oValue) {
        try {
            BinaryEntry binEntry = (BinaryEntry)entry;
            PofValue valueRoot = PofValueParser.parse(binEntry.getBinaryValue(), (PofContext)binEntry.getSerializer());
            PofValue valueProp = this.m_navigator.navigate(valueRoot);
            if (valueProp == null) {
                throw new PofNavigationException("Property is missing: " + this.m_navigator);
            }
            valueProp.setValue(oValue);
            binEntry.updateBinaryValue(valueRoot.applyChanges());
        }
        catch (ClassCastException cce) {
            String sReason = entry instanceof BinaryEntry ? "the configured Serializer is not a PofContext" : "the Map Entry is not a BinaryEntry";
            throw new UnsupportedOperationException("PofUpdater must be used with POF-encoded Binary entries;" + sReason);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PofUpdater) {
            PofUpdater that = (PofUpdater)o;
            return this.m_navigator.equals(that.m_navigator);
        }
        return false;
    }

    public int hashCode() {
        return this.m_navigator.hashCode();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(navigator=" + this.m_navigator + ')';
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_navigator = (PofNavigator)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        PofNavigator navigator = this.m_navigator;
        if (navigator == null) {
            throw new NotActiveException("PofUpdater was constructed without a navigator");
        }
        out.writeObject(0, navigator);
    }
}

