/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.QueryRecorderFilter;
import java.util.Map;
import java.util.Set;

public abstract class AbstractQueryRecorderFilter
extends ExternalizableHelper
implements QueryRecorderFilter {
    @Override
    public void explain(QueryContext ctx, QueryRecord.PartialResult.ExplainStep step, Set setKeys) {
        AbstractQueryRecorderFilter.explain(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step);
    }

    @Override
    public Filter trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Set setKeys) {
        return AbstractQueryRecorderFilter.trace(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step);
    }

    @Override
    public boolean trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Map.Entry entry) {
        return AbstractQueryRecorderFilter.trace(this, entry, step);
    }

    protected static void explain(Filter filter, Map mapIndexes, Set setKeys, QueryRecord.PartialResult.ExplainStep step) {
        step.recordPreFilterKeys(setKeys.size());
        if (filter instanceof IndexAwareFilter) {
            if (filter instanceof ExtractorFilter) {
                step.recordExtractor(((ExtractorFilter)filter).getValueExtractor());
            }
            step.recordEfficiency(((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys));
        }
    }

    protected static Filter trace(Filter filter, Map mapIndexes, Set setKeys, QueryRecord.PartialResult.TraceStep step) {
        step.recordPreFilterKeys(setKeys.size());
        if (filter instanceof IndexAwareFilter) {
            if (filter instanceof ExtractorFilter) {
                step.recordExtractor(((ExtractorFilter)filter).getValueExtractor());
            }
            long ldtStart = Base.getSafeTimeMillis();
            filter = ((IndexAwareFilter)filter).applyIndex(mapIndexes, setKeys);
            long ldtEnd = Base.getSafeTimeMillis();
            step.recordDuration(ldtEnd - ldtStart);
        }
        step.recordPostFilterKeys(setKeys.size());
        return filter;
    }

    protected static boolean trace(Filter filter, Map.Entry entry, QueryRecord.PartialResult.TraceStep step) {
        step.recordPreFilterKeys(1);
        long ldtStart = Base.getSafeTimeMillis();
        boolean fResult = InvocableMapHelper.evaluateEntry(filter, entry);
        long ldtEnd = Base.getSafeTimeMillis();
        step.recordDuration(ldtEnd - ldtStart);
        step.recordPostFilterKeys(fResult ? 1 : 0);
        return fResult;
    }
}

