/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ContainsAllFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public ContainsAllFilter() {
    }

    public ContainsAllFilter(ValueExtractor extractor, Set setValues) {
        super(extractor, new HashSet(setValues));
        ContainsAllFilter.azzert(setValues != null);
    }

    public ContainsAllFilter(String sMethod, Set setValues) {
        super(sMethod, new HashSet(setValues));
        ContainsAllFilter.azzert(setValues != null);
    }

    @Override
    protected boolean evaluateExtracted(Object oExtracted) {
        Collection collValues = (Collection)this.getValue();
        if (oExtracted instanceof Collection) {
            return ((Collection)oExtracted).containsAll(collValues);
        }
        if (oExtracted instanceof Object[]) {
            Object[] aoExtracted = (Object[])oExtracted;
            int cExtracted = aoExtracted.length;
            block0: for (Object oValue : collValues) {
                for (int i = 0; i < cExtracted; ++i) {
                    if (ContainsAllFilter.equals(aoExtracted[i], oValue)) continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? ContainsAllFilter.calculateIteratorEffectiveness(setKeys.size()) : ((Collection)this.getValue()).size();
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        for (Object oValue : (Collection)this.getValue()) {
            Set setEQ = (Set)index.getIndexContents().get(oValue);
            if (setEQ == null) {
                setKeys.clear();
                break;
            }
            setKeys.retainAll(setEQ);
            if (!setKeys.isEmpty()) continue;
            break;
        }
        return null;
    }
}

