/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SafeSortedMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class GreaterEqualsFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public GreaterEqualsFilter() {
    }

    public GreaterEqualsFilter(ValueExtractor extractor, Comparable oValue) {
        super(extractor, (Object)oValue);
    }

    public GreaterEqualsFilter(String sMethod, Comparable oValue) {
        super(sMethod, (Object)oValue);
    }

    public GreaterEqualsFilter(String sMethod, int iValue) {
        this(sMethod, (Comparable)GreaterEqualsFilter.makeInteger(iValue));
    }

    public GreaterEqualsFilter(String sMethod, long lValue) {
        this(sMethod, (Comparable)GreaterEqualsFilter.makeLong(lValue));
    }

    public GreaterEqualsFilter(String sMethod, float fValue) {
        this(sMethod, (Comparable)new Float(fValue));
    }

    public GreaterEqualsFilter(String sMethod, double dValue) {
        this(sMethod, (Comparable)new Double(dValue));
    }

    @Override
    protected boolean evaluateExtracted(Object oExtracted) {
        try {
            Comparable oLeft = (Comparable)oExtracted;
            Comparable oRight = (Comparable)this.getValue();
            return oLeft != null && oRight != null && oLeft.compareTo(oRight) >= 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return this.calculateRangeEffectiveness(mapIndexes, setKeys);
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Object oValue = this.getValue();
        if (oValue == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.isOrdered()) {
            boolean fHeadHeavy;
            SortedMap mapGE;
            SortedMap mapLT;
            SortedMap mapContents = (SortedMap)index.getIndexContents();
            if (mapContents instanceof SafeSortedMap) {
                SafeSortedMap.Split split = ((SafeSortedMap)mapContents).split(oValue);
                mapLT = split.getHead();
                mapGE = split.getTail();
                fHeadHeavy = split.isHeadHeavy();
            } else {
                mapLT = mapContents.headMap(oValue);
                mapGE = mapContents.tailMap(oValue);
                boolean bl = fHeadHeavy = mapLT.size() > mapContents.size() / 2;
            }
            if (fHeadHeavy || index.isPartial()) {
                HashSet setGE = new HashSet();
                for (Set set : mapGE.values()) {
                    setGE.addAll(set);
                }
                setKeys.retainAll(setGE);
            } else {
                for (Set set : mapLT.values()) {
                    setKeys.removeAll(set);
                }
            }
        } else {
            Map mapContents = index.getIndexContents();
            if (index.isPartial()) {
                HashSet setGE = new HashSet();
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest == null || oTest.compareTo(oValue) < 0) continue;
                    setGE.addAll((Set)entry.getValue());
                }
                setKeys.retainAll(setGE);
            } else {
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest != null && oTest.compareTo(oValue) >= 0) continue;
                    setKeys.removeAll((Set)entry.getValue());
                }
            }
        }
        return null;
    }
}

