/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NotEqualsFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public NotEqualsFilter() {
    }

    public NotEqualsFilter(ValueExtractor extractor, Object oValue) {
        super(extractor, oValue);
    }

    public NotEqualsFilter(String sMethod, Object oValue) {
        super(sMethod, oValue);
    }

    public NotEqualsFilter(String sMethod, int iValue) {
        this(sMethod, (Object)NotEqualsFilter.makeInteger(iValue));
    }

    public NotEqualsFilter(String sMethod, long lValue) {
        this(sMethod, (Object)NotEqualsFilter.makeLong(lValue));
    }

    public NotEqualsFilter(String sMethod, float fValue) {
        this(sMethod, (Object)new Float(fValue));
    }

    public NotEqualsFilter(String sMethod, double dValue) {
        this(sMethod, (Object)new Double(dValue));
    }

    @Override
    protected boolean evaluateExtracted(Object oExtracted) {
        return !NotEqualsFilter.equals(oExtracted, this.getValue());
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return this.calculateMatchEffectiveness(mapIndexes, setKeys);
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Map mapContents = index.getIndexContents();
        Object oValue = this.getValue();
        if (index.isPartial()) {
            HashSet setNE = new HashSet();
            for (Map.Entry entry : mapContents.entrySet()) {
                if (entry.getKey().equals(oValue)) continue;
                Set set = (Set)entry.getValue();
                setNE.addAll(set);
            }
            setKeys.retainAll(setNE);
        } else {
            Set setEquals = (Set)mapContents.get(oValue);
            if (setEquals != null && !setEquals.isEmpty()) {
                setKeys.removeAll(setEquals);
            }
        }
        return null;
    }
}

