/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class ConditionalPut
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected Filter m_filter;
    protected Object m_oValue;
    protected boolean m_fReturn;

    public ConditionalPut() {
    }

    public ConditionalPut(Filter filter, Object oValue) {
        this(filter, oValue, false);
    }

    public ConditionalPut(Filter filter, Object oValue, boolean fReturn) {
        ConditionalPut.azzert(filter != null, "Filter is null");
        this.m_filter = filter;
        this.m_oValue = oValue;
        this.m_fReturn = fReturn;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        if (InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
            entry.setValue(this.m_oValue, false);
            return null;
        }
        return this.m_fReturn ? entry.getValue() : null;
    }

    @Override
    public Map processAll(Set setEntries) {
        LiteMap mapResult = new LiteMap();
        Filter filter = this.m_filter;
        Object oValue = this.m_oValue;
        boolean fReturn = this.m_fReturn;
        for (InvocableMap.Entry entry : setEntries) {
            if (InvocableMapHelper.evaluateEntry(filter, entry)) {
                entry.setValue(oValue, false);
                continue;
            }
            if (!fReturn) continue;
            mapResult.put(entry.getKey(), entry.getValue());
        }
        return mapResult;
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalPut) {
            ConditionalPut that = (ConditionalPut)o;
            return ConditionalPut.equals(this.m_filter, that.m_filter) && ConditionalPut.equals(this.m_oValue, that.m_oValue) && this.m_fReturn == that.m_fReturn;
        }
        return false;
    }

    public int hashCode() {
        Object oValue = this.m_oValue;
        int nHash = oValue == null ? 0 : oValue.hashCode();
        return nHash + this.m_filter.hashCode() + (this.m_fReturn ? -1 : 1);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Filter = " + this.m_filter + ", Value=" + this.m_oValue + ", ReturnRequired= " + this.m_fReturn + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_oValue = ExternalizableHelper.readObject(in);
        this.m_fReturn = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_filter);
        ExternalizableHelper.writeObject(out, this.m_oValue);
        out.writeBoolean(this.m_fReturn);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_oValue = in.readObject(1);
        this.m_fReturn = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_oValue);
        out.writeBoolean(2, this.m_fReturn);
    }
}

