/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.SubstitutionResolver;
import com.typesafe.config.impl.Unmergeable;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class ConfigSubstitution
extends AbstractConfigValue
implements Unmergeable {
    private static final long serialVersionUID = 1L;
    private final List<Object> pieces;
    private final int prefixLength;
    private final boolean ignoresFallbacks;
    private static final int MAX_DEPTH = 100;

    ConfigSubstitution(ConfigOrigin configOrigin, List<Object> list) {
        this(configOrigin, list, 0, false);
    }

    private ConfigSubstitution(ConfigOrigin configOrigin, List<Object> list, int n, boolean bl) {
        super(configOrigin);
        this.pieces = list;
        this.prefixLength = n;
        this.ignoresFallbacks = bl;
        for (Object object : list) {
            if (!(object instanceof Path)) continue;
            throw new RuntimeException("broken here");
        }
    }

    @Override
    public ConfigValueType valueType() {
        throw new ConfigException.NotResolved("need to call resolve() on root config; tried to get value type on an unresolved substitution: " + this);
    }

    @Override
    public Object unwrapped() {
        throw new ConfigException.NotResolved("need to call resolve() on root config; tried to unwrap an unresolved substitution: " + this);
    }

    @Override
    protected ConfigSubstitution newCopy(boolean bl, ConfigOrigin configOrigin) {
        return new ConfigSubstitution(configOrigin, this.pieces, this.prefixLength, bl);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    @Override
    protected AbstractConfigValue mergedWithTheUnmergeable(Unmergeable unmergeable) {
        if (this.ignoresFallbacks) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.add(this);
        arrayList.addAll(unmergeable.unmergedValues());
        return new ConfigDelayedMerge(AbstractConfigObject.mergeOrigins(arrayList), arrayList, ((AbstractConfigValue)((Object)unmergeable)).ignoresFallbacks());
    }

    protected AbstractConfigValue mergedLater(AbstractConfigValue abstractConfigValue) {
        if (this.ignoresFallbacks) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.add(this);
        arrayList.add(abstractConfigValue);
        return new ConfigDelayedMerge(AbstractConfigObject.mergeOrigins(arrayList), arrayList, abstractConfigValue.ignoresFallbacks());
    }

    @Override
    protected AbstractConfigValue mergedWithObject(AbstractConfigObject abstractConfigObject) {
        return this.mergedLater(abstractConfigObject);
    }

    @Override
    protected AbstractConfigValue mergedWithNonObject(AbstractConfigValue abstractConfigValue) {
        if (this.pieces.size() == 1 && ((SubstitutionExpression)this.pieces.get(0)).optional()) {
            return this.mergedLater(abstractConfigValue);
        }
        return super.mergedWithNonObject(abstractConfigValue);
    }

    public Collection<ConfigSubstitution> unmergedValues() {
        return Collections.singleton(this);
    }

    List<Object> pieces() {
        return this.pieces;
    }

    private ConfigValue findInObject(AbstractConfigObject abstractConfigObject, SubstitutionResolver substitutionResolver, Path path, int n, ConfigResolveOptions configResolveOptions) {
        if (n > 100) {
            throw new ConfigException.BadValue((ConfigOrigin)this.origin(), path.render(), "Substitution ${" + path.render() + "} is part of a cycle of substitutions");
        }
        AbstractConfigValue abstractConfigValue = abstractConfigObject.peekPath(path, substitutionResolver, n, configResolveOptions);
        if (abstractConfigValue instanceof ConfigSubstitution) {
            throw new ConfigException.BugOrBroken("peek or peekPath returned an unresolved substitution");
        }
        return abstractConfigValue;
    }

    private ConfigValue resolve(SubstitutionResolver substitutionResolver, SubstitutionExpression substitutionExpression, int n, ConfigResolveOptions configResolveOptions) {
        ConfigValue configValue = this.findInObject(substitutionResolver.root(), substitutionResolver, substitutionExpression.path(), n, configResolveOptions);
        if (configValue == null) {
            Path path = substitutionExpression.path().subPath(this.prefixLength);
            if (configValue == null && this.prefixLength > 0) {
                configValue = this.findInObject(substitutionResolver.root(), substitutionResolver, path, n, configResolveOptions);
            }
            if (configValue == null && configResolveOptions.getUseSystemEnvironment()) {
                configValue = this.findInObject(ConfigImpl.envVariablesAsConfigObject(), null, path, n, configResolveOptions);
            }
        }
        return configValue;
    }

    private ConfigValue resolve(SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        if (this.pieces.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.pieces) {
                if (object instanceof String) {
                    stringBuilder.append((String)object);
                    continue;
                }
                SubstitutionExpression substitutionExpression = (SubstitutionExpression)object;
                ConfigValue configValue = this.resolve(substitutionResolver, substitutionExpression, n, configResolveOptions);
                if (configValue == null) {
                    if (substitutionExpression.optional()) continue;
                    throw new ConfigException.UnresolvedSubstitution(this.origin(), substitutionExpression.toString());
                }
                switch (configValue.valueType()) {
                    case LIST: 
                    case OBJECT: {
                        throw new ConfigException.WrongType(configValue.origin(), substitutionExpression.path().render(), "not a list or object", configValue.valueType().name());
                    }
                }
                stringBuilder.append(((AbstractConfigValue)configValue).transformToString());
            }
            return new ConfigString(this.origin(), stringBuilder.toString());
        }
        if (!(this.pieces.get(0) instanceof SubstitutionExpression)) {
            throw new ConfigException.BugOrBroken("ConfigSubstitution should never contain a single String piece");
        }
        SubstitutionExpression substitutionExpression = (SubstitutionExpression)this.pieces.get(0);
        ConfigValue configValue = this.resolve(substitutionResolver, substitutionExpression, n, configResolveOptions);
        if (configValue == null && !substitutionExpression.optional()) {
            throw new ConfigException.UnresolvedSubstitution(this.origin(), substitutionExpression.toString());
        }
        return configValue;
    }

    @Override
    AbstractConfigValue resolveSubstitutions(SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        AbstractConfigValue abstractConfigValue = (AbstractConfigValue)this.resolve(substitutionResolver, n + 1, configResolveOptions);
        return abstractConfigValue;
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigSubstitution relativized(Path path) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : this.pieces) {
            if (object instanceof SubstitutionExpression) {
                SubstitutionExpression substitutionExpression = (SubstitutionExpression)object;
                arrayList.add(substitutionExpression.changePath(substitutionExpression.path().prepend(path)));
                continue;
            }
            arrayList.add(object);
        }
        return new ConfigSubstitution(this.origin(), arrayList, this.prefixLength + path.length(), this.ignoresFallbacks);
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigSubstitution;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigSubstitution) {
            return this.canEqual(object) && ((Object)this.pieces).equals(((ConfigSubstitution)object).pieces);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.pieces).hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, boolean bl) {
        for (Object object : this.pieces) {
            if (object instanceof SubstitutionExpression) {
                stringBuilder.append(object.toString());
                continue;
            }
            stringBuilder.append(ConfigImplUtil.renderJsonString((String)object));
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ConfigSubstitution(this.origin(), new LinkedList<Object>(this.pieces), this.prefixLength, this.ignoresFallbacks);
    }
}

