/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net;

import java.net.SocketException;
import java.net.SocketOptions;
import java.util.HashMap;
import java.util.Map;

public class SocketSettings
implements SocketOptions {
    protected Map m_mapOptions = new HashMap();

    public SocketSettings() {
    }

    public SocketSettings(SocketOptions options) {
        this.setOptions(options);
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        this.m_mapOptions.put(optID, value);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        return this.m_mapOptions.get(optID);
    }

    public void setOptions(SocketOptions options) {
        try {
            if (options != null) {
                Map map = this.m_mapOptions;
                for (int nOp : new int[]{1, 4, 32, 3, 128, 4102, 4097, 4098, 8, 4099}) {
                    Object oVal = options.getOption(nOp);
                    if (oVal == null) continue;
                    map.put(nOp, oVal);
                }
            }
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SocketSettings set(int optID, Object value) {
        try {
            this.setOption(optID, value);
            return this;
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object get(int optID) {
        try {
            return this.getOption(optID);
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        Map map = this.m_mapOptions;
        StringBuffer sb = new StringBuffer("SocketOptions{");
        String sDelim = "";
        String sComma = ", ";
        Object oOption = map.get(4);
        if (oOption != null) {
            sb.append(sDelim).append("ReuseAddress=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(4098)) != null) {
            sb.append(sDelim).append("ReceiveBufferSize=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(4097)) != null) {
            sb.append(sDelim).append("SendBufferSize=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(4102)) != null) {
            sb.append(sDelim).append("Timeout=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(128)) != null) {
            sb.append(sDelim).append("LingerTimeout=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(8)) != null) {
            sb.append(sDelim).append("KeepAlive=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(1)) != null) {
            sb.append(sDelim).append("TcpNoDelay=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(3)) != null) {
            sb.append(sDelim).append("TrafficClass=").append(oOption);
        }
        return sb.append('}').toString();
    }
}

