/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.optimizers.impl.refl.collection;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.DataConversion;
import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.compiler.Accessor;
import com.tangosol.coherence.mvel.compiler.ExecutableLiteral;
import com.tangosol.coherence.mvel.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.ParseTools;

public class ExprValueAccessor
implements Accessor {
    public ExecutableStatement stmt;

    public ExprValueAccessor(String ex, Class expectedType, Object ctx, VariableResolverFactory factory, ParserContext pCtx) {
        this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(ex.toCharArray(), pCtx);
        Class tt = ParseTools.getSubComponentType(expectedType);
        Class et = this.stmt.getKnownEgressType();
        if (this.stmt.getKnownEgressType() != null && !tt.isAssignableFrom(et)) {
            if (this.stmt instanceof ExecutableLiteral && DataConversion.canConvert(et, tt)) {
                try {
                    this.stmt = new ExecutableLiteral(DataConversion.convert(this.stmt.getValue(ctx, factory), tt));
                    return;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (pCtx != null && pCtx.isStrongTyping()) {
                throw new CompileException("was expecting type: " + tt + "; but found type: " + (et == null ? "null" : et.getName()));
            }
        }
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        return this.stmt.getValue(elCtx, variableFactory);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    public ExecutableStatement getStmt() {
        return this.stmt;
    }

    public void setStmt(ExecutableStatement stmt) {
        this.stmt = stmt;
    }

    public Class getKnownEgressType() {
        return this.stmt.getKnownEgressType();
    }
}

