/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.optimizers.impl.refl.nodes;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.OptimizationFailure;
import com.tangosol.coherence.mvel.compiler.AccessorNode;
import com.tangosol.coherence.mvel.integration.PropertyHandler;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import java.lang.reflect.Field;

public class StaticVarAccessorNH
implements AccessorNode {
    private AccessorNode nextNode;
    Field field;
    private PropertyHandler nullHandler;

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            Object v = this.field.get(ctx);
            if (v == null) {
                v = this.nullHandler.getProperty(this.field.getName(), elCtx, vars);
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(v, elCtx, vars);
            }
            return v;
        }
        catch (Exception e) {
            throw new OptimizationFailure("unable to access static field", e);
        }
    }

    public StaticVarAccessorNH(Field field, PropertyHandler handler) {
        this.field = field;
        this.nullHandler = handler;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(this.field.get(null), elCtx, variableFactory, value);
            }
            this.field.set(null, value);
        }
        catch (Exception e) {
            throw new CompileException("error accessing static variable", e);
        }
        return value;
    }

    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

