/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.XidManager;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.AggregateOperation;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteSet;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.util.Set;

public class StorageAggregate
implements Component {
    private static final Object NOKEY = new Object();

    @Override
    public Message invoke(Message msg) {
        Results results = msg.getResults();
        Set setEntries = (Set)msg.getContext();
        LiteSet setWrappedEntries = new LiteSet();
        AggregateOperation operation = (AggregateOperation)msg.getOperation();
        String sService = operation.getServiceName();
        for (InvocableMap.Entry entry : setEntries) {
            if (Storage.NIL.equals(entry.getValue())) continue;
            setWrappedEntries.add(new EntryWrapper(msg, entry));
        }
        InvocableMap.EntryAggregator aggregator = operation.getEntryAggregator();
        if (aggregator instanceof InvocableMap.ParallelAwareAggregator) {
            aggregator = ((InvocableMap.ParallelAwareAggregator)aggregator).getParallelAggregator();
        }
        Object oResults = aggregator.aggregate(setWrappedEntries);
        results.put(AggregateOperation.AGGREGATE_KEY, oResults);
        return msg;
    }

    protected class EntryWrapper
    implements InvocableMap.Entry {
        private Object m_oNaturalKey;
        private InvocableMap.Entry m_entry;
        private Message m_message;

        EntryWrapper(Message msg, InvocableMap.Entry entry) {
            this.m_message = msg;
            this.m_entry = entry;
            this.m_oNaturalKey = NOKEY;
        }

        @Override
        public Object getKey() {
            if (this.m_oNaturalKey == NOKEY) {
                Operation operation = this.m_message.getOperation();
                TableInfoImpl info = new TableInfoImpl(operation.getTableName(), operation.getServiceName());
                XidSyntheticKey xidSynKey = XidManager.getXidSynKeyFromEntry((BinaryEntry)this.m_entry, info);
                this.m_oNaturalKey = XidManager.getNaturalKey(xidSynKey, info);
            }
            return this.m_oNaturalKey;
        }

        @Override
        public Object getValue() {
            return this.m_entry.getValue();
        }

        @Override
        public Object setValue(Object oValue) {
            return this.m_entry.setValue(oValue);
        }

        @Override
        public void setValue(Object oValue, boolean synthetic) {
            this.m_entry.setValue(oValue, synthetic);
        }

        @Override
        public void update(ValueUpdater updater, Object oValue) {
            this.m_entry.update(updater, oValue);
        }

        @Override
        public boolean isPresent() {
            return this.m_entry.isPresent();
        }

        @Override
        public void remove(boolean b) {
            this.m_entry.remove(b);
        }

        @Override
        public Object extract(ValueExtractor valueExtractor) {
            return InvocableMapHelper.extractFromEntry(valueExtractor, this);
        }
    }
}

