/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AccessFlags
extends VMStructure
implements Constants {
    private static final String CLASS = "AccessFlags";
    private int m_nFlags;
    private int m_nPrevFlags;

    protected AccessFlags() {
    }

    protected AccessFlags(int nFlags) {
        this.m_nPrevFlags = this.m_nFlags = nFlags;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_nFlags = stream.readUnsignedShort();
    }

    @Override
    protected void preassemble(ConstantPool pool) {
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(this.m_nFlags);
    }

    @Override
    public boolean isModified() {
        return this.m_nFlags != this.m_nPrevFlags;
    }

    @Override
    protected void resetModified() {
        this.m_nPrevFlags = this.m_nFlags;
    }

    public boolean equals(Object obj) {
        try {
            AccessFlags that = (AccessFlags)obj;
            return this == that || this.getClass() == that.getClass() && this.m_nFlags == that.m_nFlags;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return this.toString(2047);
    }

    public String toString(int nMask) {
        StringBuffer sb = new StringBuffer();
        int nAccess = this.m_nFlags & nMask;
        if ((nAccess & 1) != 0) {
            sb.append(" public");
        }
        if ((nAccess & 2) != 0) {
            sb.append(" private");
        }
        if ((nAccess & 4) != 0) {
            sb.append(" protected");
        }
        if ((nAccess & 8) != 0) {
            sb.append(" static");
        }
        if ((nAccess & 0x10) != 0) {
            sb.append(" final");
        }
        if ((nAccess & 0x20) != 0) {
            sb.append(" synchronized");
        }
        if ((nAccess & 0x40) != 0) {
            sb.append(" volatile");
        }
        if ((nAccess & 0x80) != 0) {
            sb.append(" transient");
        }
        if ((nAccess & 0x40) != 0) {
            sb.append(" (bridge)");
        }
        if ((nAccess & 0x80) != 0) {
            sb.append(" (varargs)");
        }
        if ((nAccess & 0x800) != 0) {
            sb.append(" strictfp");
        }
        if ((nAccess & 0x100) != 0) {
            sb.append(" native");
        }
        if ((nAccess & 0x200) != 0) {
            sb.append(" interface");
        }
        if ((nAccess & 0x400) != 0) {
            sb.append(" abstract");
        }
        if ((nAccess & 0x1000) != 0) {
            sb.append(" (synthetic)");
        }
        if ((nAccess & 0x2000) != 0) {
            sb.append(" (annotation)");
        }
        if ((nAccess & 0x4000) != 0) {
            sb.append(" (enum)");
        }
        return sb.length() == 0 ? "" : sb.toString().substring(1);
    }

    public int getFlags() {
        return this.m_nFlags;
    }

    public void setFlags(int nFlags) {
        this.m_nFlags = nFlags & 0x7FF;
    }

    public boolean isInterface() {
        return (this.m_nFlags & 0x200) != 0;
    }

    public void setInterface(boolean fInterface) {
        this.m_nFlags = fInterface ? (this.m_nFlags |= 0x200) : (this.m_nFlags &= 0xFFFFFDFF);
    }

    public int getAccess() {
        return this.m_nFlags & 7;
    }

    public void setAccess(int nAccess) {
        this.m_nFlags = this.m_nFlags & 0xFFFFFFF8 | nAccess & 7;
    }

    public boolean isPublic() {
        return (this.m_nFlags & 1) != 0;
    }

    public void setPublic() {
        this.setAccess(1);
    }

    public boolean isProtected() {
        return (this.m_nFlags & 4) != 0;
    }

    public void setProtected() {
        this.setAccess(4);
    }

    public boolean isPackage() {
        return (this.m_nFlags & 7) == 0;
    }

    public void setPackage() {
        this.setAccess(0);
    }

    public boolean isPrivate() {
        return (this.m_nFlags & 2) != 0;
    }

    public void setPrivate() {
        this.setAccess(2);
    }

    public boolean isAbstract() {
        return (this.m_nFlags & 0x400) != 0;
    }

    public void setAbstract(boolean fAbstract) {
        this.m_nFlags = fAbstract ? (this.m_nFlags |= 0x400) : (this.m_nFlags &= 0xFFFFFBFF);
    }

    public boolean isSynthetic() {
        return (this.m_nFlags & 0x1000) != 0;
    }

    public void setSynthetic(boolean fSynthetic) {
        this.m_nFlags = fSynthetic ? (this.m_nFlags |= 0x1000) : (this.m_nFlags &= 0xFFFFEFFF);
    }

    public boolean isBridge() {
        return (this.m_nFlags & 0x40) != 0;
    }

    public void setBridge(boolean fBridge) {
        this.m_nFlags = fBridge ? (this.m_nFlags |= 0x40) : (this.m_nFlags &= 0xFFFFFFBF);
    }

    public boolean isVarArgs() {
        return (this.m_nFlags & 0x80) != 0;
    }

    public void setVarArgs(boolean fVarArgs) {
        this.m_nFlags = fVarArgs ? (this.m_nFlags |= 0x80) : (this.m_nFlags &= 0xFFFFFF7F);
    }

    public boolean isStrict() {
        return (this.m_nFlags & 0x800) != 0;
    }

    public void setStrict(boolean fStrict) {
        this.m_nFlags = fStrict ? (this.m_nFlags |= 0x800) : (this.m_nFlags &= 0xFFFFF7FF);
    }

    public boolean isAnnotation() {
        return (this.m_nFlags & 0x2000) != 0;
    }

    public void setAnnotation(boolean fAnnotation) {
        this.m_nFlags = fAnnotation ? (this.m_nFlags |= 0x2000) : (this.m_nFlags &= 0xFFFFDFFF);
    }

    public boolean isEnum() {
        return (this.m_nFlags & 0x4000) != 0;
    }

    public void setEnum(boolean fEnum) {
        this.m_nFlags = fEnum ? (this.m_nFlags |= 0x4000) : (this.m_nFlags &= 0xFFFFBFFF);
    }

    public boolean isStatic() {
        return (this.m_nFlags & 8) != 0;
    }

    public void setStatic(boolean fStatic) {
        this.m_nFlags = fStatic ? (this.m_nFlags |= 8) : (this.m_nFlags &= 0xFFFFFFF7);
    }

    public boolean isFinal() {
        return (this.m_nFlags & 0x10) != 0;
    }

    public void setFinal(boolean fFinal) {
        this.m_nFlags = fFinal ? (this.m_nFlags |= 0x10) : (this.m_nFlags &= 0xFFFFFFEF);
    }

    public boolean isSynchronized() {
        return (this.m_nFlags & 0x20) != 0;
    }

    public void setSynchronized(boolean fSync) {
        this.m_nFlags = fSync ? (this.m_nFlags |= 0x20) : (this.m_nFlags &= 0xFFFFFFDF);
    }

    public boolean isNative() {
        return (this.m_nFlags & 0x100) != 0;
    }

    public void setNative(boolean fNative) {
        this.m_nFlags = fNative ? (this.m_nFlags |= 0x100) : (this.m_nFlags &= 0xFFFFFEFF);
    }

    public boolean isVolatile() {
        return (this.m_nFlags & 0x40) != 0;
    }

    public void setVolatile(boolean fVolatile) {
        this.m_nFlags = fVolatile ? (this.m_nFlags |= 0x40) : (this.m_nFlags &= 0xFFFFFFBF);
    }

    public boolean isTransient() {
        return (this.m_nFlags & 0x80) != 0;
    }

    public void setTransient(boolean fTransient) {
        this.m_nFlags = fTransient ? (this.m_nFlags |= 0x80) : (this.m_nFlags &= 0xFFFFFF7F);
    }
}

