/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Getstatic;
import com.tangosol.dev.assembler.Invokestatic;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.SignatureConstant;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class ClassExpression
extends UnaryExpression {
    private static final String CLASS = "ClassExpression";
    private static final DataType CLZ = DataType.getClassType(Class.class);
    private static final SignatureConstant SIG = new SignatureConstant("TYPE", CLZ.getJVMSignature());
    private static final FieldConstant BOOLEAN_TYPE = new FieldConstant(new ClassConstant(Boolean.class.getName()), SIG);
    private static final FieldConstant BYTE_TYPE = new FieldConstant(new ClassConstant(Byte.class.getName()), SIG);
    private static final FieldConstant CHAR_TYPE = new FieldConstant(new ClassConstant(Character.class.getName()), SIG);
    private static final FieldConstant SHORT_TYPE = new FieldConstant(new ClassConstant(Short.class.getName()), SIG);
    private static final FieldConstant INT_TYPE = new FieldConstant(new ClassConstant(Integer.class.getName()), SIG);
    private static final FieldConstant LONG_TYPE = new FieldConstant(new ClassConstant(Long.class.getName()), SIG);
    private static final FieldConstant FLOAT_TYPE = new FieldConstant(new ClassConstant(Float.class.getName()), SIG);
    private static final FieldConstant DOUBLE_TYPE = new FieldConstant(new ClassConstant(Double.class.getName()), SIG);

    public ClassExpression(Token tokDot, TypeExpression expr, Token tokName) {
        super(tokDot, expr);
        this.setStartToken(expr.getStartToken());
        this.setEndToken(tokName);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        this.setExpression(expr);
        this.setType(CLZ);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        DataType dt = this.getExpression().getType();
        if (dt.isPrimitive()) {
            FieldConstant constant;
            switch (dt.getTypeString().charAt(0)) {
                case 'Z': {
                    constant = BOOLEAN_TYPE;
                    break;
                }
                case 'B': {
                    constant = BYTE_TYPE;
                    break;
                }
                case 'C': {
                    constant = CHAR_TYPE;
                    break;
                }
                case 'S': {
                    constant = SHORT_TYPE;
                    break;
                }
                case 'I': {
                    constant = INT_TYPE;
                    break;
                }
                case 'J': {
                    constant = LONG_TYPE;
                    break;
                }
                case 'F': {
                    constant = FLOAT_TYPE;
                    break;
                }
                case 'D': {
                    constant = DOUBLE_TYPE;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            code.add(new Getstatic(constant));
        } else {
            MethodConstant constant = ctx.getClassForName(dt);
            code.add(new Invokestatic(constant));
        }
        return fReached;
    }
}

