/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.DoubleConstant;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.FloatConstant;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.StringConstant;
import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Constants;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.DerivationException;
import com.tangosol.dev.component.Integration;
import com.tangosol.dev.component.Interface;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.ReturnValue;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ErrorList;
import com.tangosol.util.LiteSet;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

public class Property
extends Trait
implements Constants {
    public static final String ATTR_ACCESS = "Access";
    public static final String ATTR_STATIC = "Static";
    public static final String ATTR_FINAL = "Final";
    public static final String ATTR_VISIBLE = "Visible";
    public static final String ATTR_DEPRECATED = "Deprecated";
    public static final String ATTR_PERSISTENT = "Persistent";
    public static final String ATTR_DIRECTION = "Direction";
    public static final String ATTR_DATATYPE = "DataType";
    public static final String ATTR_INDEXED = "Indexed";
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_VALUE = "Value";
    public static final DataType BOOLEAN = DataType.BOOLEAN;
    protected static final byte DT_BOOLEAN = 0;
    public static final DataType CHAR = DataType.CHAR;
    protected static final byte DT_CHAR = 1;
    public static final DataType BYTE = DataType.BYTE;
    protected static final byte DT_BYTE = 2;
    public static final DataType SHORT = DataType.SHORT;
    protected static final byte DT_SHORT = 3;
    public static final DataType INT = DataType.INT;
    protected static final byte DT_INT = 4;
    public static final DataType LONG = DataType.LONG;
    protected static final byte DT_LONG = 5;
    public static final DataType FLOAT = DataType.FLOAT;
    protected static final byte DT_FLOAT = 6;
    public static final DataType DOUBLE = DataType.DOUBLE;
    protected static final byte DT_DOUBLE = 7;
    public static final DataType BINARY = DataType.BINARY;
    protected static final byte DT_BINARY = 8;
    public static final DataType STRING = DataType.STRING;
    protected static final byte DT_STRING = 9;
    public static final DataType COMPLEX = DataType.COMPLEX;
    protected static final byte DT_COMPLEX = 10;
    public static final DataType SERIALIZABLE = DataType.SERIALIZABLE;
    protected static final byte DT_SERIALIZABLE = 11;
    public static final Object NO_VALUE = new Object();
    protected static final Object NO_DELTA = new Object();
    protected static final byte E_NO_VALUE = 0;
    protected static final byte E_NO_DELTA = 1;
    protected static final byte E_NULL_REF = 2;
    protected static final byte E_HAS_VALUE = 3;
    protected static final Object[] DEFAULT_VALUES = new Object[]{new Boolean(false), new Byte(0), new Character('\u0000'), new Short(0), Property.makeInteger(0), Property.makeLong(0L), new Float(0.0f), new Double(0.0), null, null, null, null};
    public static final int RSVD_SET_SINGLE = 0;
    public static final int RSVD_SET_ARRAY = 1;
    public static final int RSVD_SET_INDEX = 2;
    public static final int RSVD_GET_EITHER = 3;
    public static final int RSVD_GET_INDEX = 4;
    public static final int RSVD_IS_EITHER = 5;
    public static final int RSVD_IS_INDEX = 6;
    public static final int PA_GET_SINGLE = 0;
    public static final int PA_FIRST = 0;
    public static final int PA_SET_SINGLE = 1;
    public static final int PA_GET_ARRAY = 2;
    public static final int PA_SET_ARRAY = 3;
    public static final int PA_GET_INDEX = 4;
    public static final int PA_SET_INDEX = 5;
    public static final int PA_LAST = 5;
    private static final String CLASS = "Property";
    protected static final String DESCRIPTOR = "Property";
    protected static final int DEFAULT_FLAGS = 0;
    protected static final int SPECABLE_FLAGS = 153178377;
    protected static final int CLASSGEN_FLAGS = 0x6008000;
    protected static final int DECL_ONLY_MASK = 0x38E33338;
    protected static final int OVERRIDE_FLAGS = 0x1004000;
    protected static final DataType[] NO_PARAMS = new DataType[0];
    protected static final String[] NO_NAMES = new String[0];
    protected static final int[] NO_DIRS = new int[0];
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected static final String INDEX_PARAM = "pIndex";
    protected static final String VALUE_PARAM = "p";
    private String m_sName;
    private DataType m_dt;
    private int m_nFlags;
    private Object m_oValue;
    private Object m_oPrevValue;
    private boolean m_fSizeDelta;
    private transient boolean m_fPrevSizeDelta;
    private transient boolean m_fBooleanGet;

    protected Property(Component cd, int nFlags, String sName, DataType dt) {
        super((Trait)cd, 1);
        this.m_nFlags = nFlags;
        this.m_sName = sName;
        this.m_dt = dt;
        this.m_oValue = NO_VALUE;
        this.m_oPrevValue = NO_VALUE;
        if (!cd.isSignature()) {
            this.assignUID();
        }
    }

    protected Property(Property base, Component cd, int nMode) {
        super((Trait)base, cd, nMode);
        Object oVal = nMode == 1 ? NO_VALUE : NO_DELTA;
        this.m_nFlags = 0 | base.m_nFlags & 0x38E33338;
        this.m_sName = base.m_sName;
        this.m_dt = base.m_dt;
        this.m_oValue = oVal;
        this.m_oPrevValue = oVal;
    }

    protected Property(Component cd, Property that, Interface iface) {
        this(cd, that);
        this.setExists(6);
        this.addOriginTrait(iface);
        this.m_oPrevValue = this.m_oValue;
    }

    protected Property(Component cd, Property that) {
        super((Trait)cd, that);
        this.m_nFlags = that.m_nFlags;
        this.m_sName = that.m_sName;
        this.m_dt = that.m_dt;
        this.m_oValue = this.copyValue(that.m_oValue);
        this.m_oPrevValue = this.copyValue(that.m_oPrevValue);
        this.m_fSizeDelta = that.m_fSizeDelta;
        this.m_fPrevSizeDelta = that.m_fPrevSizeDelta;
    }

    private Object copyValue(Object oThat) {
        if (oThat == NO_DELTA || oThat == NO_VALUE || oThat == null) {
            return oThat;
        }
        if (this.isSingle()) {
            if (!this.isComplex()) {
                return oThat;
            }
            return new Component((Trait)this, (Component)oThat);
        }
        oThat = ((Object[])oThat).clone();
        if (!this.isComplex()) {
            return oThat;
        }
        Object[] aoThat = (Object[])oThat;
        for (int i = 0; i < aoThat.length; ++i) {
            oThat = aoThat[i];
            if (oThat == NO_DELTA || oThat == NO_VALUE || oThat == null) continue;
            aoThat[i] = new Component((Trait)this, (Component)oThat);
        }
        return aoThat;
    }

    protected Property(Component cdJCS, Field field) {
        super((Trait)cdJCS, 1);
        int nFlags = 0x10000002;
        if (field.isPublic()) {
            nFlags |= 0x30;
        } else if (field.isProtected()) {
            nFlags |= 0x2000020;
        } else if (field.isPackage()) {
            nFlags |= 0x2000010;
        } else if (field.isPrivate()) {
            nFlags |= 0x2000000;
        }
        if (field.isSynthetic()) {
            nFlags |= 0x6000000;
        }
        nFlags |= field.isDeprecated() ? 32768 : 0;
        nFlags |= field.isStatic() ? 512 : 0;
        if (field.isFinal()) {
            nFlags |= 0x822000;
        } else {
            nFlags |= 0xC00000;
            nFlags |= field.isTransient() ? 0 : 131072;
        }
        DataType dt = DataType.getJVMType(field.getType());
        Object oValue = NO_VALUE;
        if ((nFlags & 0x2200) == 8704 && dt.isExtendedSimple() && field.isConstant()) {
            Constant constant = field.getConstantValue();
            if (constant instanceof IntConstant) {
                switch (dt.getTypeString().charAt(0)) {
                    case 'B': {
                        oValue = new Byte((byte)((IntConstant)constant).getValue());
                        break;
                    }
                    case 'C': {
                        oValue = new Character((char)((IntConstant)constant).getValue());
                        break;
                    }
                    case 'S': {
                        oValue = new Short((short)((IntConstant)constant).getValue());
                        break;
                    }
                    case 'I': {
                        oValue = Property.makeInteger(((IntConstant)constant).getValue());
                    }
                }
            } else if (constant instanceof LongConstant) {
                oValue = Property.makeLong(((LongConstant)constant).getValue());
            } else if (constant instanceof FloatConstant) {
                oValue = new Float(((FloatConstant)constant).getValue());
            } else if (constant instanceof DoubleConstant) {
                oValue = new Double(((DoubleConstant)constant).getValue());
            } else if (constant instanceof StringConstant) {
                oValue = ((StringConstant)constant).getValue();
            }
        }
        this.m_dt = dt;
        this.m_sName = field.getName();
        this.m_nFlags = nFlags;
        this.m_oValue = oValue;
        this.m_oPrevValue = NO_DELTA;
    }

    protected void mergeJCSFields(Property that) {
        if (this.getExists() == 4) {
            return;
        }
        if (this.isFinal() && that.isFinal() && this.isStatic() && that.isStatic() && this.getDataType() == that.getDataType() && !this.isNoValue() && this.isValueEqual(that.m_oValue)) {
            return;
        }
        this.setExists(4);
    }

    protected Property(Component cd, DataInput stream, int nVersion) throws IOException {
        super((Trait)cd, stream, nVersion);
        this.m_nFlags = stream.readInt();
        this.m_sName = stream.readUTF();
        this.m_dt = DataType.getType(stream.readUTF());
        this.m_fSizeDelta = stream.readBoolean();
        boolean fSingle = this.isSingle();
        byte nType = this.getDataTypeEnum();
        this.m_oValue = this.readValue(stream, nType, fSingle, nVersion);
        this.m_oPrevValue = this.readValue(stream, nType, fSingle, nVersion);
        this.m_oPrevValue = NO_DELTA;
    }

    protected Property(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        String sName = Property.readString(xml.getElement("name"));
        String sType = Property.readString(xml.getElement("type"));
        if (sName == "" || sType == "") {
            throw new IOException("name or type is missing");
        }
        int nFlags = Property.readFlags(xml, "flags", 0x400000);
        boolean fSizeDelta = false;
        XmlElement xmlSizeDelta = xml.getElement("size-delta");
        if (xmlSizeDelta != null) {
            fSizeDelta = xmlSizeDelta.getBoolean();
        }
        this.m_sName = sName;
        this.m_dt = DataType.getType(sType);
        this.m_nFlags = nFlags;
        this.m_fSizeDelta = fSizeDelta;
        boolean fSingle = this.isSingle();
        byte nType = this.getDataTypeEnum();
        Object oDefault = this.getMode() == 1 ? NO_VALUE : NO_DELTA;
        this.m_oValue = this.readValue(xml, "current", nType, fSingle, nVersion, oDefault);
        this.m_oPrevValue = this.readValue(xml, "original", nType, fSingle, nVersion, oDefault);
    }

    @Override
    protected synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeInt(this.m_nFlags);
        stream.writeUTF(this.m_sName);
        stream.writeUTF(this.m_dt.getTypeString());
        stream.writeBoolean(this.m_fSizeDelta);
        boolean fSingle = this.isSingle();
        byte nType = this.getDataTypeEnum();
        this.writeValue(stream, nType, fSingle, this.m_oValue);
        this.writeValue(stream, nType, fSingle, this.m_oPrevValue);
    }

    @Override
    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("name").setString(this.m_sName);
        xml.addElement("type").setString(this.m_dt.getTypeString());
        super.save(xml);
        Property.saveFlags(xml, "flags", this.m_nFlags, 0);
        XmlElement xmlFlags = xml.getElement("flags");
        if (xmlFlags != null) {
            xmlFlags.addAttribute("desc").setString(Property.flagsDescription(this.m_nFlags, 0x8000100, false));
        }
        if (this.m_fSizeDelta) {
            xml.addElement("size-delta").setBoolean(true);
        }
        boolean fSingle = this.isSingle();
        byte nType = this.getDataTypeEnum();
        Object oDefault = this.getMode() == 1 ? NO_VALUE : NO_DELTA;
        this.writeValue(xml, "current", nType, fSingle, this.m_oValue, oDefault);
        this.writeValue(xml, "original", nType, fSingle, this.m_oPrevValue, oDefault);
    }

    protected Object readValue(DataInput stream, byte nType, boolean fSingle, int nVersion) throws IOException {
        boolean fMulti = stream.readBoolean();
        if (fMulti) {
            int c = stream.readInt();
            Object[] ao = new Object[c];
            for (int i = 0; i < c; ++i) {
                ao[i] = this.readValue(stream, nType, nVersion);
            }
            return ao;
        }
        return this.readValue(stream, nType, nVersion);
    }

    protected Object readValue(XmlElement xml, String sElement, byte nType, boolean fSingle, int nVersion, Object oDefault) throws IOException {
        boolean fMulti;
        if ((xml = xml.getElement(sElement)) == null) {
            return oDefault;
        }
        boolean bl = fMulti = xml.getString(null) == null && xml.getElement("type") == null;
        if (fMulti) {
            List listElements = xml.getElementList();
            ArrayList<Object> listValues = new ArrayList<Object>();
            for (XmlElement xmlElement : listElements) {
                if (!xmlElement.getName().equals("element")) continue;
                listValues.add(this.readValue(xmlElement, nType, nVersion));
            }
            return listValues.toArray();
        }
        return this.readValue(xml, nType, nVersion);
    }

    protected Object readValue(DataInput stream, byte nType, int nVersion) throws IOException {
        byte b = stream.readByte();
        switch (b) {
            case 0: {
                return NO_VALUE;
            }
            case 1: {
                return NO_DELTA;
            }
            case 2: {
                return null;
            }
            case 3: {
                break;
            }
            default: {
                throw new IOException("Property.readValue:  Unexpected value specifier.");
            }
        }
        switch (nType) {
            case 0: {
                return new Boolean(stream.readBoolean());
            }
            case 1: {
                return new Character(stream.readChar());
            }
            case 2: {
                return new Byte(stream.readByte());
            }
            case 3: {
                return new Short(stream.readShort());
            }
            case 4: {
                return Property.makeInteger(stream.readInt());
            }
            case 5: {
                return Property.makeLong(stream.readLong());
            }
            case 6: {
                return new Float(stream.readFloat());
            }
            case 7: {
                return new Double(stream.readDouble());
            }
            case 8: {
                int cb = stream.readInt();
                byte[] ab = new byte[cb];
                stream.readFully(ab);
                return ab;
            }
            case 9: {
                return stream.readUTF();
            }
            case 10: {
                return new Component((Trait)this, stream, nVersion);
            }
            case 11: {
                int cb = stream.readInt();
                byte[] ab = new byte[cb];
                stream.readFully(ab);
                ByteArrayInputStream streamRaw = new ByteArrayInputStream(ab);
                ObjectInputStream streamObj = new ObjectInputStream(streamRaw);
                try {
                    Object o = streamObj.readObject();
                    streamObj.close();
                    return o;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e.toString());
                }
            }
        }
        throw new IOException("Property.readValue:  Unexpected value.");
    }

    protected Object readValue(XmlElement xml, byte nType, int nVersion) throws IOException {
        Object oValue = null;
        String sValue = xml.getString(null);
        if (sValue == null) {
            XmlElement xmlType = xml.getElement("type");
            XmlElement xmlValue = xml.getElement("value");
            if (xmlType == null || xmlValue == null) {
                throw new IOException("missing <type> and/or <value> tags for property value");
            }
            String sType = xmlType.getString();
            if (sType.length() == 0) {
                throw new IOException("missing <type> tag for property value");
            }
            switch (sType.charAt(0)) {
                case 'b': {
                    if (sType.equals("boolean")) {
                        oValue = xmlValue.getBoolean() ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    if (sType.equals("byte")) {
                        oValue = new Byte((byte)xmlValue.getInt());
                        break;
                    }
                    if (!sType.equals("binary")) break;
                    oValue = xmlValue.getBinary().toByteArray();
                    break;
                }
                case 'c': {
                    if (sType.equals("char")) {
                        oValue = new Character((char)xmlValue.getInt());
                        break;
                    }
                    if (!sType.equals("complex")) break;
                    oValue = new Component((Trait)this, xmlValue, nVersion);
                    break;
                }
                case 'd': {
                    if (!sType.equals("double")) break;
                    oValue = new Double(xmlValue.getDouble());
                    break;
                }
                case 'f': {
                    if (!sType.equals("float")) break;
                    oValue = new Float((float)xmlValue.getDouble());
                    break;
                }
                case 'i': {
                    if (!sType.equals("int")) break;
                    oValue = Property.makeInteger(xmlValue.getInt());
                    break;
                }
                case 'l': {
                    if (!sType.equals("long")) break;
                    oValue = Property.makeLong(xmlValue.getLong());
                    break;
                }
                case 's': {
                    if (sType.equals("short")) {
                        oValue = new Short((short)xmlValue.getInt());
                        break;
                    }
                    if (sType.equals("string")) {
                        oValue = xmlValue.getString();
                        break;
                    }
                    if (!sType.equals("serializable")) break;
                    byte[] ab = xmlValue.getBinary().toByteArray();
                    ByteArrayInputStream streamRaw = new ByteArrayInputStream(ab);
                    ObjectInputStream streamObj = new ObjectInputStream(streamRaw);
                    try {
                        oValue = streamObj.readObject();
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e.toString());
                    }
                    finally {
                        streamObj.close();
                    }
                }
            }
            if (oValue == null) {
                throw new IOException("invalid type and/or value (type=" + sType + ")");
            }
        } else if (sValue.equals("null")) {
            oValue = null;
        } else if (sValue.equals("none")) {
            oValue = NO_VALUE;
        } else if (sValue.equals("unchanged")) {
            oValue = NO_DELTA;
        }
        return oValue;
    }

    protected void writeValue(DataOutput stream, byte nType, boolean fSingle, Object o) throws IOException {
        boolean fMulti = !fSingle && o != NO_VALUE && o != NO_DELTA && o != null;
        stream.writeBoolean(fMulti);
        if (fMulti) {
            Object[] ao = (Object[])o;
            int c = ao.length;
            stream.writeInt(c);
            for (int i = 0; i < c; ++i) {
                this.writeValue(stream, nType, ao[i]);
            }
        } else {
            this.writeValue(stream, nType, o);
        }
    }

    protected void writeValue(XmlElement xml, String sElement, byte nType, boolean fSingle, Object o, Object oDefault) throws IOException {
        boolean fMulti;
        if (o == oDefault) {
            return;
        }
        xml = xml.addElement(sElement);
        boolean bl = fMulti = !fSingle && o != NO_VALUE && o != NO_DELTA && o != null;
        if (fMulti) {
            Object[] ao = (Object[])o;
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                this.writeValue(xml.addElement("element"), nType, ao[i]);
            }
        } else {
            this.writeValue(xml, nType, o);
        }
    }

    protected void writeValue(DataOutput stream, byte nType, Object o) throws IOException {
        int b = o == null ? 2 : (o == NO_VALUE ? 0 : (o == NO_DELTA ? 1 : 3));
        stream.writeByte(b);
        if (b == 3) {
            switch (nType) {
                case 0: {
                    stream.writeBoolean((Boolean)o);
                    break;
                }
                case 1: {
                    stream.writeChar(((Character)o).charValue());
                    break;
                }
                case 2: {
                    stream.writeByte(((Number)o).byteValue());
                    break;
                }
                case 3: {
                    stream.writeShort(((Number)o).shortValue());
                    break;
                }
                case 4: {
                    stream.writeInt(((Number)o).intValue());
                    break;
                }
                case 5: {
                    stream.writeLong(((Number)o).longValue());
                    break;
                }
                case 6: {
                    stream.writeFloat(((Number)o).floatValue());
                    break;
                }
                case 7: {
                    stream.writeDouble(((Number)o).doubleValue());
                    break;
                }
                case 8: {
                    byte[] ab = (byte[])o;
                    stream.writeInt(ab.length);
                    stream.write(ab);
                    break;
                }
                case 9: {
                    stream.writeUTF((String)o);
                    break;
                }
                case 10: {
                    ((Component)o).save(stream);
                    break;
                }
                case 11: {
                    ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                    ObjectOutputStream streamObj = new ObjectOutputStream(streamRaw);
                    streamObj.writeObject((Serializable)o);
                    streamObj.flush();
                    streamObj.close();
                    byte[] ab = streamRaw.toByteArray();
                    stream.writeInt(ab.length);
                    stream.write(ab);
                    break;
                }
                default: {
                    throw new IOException("Property.writeValue:  Unexpected value.");
                }
            }
        }
    }

    protected void writeValue(XmlElement xml, byte nType, Object o) throws IOException {
        if (o == null) {
            xml.setString("null");
        } else if (o == NO_VALUE) {
            xml.setString("none");
        } else if (o == NO_DELTA) {
            xml.setString("unchanged");
        } else {
            XmlElement xmlType = xml.addElement("type");
            XmlElement xmlValue = xml.addElement("value");
            switch (nType) {
                case 0: {
                    xmlType.setString("boolean");
                    xmlValue.setBoolean((Boolean)o);
                    break;
                }
                case 1: {
                    xmlType.setString("char");
                    xmlValue.setInt(((Character)o).charValue());
                    break;
                }
                case 2: {
                    xmlType.setString("byte");
                    xmlValue.setInt(((Number)o).byteValue());
                    break;
                }
                case 3: {
                    xmlType.setString("short");
                    xmlValue.setInt(((Number)o).shortValue());
                    break;
                }
                case 4: {
                    xmlType.setString("int");
                    xmlValue.setInt(((Number)o).intValue());
                    break;
                }
                case 5: {
                    xmlType.setString("long");
                    xmlValue.setLong(((Number)o).longValue());
                    break;
                }
                case 6: {
                    xmlType.setString("float");
                    xmlValue.setDouble(((Number)o).doubleValue());
                    break;
                }
                case 7: {
                    xmlType.setString("double");
                    xmlValue.setDouble(((Number)o).doubleValue());
                    break;
                }
                case 8: {
                    xmlType.setString("binary");
                    byte[] ab = (byte[])o;
                    xmlValue.setBinary(new Binary(ab));
                    break;
                }
                case 9: {
                    xmlType.setString("string");
                    xmlValue.setString((String)o);
                    break;
                }
                case 10: {
                    xmlType.setString("complex");
                    ((Component)o).save(xmlValue);
                    break;
                }
                case 11: {
                    xmlType.setString("serializable");
                    ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                    ObjectOutputStream streamObj = new ObjectOutputStream(streamRaw);
                    streamObj.writeObject((Serializable)o);
                    streamObj.flush();
                    streamObj.close();
                    byte[] ab = streamRaw.toByteArray();
                    xmlValue.setBinary(new Binary(ab));
                    break;
                }
                default: {
                    throw new IOException("Property.writeValue:  Unexpected value.");
                }
            }
        }
    }

    protected static boolean isCreatable(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic, int nDir, boolean fConstant) {
        if (!cd.isModifiable()) {
            return false;
        }
        if (sName == null || sName.length() == 0 || !ClassHelper.isSimpleNameLegal(sName)) {
            return false;
        }
        Property prop = cd.getProperty(sName);
        if (prop != null) {
            return false;
        }
        if (cd.isSignature()) {
            return true;
        }
        String[] asBehavior = Property.getReservedBehaviorSignatures(dt, sName);
        Behavior[] aBehavior = Property.getReservedBehaviors(cd, dt, sName);
        int cBehavior = aBehavior.length;
        for (int i = 0; i < cBehavior; ++i) {
            ReturnValue retval;
            Behavior behavior = aBehavior[i];
            if (behavior == null) continue;
            if (fConstant) {
                return false;
            }
            String sBehavior = asBehavior[i];
            sBehavior = sBehavior.substring(0, sBehavior.indexOf(40));
            if (!(behavior.getName().equals(sBehavior) || behavior.isNameSettable() && behavior.isNameLegal(sBehavior))) {
                return false;
            }
            DataType dtRet = null;
            switch (i) {
                case 0: {
                    if ((nDir & 0x400000) == 0 || nIndexed != 0x10000000) {
                        return false;
                    }
                    dtRet = DataType.VOID;
                    break;
                }
                case 1: {
                    if ((nDir & 0x400000) == 0 || nIndexed != 0x30000000) {
                        return false;
                    }
                    dtRet = DataType.VOID;
                    break;
                }
                case 2: {
                    if ((nDir & 0x400000) == 0 || (nIndexed & 0x20000000) == 0) {
                        return false;
                    }
                    dtRet = DataType.VOID;
                    break;
                }
                case 3: {
                    if ((nDir & 0x800000) == 0 || (nIndexed & 0x10000000) == 0 || dt == BOOLEAN) {
                        return false;
                    }
                    dtRet = nIndexed == 0x10000000 ? dt : dt.getArrayType();
                    break;
                }
                case 5: {
                    if ((nDir & 0x800000) == 0 || (nIndexed & 0x10000000) == 0 || dt != BOOLEAN) {
                        return false;
                    }
                    dtRet = nIndexed == 0x10000000 ? dt : dt.getArrayType();
                    break;
                }
                case 4: {
                    if ((nDir & 0x800000) == 0 || (nIndexed & 0x20000000) == 0 || dt == BOOLEAN) {
                        return false;
                    }
                    dtRet = dt;
                    break;
                }
                case 6: {
                    if ((nDir & 0x800000) == 0 || (nIndexed & 0x20000000) == 0 || dt != BOOLEAN) {
                        return false;
                    }
                    dtRet = dt;
                }
            }
            if (behavior.isFromSuper()) {
                return false;
            }
            if (behavior.isStatic() != fStatic && !behavior.isStaticSettable()) {
                return false;
            }
            if (behavior.getReturnValue().getDataType() == dtRet || (retval = behavior.getReturnValue()).isDataTypeSettable() && retval.isDataTypeLegal(dtRet)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isJavaConstantCreatable(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic, int nAccess) {
        if (nIndexed == 0x20000000) {
            return false;
        }
        return Property.isCreatable(cd, dt, sName, nIndexed, fStatic, 0x800000, true);
    }

    protected static Property createJavaConstant(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic, int nAccess) {
        int nScope = fStatic ? 512 : 0;
        int nFlags = 0x822002 | nIndexed | nScope | nAccess;
        return new Property(cd, nFlags, sName, dt);
    }

    protected static boolean isVirtualConstantCreatable(Component cd, DataType dt, String sName, int nIndexed, int nAccess) {
        return Property.isCreatable(cd, dt, sName, nIndexed, false, 0x800000, true);
    }

    protected static Property createVirtualConstant(Component cd, DataType dt, String sName, int nIndexed, int nAccess) {
        int nFlags = 0x820002 | nIndexed | nAccess;
        return new Property(cd, nFlags, sName, dt);
    }

    protected static boolean isCalculatedPropertyCreatable(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic) {
        return Property.isCreatable(cd, dt, sName, nIndexed, fStatic, 0x800000, false);
    }

    protected static Property createCalculatedProperty(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic) {
        int nScope = fStatic ? 512 : 0;
        int nFlags = 0x800002 | nIndexed | nScope;
        Property property = new Property(cd, nFlags, sName, dt);
        property.addAccessors();
        return property;
    }

    protected static boolean isFunctionalPropertyCreatable(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic) {
        return Property.isCreatable(cd, dt, sName, nIndexed, fStatic, 0x400000, false);
    }

    protected static Property createFunctionalProperty(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic) {
        int nScope = fStatic ? 512 : 0;
        int nFlags = 0x400002 | nIndexed | nScope;
        Property property = new Property(cd, nFlags, sName, dt);
        property.addAccessors();
        return property;
    }

    protected static boolean isPropertyCreatable(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic, boolean fPersist) {
        return Property.isCreatable(cd, dt, sName, nIndexed, fStatic, 0xC00000, false);
    }

    protected static Property createProperty(Component cd, DataType dt, String sName, int nIndexed, boolean fStatic, boolean fPersist) {
        int nScope = fStatic ? 512 : 0;
        int nStg = fPersist ? 131072 : 0;
        int nFlags = 0xC00002 | nIndexed | nScope | nStg;
        Property property = new Property(cd, nFlags, sName, dt);
        property.addAccessors();
        return property;
    }

    @Override
    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new Property(this, (Component)parent, nMode);
    }

    @Override
    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        boolean fNoSetter;
        Property base = this;
        Property delta = (Property)this.resolveDelta(traitDelta, loader, errlist);
        Property derived = (Property)super.resolve(delta, parent, loader, errlist);
        delta.verifyMatch(base, true, errlist);
        int nBaseMode = base.getMode();
        int nDeltaMode = delta.getMode();
        boolean fBaseResolved = nBaseMode == 1;
        int nBaseFlags = base.m_nFlags;
        int nDeltaFlags = delta.m_nFlags;
        int nDerivedFlags = nBaseFlags;
        int nExists = 0;
        if (nDeltaMode == 3 && (nBaseFlags & 6) == 2) {
            nExists = 2;
        }
        nDerivedFlags = nDerivedFlags & 0xFFFFFFF8 | nExists;
        if ((nDeltaFlags & 0x1000000) != 0) {
            nDerivedFlags = nDerivedFlags & 0xF8FFFFFF | nDeltaFlags & 0x7000000;
        }
        if ((nDeltaFlags & 0x4000) != 0) {
            nDerivedFlags = nDerivedFlags & 0xFFFF3FFF | nDeltaFlags & 0xC000;
        }
        DataType dtBase = base.m_dt;
        DataType dtDelta = delta.m_dt;
        derived.m_sName = base.m_sName;
        derived.m_dt = dtBase;
        derived.m_nFlags = nDerivedFlags;
        Object oValue = delta.m_oValue;
        boolean fSizeDelta = delta.m_fSizeDelta;
        Object oPrevValue = delta.m_oPrevValue;
        boolean fPrevSizeDelta = delta.m_fPrevSizeDelta;
        boolean fTypeChange = dtDelta != dtBase && (!Property.isDataTypeEnumNumeric(Property.getDataTypeEnum(dtDelta)) || !Property.isDataTypeEnumNumeric(Property.getDataTypeEnum(dtBase)));
        boolean fPropChange = ((nDeltaFlags ^ nBaseFlags) & 0x30000000) != 0 && ((nDeltaFlags & 0x30000000) == 0x10000000 || (nBaseFlags & 0x30000000) == 0x10000000);
        boolean fFinalBase = nDeltaMode != 3 && (nBaseFlags & 0x2000) == 8192;
        boolean bl = fNoSetter = fBaseResolved && !derived.isValueSettable();
        if (fTypeChange || fPropChange || fFinalBase || fNoSetter) {
            oValue = NO_DELTA;
            fSizeDelta = false;
            oPrevValue = NO_DELTA;
            fPrevSizeDelta = false;
        }
        Object oBaseValue = base.m_oValue;
        if (base.getProcessState() != 2) {
            oBaseValue = base.resolveValue((nBaseFlags & 0x30000000) == 0x10000000, base.m_fSizeDelta, base.m_oPrevValue, oBaseValue, false, loader, errlist);
        }
        oPrevValue = derived.resolveValue((nBaseFlags & 0x30000000) == 0x10000000, fPrevSizeDelta, oBaseValue, oPrevValue, false, loader, errlist);
        fPrevSizeDelta = fPrevSizeDelta || base.m_fSizeDelta || base.m_fPrevSizeDelta;
        derived.m_fSizeDelta = fSizeDelta;
        derived.m_oValue = oValue;
        derived.m_fPrevSizeDelta = fPrevSizeDelta;
        derived.m_oPrevValue = oPrevValue;
        return derived;
    }

    @Override
    protected synchronized void finalizeResolve(Loader loader, ErrorList errlist) throws ComponentException {
        super.finalizeResolve(loader, errlist);
        this.m_nFlags &= 0xF6DAAAB6;
        if (this.isDeclaredAtThisLevel() && !this.isConstant()) {
            Behavior[] abeh = this.getAccessors();
            int cbeh = abeh.length;
            for (int i = 0; i < cbeh; ++i) {
                Behavior behavior = abeh[i];
                if (behavior == null && this.isAccessorApplicable(i) && !this.getComponent().isSignature()) {
                    throw new IllegalStateException("Property.finalizeResolve:  Missing accessor!  (property " + this.m_sName + ", accessor " + i + ")");
                }
                if (behavior == null) continue;
                behavior.addOriginTrait(this);
            }
        }
        if (!this.isValueSettable() && !this.getComponent().isSignature()) {
            this.m_oValue = NO_DELTA;
            this.m_fSizeDelta = false;
        }
        boolean fSingle = this.isSingle();
        this.m_oPrevValue = this.resolveValue(fSingle, false, this.m_oPrevValue, NO_DELTA, true, loader, errlist);
        this.m_oValue = this.resolveValue(fSingle, this.m_fSizeDelta, this.m_oPrevValue, this.m_oValue, true, loader, errlist);
        this.m_fSizeDelta = false;
        this.m_fPrevSizeDelta = false;
    }

    private Object resolveValue(boolean fSingle, boolean fSizeDelta, Object oBase, Object oThis, boolean fFinal, Loader loader, ErrorList errlist) throws ComponentException {
        if (oThis == NO_DELTA) {
            if (oBase == NO_DELTA) {
                if (fFinal) {
                    oBase = NO_VALUE;
                }
                return oBase;
            }
            if (oBase == NO_VALUE || oBase == null) {
                return oBase;
            }
            if (this.isComplex()) {
                if (fSingle) {
                    oBase = this.resolveComplexValue(NO_DELTA, oBase, fFinal, loader, errlist);
                } else {
                    oBase = ((Object[])oBase).clone();
                    Object[] aoBase = (Object[])oBase;
                    for (int i = 0; i < aoBase.length; ++i) {
                        Object oElement = aoBase[i];
                        if (oElement == NO_DELTA || oElement == NO_VALUE || oElement == null) continue;
                        aoBase[i] = this.resolveComplexValue(NO_DELTA, oElement, fFinal, loader, errlist);
                    }
                }
            }
            return oBase;
        }
        if (oThis == NO_VALUE || oThis == null) {
            return oThis;
        }
        if (fSingle) {
            if (this.isComplex()) {
                oThis = this.resolveComplexValue(oBase, oThis, fFinal, loader, errlist);
            }
            return oThis;
        }
        Object[] aoThis = (Object[])oThis;
        int cThis = aoThis.length;
        boolean fBaseIsArray = oBase instanceof Object[];
        Object[] aoBase = fBaseIsArray ? (Object[])oBase : NO_OBJECTS;
        int cBase = aoBase.length;
        int cResult = fSizeDelta || !fBaseIsArray ? cThis : cBase;
        Object[] aoResult = new Object[cResult];
        for (int i = 0; i < cResult; ++i) {
            oThis = i < cThis ? aoThis[i] : NO_DELTA;
            oBase = i < cBase ? aoBase[i] : NO_DELTA;
            aoResult[i] = this.resolveValue(true, false, oBase, oThis, fFinal, loader, errlist);
        }
        return aoResult;
    }

    private Object resolveComplexValue(Object oBase, Object oThis, boolean fFinal, Loader loader, ErrorList errlist) throws ComponentException {
        Component cdBase;
        Component cdThis = (Component)oThis;
        boolean fOriginal = true;
        if (oBase != NO_DELTA && oBase != NO_VALUE && oBase != null) {
            cdBase = (Component)oBase;
            if (cdThis.getSuperName().equals(cdBase.getSuperName())) {
                cdThis = (Component)cdBase.resolve(cdThis, this, loader, errlist);
                fOriginal = false;
            }
        }
        if (fFinal && cdThis.getMode() != 1) {
            cdBase = loader.loadComponent(cdThis.getSuperName(), true, errlist);
            if (cdBase == null) {
                this.logError("RES-703", 2, new Object[]{cdThis.toString(), this.toPathString()}, errlist);
                return NO_VALUE;
            }
            cdThis = (Component)cdBase.resolve(cdThis, this, loader, errlist);
            fOriginal = false;
        }
        if (fOriginal) {
            cdThis = new Component((Trait)this, cdThis);
        }
        if (fFinal) {
            cdThis.finalizeResolve(loader, errlist);
            if (cdThis.isDiscardable()) {
                cdThis.invalidate();
                return NO_VALUE;
            }
        }
        return cdThis;
    }

    @Override
    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Property derived = this;
        Property base = (Property)traitBase;
        Property delta = (Property)super.extract(base, parent, loader, errlist);
        derived.verifyMatch(base, false, errlist);
        boolean fBaseResolved = base.getMode() == 1;
        int nBaseFlags = base.m_nFlags;
        int nDerivedFlags = derived.m_nFlags;
        int nDifFlags = nBaseFlags ^ nDerivedFlags;
        int nDeltaFlags = nDerivedFlags & 0xF6DAAAB6;
        nDeltaFlags = nDeltaFlags & 0xFFFFFFF8 | 0;
        nDeltaFlags = nDeltaFlags & 0xC71CCCC7 | nBaseFlags & 0x38E33338;
        if ((nDifFlags & 0x6000000) != 0 && (fBaseResolved || (nBaseFlags & 0x1000000) != 0)) {
            nDeltaFlags |= 0x1000000;
        }
        if ((nDifFlags & 0x8000) != 0 && (fBaseResolved || (nBaseFlags & 0x4000) != 0)) {
            nDeltaFlags |= 0x4000;
        }
        DataType dtBase = base.m_dt;
        DataType dtDerived = derived.m_dt;
        delta.m_sName = base.m_sName;
        delta.m_dt = dtBase;
        delta.m_nFlags = nDeltaFlags;
        Object oValue = derived.m_oValue;
        Object oPrevValue = derived.m_oPrevValue;
        if (derived.getProcessState() == 2) {
            if (oValue instanceof Object[]) {
                oValue = ((Object[])oValue).clone();
            }
            delta.m_oValue = oValue;
            delta.m_oPrevValue = oPrevValue;
            delta.initializeExtract(loader, errlist);
            oValue = delta.m_oValue;
            oPrevValue = NO_DELTA;
        }
        if (oValue != NO_DELTA) {
            boolean fNoSetter;
            boolean fTypeChange = dtDerived != dtBase && (!Property.isDataTypeEnumNumeric(Property.getDataTypeEnum(dtDerived)) || !Property.isDataTypeEnumNumeric(Property.getDataTypeEnum(dtBase)));
            boolean fPropChange = (nDifFlags & 0x30000000) != 0 && ((nDerivedFlags & 0x30000000) == 0x10000000 || (nBaseFlags & 0x30000000) == 0x10000000);
            boolean fFinalBase = delta.getMode() != 3 && (nBaseFlags & 0x2000) == 8192;
            boolean bl = fNoSetter = fBaseResolved && !derived.isValueSettable();
            if (fTypeChange || fPropChange || fFinalBase || fNoSetter) {
                oValue = NO_DELTA;
                oPrevValue = NO_DELTA;
            } else {
                boolean fSingle = this.isSingle();
                Object oBaseValue = base.m_oValue;
                if (base.getProcessState() != 2) {
                    oBaseValue = base.resolveValue(fSingle, base.m_fSizeDelta, base.m_oPrevValue, oBaseValue, false, loader, errlist);
                }
                oPrevValue = delta.resolveValue(fSingle, base.m_fSizeDelta || base.m_fPrevSizeDelta, oPrevValue, oBaseValue, false, loader, errlist);
            }
        }
        delta.m_oValue = oValue;
        delta.m_oPrevValue = oPrevValue;
        return delta;
    }

    protected void initializeExtract(Loader loader, ErrorList errlist) throws ComponentException {
        this.extractPreviousValue(loader, errlist);
        Object oValue = this.m_oValue;
        if (this.isComplex() && oValue != NO_DELTA && oValue != NO_VALUE && oValue != null) {
            if (this.isSingle()) {
                this.m_oValue = this.initializeExtractComplexValue(oValue, loader, errlist);
            } else {
                Object[] aoValue = (Object[])oValue;
                for (int i = 0; i < aoValue.length; ++i) {
                    Object oElement = aoValue[i];
                    if (oElement == NO_DELTA || oElement == NO_VALUE || oElement == null) continue;
                    aoValue[i] = this.initializeExtractComplexValue(oElement, loader, errlist);
                }
            }
        }
    }

    private Object initializeExtractComplexValue(Object oValue, Loader loader, ErrorList errlist) throws ComponentException {
        Component cdValue = (Component)oValue;
        if (cdValue.getMode() != 1) {
            return cdValue;
        }
        Component cdBase = loader.loadComponent(cdValue.getSuperName(), true, errlist);
        if (cdBase == null) {
            this.logError("EXT-703", 2, new Object[]{cdValue.toString(), this.toPathString()}, errlist);
            cdValue.invalidate();
            return NO_DELTA;
        }
        return cdValue.extract(cdBase, this, loader, errlist);
    }

    @Override
    protected synchronized void finalizeExtract(Loader loader, ErrorList errlist) throws ComponentException {
        super.finalizeExtract(loader, errlist);
        this.extractPreviousValue(loader, errlist);
        Object oValue = this.m_oValue;
        if (this.isComplex() && oValue != NO_DELTA && oValue != NO_VALUE && oValue != null) {
            if (this.isSingle()) {
                if (this.finalizeExtractComplexValue(oValue, loader, errlist)) {
                    this.m_oValue = NO_DELTA;
                }
            } else {
                Object[] aoValue = (Object[])this.m_oValue;
                boolean fDelta = false;
                for (int i = 0; i < aoValue.length; ++i) {
                    Object oElement = aoValue[i];
                    if (oElement == NO_DELTA) continue;
                    if (oElement != NO_VALUE && oElement != null && this.finalizeExtractComplexValue(oElement, loader, errlist)) {
                        aoValue[i] = NO_DELTA;
                        continue;
                    }
                    fDelta = true;
                }
                if (!fDelta && !this.m_fSizeDelta) {
                    this.m_oValue = NO_DELTA;
                }
            }
        }
        this.m_oPrevValue = NO_DELTA;
    }

    private boolean finalizeExtractComplexValue(Object oValue, Loader loader, ErrorList errlist) throws ComponentException {
        Component cdValue = (Component)oValue;
        cdValue.finalizeExtract(loader, errlist);
        if (cdValue.isDiscardable()) {
            cdValue.invalidate();
            return true;
        }
        return false;
    }

    private void extractPreviousValue(Loader loader, ErrorList errlist) throws ComponentException {
        Object oValue = this.m_oValue;
        if (oValue == NO_DELTA) {
            return;
        }
        Object oPrevValue = this.m_oPrevValue;
        if (oValue == oPrevValue) {
            this.m_oValue = NO_DELTA;
            return;
        }
        if (oValue == NO_VALUE || oValue == null) {
            return;
        }
        DataType dt = this.m_dt;
        boolean fComplex = this.isComplex();
        if (this.isSingle()) {
            if (oValue == oPrevValue || Property.isValueEqual(dt, oValue, oPrevValue)) {
                this.m_oValue = NO_DELTA;
            } else if (fComplex) {
                this.m_oValue = this.extractPreviousComplexValue(oPrevValue, oValue, loader, errlist);
            }
            return;
        }
        Object[] aoValue = (Object[])oValue;
        Object[] aoPrevValue = oPrevValue instanceof Object[] ? (Object[])oPrevValue : NO_OBJECTS;
        int cValue = aoValue.length;
        int cPrevValue = aoPrevValue.length;
        int cElement = Math.min(cValue, cPrevValue);
        boolean fDelta = false;
        for (int i = 0; i < cElement; ++i) {
            Object oElement = aoValue[i];
            if (oElement == NO_DELTA) continue;
            Object oPrevElement = aoPrevValue[i];
            if (oElement == oPrevElement || Property.isValueEqual(dt, oElement, oPrevElement)) {
                oElement = NO_DELTA;
            } else if (fComplex && oElement != NO_DELTA && oElement != NO_VALUE && oElement != null) {
                oElement = this.extractPreviousComplexValue(oPrevElement, oElement, loader, errlist);
            }
            aoValue[i] = oElement;
            if (oElement == NO_DELTA) continue;
            fDelta = true;
        }
        boolean bl = this.m_fSizeDelta = cValue != cPrevValue;
        if (!fDelta && !this.m_fSizeDelta) {
            this.m_oValue = NO_DELTA;
        }
    }

    private Object extractPreviousComplexValue(Object oPrevValue, Object oValue, Loader loader, ErrorList errlist) throws ComponentException {
        Component cdValue = (Component)oValue;
        if (oPrevValue != NO_DELTA && oPrevValue != NO_VALUE && oPrevValue != null) {
            Component cdPrevValue = (Component)oPrevValue;
            if (cdValue.getSuperName().equals(cdPrevValue.getSuperName())) {
                cdValue = (Component)cdValue.extract((Component)oPrevValue, this, loader, errlist);
            }
        }
        if (cdValue.isDiscardable()) {
            cdValue.invalidate();
            return NO_DELTA;
        }
        return cdValue;
    }

    protected void verifyMatch(Property base, boolean fResolve, ErrorList errlist) throws DerivationException {
        Object[] aoParam;
        String sCode;
        if (!this.m_sName.equals(base.m_sName)) {
            sCode = fResolve ? "RES-701" : "EXT-701";
            aoParam = new Object[]{this.m_sName, base.m_sName, this.toPathString()};
            this.logError(sCode, 2, aoParam, errlist);
        }
        if (!this.getComponent().isSignature() && this.m_dt != base.m_dt) {
            sCode = fResolve ? "RES-702" : "EXT-702";
            aoParam = new Object[]{base.m_sName, this.m_dt.toString(), base.m_dt.toString(), this.toPathString()};
            this.logError(sCode, 2, aoParam, errlist);
        }
    }

    protected boolean isDerivedBySub() {
        if (this.isFromSuper()) {
            return true;
        }
        if (this.isConstant()) {
            return this.getAccess() != 0;
        }
        for (Behavior behavior : this.getAccessors()) {
            if (behavior == null || behavior.getAccess() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isDiscardable() {
        switch (this.getMode()) {
            case 1: {
                if (!this.getComponent().isSignature()) break;
                return false;
            }
            case 2: 
            case 3: {
                if ((this.m_nFlags & 0x9255549) == 0 && !this.m_fSizeDelta && this.m_oValue == NO_DELTA) break;
                return false;
            }
        }
        return super.isDiscardable();
    }

    @Override
    protected boolean isClassDiscardable(Trait base) {
        Property that = (Property)base;
        if (that == null || !this.isFromSuper()) {
            return false;
        }
        if (((this.m_nFlags ^ that.m_nFlags) & 0x6008000) != 0) {
            return false;
        }
        if (!this.isValueEqual(that.m_oValue)) {
            return false;
        }
        return super.isClassDiscardable(base);
    }

    @Override
    public boolean isModifiable() {
        if (this.isStatic() && this.isFromSuper()) {
            return false;
        }
        return super.isModifiable();
    }

    @Override
    protected Enumeration getSubTraits() {
        if (this.isComplex()) {
            Object oValue = this.m_oValue;
            if (this.isSingle()) {
                if (oValue instanceof Component) {
                    return new SimpleEnumerator(new Object[]{oValue});
                }
            } else if (oValue instanceof Object[]) {
                Object[] aoValue = (Object[])oValue;
                LiteSet set = null;
                for (int i = 0; i < aoValue.length; ++i) {
                    oValue = aoValue[i];
                    if (!(oValue instanceof Component)) continue;
                    if (set == null) {
                        set = new LiteSet();
                    }
                    set.add(oValue);
                }
                if (set != null) {
                    return set.elements();
                }
            }
        }
        return NullImplementation.getEnumeration();
    }

    @Override
    protected synchronized void invalidate() {
        super.invalidate();
        this.m_sName = null;
        this.m_dt = null;
        this.m_oValue = null;
        this.m_oPrevValue = null;
    }

    @Override
    protected String getUniqueName() {
        return this.m_sName;
    }

    @Override
    protected String getUniqueDescription() {
        return "Property " + this.getUniqueName();
    }

    public Component getComponent() {
        return (Component)this.getParentTrait();
    }

    public boolean isComponentComplex() {
        return this.getComponent().isComplex();
    }

    public boolean isConstant() {
        return (0xC20000 & this.m_nFlags) == 0x820000;
    }

    public boolean isJavaConstant() {
        return (0xC22000 & this.m_nFlags) == 0x822000;
    }

    public boolean isVirtualConstant() {
        return (0xC22000 & this.m_nFlags) == 0x820000;
    }

    public boolean isDesignOnly() {
        return this.isVirtualConstant() && this.getVisible() == 0x4000000 && this.getAccess() == 32 && this.m_sName.charAt(0) == '$';
    }

    public boolean isFunctionalProperty() {
        return (0xC00000 & this.m_nFlags) == 0x400000;
    }

    public boolean isCalculatedProperty() {
        return (0xC20000 & this.m_nFlags) == 0x800000;
    }

    public boolean isStandardProperty() {
        return (0xC00000 & this.m_nFlags) == 0xC00000;
    }

    protected boolean isComplexPropertyProperty() {
        if (this.getIndexed() == 0x20000000) {
            return false;
        }
        DataType dt = this.m_dt;
        if (dt.isArray() && dt.getBaseElementType().isComponent()) {
            return false;
        }
        Behavior bhvr = this.getApplicableAccessor(this.isSingle() ? 1 : 3);
        return bhvr != null && bhvr.getAccess() == 48;
    }

    public Behavior[] getReservedBehaviors() {
        return Property.getReservedBehaviors(this.getComponent(), this.m_dt, this.m_sName);
    }

    protected Behavior[] getReservedBehaviors(DataType dt, String sName) {
        return Property.getReservedBehaviors(this.getComponent(), dt, sName);
    }

    protected static Behavior[] getReservedBehaviors(Component cd, DataType dt, String sName) {
        String[] asBehavior = Property.getReservedBehaviorSignatures(dt, sName);
        int cBehavior = asBehavior.length;
        Behavior[] aBehavior = new Behavior[cBehavior];
        for (int i = 0; i < cBehavior; ++i) {
            aBehavior[i] = cd.getBehavior(asBehavior[i]);
        }
        return aBehavior;
    }

    protected static String[] getReservedBehaviorSignatures(DataType dt, String sName) {
        String sType = dt.getTypeString();
        String sSet = "set" + sName;
        String sGet = "get" + sName;
        String sIs = "is" + sName;
        return new String[]{sSet + '(' + sType + ')', sSet + "([" + sType + ')', sSet + "(I" + sType + ')', sGet + "()", sGet + "(I)", sIs + "()", sIs + "(I)"};
    }

    public boolean isReservedBehaviorSignature(String sSig) {
        Collator INSENS = Constants.INSENS;
        String sPrefix = Property.getAccessorPrefix(sSig);
        if (sPrefix == null) {
            return false;
        }
        String sName = this.m_sName;
        if (sName == null || !INSENS.equals(sName, Property.getPropertyName(sSig))) {
            return false;
        }
        sSig = Behavior.getSignature(sName, Behavior.getParameterTypes(sSig), 1);
        String[] asSigs = Property.getReservedBehaviorSignatures(this.m_dt, this.m_sName);
        switch (sPrefix.charAt(0)) {
            case 's': {
                return sSig.equals(asSigs[0]) || sSig.equals(asSigs[1]) || sSig.equals(asSigs[2]);
            }
            case 'g': {
                return sSig.equals(asSigs[3]) || sSig.equals(asSigs[4]);
            }
            case 'i': {
                return sSig.equals(asSigs[5]) || sSig.equals(asSigs[6]);
            }
        }
        throw new IllegalStateException();
    }

    public static String getAccessorPrefix(String sSig) {
        Collator INSENS = Constants.INSENS;
        String GETTER = "get";
        String SETTER = "set";
        String BOOLGET = "is";
        if (sSig.length() > 3) {
            String sPrefix = sSig.substring(0, 3);
            if (INSENS.equals(sPrefix, "get")) {
                return "get";
            }
            if (INSENS.equals(sPrefix, "set")) {
                return "set";
            }
        }
        if (sSig.length() > 2 && INSENS.equals(sSig.substring(0, 2), "is")) {
            return "is";
        }
        return null;
    }

    public static String getPropertyName(String sSig) {
        String sPrefix = Property.getAccessorPrefix(sSig);
        if (sPrefix == null) {
            return null;
        }
        String sProp = sSig.substring(sPrefix.length(), sSig.indexOf(40));
        if (sProp.length() > 0) {
            return sProp;
        }
        return null;
    }

    public boolean isAccessorApplicable(int nAccessor) {
        int nIndexed = this.getIndexed();
        int nDir = this.getDirection();
        switch (nAccessor) {
            case 0: {
                return nIndexed == 0x10000000 && nDir != 0x400000;
            }
            case 1: {
                return nIndexed == 0x10000000 && nDir != 0x800000;
            }
            case 2: {
                return nIndexed == 0x30000000 && nDir != 0x400000;
            }
            case 3: {
                return nIndexed == 0x30000000 && nDir != 0x800000;
            }
            case 4: {
                return nIndexed != 0x10000000 && nDir != 0x400000;
            }
            case 5: {
                return nIndexed != 0x10000000 && nDir != 0x800000;
            }
        }
        throw new IllegalArgumentException("Property.isAccessorApplicable:  Illegal accessor value!");
    }

    public Behavior getAccessor(int nAccessor) {
        return this.getComponent().getBehavior(this.getAccessorSignature(nAccessor));
    }

    public Behavior getApplicableAccessor(int nAccessor) {
        return this.isAccessorApplicable(nAccessor) ? this.getAccessor(nAccessor) : null;
    }

    public String getAccessorSignature(int nAccessor) {
        DataType dt = this.m_dt;
        String sGet = !this.m_fBooleanGet && dt == BOOLEAN ? "is" : "get";
        String sName = this.m_sName;
        String sType = dt.getTypeString();
        switch (nAccessor) {
            case 0: {
                return sGet + sName + "()";
            }
            case 1: {
                return "set" + sName + '(' + sType + ')';
            }
            case 2: {
                return sGet + sName + "()";
            }
            case 3: {
                return "set" + sName + "([" + sType + ')';
            }
            case 4: {
                return sGet + sName + "(I)";
            }
            case 5: {
                return "set" + sName + "(I" + sType + ')';
            }
        }
        throw new IllegalArgumentException("Property.getAccessorSignature:  Illegal accessor value!");
    }

    public Behavior[] getAccessors() {
        Behavior[] aBehavior = new Behavior[6];
        DataType dt = this.m_dt;
        String sGet = !this.m_fBooleanGet && dt == BOOLEAN ? "is" : "get";
        String sName = this.m_sName;
        String sType = dt.getTypeString();
        int nDir = this.getDirection();
        int nIndexed = this.getIndexed();
        Component cd = this.getComponent();
        switch (nIndexed) {
            case 0x10000000: {
                String sSig;
                if ((nDir & 0x400000) != 0) {
                    sSig = "set" + sName + '(' + sType + ')';
                    aBehavior[1] = cd.getBehavior(sSig);
                }
                if ((nDir & 0x800000) == 0) break;
                sSig = sGet + sName + "()";
                aBehavior[0] = cd.getBehavior(sSig);
                break;
            }
            case 0x30000000: {
                String sSig;
                if ((nDir & 0x400000) != 0) {
                    sSig = "set" + sName + "([" + sType + ')';
                    aBehavior[3] = cd.getBehavior(sSig);
                }
                if ((nDir & 0x800000) != 0) {
                    sSig = sGet + sName + "()";
                    aBehavior[2] = cd.getBehavior(sSig);
                }
            }
            case 0x20000000: {
                String sSig;
                if ((nDir & 0x400000) != 0) {
                    sSig = "set" + sName + "(I" + sType + ')';
                    aBehavior[5] = cd.getBehavior(sSig);
                }
                if ((nDir & 0x800000) == 0) break;
                sSig = sGet + sName + "(I)";
                aBehavior[4] = cd.getBehavior(sSig);
            }
        }
        return aBehavior;
    }

    protected boolean isAccessorOwned(int nAccessor) {
        return this.isAccessorOwned(this.getAccessor(nAccessor));
    }

    protected boolean isAccessorOwned(Behavior behavior) {
        return behavior == null || !behavior.isFromImplements() && !behavior.isFromDispatches() && !behavior.isFromIntegration();
    }

    protected void addAccessors() {
        if (this.isConstant()) {
            return;
        }
        boolean fSuper = this.isFromSuper();
        boolean fStatic = this.isStatic();
        for (int i = 0; i <= 5; ++i) {
            if (!this.isAccessorApplicable(i)) continue;
            Behavior behavior = this.getAccessor(i);
            if (behavior == null) {
                if (fSuper) continue;
                behavior = this.addAccessor(i);
                continue;
            }
            DataType dtRet = this.m_dt;
            String sName = this.m_sName;
            switch (i) {
                case 0: {
                    sName = (!this.m_fBooleanGet && dtRet == BOOLEAN ? "is" : "get") + sName;
                    break;
                }
                case 1: {
                    dtRet = DataType.VOID;
                    sName = "set" + sName;
                    break;
                }
                case 2: {
                    dtRet = dtRet.getArrayType();
                    sName = (!this.m_fBooleanGet && dtRet == BOOLEAN ? "is" : "get") + sName;
                    break;
                }
                case 3: {
                    dtRet = DataType.VOID;
                    sName = "set" + sName;
                    break;
                }
                case 4: {
                    sName = (!this.m_fBooleanGet && dtRet == BOOLEAN ? "is" : "get") + sName;
                    break;
                }
                case 5: {
                    dtRet = DataType.VOID;
                    sName = "set" + sName;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Property.addAccessors:  Illegal accessor value!");
                }
            }
            try {
                behavior.setName(sName, false);
                behavior.getReturnValue().setDataType(dtRet, false);
                behavior.setStatic(fStatic, false);
            }
            catch (PropertyVetoException e) {
                throw new IllegalStateException();
            }
            behavior.addOriginTrait(this);
        }
    }

    protected Behavior addAccessor(int nAccessor) {
        DataType dtRet = DataType.VOID;
        String sName = null;
        DataType[] adtParam = null;
        String[] asParam = null;
        switch (nAccessor) {
            case 0: {
                dtRet = this.m_dt;
                sName = (!this.m_fBooleanGet && this.m_dt == BOOLEAN ? "is" : "get") + this.m_sName;
                break;
            }
            case 1: {
                sName = "set" + this.m_sName;
                adtParam = new DataType[]{this.m_dt};
                asParam = new String[]{VALUE_PARAM + this.m_sName};
                break;
            }
            case 2: {
                dtRet = this.m_dt.getArrayType();
                sName = (!this.m_fBooleanGet && this.m_dt == BOOLEAN ? "is" : "get") + this.m_sName;
                break;
            }
            case 3: {
                sName = "set" + this.m_sName;
                adtParam = new DataType[]{this.m_dt.getArrayType()};
                asParam = new String[]{VALUE_PARAM + this.m_sName};
                break;
            }
            case 4: {
                dtRet = this.m_dt;
                sName = (!this.m_fBooleanGet && this.m_dt == BOOLEAN ? "is" : "get") + this.m_sName;
                adtParam = new DataType[]{INT};
                asParam = new String[]{INDEX_PARAM};
                break;
            }
            case 5: {
                sName = "set" + this.m_sName;
                adtParam = new DataType[]{INT, this.m_dt};
                asParam = new String[]{INDEX_PARAM, VALUE_PARAM + this.m_sName};
                break;
            }
            default: {
                throw new IllegalArgumentException("Property.addAccessor:  Illegal accessor value!");
            }
        }
        Component cd = this.getComponent();
        Behavior behavior = new Behavior(cd, dtRet, sName, this.isStatic(), this.getDefaultAccess(nAccessor), adtParam, asParam, null);
        behavior.addOriginTrait(this);
        if (cd.getBehavior(behavior.getSignature()) != null) {
            throw new IllegalStateException("Property.addAccessor:  Behavior already exists!");
        }
        try {
            cd.addBehavior(behavior, false);
        }
        catch (PropertyVetoException e) {
            throw new IllegalStateException();
        }
        return behavior;
    }

    protected int getDefaultAccess(int nAccessor) {
        Behavior[] aBehavior = this.getAccessors();
        int nDefault1 = -1;
        int nDefault2 = -1;
        switch (nAccessor) {
            case 0: {
                nDefault1 = 1;
                break;
            }
            case 1: {
                nDefault1 = 0;
                break;
            }
            case 2: {
                nDefault1 = 4;
                nDefault2 = 3;
                break;
            }
            case 3: {
                nDefault1 = 5;
                nDefault2 = 2;
                break;
            }
            case 4: {
                nDefault1 = 2;
                nDefault2 = 5;
                break;
            }
            case 5: {
                nDefault1 = 3;
                nDefault2 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Property.getDefaultAccess:  Illegal accessor value!");
            }
        }
        Behavior behavior = aBehavior[nDefault1];
        if (behavior == null && nDefault2 >= 0) {
            behavior = aBehavior[nDefault2];
        }
        return behavior == null ? 0 : behavior.getAccess();
    }

    protected boolean isAccessorRemovable(int nAccessor) {
        Behavior behavior = this.getAccessor(nAccessor);
        return behavior == null || !behavior.isFromImplements() && !behavior.isFromDispatches() && !behavior.isFromIntegration() && !behavior.isFromManual();
    }

    protected void removeAccessor(int nAccessor) {
        String sSig;
        Component cd = this.getComponent();
        Behavior behavior = cd.getBehavior(sSig = this.getAccessorSignature(nAccessor));
        if (behavior != null) {
            if (!behavior.isFromProperty() || behavior.isFromSuper() || behavior.isFromImplements() || behavior.isFromDispatches() || behavior.isFromIntegration() || behavior.isFromManual()) {
                throw new IllegalStateException("Property.removeAccessor:  Illegal Behavior origin!  (" + behavior.toString() + ")");
            }
            try {
                cd.removeBehavior(behavior, false);
            }
            catch (PropertyVetoException e) {
                throw new IllegalStateException();
            }
        }
    }

    public boolean isFromIntegration() {
        return this.isFromTraitDescriptor("Integration");
    }

    protected void setFromIntegration(Integration map, Property field) {
        if (map == null) {
            throw new IllegalArgumentException("Property.setFromIntegrates:  Integrates interface required!");
        }
        if (field == null) {
            this.removeOriginTrait(map);
        } else {
            try {
                Object oPrev = field.m_oValue;
                Object oValue = this.m_oValue;
                if (field.isConstant() || this.m_dt != field.m_dt || this.getIndexed() != field.getIndexed()) {
                    oValue = oPrev;
                }
                this.m_oPrevValue = oPrev;
                this.setStatic(field.isStatic(), false);
                this.setFinal(field.isFinal(), false);
                this.setPersistent(field.isPersistent(), false);
                this.setDirection(field.getDirection(), false);
                this.setDataType(field.getDataType(), false);
                this.setIndexed(field.getIndexed(), false);
                this.setValue(oValue, false);
                this.addOriginTrait(map);
            }
            catch (PropertyVetoException e) {
                throw new IllegalStateException();
            }
        }
    }

    public int getExists() {
        return this.m_nFlags & 6;
    }

    protected void setExists(int nExists) {
        this.m_nFlags = this.m_nFlags & 0xFFFFFFF9 | nExists;
    }

    public int getAccess() {
        return this.m_nFlags & 0x30;
    }

    public boolean isAccessSettable() {
        return this.isDeclaredAtThisLevel() && this.isModifiable() && this.isConstant();
    }

    public boolean isAccessLegal(int nAccess) {
        switch (nAccess) {
            case 32: 
            case 48: {
                return this.isConstant();
            }
            case 0: {
                return !this.isVirtualConstant();
            }
        }
        return false;
    }

    public void setAccess(int nAccess) throws PropertyVetoException {
        this.setAccess(nAccess, true);
    }

    protected synchronized void setAccess(int nAccess, boolean fVetoable) throws PropertyVetoException {
        int nPrev = this.getAccess();
        if (nAccess == nPrev) {
            return;
        }
        Integer prev = Property.makeInteger(nPrev);
        Integer value = Property.makeInteger(nAccess);
        if (fVetoable) {
            if (!this.isAccessSettable()) {
                this.readOnlyAttribute(ATTR_ACCESS, prev, value);
            }
            if (!this.isAccessLegal(nAccess)) {
                this.illegalAttributeValue(ATTR_ACCESS, prev, value);
            }
            this.fireVetoableChange(ATTR_ACCESS, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFFFCF | nAccess;
        this.firePropertyChange(ATTR_ACCESS, prev, value);
    }

    public boolean isStatic() {
        return (this.m_nFlags & 0x200) == 512;
    }

    public boolean isStaticSettable() {
        if (this.isDeclaredAtThisLevel() && this.isModifiable() && !this.isFromIntegration()) {
            if (this.isConstant()) {
                return this.isJavaConstant();
            }
            for (int i = 0; i <= 5; ++i) {
                if (this.isAccessorOwned(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setStatic(boolean fStatic) throws PropertyVetoException {
        this.setStatic(fStatic, true);
    }

    protected synchronized void setStatic(boolean fStatic, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevStatic = this.isStatic();
        if (fStatic == fPrevStatic) {
            return;
        }
        Boolean prev = Property.toBoolean(fPrevStatic);
        Boolean value = Property.toBoolean(fStatic);
        if (fVetoable) {
            if (!this.isStaticSettable()) {
                this.readOnlyAttribute(ATTR_STATIC, prev, value);
            }
            this.fireVetoableChange(ATTR_STATIC, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFFDFF | (fStatic ? 512 : 0);
        if (!this.isConstant()) {
            for (Behavior behavior : this.getAccessors()) {
                if (behavior == null) continue;
                if (!behavior.isFromProperty()) {
                    throw new IllegalStateException("Property.setStatic:  Behavior does not have Property as origin! (" + behavior.toString() + ")");
                }
                try {
                    behavior.setStatic(fStatic, false);
                }
                catch (PropertyVetoException e) {
                    throw new IllegalStateException("Property.setStatic:  Behavior setStatic vetoed!");
                }
            }
        }
        this.firePropertyChange(ATTR_STATIC, prev, value);
    }

    public boolean isFinal() {
        return (this.m_nFlags & 0x2000) == 8192;
    }

    public boolean isFinalSettable() {
        return this.isDeclaredAtThisLevel() && this.isModifiable() && this.isConstant() && !this.isFromIntegration() && !this.isStatic() && this.getAccess() != 0;
    }

    public void setFinal(boolean fFinal) throws PropertyVetoException {
        this.setFinal(fFinal, true);
    }

    protected synchronized void setFinal(boolean fFinal, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevFinal = this.isFinal();
        if (fFinal == fPrevFinal) {
            return;
        }
        Boolean prev = Property.toBoolean(fPrevFinal);
        Boolean value = Property.toBoolean(fFinal);
        if (fVetoable) {
            if (!this.isFinalSettable()) {
                this.readOnlyAttribute(ATTR_FINAL, prev, value);
            }
            this.fireVetoableChange(ATTR_FINAL, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFFDFFF | (fFinal ? 8192 : 0);
        if (fFinal && this.getIndexed() == 0x20000000) {
            this.setIndexed(0x30000000, false);
        }
        this.firePropertyChange(ATTR_FINAL, prev, value);
    }

    public int getVisible() {
        return this.m_nFlags & 0x6000000;
    }

    public boolean isVisibleSettable() {
        return !this.isComponentComplex() && this.isModifiable();
    }

    public boolean isVisibleLegal(int nVis) {
        switch (nVis) {
            case 0: 
            case 0x2000000: 
            case 0x4000000: 
            case 0x6000000: {
                return true;
            }
        }
        return false;
    }

    public void setVisible(int nVis) throws PropertyVetoException {
        this.setVisible(nVis, true);
    }

    protected synchronized void setVisible(int nVis, boolean fVetoable) throws PropertyVetoException {
        int nPrevVis = this.getVisible();
        if (nVis == nPrevVis) {
            return;
        }
        Integer prev = Property.makeInteger(nPrevVis);
        Integer value = Property.makeInteger(nVis);
        if (fVetoable) {
            if (!this.isVisibleSettable()) {
                this.readOnlyAttribute(ATTR_VISIBLE, prev, value);
            }
            if (!this.isVisibleLegal(nVis)) {
                this.illegalAttributeValue(ATTR_VISIBLE, prev, value);
            }
            this.fireVetoableChange(ATTR_VISIBLE, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xF9FFFFFF | nVis;
        this.firePropertyChange(ATTR_VISIBLE, prev, value);
    }

    public boolean isDeprecated() {
        return (this.m_nFlags & 0x8000) == 32768;
    }

    public boolean isDeprecatedSettable() {
        return !this.isComponentComplex() && this.isModifiable();
    }

    public void setDeprecated(boolean fDeprecated) throws PropertyVetoException {
        this.setDeprecated(fDeprecated, true);
    }

    protected synchronized void setDeprecated(boolean fDeprecated, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevDeprecated = this.isDeprecated();
        if (fDeprecated == fPrevDeprecated) {
            return;
        }
        Boolean prev = Property.toBoolean(fPrevDeprecated);
        Boolean value = Property.toBoolean(fDeprecated);
        if (fVetoable) {
            if (!this.isDeprecatedSettable()) {
                this.readOnlyAttribute(ATTR_DEPRECATED, prev, value);
            }
            this.fireVetoableChange(ATTR_DEPRECATED, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFF7FFF | (fDeprecated ? 32768 : 0);
        this.firePropertyChange(ATTR_DEPRECATED, prev, value);
    }

    public boolean isPersistent() {
        return (this.m_nFlags & 0x20000) == 131072;
    }

    public boolean isPersistentSettable() {
        return this.isDeclaredAtThisLevel() && this.isStandardProperty() && this.isModifiable() && !this.isFromIntegration();
    }

    public void setPersistent(boolean fPersistent) throws PropertyVetoException {
        this.setPersistent(fPersistent, true);
    }

    protected synchronized void setPersistent(boolean fPersistent, boolean fVetoable) throws PropertyVetoException {
        boolean fPrevPersistent = this.isPersistent();
        if (fPersistent == fPrevPersistent) {
            return;
        }
        Boolean prev = Property.toBoolean(fPrevPersistent);
        Boolean value = Property.toBoolean(fPersistent);
        if (fVetoable) {
            if (!this.isPersistentSettable()) {
                this.readOnlyAttribute(ATTR_PERSISTENT, prev, value);
            }
            this.fireVetoableChange(ATTR_PERSISTENT, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xFFFDFFFF | (fPersistent ? 131072 : 0);
        this.firePropertyChange(ATTR_PERSISTENT, prev, value);
    }

    public int getDirection() {
        return this.m_nFlags & 0xC00000;
    }

    public boolean isSettable() {
        return (this.m_nFlags & 0x400000) != 0;
    }

    public boolean isGettable() {
        return (this.m_nFlags & 0x800000) != 0;
    }

    public boolean isDirectionSettable() {
        return this.isDeclaredAtThisLevel() && !this.isConstant() && this.isModifiable() && !this.isFromIntegration();
    }

    public boolean isDirectionLegal(int nDir) {
        boolean fRemoveOut;
        switch (nDir) {
            default: {
                return false;
            }
            case 0xC00000: {
                return true;
            }
            case 0x400000: {
                fRemoveOut = true;
                break;
            }
            case 0x800000: {
                fRemoveOut = false;
            }
        }
        int nPrevDir = this.getDirection();
        if (nDir == nPrevDir) {
            return true;
        }
        Behavior[] aBehavior = this.getAccessors();
        int cBehavior = aBehavior.length;
        if (fRemoveOut) {
            return this.isAccessorRemovable(0) && this.isAccessorRemovable(2) && this.isAccessorRemovable(4);
        }
        return this.isAccessorRemovable(1) && this.isAccessorRemovable(3) && this.isAccessorRemovable(5);
    }

    public void setDirection(int nDir) throws PropertyVetoException {
        this.setDirection(nDir, true);
    }

    protected synchronized void setDirection(int nDir, boolean fVetoable) throws PropertyVetoException {
        int nPrev = this.getDirection();
        if (nDir == nPrev) {
            return;
        }
        Integer prev = Property.makeInteger(nPrev);
        Integer value = Property.makeInteger(nDir);
        if (fVetoable) {
            if (!this.isDirectionSettable()) {
                this.readOnlyAttribute(ATTR_DIRECTION, prev, value);
            }
            if (!this.isDirectionLegal(nDir)) {
                this.illegalAttributeValue(ATTR_DIRECTION, prev, value);
            }
            this.fireVetoableChange(ATTR_DIRECTION, prev, value);
        }
        if (nPrev == 0xC00000 && this.isPersistent()) {
            this.setPersistent(false, false);
        }
        if (nDir != 0xC00000) {
            boolean fRemoveOut = nDir == 0x400000;
            switch (this.getIndexed()) {
                case 0x10000000: {
                    this.removeAccessor(fRemoveOut ? 0 : 1);
                    break;
                }
                case 0x30000000: {
                    this.removeAccessor(fRemoveOut ? 2 : 3);
                }
                case 0x20000000: {
                    this.removeAccessor(fRemoveOut ? 4 : 5);
                }
            }
        }
        this.m_nFlags = this.m_nFlags & 0xFF3FFFFF | nDir;
        if (nDir == 0x800000 && this.m_oValue != NO_VALUE) {
            this.setValue(NO_VALUE, false);
        }
        if (nPrev != 0xC00000 && !this.isConstant()) {
            boolean fAddOut = nPrev == 0x400000;
            switch (this.getIndexed()) {
                case 0x10000000: {
                    this.addAccessor(fAddOut ? 0 : 1);
                    break;
                }
                case 0x30000000: {
                    this.addAccessor(fAddOut ? 2 : 3);
                }
                case 0x20000000: {
                    this.addAccessor(fAddOut ? 4 : 5);
                }
            }
        }
        this.firePropertyChange(ATTR_DIRECTION, prev, value);
    }

    public DataType getDataType() {
        return this.m_dt;
    }

    public boolean isComplex() {
        return this.m_dt.isComponent();
    }

    public boolean isComplexDesignable() {
        DataType dt = this.m_dt;
        if (!dt.isComponent()) {
            return false;
        }
        String sConstraint = dt.getComponentName();
        Component cd = this.getComponent();
        while (!Component.isDerivedFrom(sConstraint, cd.getQualifiedName())) {
            if (!cd.isComplex()) {
                return true;
            }
            Property prop = cd.getComplex();
            if (prop == null) {
                return true;
            }
            cd = prop.getComponent();
        }
        return false;
    }

    public boolean isDataTypeSettable() {
        return this.isDeclaredAtThisLevel() && this.isModifiable() && !this.isFromIntegration() && this.isAccessorOwned(0) && this.isAccessorOwned(2) && this.isAccessorOwned(4);
    }

    public boolean isDataTypeLegal(DataType dt) {
        DataType VOID = DataType.VOID;
        if (dt == null || dt == VOID) {
            return false;
        }
        if (dt == this.m_dt) {
            return true;
        }
        Behavior[] aCurrent = this.getReservedBehaviors();
        Behavior[] aBehavior = this.getReservedBehaviors(dt, this.m_sName);
        int cBehavior = aBehavior.length;
        boolean fIndexed = !this.isSingle();
        for (int i = 0; i < cBehavior; ++i) {
            ReturnValue retval;
            Behavior current = aCurrent[i];
            Behavior behavior = aBehavior[i];
            if (behavior == null || behavior == current || behavior.isFromTrait(this)) continue;
            if (behavior.isFromProperty()) {
                throw new IllegalStateException("Property.isDataTypeLegal:  Illegal Behavior origin!  (" + behavior.toString() + ")");
            }
            if (current == null) {
                return false;
            }
            if (behavior.isFromSuper()) {
                return false;
            }
            if (!behavior.getName().equals(current.getName())) {
                return false;
            }
            DataType dtRet = null;
            DataType dtActual = behavior.getReturnValue().getDataType();
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    dtRet = DataType.VOID;
                    break;
                }
                case 3: 
                case 5: {
                    dtRet = fIndexed ? dt.getArrayType() : dt;
                    break;
                }
                case 4: 
                case 6: {
                    dtRet = dt;
                }
            }
            if (!(dtRet == dtActual || (retval = behavior.getReturnValue()).isDataTypeSettable() && retval.isDataTypeLegal(dtRet))) {
                return false;
            }
            if (behavior.isStatic() == current.isStatic() || behavior.isStaticSettable()) continue;
            return false;
        }
        return true;
    }

    public void setDataType(DataType dt) throws PropertyVetoException {
        this.setDataType(dt, true);
    }

    protected synchronized void setDataType(DataType dt, boolean fVetoable) throws PropertyVetoException {
        DataType dtPrev = this.m_dt;
        if (dt == dtPrev) {
            return;
        }
        if (fVetoable) {
            if (!this.isDataTypeSettable()) {
                this.readOnlyAttribute(ATTR_DATATYPE, dtPrev, dt);
            }
            if (!this.isDataTypeLegal(dt)) {
                this.illegalAttributeValue(ATTR_DATATYPE, dtPrev, dt);
            }
            this.fireVetoableChange(ATTR_DATATYPE, dtPrev, dt);
        }
        if (this.m_oValue != NO_VALUE) {
            this.setValue(NO_VALUE, false);
        }
        if (this.isConstant()) {
            this.m_dt = dt;
        } else {
            Behavior[] aOldBehavior = this.getAccessors();
            this.m_dt = dt;
            Behavior[] aNewBehavior = this.getAccessors();
            if (this.isGettable()) {
                boolean fPrefixChange = dt == BOOLEAN || dtPrev == BOOLEAN;
                switch (this.getIndexed()) {
                    case 0x10000000: {
                        aOldBehavior[0].getReturnValue().setDataType(dt, false);
                        if (!fPrefixChange) break;
                        String sSig = this.getAccessorSignature(0);
                        String sName = sSig.substring(0, sSig.indexOf(40));
                        aOldBehavior[0].setName(sName, false);
                        break;
                    }
                    case 0x30000000: {
                        String sName;
                        String sSig;
                        aOldBehavior[2].getReturnValue().setDataType(dt.getArrayType(), false);
                        if (fPrefixChange) {
                            sSig = this.getAccessorSignature(2);
                            sName = sSig.substring(0, sSig.indexOf(40));
                            aOldBehavior[2].setName(sName, false);
                        }
                    }
                    case 0x20000000: {
                        aOldBehavior[4].getReturnValue().setDataType(dt, false);
                        if (!fPrefixChange) break;
                        String sSig = this.getAccessorSignature(4);
                        String sName = sSig.substring(0, sSig.indexOf(40));
                        aOldBehavior[4].setName(sName, false);
                    }
                }
            }
            if (this.isSettable()) {
                switch (this.getIndexed()) {
                    case 0x10000000: {
                        this.setBehaviorParameterType(1, aOldBehavior[1], aNewBehavior[1], 0, dt);
                        break;
                    }
                    case 0x30000000: {
                        this.setBehaviorParameterType(3, aOldBehavior[3], aNewBehavior[3], 0, dt.getArrayType());
                    }
                    case 0x20000000: {
                        this.setBehaviorParameterType(5, aOldBehavior[5], aNewBehavior[5], 1, dt);
                    }
                }
            }
        }
        this.firePropertyChange(ATTR_DATATYPE, dtPrev, dt);
    }

    protected void setBehaviorParameterType(int nAccessor, Behavior behOld, Behavior behNew, int iParam, DataType dt) {
        try {
            if (behNew != null && behNew != behOld) {
                behOld.removeOriginTrait(this);
                behNew.addOriginTrait(this);
                ReturnValue retval = behNew.getReturnValue();
                if (retval.getDataType() != DataType.VOID) {
                    retval.setDataType(DataType.VOID, false);
                }
                if (behNew.isStatic() != behOld.isStatic()) {
                    behNew.setStatic(behOld.isStatic(), false);
                }
                if (behOld.isFromNothing()) {
                    this.getComponent().removeBehavior(behOld, false);
                }
            } else if (behOld.isFromImplements() || behOld.isFromDispatches() || behOld.isFromIntegration()) {
                behOld.removeOriginTrait(this);
                behNew = this.addAccessor(nAccessor);
            } else {
                behNew = behOld;
                behNew.getParameter(iParam).setDataType(dt, false);
            }
        }
        catch (PropertyVetoException e) {
            throw new IllegalStateException("Property.setBehaviorParameterType:  Unexpected Property Veto (" + e.toString() + ")");
        }
    }

    protected byte getDataTypeEnum() {
        return Property.getDataTypeEnum(this.m_dt);
    }

    protected static byte getDataTypeEnum(DataType dt) {
        if (dt.isPrimitive()) {
            switch (dt.getTypeString().charAt(0)) {
                case 'Z': {
                    return 0;
                }
                case 'C': {
                    return 1;
                }
                case 'B': {
                    return 2;
                }
                case 'S': {
                    return 3;
                }
                case 'I': {
                    return 4;
                }
                case 'J': {
                    return 5;
                }
                case 'F': {
                    return 6;
                }
                case 'D': {
                    return 7;
                }
            }
            throw new IllegalStateException("Property.getDataTypeEnum:  Invalid simple type");
        }
        if (dt == BINARY) {
            return 8;
        }
        if (dt == STRING) {
            return 9;
        }
        if (dt.isComponent()) {
            return 10;
        }
        return 11;
    }

    protected static boolean isDataTypeEnumSimple(byte nType) {
        return nType >= 0 && nType <= 7;
    }

    protected static boolean isDataTypeEnumNumeric(byte nType) {
        return nType >= 2 && nType <= 7;
    }

    public String getName() {
        return this.m_sName;
    }

    public boolean isNameSettable() {
        return this.isDeclaredAtThisLevel() && this.isModifiable() && !this.isFromIntegration();
    }

    public boolean isNameLegal(String sName) {
        if (sName.equals(this.m_sName)) {
            return true;
        }
        if (INSENS.equals(sName, this.m_sName)) {
            for (int i = 0; i <= 5; ++i) {
                if (this.isAccessorOwned(i)) continue;
                return false;
            }
            return true;
        }
        return Property.isCreatable(this.getComponent(), this.m_dt, sName, this.getIndexed(), this.isStatic(), this.getDirection(), this.isConstant());
    }

    public void setName(String sName) throws PropertyVetoException {
        this.setName(sName, true);
    }

    protected synchronized void setName(String sName, boolean fVetoable) throws PropertyVetoException {
        Behavior behOld;
        int i;
        String sPrev = this.m_sName;
        if (sName.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isNameSettable()) {
                this.readOnlyAttribute(ATTR_NAME, sPrev, sName);
            }
            if (!this.isNameLegal(sName)) {
                this.illegalAttributeValue(ATTR_NAME, sPrev, sName);
            }
            this.fireVetoableChange(ATTR_NAME, sPrev, sName);
        }
        Behavior[] aBehOld = this.getAccessors();
        for (i = 0; i <= 5; ++i) {
            behOld = aBehOld[i];
            if (behOld == null) continue;
            behOld.removeOriginTrait(this);
        }
        this.getComponent().renameProperty(sPrev, sName);
        this.m_sName = sName;
        if (INSENS.equals(sName, sPrev)) {
            for (i = 0; i <= 5; ++i) {
                behOld = aBehOld[i];
                if (behOld == null) continue;
                String sSig = this.getAccessorSignature(i);
                String sBeh = sSig.substring(0, sSig.indexOf(40));
                behOld.setName(sBeh, false);
                behOld.addOriginTrait(this);
            }
        } else {
            Behavior[] aBehNew = this.getAccessors();
            for (int i2 = 0; i2 <= 5; ++i2) {
                String sBeh;
                String sSig;
                Behavior behOld2 = aBehOld[i2];
                Behavior behNew = aBehNew[i2];
                if (behOld2 == null) continue;
                if (behNew == null) {
                    if (this.isAccessorOwned(aBehOld[i2])) {
                        sSig = this.getAccessorSignature(i2);
                        sBeh = sSig.substring(0, sSig.indexOf(40));
                        behOld2.setName(sBeh, false);
                        behOld2.addOriginTrait(this);
                        continue;
                    }
                    behNew = this.addAccessor(i2);
                    continue;
                }
                sSig = this.getAccessorSignature(i2);
                sBeh = sSig.substring(0, sSig.indexOf(40));
                behNew.setName(sBeh, false);
                ReturnValue retvalOld = behOld2.getReturnValue();
                ReturnValue retvalNew = behNew.getReturnValue();
                if (retvalNew.getDataType() != retvalOld.getDataType()) {
                    retvalNew.setDataType(retvalOld.getDataType(), false);
                }
                if (behNew.isStatic() != behOld2.isStatic()) {
                    behNew.setStatic(behOld2.isStatic(), false);
                }
                behNew.addOriginTrait(this);
                if (!behOld2.isFromNothing()) continue;
                this.getComponent().removeBehavior(behOld2, false);
            }
        }
        this.firePropertyChange(ATTR_NAME, sPrev, sName);
    }

    public boolean isSingle() {
        return (this.m_nFlags & 0x30000000) == 0x10000000;
    }

    public int getIndexed() {
        return this.m_nFlags & 0x30000000;
    }

    public boolean isIndexedSettable() {
        if (this.isDeclaredAtThisLevel() && this.isModifiable() && !this.isFromIntegration()) {
            if (this.isConstant()) {
                return true;
            }
            switch (this.getIndexed()) {
                case 0x10000000: {
                    return this.isAccessorOwned(0);
                }
                case 0x30000000: {
                    return this.isAccessorOwned(2);
                }
                case 0x20000000: {
                    return true;
                }
            }
            throw new IllegalStateException("Property.isIndexedSettable");
        }
        return false;
    }

    public boolean isIndexedLegal(int nIndexed) {
        switch (nIndexed) {
            case 0x10000000: 
            case 0x20000000: 
            case 0x30000000: {
                break;
            }
            default: {
                return false;
            }
        }
        int nPrev = this.getIndexed();
        if (nIndexed == nPrev) {
            return true;
        }
        if (this.isConstant()) {
            return nIndexed != 0x20000000 || this.isVirtualConstant();
        }
        switch (nPrev) {
            case 0x10000000: {
                return this.isAccessorOwned(0) && this.isAccessorOwned(1);
            }
            case 0x30000000: {
                if (nIndexed == 0x10000000) {
                    return this.isAccessorOwned(2) && this.isAccessorOwned(3) && this.isAccessorRemovable(4) && this.isAccessorRemovable(5);
                }
                return this.isAccessorRemovable(2) && this.isAccessorRemovable(3);
            }
            case 0x20000000: {
                if (nIndexed == 0x10000000) {
                    return this.isAccessorOwned(4) && this.isAccessorOwned(5);
                }
                return true;
            }
        }
        throw new IllegalStateException("Property.isIndexedLegal");
    }

    public void setIndexed(int nIndexed) throws PropertyVetoException {
        this.setIndexed(nIndexed, true);
    }

    protected synchronized void setIndexed(int nIndexed, boolean fVetoable) throws PropertyVetoException {
        int nPrev = this.getIndexed();
        if (nIndexed == nPrev) {
            return;
        }
        Integer prev = Property.makeInteger(nPrev);
        Integer value = Property.makeInteger(nIndexed);
        if (fVetoable) {
            if (!this.isIndexedSettable()) {
                this.readOnlyAttribute(ATTR_INDEXED, prev, value);
            }
            if (!this.isIndexedLegal(nIndexed)) {
                this.illegalAttributeValue(ATTR_INDEXED, prev, value);
            }
            this.fireVetoableChange(ATTR_INDEXED, prev, value);
        }
        this.m_nFlags = this.m_nFlags & 0xCFFFFFFF | nIndexed;
        if (this.m_oValue != NO_VALUE) {
            this.setValue(NO_VALUE, false);
        }
        if (!this.isConstant()) {
            DataType dtSingle = this.m_dt;
            DataType dtArray = dtSingle.getArrayType();
            boolean fGettable = this.isGettable();
            boolean fSettable = this.isSettable();
            switch (nPrev) {
                case 0x10000000: {
                    if (nIndexed == 0x30000000) {
                        if (fGettable) {
                            this.getAccessor(0).getReturnValue().setDataType(dtArray, false);
                        }
                        if (fSettable) {
                            this.getAccessor(1).getParameter(0).setDataType(dtArray, false);
                        }
                        if (fGettable) {
                            this.addAccessor(4);
                        }
                        if (!fSettable) break;
                        this.addAccessor(5);
                        break;
                    }
                    if (fGettable) {
                        this.getAccessor(0).addParameter(-1, INT, INDEX_PARAM, false);
                    }
                    if (!fSettable) break;
                    this.getAccessor(1).addParameter(0, INT, INDEX_PARAM, false);
                    break;
                }
                case 0x30000000: {
                    if (nIndexed == 0x10000000) {
                        if (fGettable) {
                            this.getAccessor(2).getReturnValue().setDataType(dtSingle, false);
                        }
                        if (fSettable) {
                            this.getAccessor(3).getParameter(0).setDataType(dtSingle, false);
                        }
                        if (fGettable) {
                            this.removeAccessor(4);
                        }
                        if (!fSettable) break;
                        this.removeAccessor(5);
                        break;
                    }
                    if (fGettable) {
                        this.removeAccessor(2);
                    }
                    if (!fSettable) break;
                    this.removeAccessor(3);
                    break;
                }
                case 0x20000000: {
                    if (nIndexed == 0x10000000) {
                        if (fGettable) {
                            this.getAccessor(4).removeParameter(0, false);
                        }
                        if (!fSettable) break;
                        this.getAccessor(5).removeParameter(0, false);
                        break;
                    }
                    if (fGettable) {
                        this.addAccessor(2);
                    }
                    if (!fSettable) break;
                    this.addAccessor(3);
                    break;
                }
                default: {
                    throw new IllegalStateException("Property.setIndexed");
                }
            }
        }
        this.firePropertyChange(ATTR_INDEXED, prev, value);
    }

    public boolean isNoValue() {
        return this.m_oValue == NO_VALUE;
    }

    protected boolean isNoDelta() {
        return this.m_oValue == NO_DELTA;
    }

    public boolean isNullValue() {
        return this.m_oValue == null;
    }

    public Object getValue() {
        Object oValue = this.m_oValue;
        if (oValue instanceof Object[]) {
            return ((Object[])oValue).clone();
        }
        return oValue;
    }

    public boolean isValueDiscardable() {
        return this.isValueEqual(this.m_oPrevValue);
    }

    public Object getDefaultValue() {
        Object oValue = this.m_oPrevValue;
        if (oValue instanceof Object[]) {
            return ((Object[])oValue).clone();
        }
        return oValue;
    }

    public boolean isValueSettable() {
        Behavior setter;
        if (!this.isModifiable()) {
            return false;
        }
        if (this.getComponent().isSignature()) {
            return false;
        }
        if (this.isComponentComplex()) {
            return true;
        }
        DataType dt = this.m_dt;
        if (dt.isArray() && dt.getBaseElementType().isComponent()) {
            return false;
        }
        if (this.isVirtualConstant()) {
            return true;
        }
        if (this.isCalculatedProperty()) {
            return false;
        }
        if (this.isJavaConstant()) {
            return !this.isFromSuper() && !this.isFromIntegration();
        }
        if (this.isStatic()) {
            return !this.isFromSuper();
        }
        switch (this.getIndexed()) {
            case 0x10000000: {
                setter = this.getAccessor(1);
                break;
            }
            case 0x30000000: {
                setter = this.getAccessor(3);
                break;
            }
            case 0x20000000: {
                return false;
            }
            default: {
                throw new IllegalStateException("Property.isValueSettable");
            }
        }
        return setter != null;
    }

    public boolean isValueLegal(Object oValue) {
        DataType dt = this.m_dt;
        int nIndexed = this.getIndexed();
        if (nIndexed == 0x10000000) {
            return this.isValueLegal(dt, oValue);
        }
        if (oValue == null || oValue == NO_VALUE) {
            return nIndexed == 0x30000000;
        }
        if (!(oValue instanceof Object[])) {
            return false;
        }
        Object[] aoValue = (Object[])oValue;
        int cValues = aoValue.length;
        for (int i = 0; i < cValues; ++i) {
            if (this.isValueLegal(dt, aoValue[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isValueEqual(Object oNewValue) {
        return Property.isValueEqual(this.m_dt, this.isSingle(), this.m_oValue, oNewValue);
    }

    public void setValue(Object oValue) throws PropertyVetoException {
        this.setValue(oValue, true);
    }

    protected synchronized void setValue(Object oValue, boolean fVetoable) throws PropertyVetoException {
        if (this.isValueEqual(oValue)) {
            return;
        }
        Object oPrev = this.m_oValue;
        if (fVetoable) {
            if (!this.isValueSettable()) {
                this.readOnlyAttribute(ATTR_VALUE, oPrev, oValue);
            }
            if (!this.isValueLegal(oValue)) {
                this.illegalAttributeValue(ATTR_VALUE, oPrev, oValue);
            }
            this.fireVetoableChange(ATTR_VALUE, oPrev, oValue);
        }
        this.m_oValue = oValue;
        if (!this.isSingle() && oValue instanceof Object[]) {
            Object[] aoValue = (Object[])oValue;
            int cValues = aoValue.length;
            this.m_oValue = new Object[cValues];
            System.arraycopy(aoValue, 0, (Object[])this.m_oValue, 0, cValues);
            if (this.isComplex()) {
                aoValue = (Object[])this.m_oValue;
                for (int i = 0; i < aoValue.length; ++i) {
                    Object oElement = aoValue[i];
                    if (oElement == NO_VALUE || oElement == null) continue;
                    aoValue[i] = new Component((Trait)this, (Component)oElement);
                }
            }
        } else if (this.isComplex() && oValue != NO_VALUE && oValue != null) {
            this.m_oValue = new Component((Trait)this, (Component)oValue);
        }
        this.firePropertyChange(ATTR_VALUE, oPrev, this.m_oValue);
    }

    public synchronized void resetValue() throws PropertyVetoException {
        this.setValue(this.m_oPrevValue);
    }

    public int getValueCount() {
        if (this.isSingle() || this.m_oValue == null || this.m_oValue == NO_VALUE) {
            throw new IllegalStateException("Property.getValueCount:  Property value is not an array!");
        }
        return ((Object[])this.m_oValue).length;
    }

    public void setValueCount(int cValues) throws PropertyVetoException {
        if (this.isSingle()) {
            throw new IllegalStateException("Property.setValueCount:  Property is not indexed!");
        }
        Object oPrev = this.m_oValue;
        Object[] aoOldValue = oPrev instanceof Object[] ? (Object[])oPrev : NO_OBJECTS;
        Object[] aoNewValue = new Object[cValues];
        int cOldValues = aoOldValue.length;
        if (cOldValues > 0) {
            System.arraycopy(aoOldValue, 0, aoNewValue, 0, cOldValues);
        }
        for (int i = cOldValues; i < cValues; ++i) {
            aoNewValue[i] = NO_VALUE;
        }
        this.setValue(aoNewValue);
    }

    public Object getValue(int iValue) {
        try {
            return ((Object[])this.m_oValue)[iValue];
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Property.getValue:  Property value is not an array!  (" + e.toString() + ")");
        }
    }

    public void setValue(int iValue, Object oValue) throws PropertyVetoException {
        try {
            Object[] aoValue = (Object[])this.getValue();
            aoValue[iValue] = oValue;
            this.setValue(aoValue);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Property.setValue:  Property value is not an array!  (" + e.toString() + ")");
        }
    }

    public void addValue(int iValue) throws PropertyVetoException {
        this.addValue(iValue, NO_VALUE);
    }

    public void addValue(int iValue, Object oValue) throws PropertyVetoException {
        if (iValue == -1) {
            try {
                Object[] aoOldValue = (Object[])this.m_oValue;
                int cOldValues = aoOldValue.length;
                int cNewValues = cOldValues + 1;
                Object[] aoNewValue = new Object[cNewValues];
                if (cOldValues > 0) {
                    System.arraycopy(aoOldValue, 0, aoNewValue, 0, cOldValues);
                }
                aoNewValue[cOldValues] = NO_VALUE;
                this.setValue(aoNewValue);
            }
            catch (ClassCastException e) {
                Object[] aoNewValue = new Object[]{NO_VALUE};
                this.setValue(aoNewValue);
            }
        } else {
            try {
                Object[] aoOldValue = (Object[])this.m_oValue;
                int cOldValues = aoOldValue.length;
                if (iValue < 0 || iValue > cOldValues) {
                    throw new ArrayIndexOutOfBoundsException("Property.addValue:  " + iValue);
                }
                int cNewValues = cOldValues + 1;
                Object[] aoNewValue = new Object[cNewValues];
                if (iValue > 0) {
                    System.arraycopy(aoOldValue, 0, aoNewValue, 0, iValue);
                }
                if (iValue < cOldValues) {
                    System.arraycopy(aoOldValue, iValue, aoNewValue, iValue + 1, cOldValues - iValue);
                }
                aoNewValue[iValue] = oValue;
                this.setValue(aoNewValue);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Property.addValue:  Property value is not an array!  (" + e.toString() + ")");
            }
        }
    }

    public void removeValue(int iValue) throws PropertyVetoException {
        this.removeValues(iValue, 1);
    }

    public void removeValues(int iValue, int cValues) throws PropertyVetoException {
        if (cValues == 0) {
            return;
        }
        try {
            Object[] aoOldValue = (Object[])this.m_oValue;
            int cOldValues = aoOldValue.length;
            if (iValue < 0 || cValues < 0 || iValue + cValues - 1 > cOldValues) {
                throw new ArrayIndexOutOfBoundsException("Property.removeValues:  " + iValue + ", " + cValues);
            }
            int cNewValues = cOldValues - cValues;
            Object[] aoNewValue = new Object[cNewValues];
            if (iValue > 0) {
                System.arraycopy(aoOldValue, 0, aoNewValue, 0, iValue);
            }
            if (iValue + cValues < cOldValues) {
                System.arraycopy(aoOldValue, iValue + cValues, aoNewValue, iValue, cOldValues - iValue - cValues);
            }
            this.setValue(aoNewValue);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Property.removeValues:  Property value is not an array!  (" + e.toString() + ")");
        }
    }

    protected boolean isValueLegal(DataType dt, Object oValue) {
        byte nType = Property.getDataTypeEnum(dt);
        if (oValue == NO_VALUE) {
            return true;
        }
        if (oValue == null) {
            return !Property.isDataTypeEnumSimple(nType);
        }
        switch (nType) {
            case 0: {
                return oValue instanceof Boolean;
            }
            case 1: {
                return oValue instanceof Character;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return oValue instanceof Number;
            }
            case 8: {
                return oValue instanceof byte[];
            }
            case 9: {
                return oValue instanceof String;
            }
            case 10: {
                if (!this.isComplexDesignable()) {
                    return false;
                }
                if (!(oValue instanceof Component)) {
                    return false;
                }
                Component cd = (Component)oValue;
                if (!cd.isComplex()) {
                    return false;
                }
                String sComponent = cd.getQualifiedName();
                if (!Component.isDerivedFrom(sComponent, dt.getComponentName())) {
                    return false;
                }
                cd = this.getComponent();
                while (!Component.isDerivedFrom(sComponent, cd.getQualifiedName())) {
                    if (!cd.isComplex()) {
                        return true;
                    }
                    Property prop = cd.getComplex();
                    if (prop == null) {
                        return true;
                    }
                    cd = prop.getComponent();
                }
                return false;
            }
        }
        return oValue instanceof Serializable;
    }

    protected static boolean isValueEqual(DataType dt, boolean fSingle, Object oValue1, Object oValue2) {
        if (oValue1 == oValue2) {
            return true;
        }
        if (oValue1 == NO_VALUE || oValue1 == null || oValue2 == NO_VALUE || oValue2 == null) {
            return false;
        }
        if (fSingle) {
            return Property.isValueEqual(dt, oValue1, oValue2);
        }
        Object[] aoValue1 = (Object[])oValue1;
        int cValue1 = aoValue1.length;
        Object[] aoValue2 = (Object[])oValue2;
        int cValue2 = aoValue2.length;
        if (cValue1 != cValue2) {
            return false;
        }
        for (int i = 0; i < cValue2; ++i) {
            if (Property.isValueEqual(dt, aoValue1[i], aoValue2[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean isValueEqual(DataType dt, Object oValue1, Object oValue2) {
        if (oValue1 == oValue2) {
            return true;
        }
        if (oValue1 == NO_VALUE || oValue1 == NO_DELTA || oValue1 == null || oValue2 == NO_VALUE || oValue2 == NO_DELTA || oValue2 == null) {
            return false;
        }
        if (dt == BINARY) {
            byte[] ab1 = (byte[])oValue1;
            int cb1 = ab1.length;
            byte[] ab2 = (byte[])oValue2;
            int cb2 = ab2.length;
            if (cb1 != cb2) {
                return false;
            }
            int i = cb1;
            while (i-- != 0) {
                if (ab1[i] == ab2[i]) continue;
                return false;
            }
            return true;
        }
        if (dt.isPrimitive() && dt != BOOLEAN && dt != CHAR) {
            Number num1 = (Number)oValue1;
            Number num2 = (Number)oValue2;
            switch (Property.getDataTypeEnum(dt)) {
                case 2: {
                    return num1.byteValue() == num2.byteValue();
                }
                case 3: {
                    return num1.shortValue() == num2.shortValue();
                }
                case 4: {
                    return num1.intValue() == num2.intValue();
                }
                case 5: {
                    return num1.longValue() == num2.longValue();
                }
                case 6: {
                    return Float.floatToIntBits(num1.floatValue()) == Float.floatToIntBits(num2.floatValue());
                }
                case 7: {
                    return Double.doubleToLongBits(num1.doubleValue()) == Double.doubleToLongBits(num2.doubleValue());
                }
            }
            throw new IllegalStateException("Property.isValueEqual:  Unexpected Data Type " + dt);
        }
        if (dt.isArray()) {
            try {
                DataType dtElement = dt.getElementType();
                if (oValue1 instanceof Object[]) {
                    Object[] aoValue1 = (Object[])oValue1;
                    int cValues = aoValue1.length;
                    Object[] aoValue2 = (Object[])oValue2;
                    if (cValues != aoValue2.length) {
                        return false;
                    }
                    for (int i = 0; i < cValues; ++i) {
                        if (Property.isValueEqual(dtElement, aoValue1[i], aoValue2[i])) continue;
                        return false;
                    }
                    return true;
                }
                switch (Property.getDataTypeEnum(dtElement)) {
                    case 0: {
                        return Arrays.equals((boolean[])oValue1, (boolean[])oValue2);
                    }
                    case 1: {
                        return Arrays.equals((char[])oValue1, (char[])oValue2);
                    }
                    case 2: {
                        return Arrays.equals((byte[])oValue1, (byte[])oValue2);
                    }
                    case 3: {
                        return Arrays.equals((short[])oValue1, (short[])oValue2);
                    }
                    case 4: {
                        return Arrays.equals((int[])oValue1, (int[])oValue2);
                    }
                    case 5: {
                        return Arrays.equals((long[])oValue1, (long[])oValue2);
                    }
                    case 6: {
                        return Arrays.equals((float[])oValue1, (float[])oValue2);
                    }
                    case 7: {
                        return Arrays.equals((double[])oValue1, (double[])oValue2);
                    }
                }
                throw new IllegalStateException("Property.isValueEqual:  Unexpected Data Type " + dtElement);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return oValue1.equals(oValue2);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Property) {
            Property that = (Property)obj;
            return this == that || this.m_nFlags == that.m_nFlags && this.m_dt == that.m_dt && this.m_fSizeDelta == that.m_fSizeDelta && this.m_sName.equals(that.m_sName) && Property.isValueEqual(this.m_dt, this.isSingle(), this.m_oValue, that.m_oValue) && super.equals(that);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb;
        block34: {
            sb = new StringBuffer();
            switch (this.getVisible()) {
                case 0x2000000: {
                    sb.append("advanced ");
                    break;
                }
                case 0x4000000: {
                    sb.append("hidden ");
                    break;
                }
                case 0x6000000: {
                    sb.append("system ");
                }
            }
            switch (this.getAccess()) {
                case 48: {
                    sb.append("public ");
                    break;
                }
                case 32: {
                    sb.append("protected ");
                    break;
                }
                case 0: {
                    sb.append("private ");
                }
            }
            if (this.isStatic()) {
                sb.append("static ");
            }
            if (this.isFinal()) {
                sb.append("final ");
            }
            sb.append(this.isPersistent() ? "persistent " : "transient ");
            switch (this.getDirection()) {
                case 0x400000: {
                    sb.append("in ");
                    break;
                }
                case 0x800000: {
                    sb.append("out ");
                    break;
                }
                case 0xC00000: {
                    sb.append("inout ");
                }
            }
            if (!this.isSingle()) {
                sb.append("indexed ");
            }
            sb.append(this.m_dt.toString()).append(' ').append(this.m_sName);
            if (!this.isNoValue()) {
                try {
                    sb.append(" = ");
                    if (this.isNullValue()) {
                        sb.append("null");
                        break block34;
                    }
                    if (this.isSingle()) {
                        switch (Property.getDataTypeEnum(this.m_dt)) {
                            case 0: {
                                sb.append(this.m_oValue.toString());
                                break;
                            }
                            case 1: {
                                char ch = ((Character)this.m_oValue).charValue();
                                sb.append(Property.toQuotedCharEscape(ch));
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                sb.append(this.m_oValue.toString());
                                break;
                            }
                            case 8: {
                                boolean fTrunc;
                                byte[] ab = (byte[])this.m_oValue;
                                boolean bl = fTrunc = ab.length > 16;
                                if (fTrunc) {
                                    byte[] abTemp = new byte[16];
                                    System.arraycopy(ab, 0, abTemp, 0, abTemp.length);
                                    ab = abTemp;
                                }
                                sb.append("0x").append(Property.toHex(ab));
                                if (fTrunc) {
                                    sb.append("...");
                                    break;
                                }
                                break block34;
                            }
                            case 9: {
                                String s = (String)this.m_oValue;
                                if (s.length() > 32) {
                                    s = s.substring(0, 32) + "...";
                                }
                                sb.append(Property.toQuotedStringEscape(s));
                                break;
                            }
                            case 10: {
                                Component cd = (Component)this.m_oValue;
                                sb.append(cd.getQualifiedName()).append(" {...}");
                                break;
                            }
                            default: {
                                sb.append("Serializable");
                                break;
                            }
                        }
                        break block34;
                    }
                    sb.append("{...}");
                }
                catch (ClassCastException cce) {
                    sb.append("???");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void dump(PrintWriter out, String sIndent) {
        boolean fDerOrMod = this.getMode() == 3 || this.getMode() == 2;
        out.println(sIndent + "property " + (this.m_sName == null ? "<null>" : this.m_sName));
        super.dump(out, sIndent);
        out.print(sIndent + "flags=0x" + Integer.toHexString(this.m_nFlags));
        out.println(" (" + Property.flagsDescription(this.m_nFlags, 153178377, fDerOrMod) + ')');
        out.println(sIndent + "type=" + (this.m_dt == null ? "<null>" : this.m_dt.toString()));
        byte nType = this.getDataTypeEnum();
        if (this.isSingle() || this.isNullValue() || this.isNoValue() || this.isNoDelta()) {
            out.print(sIndent + "value=");
            this.dumpValue(out, sIndent + "      ", nType, this.m_oValue);
        } else {
            this.dumpArrayValues(out, sIndent, nType, (Object[])this.m_oValue);
        }
        Object o = this.m_oPrevValue;
        if (this.isSingle() || o == null || o == NO_VALUE || o == NO_DELTA) {
            out.print(sIndent + "prev value=");
            this.dumpValue(out, sIndent + "           ", nType, o);
        } else {
            this.dumpArrayValues(out, sIndent, nType, (Object[])o);
        }
        out.println(sIndent + "(delta size=" + this.m_fSizeDelta + ", prev delta size=" + this.m_fPrevSizeDelta + ')');
    }

    protected void dumpArrayValues(PrintWriter out, String sIndent, byte nType, Object[] aoValue) {
        int cValues = aoValue.length;
        int cDigits = Property.getMaxDecDigits(cValues);
        out.println(sIndent + "value [0.." + (cValues - 1) + "]:");
        String sIndentVal = sIndent + "     " + "          ".substring(0, cDigits);
        for (int i = 0; i < cValues; ++i) {
            out.print(sIndent + "  [" + Property.toDecString(i, cDigits) + "]=");
            this.dumpValue(out, sIndentVal, nType, aoValue[i]);
        }
    }

    protected void dumpValue(PrintWriter out, String sIndent, byte nType, Object oValue) {
        if (oValue == null) {
            out.println("<null>");
        } else if (oValue == NO_VALUE) {
            out.println("<no value>");
        } else if (oValue == NO_DELTA) {
            out.println("<no delta>");
        } else {
            switch (nType) {
                case 0: {
                    out.println(oValue.toString());
                    break;
                }
                case 1: {
                    char ch = ((Character)oValue).charValue();
                    out.println(Property.toQuotedCharEscape(ch));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    out.println(oValue.toString());
                    break;
                }
                case 9: {
                    out.println(Property.toQuotedStringEscape((String)oValue));
                    break;
                }
                case 8: {
                    byte[] ab = (byte[])oValue;
                    out.println(Property.indentString(Property.toHexDump(ab, 16), sIndent, false));
                    break;
                }
                case 10: {
                    Component cd = (Component)oValue;
                    cd.dump(out, sIndent, false);
                    break;
                }
                case 11: {
                    out.println("(java.io.Serializable) " + oValue.getClass().getName());
                    try {
                        ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                        ObjectOutputStream streamObj = new ObjectOutputStream(streamRaw);
                        streamObj.writeObject((Serializable)oValue);
                        streamObj.flush();
                        streamObj.close();
                        byte[] ab = streamRaw.toByteArray();
                        out.println(Property.indentString(Property.toHexDump(ab, 16), sIndent));
                    }
                    catch (IOException e) {
                        out.println(sIndent + "Unable to serialize!  (" + e.toString() + ')');
                    }
                    break;
                }
                default: {
                    out.println("<unsupported>");
                }
            }
        }
    }

    protected void setBooleanGet(boolean fGet) {
        this.m_fBooleanGet = fGet;
    }

    protected boolean isBooleanGet() {
        return this.m_fBooleanGet;
    }
}

