/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.pof.LoggingPofHandler;
import com.tangosol.io.pof.PofConstants;
import com.tangosol.io.pof.PofHandler;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.RawQuad;
import java.io.IOException;

public class PofParser
extends PofHelper
implements PofConstants {
    private PofHandler m_handler;

    public PofParser(PofHandler handler) {
        this.m_handler = handler;
    }

    public void parse(ReadBuffer.BufferInput in) {
        try {
            this.parseValue(in, -1);
        }
        catch (IOException e) {
            throw PofParser.ensureRuntimeException(e);
        }
    }

    protected void parseValue(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int nType = in.readPackedInt();
        if (nType == -31) {
            this.m_handler.registerIdentity(in.readPackedInt());
            nType = in.readPackedInt();
        }
        this.parseUniformValue(in, iPos, nType);
    }

    protected void parseUniformValue(ReadBuffer.BufferInput in, int iPos, int nType) throws IOException {
        if (nType >= 0) {
            this.parseUserType(in, iPos, nType);
        } else {
            PofHandler handler = this.m_handler;
            switch (nType) {
                case -1: {
                    handler.onInt16(iPos, (short)in.readPackedInt());
                    break;
                }
                case -2: {
                    handler.onInt32(iPos, in.readPackedInt());
                    break;
                }
                case -3: {
                    handler.onInt64(iPos, in.readPackedLong());
                    break;
                }
                case -4: {
                    handler.onInt128(iPos, PofParser.readBigInteger(in));
                    break;
                }
                case -5: {
                    handler.onFloat32(iPos, in.readFloat());
                    break;
                }
                case -6: {
                    handler.onFloat64(iPos, in.readDouble());
                    break;
                }
                case -7: {
                    handler.onFloat128(iPos, new RawQuad(in.readBuffer(16).toBinary()));
                }
                case -8: {
                    handler.onDecimal32(iPos, PofParser.readBigDecimal(in, 4));
                    break;
                }
                case -9: {
                    handler.onDecimal64(iPos, PofParser.readBigDecimal(in, 8));
                    break;
                }
                case -10: {
                    handler.onDecimal128(iPos, PofParser.readBigDecimal(in, 16));
                    break;
                }
                case -11: {
                    handler.onBoolean(iPos, in.readPackedInt() != 0);
                    break;
                }
                case -12: {
                    handler.onOctet(iPos, in.readUnsignedByte());
                    break;
                }
                case -13: {
                    int cb = in.readPackedInt();
                    int of = in.getOffset();
                    in.skipBytes(cb);
                    handler.onOctetString(iPos, in.getBuffer().toBinary(of, cb));
                    break;
                }
                case -14: {
                    handler.onChar(iPos, PofParser.readChar(in));
                    break;
                }
                case -15: {
                    handler.onCharString(iPos, in.readSafeUTF());
                    break;
                }
                case -16: {
                    int nYear = in.readPackedInt();
                    int nMonth = in.readPackedInt();
                    int nDay = in.readPackedInt();
                    handler.onDate(iPos, nYear, nMonth, nDay);
                    break;
                }
                case -17: {
                    int cYears = in.readPackedInt();
                    int dMonths = in.readPackedInt();
                    handler.onYearMonthInterval(iPos, cYears, dMonths);
                    break;
                }
                case -18: {
                    int nHour = in.readPackedInt();
                    int nMinute = in.readPackedInt();
                    int nSecond = in.readPackedInt();
                    int nFraction = in.readPackedInt();
                    int nNanos = nFraction <= 0 ? -nFraction : nFraction * 1000000;
                    int nZoneType = in.readPackedInt();
                    if (nZoneType == 2) {
                        int nHourOffset = in.readPackedInt();
                        int nMinuteOffset = in.readPackedInt();
                        handler.onTime(iPos, nHour, nMinute, nSecond, nNanos, nHourOffset, nMinuteOffset);
                        break;
                    }
                    assert (nZoneType == 0 || nZoneType == 1);
                    boolean fUTC = nZoneType == 1;
                    handler.onTime(iPos, nHour, nMinute, nSecond, nNanos, fUTC);
                    break;
                }
                case -19: {
                    int cHours = in.readPackedInt();
                    int cMinutes = in.readPackedInt();
                    int cSeconds = in.readPackedInt();
                    int cNanos = in.readPackedInt();
                    handler.onTimeInterval(iPos, cHours, cMinutes, cSeconds, cNanos);
                    break;
                }
                case -20: {
                    int nYear = in.readPackedInt();
                    int nMonth = in.readPackedInt();
                    int nDay = in.readPackedInt();
                    int nHour = in.readPackedInt();
                    int nMinute = in.readPackedInt();
                    int nSecond = in.readPackedInt();
                    int nFraction = in.readPackedInt();
                    int nNano = nFraction <= 0 ? -nFraction : nFraction * 1000000;
                    int nZoneType = in.readPackedInt();
                    if (nZoneType == 2) {
                        int nHourOffset = in.readPackedInt();
                        int nMinuteOffset = in.readPackedInt();
                        handler.onDateTime(iPos, nYear, nMonth, nDay, nHour, nMinute, nSecond, nNano, nHourOffset, nMinuteOffset);
                        break;
                    }
                    assert (nZoneType == 0 || nZoneType == 1);
                    boolean fUTC = nZoneType == 1;
                    handler.onDateTime(iPos, nYear, nMonth, nDay, nHour, nMinute, nSecond, nNano, fUTC);
                    break;
                }
                case -21: {
                    int cDays = in.readPackedInt();
                    int cHours = in.readPackedInt();
                    int cMinutes = in.readPackedInt();
                    int cSeconds = in.readPackedInt();
                    int cNanos = in.readPackedInt();
                    handler.onDayTimeInterval(iPos, cDays, cHours, cMinutes, cSeconds, cNanos);
                    break;
                }
                case -22: {
                    this.parseCollection(in, iPos);
                    break;
                }
                case -23: {
                    this.parseUniformCollection(in, iPos);
                    break;
                }
                case -24: {
                    this.parseArray(in, iPos);
                    break;
                }
                case -25: {
                    this.parseUniformArray(in, iPos);
                    break;
                }
                case -26: {
                    this.parseSparseArray(in, iPos);
                    break;
                }
                case -27: {
                    this.parseUniformSparseArray(in, iPos);
                    break;
                }
                case -28: {
                    this.parseMap(in, iPos);
                    break;
                }
                case -29: {
                    this.parseUniformKeysMap(in, iPos);
                    break;
                }
                case -30: {
                    this.parseUniformMap(in, iPos);
                    break;
                }
                case -31: {
                    throw PofParser.azzert();
                }
                case -32: {
                    handler.onIdentityReference(iPos, in.readPackedInt());
                    break;
                }
                case -34: 
                case -33: {
                    handler.onBoolean(iPos, nType == -34);
                    break;
                }
                case -35: {
                    handler.onOctetString(iPos, BINARY_EMPTY);
                    break;
                }
                case -36: {
                    handler.beginCollection(iPos, 0);
                    handler.endComplexValue();
                    break;
                }
                case -37: {
                    handler.onNullReference(iPos);
                    break;
                }
                case -38: {
                    handler.onFloat32(iPos, Float.POSITIVE_INFINITY);
                    break;
                }
                case -39: {
                    handler.onFloat32(iPos, Float.NEGATIVE_INFINITY);
                    break;
                }
                case -40: {
                    handler.onFloat32(iPos, Float.NaN);
                    break;
                }
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -60: 
                case -59: 
                case -58: 
                case -57: 
                case -56: 
                case -55: 
                case -54: 
                case -53: 
                case -52: 
                case -51: 
                case -50: 
                case -49: 
                case -48: 
                case -47: 
                case -46: 
                case -45: 
                case -44: 
                case -43: 
                case -42: 
                case -41: {
                    handler.onInt32(iPos, -42 - nType);
                    break;
                }
                default: {
                    PofParser.azzert();
                }
            }
        }
    }

    protected void parseUserType(ReadBuffer.BufferInput in, int iPos, int nType) throws IOException {
        PofHandler handler = this.m_handler;
        handler.beginUserType(iPos, nType, in.readPackedInt());
        while (true) {
            int iProp;
            if ((iProp = in.readPackedInt()) < 0) break;
            this.parseValue(in, iProp);
        }
        handler.endComplexValue();
    }

    protected void parseCollection(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginCollection(iPos, cElements);
        for (int i = 0; i < cElements; ++i) {
            this.parseValue(in, i);
        }
        handler.endComplexValue();
    }

    protected void parseUniformCollection(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int nType = in.readPackedInt();
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginUniformCollection(iPos, cElements, nType);
        for (int i = 0; i < cElements; ++i) {
            this.parseUniformValue(in, i, nType);
        }
        handler.endComplexValue();
    }

    protected void parseArray(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginArray(iPos, cElements);
        for (int i = 0; i < cElements; ++i) {
            this.parseValue(in, i);
        }
        handler.endComplexValue();
    }

    protected void parseUniformArray(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int nType = in.readPackedInt();
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginUniformArray(iPos, cElements, nType);
        for (int i = 0; i < cElements; ++i) {
            this.parseUniformValue(in, i, nType);
        }
        handler.endComplexValue();
    }

    protected void parseSparseArray(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int iArrayIndex;
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginSparseArray(iPos, cElements);
        for (int i = 0; i < cElements && (iArrayIndex = in.readPackedInt()) >= 0; ++i) {
            this.parseValue(in, iArrayIndex);
        }
        handler.endComplexValue();
    }

    protected void parseUniformSparseArray(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int iArrayIndex;
        int nType = in.readPackedInt();
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginUniformSparseArray(iPos, cElements, nType);
        for (int i = 0; i < cElements && (iArrayIndex = in.readPackedInt()) >= 0; ++i) {
            this.parseUniformValue(in, iArrayIndex, nType);
        }
        handler.endComplexValue();
    }

    protected void parseMap(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginMap(iPos, cElements);
        for (int i = 0; i < cElements; ++i) {
            this.parseValue(in, i);
            this.parseValue(in, i);
        }
        handler.endComplexValue();
    }

    protected void parseUniformKeysMap(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int nTypeKeys = in.readPackedInt();
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginUniformKeysMap(iPos, cElements, nTypeKeys);
        for (int i = 0; i < cElements; ++i) {
            this.parseUniformValue(in, i, nTypeKeys);
            this.parseValue(in, i);
        }
        handler.endComplexValue();
    }

    protected void parseUniformMap(ReadBuffer.BufferInput in, int iPos) throws IOException {
        int nTypeKeys = in.readPackedInt();
        int nTypeVals = in.readPackedInt();
        int cElements = in.readPackedInt();
        PofHandler handler = this.m_handler;
        handler.beginUniformMap(iPos, cElements, nTypeKeys, nTypeVals);
        for (int i = 0; i < cElements; ++i) {
            this.parseUniformValue(in, i, nTypeKeys);
            this.parseUniformValue(in, i, nTypeVals);
        }
        handler.endComplexValue();
    }

    public static void main(String[] asArg) throws Exception {
        if (asArg.length > 0) {
            ReadBuffer.BufferInput in = new ByteArrayReadBuffer(PofParser.parseHex(asArg[0])).getBufferInput();
            new PofParser(new LoggingPofHandler()).parse(in);
        }
    }
}

