/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.AbstractStableIterator;
import com.tangosol.util.Filter;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.PartitionedFilter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PartitionedIterator
extends AbstractStableIterator {
    public static final int OPT_KEYS = 0;
    public static final int OPT_ENTRIES = 1;
    public static final int OPT_BY_PARTITION = 0;
    public static final int OPT_BY_MEMBER = 2;
    public static final int OPT_RANDOMIZED = 4;
    private NamedCache m_cache;
    private PartitionedFilter m_filter;
    private PartitionSet m_setPids;
    private int m_iPrevPid = -1;
    private boolean m_fKeysOnly;
    private boolean m_fByMember;
    private boolean m_fRandom;
    private Iterator m_iterKeys;

    public PartitionedIterator(NamedCache cache, Filter filter, PartitionSet setPids, int nOptions) {
        this.m_cache = cache;
        this.m_filter = new PartitionedFilter(filter, new PartitionSet(setPids.getPartitionCount()));
        this.m_setPids = new PartitionSet(setPids);
        this.m_fKeysOnly = (nOptions & 1) == 0;
        this.m_fByMember = (nOptions & 2) != 0;
        this.m_fRandom = (nOptions & 4) != 0;
    }

    @Override
    protected void advance() {
        Iterator iterKeys = this.m_iterKeys;
        while (iterKeys == null || !iterKeys.hasNext()) {
            PartitionedFilter filter = this.m_filter;
            if (!this.advancePartitionSet(filter.getPartitionSet())) {
                this.m_iterKeys = null;
                return;
            }
            Set set = this.m_fKeysOnly ? this.m_cache.keySet(filter) : this.m_cache.entrySet(filter);
            this.m_iterKeys = iterKeys = set.iterator();
        }
        this.setNext(iterKeys.next());
    }

    @Override
    protected void remove(Object oPrev) {
        this.m_cache.keySet().remove(this.m_fKeysOnly ? oPrev : ((Map.Entry)oPrev).getKey());
    }

    private boolean advancePartitionSet(PartitionSet setPids) {
        int iNextPid;
        PartitionSet setRemain = this.m_setPids;
        int iPrevPid = this.m_iPrevPid;
        int n = iNextPid = this.m_fRandom ? setRemain.rnd() : setRemain.next(iPrevPid + 1);
        if (iNextPid < 0) {
            return false;
        }
        if (this.m_fByMember) {
            setPids.clear();
            setPids.add(setRemain);
            PartitionedService service = (PartitionedService)((Object)this.m_cache.getCacheService());
            Member member = service.getPartitionOwner(iNextPid);
            block2: while (member == null) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WrapperException(e);
                }
                int iPid = setRemain.next(0);
                while (iPid >= 0) {
                    member = service.getPartitionOwner(iPid);
                    if (member != null) {
                        iNextPid = iPrevPid;
                        continue block2;
                    }
                    iPid = setRemain.next(iPid + 1);
                }
            }
            PartitionSet setColocated = service.getOwnedPartitions(member);
            setPids.retain(setColocated);
            setRemain.remove(setPids);
        } else {
            if (iPrevPid >= 0) {
                setPids.remove(iPrevPid);
            }
            setPids.add(iNextPid);
            setRemain.remove(iNextPid);
        }
        this.m_iPrevPid = iNextPid;
        return true;
    }
}

