/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.ssl;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.TcpSocketProvider;
import com.tangosol.net.security.SecurityProvider;
import com.tangosol.net.ssl.SSLServerSocket;
import com.tangosol.net.ssl.SSLServerSocketChannel;
import com.tangosol.net.ssl.SSLSocket;
import com.tangosol.net.ssl.SSLSocketChannel;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.DaemonThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLSocketProvider
extends TcpSocketProvider {
    protected String m_sDescription = "SSLSocketProvider()";
    protected Executor m_executor = DEFAULT_EXECUTOR;
    protected SSLContext m_ctx;
    protected boolean m_fClientAuthRequired;
    protected HostnameVerifier m_hostnameVerifier;
    protected String[] m_asCipherSuitesEnabled;
    public static final String XML_NAME = "ssl";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final String DEFAULT_IDENTITY_ALGORITHM = "SunX509";
    public static final String DEFAULT_TRUST_ALGORITHM = "SunX509";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final Executor DEFAULT_EXECUTOR = Executors.newCachedThreadPool(new DaemonThreadFactory("SSLExecutor-"));

    @Override
    public Socket openSocket() throws IOException {
        return new SSLSocket(this.ensureDelegate().openSocket(), this);
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return new SSLSocketChannel(this.ensureDelegate().openSocketChannel(), this);
    }

    @Override
    public ServerSocket openServerSocket() throws IOException {
        return new SSLServerSocket(this.ensureDelegate().openServerSocket(), this);
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return new SSLServerSocketChannel(this.ensureDelegate().openServerSocketChannel(), this);
    }

    @Override
    public MulticastSocket openMulticastSocket() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatagramChannel openDatagramChannel() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConfig(XmlElement xml) {
        if (this.m_xml != null) {
            throw new IllegalStateException();
        }
        if (xml == null) {
            throw new IllegalArgumentException("Missing configuration");
        }
        if (!xml.getName().equals(XML_NAME)) {
            throw new IllegalArgumentException("Invalid configuration: " + xml);
        }
        super.setConfig(xml);
        StringBuffer sbDesc = new StringBuffer();
        try {
            XmlElement xmlStore;
            Provider provider;
            String sProvider;
            XmlElement xmlProvider;
            Object factory;
            String sAlgorithm;
            SSLContext ctx = null;
            KeyManager[] aKeyManager = null;
            TrustManager[] aTrustManager = null;
            String sProtocol = xml.ensureElement("protocol").getString(DEFAULT_SSL_PROTOCOL);
            XmlElement xmlChild = xml.getElement("provider");
            if (xmlChild != null) {
                String sProvider2 = xmlChild.ensureElement("name").getString(null);
                Provider provider2 = this.instantiateProvider(xmlChild);
                if (provider2 == null) {
                    if (sProvider2 != null) {
                        ctx = SSLContext.getInstance(sProtocol, sProvider2);
                    }
                } else {
                    ctx = SSLContext.getInstance(sProtocol, provider2);
                }
            }
            if (ctx == null) {
                ctx = SSLContext.getInstance(sProtocol);
            }
            this.m_ctx = ctx;
            xmlChild = xml.getElement("executor");
            if (xmlChild != null) {
                this.m_executor = XmlHelper.isInstanceConfigEmpty(xmlChild) ? DEFAULT_EXECUTOR : (Executor)XmlHelper.createInstance(xmlChild, null, null);
            }
            if ((xmlChild = xml.getElement("identity-manager")) == null) {
                sbDesc.append("identity=unspecified");
            } else {
                sbDesc.append("identity=");
                sAlgorithm = xmlChild.ensureElement("algorithm").getString("SunX509");
                sbDesc.append(sAlgorithm);
                factory = null;
                xmlProvider = xmlChild.getElement("provider");
                if (xmlProvider != null) {
                    sProvider = xmlProvider.ensureElement("name").getString(null);
                    provider = this.instantiateProvider(xmlProvider);
                    if (provider == null) {
                        if (sProvider != null) {
                            factory = KeyManagerFactory.getInstance(sAlgorithm, sProvider);
                        }
                    } else {
                        factory = KeyManagerFactory.getInstance(sAlgorithm, provider);
                    }
                }
                if (factory == null) {
                    factory = KeyManagerFactory.getInstance(sAlgorithm);
                }
                xmlStore = xmlChild.ensureElement("key-store");
                String sPassword = xmlChild.ensureElement("password").getString(null);
                char[] achPassword = sPassword == null ? null : sPassword.toCharArray();
                String sURL = xmlStore.ensureElement("url").getString(null);
                KeyStore keyStore = this.loadKeyStore(sURL, xmlStore.ensureElement("password").getString(null), xmlStore.ensureElement("type").getString(DEFAULT_KEYSTORE_TYPE));
                if (sURL != null && sURL.length() > 0) {
                    sbDesc.append('/').append(sURL);
                }
                xmlChild.ensureElement("password").setString(null);
                xmlStore.ensureElement("password").setString(null);
                ((KeyManagerFactory)factory).init(keyStore, achPassword);
                aKeyManager = ((KeyManagerFactory)factory).getKeyManagers();
            }
            xmlChild = xml.getElement("trust-manager");
            if (xmlChild == null || xmlChild.getElementList().isEmpty()) {
                sbDesc.append(", trust=unspecified");
            } else {
                sbDesc.append(", trust=");
                sAlgorithm = xmlChild.ensureElement("algorithm").getString("SunX509");
                sbDesc.append(sAlgorithm);
                factory = null;
                xmlProvider = xmlChild.getElement("provider");
                if (xmlProvider != null) {
                    sProvider = xmlProvider.ensureElement("name").getString(null);
                    provider = this.instantiateProvider(xmlProvider);
                    if (provider == null) {
                        if (sProvider != null) {
                            factory = TrustManagerFactory.getInstance(sAlgorithm, sProvider);
                        }
                    } else {
                        factory = TrustManagerFactory.getInstance(sAlgorithm, provider);
                    }
                }
                if (factory == null) {
                    factory = TrustManagerFactory.getInstance(sAlgorithm);
                }
                xmlStore = xmlChild.ensureElement("key-store");
                String sURL = xmlStore.ensureElement("url").getString(null);
                KeyStore keyStore = this.loadKeyStore(sURL, xmlStore.ensureElement("password").getString(null), xmlStore.ensureElement("type").getString(DEFAULT_KEYSTORE_TYPE));
                if (sURL != null && sURL.length() > 0) {
                    sbDesc.append('/').append(sURL);
                }
                xmlStore.ensureElement("password").setString(null);
                ((TrustManagerFactory)factory).init(keyStore);
                aTrustManager = ((TrustManagerFactory)factory).getTrustManagers();
                this.m_fClientAuthRequired = aTrustManager != null;
            }
            xmlChild = xml.getElement("hostname-verifier");
            if (xmlChild != null) {
                this.m_hostnameVerifier = (HostnameVerifier)XmlHelper.createInstance(xmlChild, null, null);
                sbDesc.append(", hostname-verifier=enabled");
            }
            if ((xmlChild = xml.getElement("cipher-suites")) != null) {
                ArrayList<Object> listCipher = new ArrayList<Object>();
                Iterator iter = xmlChild.getElements("name");
                while (iter.hasNext()) {
                    listCipher.add(((XmlElement)iter.next()).getValue());
                }
                this.m_asCipherSuitesEnabled = listCipher.toArray(new String[listCipher.size()]);
            }
            SecureRandom random = new SecureRandom();
            random.nextInt();
            ctx.init(aKeyManager, aTrustManager, random);
            String sAuth = aKeyManager == null && aTrustManager == null ? "none" : (aKeyManager == null && aTrustManager != null ? "one-way client" : (aKeyManager != null && aTrustManager == null ? "one-way server" : "two-way"));
            this.m_sDescription = sbDesc.insert(0, "SSLSocketProvider(auth=" + sAuth + ", ").append(')').toString();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid configuration: " + xml, e);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected Provider instantiateProvider(XmlElement xml) {
        if (XmlHelper.isInstanceConfigEmpty(xml)) {
            return null;
        }
        return (Provider)XmlHelper.createInstance(xml, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore loadKeyStore(String sURL, String sPassword, String sType) throws GeneralSecurityException, IOException {
        if (sURL == null || sURL.length() == 0) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance(sType);
        char[] achPassword = sPassword == null || sPassword.length() == 0 ? null : sPassword.toCharArray();
        InputStream in = null;
        try {
            in = new URL(sURL).openStream();
            keyStore.load(in, achPassword);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return keyStore;
    }

    protected boolean validateSession(SSLSession session, Socket socket) {
        if (session == null || socket == null) {
            throw new IllegalArgumentException();
        }
        HostnameVerifier verifier = this.m_hostnameVerifier;
        return verifier == null || verifier.verify(socket.getInetAddress().getHostName(), session);
    }

    protected void ensureSessionValidity(SSLSession session, Socket socket) throws SSLException {
        if (!this.validateSession(session, socket)) {
            throw new SSLException("Unacceptible peer: " + socket);
        }
        CacheFactory.log("Established " + session.getCipherSuite() + " connection with " + socket, 7);
    }

    protected SSLEngine openSSLEngine() {
        SSLEngine engine = this.getSSLContext().createSSLEngine();
        String[] asCiphers = this.m_asCipherSuitesEnabled;
        if (asCiphers != null) {
            engine.setEnabledCipherSuites(asCiphers);
        }
        engine.setNeedClientAuth(this.m_fClientAuthRequired);
        return engine;
    }

    @Override
    public String toString() {
        return this.m_sDescription;
    }

    public SSLContext getSSLContext() {
        return this.m_ctx;
    }

    public Executor getExecutor() {
        return this.m_executor;
    }

    static {
        SecurityProvider.ensureRegistration();
    }
}

