/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ExtractorFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public abstract class ComparisonFilter
extends ExtractorFilter {
    protected Object m_oValue;

    public ComparisonFilter() {
    }

    public ComparisonFilter(ValueExtractor extractor, Object oValue) {
        super(extractor);
        this.m_oValue = oValue;
    }

    public ComparisonFilter(String sMethod, Object oValue) {
        super(sMethod);
        this.m_oValue = oValue;
    }

    public Object getValue() {
        return this.m_oValue;
    }

    protected int calculateMatchEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? ComparisonFilter.calculateIteratorEffectiveness(setKeys.size()) : 1;
    }

    protected int calculateRangeEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return ComparisonFilter.calculateIteratorEffectiveness(setKeys.size());
        }
        if (index.isOrdered()) {
            return Math.max(index.getIndexContents().size() / 4, 1);
        }
        return index.getIndexContents().size();
    }

    public static int calculateIteratorEffectiveness(int cKeys) {
        long lCost = (long)EVAL_COST * (long)cKeys;
        return lCost <= Integer.MAX_VALUE ? (int)lCost : Integer.MAX_VALUE;
    }

    public boolean equals(Object o) {
        if (o instanceof ComparisonFilter) {
            ComparisonFilter that = (ComparisonFilter)o;
            return this.getClass() == that.getClass() && ComparisonFilter.equals(this.m_extractor, that.m_extractor) && ComparisonFilter.equals(this.m_oValue, that.m_oValue);
        }
        return false;
    }

    public int hashCode() {
        return ComparisonFilter.hashCode(this.m_extractor) + ComparisonFilter.hashCode(this.m_oValue);
    }

    public String toString() {
        String sClass = this.getClass().getName();
        return sClass.substring(sClass.lastIndexOf(46) + 1) + '(' + this.getValueExtractor() + ", " + this.getValue() + ')';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_oValue = ComparisonFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ComparisonFilter.writeObject(out, this.m_oValue);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_oValue = in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeObject(1, this.m_oValue);
    }
}

