/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueManipulator;
import com.tangosol.util.processor.PropertyProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberIncrementor
extends PropertyProcessor {
    static final Number INTEGER_ZERO = NumberIncrementor.makeInteger(0);
    static final Number LONG_ZERO = NumberIncrementor.makeLong(0L);
    static final Number DOUBLE_ZERO = new Double(0.0);
    static final Number FLOAT_ZERO = new Float(0.0f);
    static final Number BIGDECIMAL_ZERO = new BigDecimal(BigInteger.ZERO);
    static final Number BIGINTEGER_ZERO = BigInteger.ZERO;
    static final Number SHORT_ZERO = new Short(0);
    static final Number BYTE_ZERO = new Byte(0);
    private Number m_numInc;
    private boolean m_fPostInc;

    public NumberIncrementor() {
    }

    public NumberIncrementor(String sName, Number numInc, boolean fPostIncrement) {
        super(sName);
        NumberIncrementor.azzert(numInc != null);
        this.m_numInc = numInc;
        this.m_fPostInc = fPostIncrement;
    }

    public NumberIncrementor(ValueManipulator manipulator, Number numInc, boolean fPostIncrement) {
        super(manipulator);
        NumberIncrementor.azzert(numInc != null);
        this.m_numInc = numInc;
        this.m_fPostInc = fPostIncrement;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        Number numNew;
        if (!entry.isPresent()) {
            return null;
        }
        Number numInc = this.m_numInc;
        if (numInc == null) {
            throw new IllegalArgumentException("Incorrectly constructed NumberIncrementor");
        }
        Number numOld = (Number)this.get(entry);
        if (numOld == null) {
            Number number = numInc instanceof Integer ? (Number)INTEGER_ZERO : (Number)(numInc instanceof Long ? (Number)LONG_ZERO : (Number)(numInc instanceof Double ? (Number)DOUBLE_ZERO : (Number)(numInc instanceof Float ? (Number)FLOAT_ZERO : (Number)(numInc instanceof BigInteger ? (Number)BIGINTEGER_ZERO : (Number)(numInc instanceof BigDecimal ? (Number)BIGDECIMAL_ZERO : (Number)(numInc instanceof Short ? (Number)SHORT_ZERO : (Number)(numOld = numInc instanceof Byte ? BYTE_ZERO : null)))))));
        }
        if (numOld instanceof Integer) {
            numNew = NumberIncrementor.makeInteger(numOld.intValue() + numInc.intValue());
        } else if (numOld instanceof Long) {
            numNew = NumberIncrementor.makeLong(numOld.longValue() + numInc.longValue());
        } else if (numOld instanceof Double) {
            numNew = new Double(numOld.doubleValue() + numInc.doubleValue());
        } else if (numOld instanceof Float) {
            numNew = new Float(numOld.floatValue() + numInc.floatValue());
        } else if (numOld instanceof BigInteger) {
            numNew = ((BigInteger)numOld).add((BigInteger)numInc);
        } else if (numOld instanceof BigDecimal) {
            numNew = ((BigDecimal)numOld).add((BigDecimal)numInc);
        } else if (numOld instanceof Short) {
            numNew = new Short((short)(numOld.shortValue() + numInc.shortValue()));
        } else if (numOld instanceof Byte) {
            numNew = new Byte((byte)(numOld.byteValue() + numInc.byteValue()));
        } else {
            throw new RuntimeException("Unsupported type:" + (numOld == null ? numInc.getClass().getName() : numOld.getClass().getName()));
        }
        this.set(entry, numNew);
        return this.m_fPostInc ? (Number)numOld : (Number)numNew;
    }

    @Override
    protected String getDescription() {
        return (this.m_fPostInc ? ", post" : ", pre") + "-increment=" + this.m_numInc;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_numInc = (Number)ExternalizableHelper.readObject(in);
        this.m_fPostInc = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeObject(out, this.m_numInc);
        out.writeBoolean(this.m_fPostInc);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_numInc = (Number)in.readObject(1);
        this.m_fPostInc = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeObject(1, this.m_numInc);
        out.writeBoolean(2, this.m_fPostInc);
    }
}

