/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Member$SentQueue;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.socket.udpSocket.MulticastUdpSocket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.net.udpPacket.OutgoingUdpPacket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$AckQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ConfirmationQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$MemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$OutgoingMessageArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ResendQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.internal.PacketComparator;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PacketPublisher
extends PacketProcessor {
    private int __m_AckDelay;
    private PacketPublisher$AckQueue __m_AckQueue;
    private transient List __m_AckdPacketListTemp;
    private Set __m_BroadcastAddresses;
    private int __m_CloggedCount;
    private int __m_CloggedDelay;
    private PacketPublisher$ConfirmationQueue __m_ConfirmationQueue;
    private Queue __m_DeferredReadyQueue;
    private boolean __m_HeterogeneousPacketLengths;
    private transient Queue[] __m_IncommingPacketQueues;
    private volatile long __m_LastTrafficJamWarningTimeMillis;
    private transient List __m_LostPacketListTemp;
    private int __m_MaximumPacketLength;
    private PacketPublisher$MemberSet __m_MemberSetTemp;
    private transient MultiBufferWriteBuffer.WriteBufferPool __m_MessageBufferAllocator;
    private WindowedArray __m_MessageOutgoing;
    private transient Message[] __m_MsgArrayTemp;
    private transient long[] __m_MsgIdArrayTemp;
    private boolean __m_MulticastEnabled;
    private double __m_MulticastThreshold;
    private transient long __m_NackDelayMillis;
    private transient boolean __m_NackEnabled;
    private transient Queue __m_PacketAdapterQueue;
    private PacketBufferPool __m_PacketAllocator;
    private int __m_PreferredPacketLength;
    private int __m_ResendDelay;
    private PacketPublisher$ResendQueue __m_ResendQueue;
    private int __m_ResendTimeout;
    private transient OutgoingUdpPacket __m_ReuseableUdpPacket;
    private transient Queue __m_SendQueue;
    private transient SingleMemberSet __m_SingleMemberSetTemp;
    private transient long __m_StatsCpu;
    private transient long __m_StatsNacksSent;
    private transient long __m_StatsResent;
    private transient long __m_StatsResentEarly;
    private transient long __m_StatsResentExcess;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private MulticastUdpSocket __m_UdpSocketMulticast;
    private UnicastUdpSocket __m_UdpSocketUnicast;

    public PacketPublisher() {
        this(null, null, true);
    }

    public PacketPublisher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAckdPacketListTemp(new RecyclingLinkedList());
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLostPacketListTemp(new RecyclingLinkedList());
            this.setMulticastEnabled(true);
            this.setMulticastThreshold(0.25);
            this.setSingleMemberSetTemp(new SingleMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new PacketPublisher$AckQueue("AckQueue", this, true), "AckQueue");
        this._addChild(new PacketPublisher$ConfirmationQueue("ConfirmationQueue", this, true), "ConfirmationQueue");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new PacketPublisher$InQueue("InQueue", this, true), "InQueue");
        this._addChild(new PacketPublisher$MemberSet("MemberSet", this, true), "MemberSet");
        this._addChild(new PacketPublisher$OutgoingMessageArray("OutgoingMessageArray", this, true), "OutgoingMessageArray");
        this._addChild(new PacketPublisher$ResendQueue("ResendQueue", this, true), "ResendQueue");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addressBroadcastPacket(OutgoingUdpPacket packet, InetSocketAddress address) {
        packet.setUdpSocket(this.getUdpSocketUnicast());
        if (address == null) {
            Iterator iter;
            MasterMemberSet setMembers = this.getMemberSet();
            ActualMemberSet setRecycle = setMembers.getRecycleSet();
            Set setBroadcast = this.getBroadcastAddresses();
            int cAddresses = setBroadcast.size() + setRecycle.size();
            int cSent = 0;
            packet.ensureAddressCapacity(cAddresses);
            Set set = setBroadcast;
            synchronized (set) {
                iter = setBroadcast.iterator();
                while (!iter.hasNext() ? false : cSent < cAddresses) {
                    packet.addAddress((InetSocketAddress)iter.next());
                    ++cSent;
                }
            }
            set = setMembers;
            synchronized (set) {
                iter = setRecycle.iterator();
                while (!iter.hasNext() ? false : cSent < cAddresses) {
                    packet.addAddress(((Member)iter.next()).getSocketAddress());
                    ++cSent;
                }
            }
        }
        packet.addAddress(address);
    }

    protected void addressMulticastPacket(OutgoingUdpPacket packet) {
        MulticastUdpSocket socket = this.getUdpSocketMulticast();
        packet.setUdpSocket(socket);
        packet.addAddress(socket.getAddress());
    }

    protected void addressMultipointPacket(Packet packetData, OutgoingUdpPacket packet, PacketPublisher$MemberSet setTo) {
        int[] anToId = setTo.toIdArray();
        int cAddrs = anToId.length;
        packet.setUdpSocket(this.getUdpSocketUnicast());
        packet.ensureAddressCapacity(cAddrs);
        int i = 0;
        while (i < cAddrs) {
            Member member = this.getMember(anToId[i]);
            if (member != null) {
                packet.addAddress(this.getSocketAddress(member, packetData));
            }
            ++i;
        }
    }

    public void assignMessageIds(Message msg) {
        MessagePacket packetFirst = msg.getPacket(0);
        if (packetFirst instanceof Directed) {
            Directed packetHead = (Directed)packetFirst;
            DependentMemberSet setTo = packetHead.getToMemberSet();
            if (setTo == null) {
                Member memberTo = this.getMember(packetHead.getToId());
                if (memberTo != null) {
                    packetHead.setToMessageId(memberTo.getNextDestinationMessageId());
                }
            } else {
                Object[] aMember = setTo.toArray();
                int i = aMember.length - 1;
                while (i >= 0) {
                    Member memberTo = (Member)aMember[i];
                    setTo.setDestinationMessageId(memberTo.getId(), memberTo.getNextDestinationMessageId());
                    --i;
                }
            }
            long lFromMsgId = this.getMessageOutgoing().add(msg);
            long lSetId = msg.getFromMessageId();
            if (lSetId != lFromMsgId) {
                throw new IllegalStateException(String.valueOf("Set MsgFromId ") + lSetId + " != expected " + lFromMsgId);
            }
            int i = 0;
            int c = msg.getMessagePartCount();
            while (i < c) {
                msg.getPacket(i).setFromMessageId(lFromMsgId);
                ++i;
            }
        } else {
            WindowedArray wa = this.getMessageOutgoing();
            wa.remove(wa.add(msg));
        }
    }

    protected int computePreferredPacketLength(MemberSet setTo) {
        int cbPref;
        block6: {
            int cTo;
            block7: {
                cbPref = this.getPreferredPacketLength();
                if (!this.isHeterogeneousPacketLengths()) break block6;
                cTo = setTo == null ? 0 : setTo.size();
                if (!(cTo == 1)) break block7;
                Member memberTo = this.getMemberSet().getMember(setTo.getFirstId());
                if (!(memberTo != null)) break block6;
                cbPref = Math.min(cbPref, memberTo.getPreferredPacketLength());
                break block6;
            }
            if (!(cTo == 0)) {
                if (setTo instanceof ActualMemberSet) {
                    Iterator iter = setTo.iterator();
                    while (iter.hasNext()) {
                        cbPref = Math.min(cbPref, ((Member)iter.next()).getPreferredPacketLength());
                    }
                } else {
                    MasterMemberSet setCluster = this.getMemberSet();
                    int[] anToId = setTo.toIdArray();
                    int i = 0;
                    int c = anToId.length;
                    while (i < c) {
                        Member memberTo = ((MemberSet)setCluster).getMember(anToId[i]);
                        if (memberTo != null) {
                            cbPref = Math.min(cbPref, memberTo.getPreferredPacketLength());
                        }
                        ++i;
                    }
                }
            }
        }
        return cbPref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deferPacket(Member member, MessagePacket packet) {
        boolean fResult = false;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            if (packet.getDeliveryState() == MessagePacket.DELIVERY_CONFIRMED) {
                return false;
            }
            int cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold();
            int cOutstanding = flowControl.getOutstandingPacketCount();
            boolean fOverLimit = cOutstanding > cThreshold;
            boolean fDeferring = flowControl.isDeferring();
            int nState = packet.getDeliveryState();
            if (nState == MessagePacket.DELIVERY_CONFIRMED) {
                fResult = false;
            } else if (fOverLimit) {
                Member$FlowControl member$FlowControl = flowControl;
                synchronized (member$FlowControl) {
                    flowControl.getDeferredQueue().add(packet);
                }
                packet.setDeliveryState(MessagePacket.DELIVERY_DEFERRED, member);
                fResult = true;
            } else if (!fDeferring ? false : nState != MessagePacket.DELIVERY_DEFERRED) {
                Member$FlowControl member$FlowControl = flowControl;
                synchronized (member$FlowControl) {
                    Queue deferredQueue = flowControl.getDeferredQueue();
                    if (deferredQueue.isEmpty()) {
                        this.getDeferredReadyQueue().add(packet);
                    } else {
                        deferredQueue.add(packet);
                    }
                }
                packet.setDeliveryState(MessagePacket.DELIVERY_DEFERRED, member);
                fResult = true;
            }
        }
        return fResult;
    }

    protected void doEarlyLossDetection(Member member, MessagePacket packetNewestTo, PacketIdentifier ptidNewestFrom) {
        MessagePacket packet;
        if (PacketComparator.compare(ptidNewestFrom, member.getContiguousFromPacketId()) > 0) {
            this.scheduleNack(member);
        }
        Member$SentQueue queueRecent = member.getRecentPacketQueue();
        int nMemberId = member.getId();
        if (packetNewestTo == null) {
            MessagePacket packet2;
            do {
                if (!((packet2 = (MessagePacket)((Queue)queueRecent).peekNoWait()) == null ? true : packet2.isAddressedTo(nMemberId))) continue;
                return;
            } while (!(packet2 != ((Queue)queueRecent).removeNoWait()));
            throw new IllegalStateException();
        }
        PacketIdentifier ptidContTo = member.getContiguousToPacketId();
        long ldtNow = Base.getSafeTimeMillis();
        List listLost = this.getLostPacketListTemp();
        List listAckd = this.getAckdPacketListTemp();
        boolean fAdded = false;
        do {
            if ((packet = (MessagePacket)((Queue)queueRecent).removeNoWait()) == null) {
                fAdded = false;
                break;
            }
            if (!(!packet.isAddressedTo(nMemberId) ? false : packet.getResendScheduled() > ldtNow)) continue;
            if (PacketComparator.compare(ptidContTo, packet) >= 0) {
                if (!packet.registerAck(member)) continue;
                listAckd.add(packet);
                continue;
            }
            listLost.add(packet);
            fAdded = true;
        } while (packet != packetNewestTo);
        if (listAckd.isEmpty() ^ true) {
            this.onAcknowledgedPacket(member, listAckd);
        }
        if (fAdded) {
            this.getResendQueue().addAllHead(listLost, true);
        }
    }

    public void drainDeferredPackets(Member member) {
        int cThreshold;
        int cSpots;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (cSpots = (cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold()) - flowControl.getOutstandingPacketCount()) > 0) {
            Packet packet;
            Queue queueDeferred = flowControl.getDeferredQueue();
            Queue queueReady = this.getDeferredReadyQueue();
            while (!((packet = (Packet)queueDeferred.removeNoWait()) == null)) {
                queueReady.add(packet);
                if (packet.getToId() != 0) {
                    --cSpots;
                }
                if (cSpots > 0) continue;
            }
        }
    }

    public void drainOverflow(Message msg) {
        int cMaxPackets = this.getCloggedCount();
        MemberSet setMember = msg.getToMemberSet();
        if (((Thread.currentThread().getThreadGroup() == this.getThreadGroup() ? true : cMaxPackets <= 0) ? true : msg == null) ? true : setMember == null) {
            return;
        }
        Member member = this.getMember(setMember.getFirstId());
        if (!(!(!Member$FlowControl.isEnabled() ? false : setMember.size() == 1) ? false : member != null) ? false : member != this.getThisMember()) {
            long cPackets = this.getResendQueue().getMultipointPacketCount() + this.getDeferredReadyQueue().size();
            Member$FlowControl flowControl = member.getFlowControl();
            if (flowControl != null) {
                cPackets += (long)flowControl.getPendingPacketCount();
            }
            if (cPackets < (long)cMaxPackets) {
                return;
            }
        }
        this.drainOverflowComplex(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drainOverflowComplex(Message msg) {
        int cMaxPackets = this.getCloggedCount();
        Queue queueIn = this.getPacketAdapterQueue();
        Queue queueReady = this.getDeferredReadyQueue();
        PacketPublisher$ResendQueue queueResend = this.getResendQueue();
        boolean fFlowcontrol = Member$FlowControl.isEnabled();
        Member memberThis = this.getThisMember();
        MemberSet setMembers = msg.getToMemberSet();
        int[] anToId = null;
        long ldtNow = 0L;
        long ldtStart = 0L;
        long ldtAlarmNext = 0L;
        long ldtTimeout = 0L;
        int cIters = 0;
        while (this.isStarted()) {
            block20: {
                Member memberJammed;
                int cPacketsPending;
                int cPacketsMp;
                int cPacketsReady;
                int cPacketsResend;
                int cPacketsIn;
                int cPackets;
                block16: {
                    block17: {
                        block18: {
                            Member$FlowControl flowControl;
                            Member member;
                            block19: {
                                cPacketsIn = cPackets = queueIn.size();
                                cPacketsResend = -1;
                                cPacketsReady = -1;
                                cPacketsMp = -1;
                                cPacketsPending = -1;
                                memberJammed = null;
                                if (!fFlowcontrol) break block17;
                                cPacketsMp = queueResend.getMultipointPacketCount();
                                cPackets += cPacketsMp;
                                cPacketsReady = queueReady.size();
                                cPackets += cPacketsReady;
                                if (setMembers == null) return;
                                boolean bl = false;
                                if (bl) {
                                    return;
                                }
                                if (!(setMembers.size() == 1)) break block18;
                                member = this.getMember(setMembers.getFirstId());
                                if (!(member == memberThis)) break block19;
                                setMembers = this.getMemberSet();
                                if (!(setMembers.size() > 1)) break block16;
                                --cIters;
                                break block20;
                            }
                            if (member != null && (flowControl = member.getFlowControl()) != null) {
                                memberJammed = member;
                                cPacketsPending = flowControl.getPendingPacketCount();
                                cPackets += cPacketsPending;
                            }
                            break block16;
                        }
                        if (anToId == null) {
                            PacketPublisher$MemberSet setTo = new PacketPublisher$MemberSet();
                            setTo.addAll((Collection)setMembers);
                            anToId = setTo.toIdArray();
                        }
                        int i = 0;
                        int c = anToId.length;
                        while (i < c) {
                            int cPending;
                            Member$FlowControl flowControl;
                            Member member = this.getMember(anToId[i]);
                            if (member != null && (flowControl = member.getFlowControl()) != null && cPackets + (cPending = flowControl.getPendingPacketCount()) > cMaxPackets) {
                                memberJammed = member;
                                cPacketsPending = cPending;
                                cPackets += cPacketsPending;
                                break block16;
                            }
                            ++i;
                        }
                        break block16;
                    }
                    cPacketsResend = queueResend.size();
                    cPackets += cPacketsResend;
                }
                if (!(cPackets > cMaxPackets) ? false : ldtNow <= ldtTimeout) {
                    if (ldtNow > ldtAlarmNext) {
                        if (ldtStart == 0L) {
                            ldtStart = ldtNow = Base.getSafeTimeMillis();
                            ldtTimeout = msg.getService().calculateDeferrableMillis(msg);
                            if (ldtTimeout == 0L) {
                                ldtTimeout = Long.MAX_VALUE;
                            }
                        } else {
                            Component._trace(String.valueOf("Overloaded packet queue; ") + cPackets + "/" + cMaxPackets + " packet limit" + ", Duration=" + (ldtNow - ldtStart) / (long)1000 + "s" + ", InQueue=" + cPacketsIn + ", ResendQueue=" + cPacketsResend + ", MultiPoint=" + cPacketsMp + ", Pending=" + cPacketsPending + ", Ready=" + cPacketsReady + ", " + memberJammed + ", FlowControl(" + (memberJammed == null ? null : memberJammed.getFlowControl()) + ")", 2);
                        }
                        ldtAlarmNext = ldtNow + (long)(this.getResendTimeout() / 4);
                    }
                    this.getQueue().flush();
                    if (!Daemon.sleep(this.getCloggedDelay())) return;
                    setMembers = msg.getToMemberSet();
                    ldtNow = Base.getSafeTimeMillis();
                } else {
                    if (cPackets != 0) {
                        return;
                    }
                    boolean bl = true;
                    if (!bl) {
                        return;
                    }
                    if (cIters <= 1) {
                        return;
                    }
                    boolean bl2 = true;
                    if (!bl2) return;
                    ldtNow = System.currentTimeMillis();
                    if (ldtNow <= this.getLastTrafficJamWarningTimeMillis() + 60000L) {
                        return;
                    }
                    boolean bl3 = true;
                    if (!bl3) return;
                    Component._trace(String.valueOf("The \"traffic-jam\" settings may be overly cautious; consider ") + "increasing the \"maximum-packets\", or decreasing " + "\"pause-milliseconds\"", 5);
                    this.setLastTrafficJamWarningTimeMillis(ldtNow);
                    return;
                }
            }
            ++cIters;
        }
    }

    protected Message[] ensureMsgArrayTemp(int cMinSize) {
        Message[] aMsgTemp = this.getMsgArrayTemp();
        if (aMsgTemp == null ? true : aMsgTemp.length < cMinSize) {
            aMsgTemp = new Message[cMinSize];
            this.setMsgArrayTemp(aMsgTemp);
        }
        return aMsgTemp;
    }

    protected long[] ensureMsgIdArrayTemp(int cMinSize) {
        long[] alTemp = this.getMsgIdArrayTemp();
        if (alTemp == null ? true : alTemp.length < cMinSize) {
            alTemp = new long[cMinSize];
            this.setMsgIdArrayTemp(alTemp);
        }
        return alTemp;
    }

    protected MemberSet ensureSingleMemberSetTemp(Member member) {
        SingleMemberSet setMember = this.getSingleMemberSetTemp();
        setMember.setTheMember(member);
        return setMember;
    }

    public void flushSend() {
        this.getSendQueue().flush();
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cMillis = Base.getSafeTimeMillis() - this.getStartTimestamp();
        long lSent = this.getStatsSent();
        long lResent = this.getStatsResent();
        double dCpu = cMillis == 0L ? 0.0 : (double)cCpu / (double)cMillis;
        double dThru = cCpu == 0L ? 0.0 : (double)lSent * (double)1000 / (double)cCpu;
        double dSuccess = lSent == 0L ? 1.0 : 1.0 - (double)lResent / (double)lSent;
        dCpu = (double)((int)(dCpu * 1000.0)) / 10.0;
        dSuccess = (double)((int)(dSuccess * 10000.0)) / 10000.0;
        return String.valueOf("Cpu=") + cCpu + "ms (" + dCpu + "%)" + ", PacketsSent=" + lSent + ", PacketsResent=" + lResent + ", SuccessRate=" + dSuccess + ", Throughput=" + (int)dThru + "pkt/sec";
    }

    public int getAckDelay() {
        return this.getAckQueue().getDelayMillis();
    }

    public PacketPublisher$AckQueue getAckQueue() {
        return this.__m_AckQueue;
    }

    protected List getAckdPacketListTemp() {
        List list = this.__m_AckdPacketListTemp;
        list.clear();
        return list;
    }

    public Set getBroadcastAddresses() {
        return this.__m_BroadcastAddresses;
    }

    public ByteArrayWriteBuffer.Allocator getBufferAllocator(int cb) {
        return null;
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public int getCloggedDelay() {
        return this.__m_CloggedDelay;
    }

    public PacketPublisher$ConfirmationQueue getConfirmationQueue() {
        return this.__m_ConfirmationQueue;
    }

    public Queue getDeferredReadyQueue() {
        return this.__m_DeferredReadyQueue;
    }

    protected Queue[] getIncommingPacketQueues() {
        return this.__m_IncommingPacketQueues;
    }

    public long getLastTrafficJamWarningTimeMillis() {
        return this.__m_LastTrafficJamWarningTimeMillis;
    }

    protected List getLostPacketListTemp() {
        List list = this.__m_LostPacketListTemp;
        list.clear();
        return list;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public PacketPublisher$MemberSet getMemberSetTemp() {
        PacketPublisher$MemberSet set = this.__m_MemberSetTemp;
        if (set == null) {
            set = (PacketPublisher$MemberSet)this._findChild("MemberSet");
            this.setMemberSetTemp(set);
        } else {
            set.clear();
        }
        return set;
    }

    public MultiBufferWriteBuffer.WriteBufferPool getMessageBufferAllocator() {
        return this.__m_MessageBufferAllocator;
    }

    public WindowedArray getMessageOutgoing() {
        return this.__m_MessageOutgoing;
    }

    public Message[] getMsgArrayTemp() {
        return this.__m_MsgArrayTemp;
    }

    public long[] getMsgIdArrayTemp() {
        return this.__m_MsgIdArrayTemp;
    }

    public double getMulticastThreshold() {
        return this.__m_MulticastThreshold;
    }

    public long getNackDelayMillis() {
        return this.__m_NackDelayMillis;
    }

    public Queue getPacketAdapterQueue() {
        return this.__m_PacketAdapterQueue;
    }

    public PacketBufferPool getPacketAllocator() {
        return this.__m_PacketAllocator;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public int getResendDelay() {
        return this.getResendQueue().getResendMillis();
    }

    public PacketPublisher$ResendQueue getResendQueue() {
        return this.__m_ResendQueue;
    }

    public int getResendTimeout() {
        return this.getResendQueue().getTimeoutMillis();
    }

    protected OutgoingUdpPacket getReuseableUdpPacket() {
        return this.__m_ReuseableUdpPacket;
    }

    public Queue getSendQueue() {
        return this.__m_SendQueue;
    }

    protected SingleMemberSet getSingleMemberSetTemp() {
        return this.__m_SingleMemberSetTemp;
    }

    protected SocketAddress getSocketAddress(Member member, Packet packetData) {
        switch (packetData.getPacketType()) {
            case 0xDDF00D0: 
            case 232718545: {
                return member.getPreferredSocketAddress();
            }
            case 232718547: 
            case 232718548: 
            case 232718549: {
                if (packetData.getSentCount() < member.getTxDebugDropCount()) {
                    return null;
                }
            }
            case 232718546: 
            case 232718551: 
            case 232718552: 
            case 232718553: {
                return ((MessagePacket)packetData).getLength() <= member.getPreferredPacketLength() ? member.getPreferredSocketAddress() : member.getSocketAddress();
            }
        }
        throw new IllegalStateException();
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsNacksSent() {
        return this.__m_StatsNacksSent;
    }

    public long getStatsResent() {
        return this.__m_StatsResent;
    }

    public long getStatsResentEarly() {
        return this.__m_StatsResentEarly;
    }

    public long getStatsResentExcess() {
        return this.__m_StatsResentExcess;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public MulticastUdpSocket getUdpSocketMulticast() {
        return this.__m_UdpSocketMulticast;
    }

    public UnicastUdpSocket getUdpSocketUnicast() {
        return this.__m_UdpSocketUnicast;
    }

    public long getWaitMillis() {
        long lWaitResend = this.getResendQueue().getWaitMillis();
        long lWaitAck = this.getAckQueue().getWaitMillis();
        if (!(lWaitResend == 0L) ? false : lWaitAck == 0L) {
            return 0L;
        }
        if (lWaitResend == 0L) {
            lWaitResend = 60000L;
        }
        if (lWaitAck == 0L) {
            lWaitAck = 60000L;
        }
        return Math.min(lWaitResend, lWaitAck);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PacketPublisher();
    }

    private final Component get_Module() {
        return this;
    }

    protected void halt() {
        this.setUdpSocketMulticast(null);
        this.setUdpSocketUnicast(null);
        super.halt();
    }

    protected Queue instantiateQueue() {
        return (Queue)this._findChild("InQueue");
    }

    public boolean isHeterogeneousPacketLengths() {
        return this.__m_HeterogeneousPacketLengths;
    }

    protected boolean isMulticast(Packet packet, MemberSet setTo) {
        int cToMembers = setTo.size();
        if (cToMembers <= 1) {
            return false;
        }
        int cOtherMembers = this.getMemberSet().size() - 1;
        double dflMulticastThreshold = this.getMulticastThreshold();
        return cToMembers > (int)(dflMulticastThreshold * (double)cOtherMembers);
    }

    public boolean isMulticastEnabled() {
        return this.__m_MulticastEnabled;
    }

    public boolean isNackEnabled() {
        return this.__m_NackEnabled;
    }

    public boolean isNotification() {
        Queue queueIn = this.getPacketAdapterQueue();
        PacketPublisher$ConfirmationQueue queueConfirmation = this.getConfirmationQueue();
        Queue queueDeferredReady = this.getDeferredReadyQueue();
        return (queueIn.isEmpty() ^ true ? true : ((Queue)queueConfirmation).isEmpty() ^ true) ? true : (!(queueDeferredReady != null) ? false : queueDeferredReady.isEmpty() ^ true);
    }

    protected void onAcknowledgedPacket(Member member, Collection collAcknowledged) {
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            int cNewAcks = 0;
            Iterator iter = collAcknowledged.iterator();
            while (iter.hasNext()) {
                MessagePacket packet = (MessagePacket)iter.next();
                if (!packet.isDeferrable()) continue;
                ++cNewAcks;
                packet.setDeliveryState(MessagePacket.DELIVERY_CONFIRMED, member);
            }
            int cSeqAcks = flowControl.getSequentialConfirmedCount();
            int cSeqLost = flowControl.getSequentialLostCount();
            if (cSeqLost > 0) {
                flowControl.setPaused(false);
                flowControl.setSequentialLostCount(0);
                flowControl.setSequentialConfirmedCount(cNewAcks);
            } else {
                flowControl.setSequentialConfirmedCount(cSeqAcks + cNewAcks);
            }
            if (flowControl.isAdjustable()) {
                int cThreshold = flowControl.getOutstandingPacketThreshold();
                int cEffectiveAcks = cSeqLost == 0 ? cSeqAcks : cSeqAcks / cSeqLost;
                int iGoalDelta = cEffectiveAcks - Member$FlowControl.getSuccessGoal();
                boolean fNearCap = flowControl.getOutstandingPacketHighMark() > cThreshold - (cThreshold >>> 2);
                if (!(iGoalDelta < 0) ? false : cSeqLost > 0) {
                    cThreshold -= Math.max(1, cThreshold / Member$FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                } else if (!(iGoalDelta > 0) ? false : fNearCap) {
                    flowControl.setOutstandingPacketHighMark(flowControl.getOutstandingPacketCount());
                    cThreshold += Math.max(1, cThreshold / Member$FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                }
            }
            this.drainDeferredPackets(member);
        }
    }

    protected void onConfirmation(Ack packetAck) {
        Member memberThis;
        Object[] aMsgAck;
        long[] alMsgId;
        int nFromId = packetAck.getFromId();
        Member member = this.getMember(nFromId);
        if (member == null) {
            return;
        }
        WindowedArray waMsg = this.getMessageOutgoing();
        long lMsgFirst = waMsg.getFirstIndex();
        long lMsgId = 0L;
        int cUniqueMsgs = 0;
        try {
            int cNotify = packetAck.getNotifyCount();
            alMsgId = this.ensureMsgIdArrayTemp(cNotify + 1);
            int iNotify = 0;
            int iLastTrint = -1;
            while (iNotify < cNotify) {
                int iMsgIdTrint = packetAck.getMessageId(iNotify);
                if (iMsgIdTrint != iLastTrint) {
                    lMsgId = Packet.translateTrint(iMsgIdTrint, lMsgFirst);
                    iLastTrint = iMsgIdTrint;
                    alMsgId[cUniqueMsgs++] = lMsgId;
                }
                ++iNotify;
            }
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Exception while translating Trints from Ack ") + packetAck + " front of outgoing message array is " + waMsg.get(lMsgFirst) + " array window size is " + waMsg.getWindowSize(), 1);
            throw Base.ensureRuntimeException(e);
        }
        boolean fUseNacks = this.isNackEnabled();
        PacketIdentifier ptidNewestTo = packetAck.getNewestFromPacketId(lMsgFirst);
        MessagePacket packetNewestTo = null;
        if (!fUseNacks ? false : ptidNewestTo != null) {
            long lNewestMsgId = ptidNewestTo.getFromMessageId();
            if (lNewestMsgId != lMsgId) {
                alMsgId[cUniqueMsgs++] = lNewestMsgId;
            }
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
            Object msgNewest = aMsgAck[cUniqueMsgs - 1];
            int iPacket = ptidNewestTo.getMessagePartIndex();
            if ((!(msgNewest != null) ? false : iPacket < ((Message)msgNewest).getMessagePartCount()) && (!((packetNewestTo = ((Message)msgNewest).getPacket(iPacket)) != null) ? false : packetNewestTo.isAddressedTo(nFromId) ^ true)) {
                packetNewestTo = null;
            }
        } else {
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
        }
        MessagePacket packetLast = this.registerAcks(packetAck, member, (Message[])aMsgAck);
        PacketIdentifier ptidCont = packetAck.getContiguousFromPacketId(lMsgFirst);
        if (PacketComparator.compare(ptidCont, member.getContiguousToPacketId()) > 0) {
            member.setContiguousToPacketId(ptidCont);
        }
        PacketIdentifier ptidNewestFrom = packetAck.getNewestToPacketId(member.getLastIncomingMessageId());
        member.setNewestFromPacketId(ptidNewestFrom);
        if (fUseNacks) {
            this.doEarlyLossDetection(member, (packetNewestTo == null ? true : packetNewestTo.isOutgoingMultipoint()) ? packetLast : packetNewestTo, ptidNewestFrom);
        }
        if ((memberThis = this.getThisMember()) != null) {
            long lRecvTime = packetAck.getReceivedMillis();
            memberThis.setLastIncomingMillis(lRecvTime);
            if (member != memberThis) {
                member.setLastIncomingMillis(lRecvTime);
            }
        }
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    public void onException(Throwable e) {
        super.onException(e);
    }

    public void onInit() {
        this.setMessageOutgoing((PacketPublisher$OutgoingMessageArray)this._findChild("OutgoingMessageArray"));
        this.setAckQueue((PacketPublisher$AckQueue)this._findChild("AckQueue"));
        this.setResendQueue((PacketPublisher$ResendQueue)this._findChild("ResendQueue"));
        this.setConfirmationQueue((PacketPublisher$ConfirmationQueue)this._findChild("ConfirmationQueue"));
        super.onInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMemberLeft(Member member) {
        Queue queueReady;
        Queue queueDeferred;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (queueDeferred = flowControl.getDeferredQueue()) != (queueReady = this.getDeferredReadyQueue())) {
            Member$FlowControl member$FlowControl = flowControl;
            synchronized (member$FlowControl) {
                flowControl.setDeferredQueue(this.getDeferredReadyQueue());
            }
            Object o = queueDeferred.removeNoWait();
            while (o != null) {
                queueReady.add(o);
                o = queueDeferred.removeNoWait();
            }
        }
    }

    protected void onNoRecipientPacket(Packet packet) {
        if (packet.isConfirmationRequired()) {
            ((MessagePacket)packet).clearRecipients();
            this.getResendQueue().addHead(packet);
        }
    }

    protected void onNotify() {
        try {
            long lStartTime = System.currentTimeMillis();
            Queue[] aQueue = this.getIncommingPacketQueues();
            Queue queueReady = this.getDeferredReadyQueue();
            PacketPublisher$ConfirmationQueue queueConfirm = this.getConfirmationQueue();
            Queue queueIn = this.getPacketAdapterQueue();
            int cQueues = aQueue.length;
            int cPacketsStart = queueIn.size();
            int cSentPackets = 0;
            int cResentPackets = 0;
            int cEarlyPackets = 0;
            while (true) {
                Ack ack;
                if (!((ack = (Ack)((Queue)queueConfirm).removeNoWait()) == null)) {
                    this.onConfirmation(ack);
                    continue;
                }
                boolean fMore = false;
                int iQueue = 0;
                int cDeferred = 0;
                while (iQueue < cQueues) {
                    Queue queue = aQueue[iQueue];
                    Packet packet = (Packet)queue.removeNoWait();
                    if (packet != null) {
                        boolean fResend = packet.getSentMillis() != 0L;
                        int cSent = this.onPacket(packet);
                        fMore = true;
                        cSentPackets += cSent;
                        if (fResend) {
                            cResentPackets += cSent;
                            if (((MessagePacket)packet).getPendingResendSkips() > 0) {
                                cEarlyPackets += cSent;
                            }
                        }
                        if (queue == queueReady) {
                            if (cDeferred-- > 0) {
                                continue;
                            }
                        } else if (!(cSent == 0) ? false : packet.isDeferrable()) {
                            ++cDeferred;
                        }
                    }
                    ++iQueue;
                }
                if (!(!fMore ? false : cSentPackets < 30000)) break;
            }
            if (cSentPackets > 0 ? true : cResentPackets > 0) {
                ((PacketSpeaker$BundlingQueue)this.getSendQueue()).tuneVolumeThreshold(queueIn.size() - cPacketsStart);
                this.setStatsSent(this.getStatsSent() + (long)cSentPackets);
                this.setStatsResent(this.getStatsResent() + (long)cResentPackets);
                this.setStatsResentEarly(this.getStatsResentEarly() + (long)cEarlyPackets);
                this.setStatsCpu(this.getStatsCpu() + System.currentTimeMillis() - lStartTime);
            }
        }
        catch (Exception e) {
            if (this.isExiting()) {
                return;
            }
            throw Base.ensureRuntimeException(e);
        }
    }

    protected int onPacket(Packet packetData) {
        if (!(packetData.getSentMillis() > 0L) ? false : this.verifyResendNecessary((MessagePacket)packetData) ^ true) {
            this.onNoRecipientPacket(packetData);
            return 0;
        }
        Member memberSingle = this.getMember(packetData.getToId());
        if (!(!(memberSingle != null) ? false : packetData.isDeferrable()) ? false : this.deferPacket(memberSingle, (MessagePacket)packetData)) {
            return 0;
        }
        PacketBufferPool pool = this.getPacketAllocator();
        OutgoingUdpPacket packet = this.getReuseableUdpPacket();
        MemberSet setTo = null;
        int cAddresses = 0;
        try {
            try {
                WriteBuffer packetBuffer;
                if (packet == null) {
                    packet = new OutgoingUdpPacket();
                    packetBuffer = pool.allocate(0);
                    packet.setWriteBuffer(packetBuffer);
                } else {
                    packet.reset();
                    packetBuffer = packet.getWriteBuffer();
                }
                if (memberSingle == null) {
                    boolean fMulticast;
                    setTo = this.getMemberSetTemp();
                    if (packetData.isOutgoingMultipoint()) {
                        setTo.addAll((Collection)((MessagePacket)packetData).getToMemberSet());
                    }
                    boolean fBroadcast = packetData.isOutgoingBroadcast();
                    boolean bl = !this.isMulticastEnabled() ? false : (fBroadcast ? ((Broadcast)packetData).getToAddress() == null : (fMulticast = this.isMulticast(packetData, setTo)));
                    if (fMulticast) {
                        this.addressMulticastPacket(packet);
                    } else if (fBroadcast) {
                        this.addressBroadcastPacket(packet, ((Broadcast)packetData).getToAddress());
                    } else {
                        this.addressMultipointPacket(packetData, packet, (PacketPublisher$MemberSet)setTo);
                    }
                    cAddresses = packet.getAddressCount();
                    if (cAddresses == 0) {
                        this.onNoRecipientPacket(packetData);
                        int n = 0;
                        Object var11_15 = null;
                        this.setReuseableUdpPacket(packet);
                        return n;
                    }
                    if (((MessagePacket)packetData).getLength() > packetBuffer.getCapacity()) {
                        packetBuffer = pool.reallocate(packetBuffer, this.getMaximumPacketLength());
                        packet.setWriteBuffer(packetBuffer);
                    }
                    int cbPref = this.getPreferredPacketLength();
                    if (!(fBroadcast ^ true) ? false : this.isHeterogeneousPacketLengths()) {
                        int[] anId = setTo.toIdArray();
                        int i = 0;
                        int c = anId.length;
                        while (i < c) {
                            Member member = this.getMember(anId[i]);
                            if (member != null) {
                                cbPref = Math.min(cbPref, member.getPreferredPacketLength());
                            }
                            ++i;
                        }
                    }
                    packet.setMaximumBundleLength(cbPref);
                } else {
                    setTo = this.ensureSingleMemberSetTemp(memberSingle);
                    packet.setUdpSocket(this.getUdpSocketUnicast());
                    packet.addAddress(this.getSocketAddress(memberSingle, packetData));
                    packet.setMaximumBundleLength(Math.min(this.getPreferredPacketLength(), memberSingle.getPreferredPacketLength()));
                    cAddresses = 1;
                }
                packetData.write(packet.getWriteBuffer().getBufferOutput(), setTo);
                this.onSendPacket(packetData);
                if (this.getSendQueue().add(packet)) {
                    packet = null;
                }
            }
            catch (IOException e) {
                throw new WrapperException(e);
            }
        }
        catch (Throwable e) {
            Object var11_17 = null;
            this.setReuseableUdpPacket(packet);
            throw e;
        }
        Object var11_16 = null;
        this.setReuseableUdpPacket(packet);
        long cMillis = Base.getSafeTimeMillis();
        packetData.setSentMillis(cMillis);
        packetData.setSentCount(packetData.getSentCount() + 1);
        if (packetData.isConfirmationRequired()) {
            if (memberSingle == null) {
                ((PacketPublisher$MemberSet)setTo).updateStats(cMillis);
            } else {
                memberSingle.setLastOutgoingMillis(cMillis);
            }
            this.getResendQueue().add(packetData);
        } else if (packetData.getPacketType() == Packet.TYPE_BROADCAST) {
            ((Broadcast)packetData).getBufferController().dispose();
        }
        return cAddresses;
    }

    protected void onSendPacket(Member member, Packet packet) {
        MessagePacket msgPacket;
        Member$FlowControl flowControl = member.getFlowControl();
        if ((!(flowControl != null) ? false : packet.isDeferrable()) && (msgPacket = (MessagePacket)packet).getDeliveryState() != MessagePacket.DELIVERY_CONFIRMED) {
            msgPacket.setDeliveryState(MessagePacket.DELIVERY_OUTSTANDING, member);
        }
        if (!(!this.isNackEnabled() ? false : packet.isConfirmationRequired()) ? false : packet.isOutgoingMultipoint() ^ true) {
            if (packet.getSentMillis() == 0L) {
                member.setNewestToPacketId((MessagePacket)packet);
            }
            member.getRecentPacketQueue().add(packet);
        }
        member.setStatsSent(member.getStatsSent() + (long)1);
        if (packet.getSentMillis() > (long)0) {
            member.setStatsResent(member.getStatsResent() + (long)1);
        }
    }

    protected void onSendPacket(Packet packet) {
        if (packet.isOutgoingMultipoint()) {
            PacketPublisher$MemberSet setTo = this.getMemberSetTemp();
            setTo.addAll((Collection)((MessagePacket)packet).getToMemberSet());
            int[] anToId = setTo.toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = this.getMember(anToId[i]);
                if (member != null) {
                    this.onSendPacket(member, packet);
                }
                ++i;
            }
        } else {
            Member member = this.getMember(packet.getToId());
            if (member != null) {
                this.onSendPacket(member, packet);
            }
        }
    }

    public void onSlowPacket(MessagePacket packet) {
    }

    public void onUndeliverablePacket(MessagePacket packet) {
        DependentMemberSet setMemberTo;
        int nMemberTo = packet.getToId();
        if (nMemberTo != 0) {
            Member member = this.getMember(nMemberTo);
            if (member != null) {
                this.getMemberSet().remove(member);
            }
            packet.setToId(0);
        }
        if ((setMemberTo = packet.getToMemberSet()) != null) {
            this.getMemberSet().removeAll((Collection)setMemberTo);
            setMemberTo.clear();
        }
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public boolean packetizeMessage(Message msg) {
        ReadBuffer bufferRead = msg.getReadBuffer();
        if (bufferRead == null) {
            try {
                MultiBufferWriteBuffer buffer = new MultiBufferWriteBuffer(this.getMessageBufferAllocator());
                msg.setBufferController(buffer);
                msg.getService().serializeMessage(msg, buffer.getBufferOutput());
                bufferRead = buffer.getUnsafeReadBuffer();
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        msg.validateAddressing(this.getMemberSet());
        return msg.packetize(bufferRead, this.isHeterogeneousPacketLengths() ? this.computePreferredPacketLength(msg.getToMemberSet()) : this.getPreferredPacketLength(), this.getMaximumPacketLength());
    }

    protected MessagePacket registerAcks(Ack packetAck, Member member, Message[] aMsgAck) {
        Message msgLast = null;
        MessagePacket packetLast = null;
        List listAckd = this.getAckdPacketListTemp();
        int cNotify = packetAck.getNotifyCount();
        int cNewAck = 0;
        int i = 0;
        int iLastTrint = -1;
        int iMsg = 0;
        while (i < cNotify) {
            MessagePacket packetMsg;
            int iMsgIdTrint = packetAck.getMessageId(i);
            if (iMsgIdTrint != iLastTrint) {
                msgLast = aMsgAck[iMsg++];
                iLastTrint = iMsgIdTrint;
            }
            if (msgLast != null && (!((packetMsg = msgLast.getPacket(packetAck.getMessagePartIndex(i))) != null) ? false : packetMsg.registerAck(member))) {
                listAckd.add(packetMsg);
                if (packetMsg.isOutgoingMultipoint() ^ true) {
                    packetLast = packetMsg;
                }
                ++cNewAck;
            }
            ++i;
        }
        if (cNewAck < cNotify) {
            this.setStatsResentExcess(Math.min(this.getStatsResent(), this.getStatsResentExcess() + (long)(cNotify - cNewAck)));
        }
        this.onAcknowledgedPacket(member, listAckd);
        return packetLast;
    }

    public void resetStats() {
        this.setStatsSent(0L);
        this.setStatsResent(0L);
        this.setStatsResentEarly(0L);
        this.setStatsResentExcess(0L);
        this.setStatsNacksSent(0L);
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void scheduleNack(Member member) {
        Ack packetAck = member.getPacketAck();
        long ldtSend = Base.getSafeTimeMillis() + this.getNackDelayMillis();
        if (!(packetAck != null) ? false : packetAck.getScheduledMillis() <= ldtSend) {
            if (packetAck.isFlushed() ^ true) {
                return;
            }
            packetAck = null;
        }
        if (packetAck == null) {
            packetAck = new Ack();
            packetAck.setFromId(this.getMemberId());
            packetAck.setToId(member.getId());
        }
        packetAck.setScheduledMillis(ldtSend);
        this.setStatsNacksSent(this.getStatsNacksSent() + 1L);
        this.getAckQueue().addHead(packetAck);
    }

    public void sendDiagnosticPacket(DiagnosticPacket packetDiag) {
        block3: {
            try {
                Member memberTo = this.getMember(packetDiag.getToId());
                if (memberTo == null) {
                    Component._trace(String.valueOf("Aborting diagnostic to unknown member ") + packetDiag, 5);
                    return;
                }
                OutgoingUdpPacket packetOut = new OutgoingUdpPacket();
                packetOut.setWriteBuffer(this.getPacketAllocator().allocate(Math.min(this.getPreferredPacketLength(), memberTo.getPreferredPacketLength())));
                packetDiag.setFromId(this.getThisMember().getId());
                packetOut.setUdpSocket(this.getUdpSocketUnicast());
                packetOut.addAddress(memberTo.getSocketAddress());
                packetDiag.setSentMillis(Base.getSafeTimeMillis());
                SingleMemberSet setTo = new SingleMemberSet();
                setTo.add(memberTo);
                packetDiag.write(packetOut.getWriteBuffer().getBufferOutput(), setTo);
                packetOut.send();
                packetDiag.setSentCount(1);
                Component._trace(String.valueOf("Sent diagnostic packet ") + packetDiag, 6);
            }
            catch (Exception e) {
                if (!(this.isExiting() ^ true)) break block3;
                Component._trace(String.valueOf("Failed to send diagnostic packet ") + packetDiag + " due to exception: " + e, 1);
            }
        }
    }

    public void setAckDelay(int cMillis) {
        this.getAckQueue().setDelayMillis(cMillis);
    }

    protected void setAckQueue(PacketPublisher$AckQueue queue) {
        this.__m_AckQueue = queue;
    }

    protected void setAckdPacketListTemp(List listPacket) {
        this.__m_AckdPacketListTemp = listPacket;
    }

    public void setBroadcastAddresses(Set list) {
        this.__m_BroadcastAddresses = list;
    }

    public void setCloggedCount(int cMaxPackets) {
        this.__m_CloggedCount = cMaxPackets;
    }

    public void setCloggedDelay(int cMillis) {
        this.__m_CloggedDelay = Math.max(1, cMillis);
    }

    protected void setConfirmationQueue(PacketPublisher$ConfirmationQueue queue) {
        this.__m_ConfirmationQueue = queue;
    }

    public void setDeferredReadyQueue(Queue queue) {
        this.__m_DeferredReadyQueue = queue;
    }

    public void setHeterogeneousPacketLengths(boolean fHetero) {
        this.__m_HeterogeneousPacketLengths = fHetero;
    }

    protected void setIncommingPacketQueues(Queue[] aQueue) {
        this.__m_IncommingPacketQueues = aQueue;
    }

    protected void setLastTrafficJamWarningTimeMillis(long cMillis) {
        this.__m_LastTrafficJamWarningTimeMillis = cMillis;
    }

    protected void setLostPacketListTemp(List listPacket) {
        this.__m_LostPacketListTemp = listPacket;
    }

    public void setMaximumPacketLength(int cbMax) {
        this.__m_MaximumPacketLength = cbMax;
    }

    protected void setMemberSetTemp(PacketPublisher$MemberSet set) {
        this.__m_MemberSetTemp = set;
    }

    public void setMessageBufferAllocator(MultiBufferWriteBuffer.WriteBufferPool allocator) {
        this.__m_MessageBufferAllocator = allocator;
    }

    protected void setMessageOutgoing(WindowedArray waMsg) {
        this.__m_MessageOutgoing = waMsg;
    }

    protected void setMsgArrayTemp(Message[] aMsg) {
        this.__m_MsgArrayTemp = aMsg;
    }

    protected void setMsgIdArrayTemp(long[] alMsgId) {
        this.__m_MsgIdArrayTemp = alMsgId;
    }

    public void setMulticastEnabled(boolean fEnabled) {
        this.__m_MulticastEnabled = fEnabled;
    }

    public void setMulticastThreshold(double dflThresholdPercent) {
        this.__m_MulticastThreshold = dflThresholdPercent;
    }

    public void setNackDelayMillis(long cDelayMillis) {
        this.__m_NackDelayMillis = cDelayMillis;
    }

    public void setNackEnabled(boolean fEnabled) {
        this.__m_NackEnabled = fEnabled;
    }

    protected void setPacketAdapterQueue(Queue queue) {
        this.__m_PacketAdapterQueue = queue;
    }

    public void setPacketAllocator(PacketBufferPool allocator) {
        this.__m_PacketAllocator = allocator;
    }

    public void setPreferredPacketLength(int cbPacket) {
        this.__m_PreferredPacketLength = cbPacket;
    }

    public void setResendDelay(int cMillis) {
        PacketPublisher$ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setResendMillis(cMillis);
        }
    }

    protected void setResendQueue(PacketPublisher$ResendQueue queue) {
        this.__m_ResendQueue = queue;
    }

    public void setResendTimeout(int cMillis) {
        PacketPublisher$ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setTimeoutMillis(cMillis);
        }
    }

    protected void setReuseableUdpPacket(OutgoingUdpPacket packet) {
        this.__m_ReuseableUdpPacket = packet;
    }

    public void setSendQueue(Queue queue) {
        this.__m_SendQueue = queue;
    }

    protected void setSingleMemberSetTemp(SingleMemberSet set) {
        this.__m_SingleMemberSetTemp = set;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsNacksSent(long cPackets) {
        this.__m_StatsNacksSent = cPackets;
    }

    protected void setStatsResent(long cPackets) {
        this.__m_StatsResent = cPackets;
    }

    protected void setStatsResentEarly(long cPackets) {
        this.__m_StatsResentEarly = cPackets;
    }

    protected void setStatsResentExcess(long cPackets) {
        this.__m_StatsResentExcess = cPackets;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsSent(long cPackets) {
        this.__m_StatsSent = cPackets;
    }

    public void setUdpSocketMulticast(MulticastUdpSocket socket) {
        this.__m_UdpSocketMulticast = socket;
    }

    public void setUdpSocketUnicast(UnicastUdpSocket socket) {
        this.__m_UdpSocketUnicast = socket;
    }

    public synchronized void start() {
        if (this.getSendQueue() == null) {
            throw new IllegalStateException("SendQueue is required!");
        }
        if (this.getMaximumPacketLength() == 0) {
            throw new IllegalStateException("MaximumPacketLength is required!");
        }
        if (this.getPreferredPacketLength() == 0) {
            throw new IllegalStateException("PreferredPacketLength is required!");
        }
        if (this.getUdpSocketUnicast() == null) {
            throw new IllegalStateException("UdpSocketUnicast is required!");
        }
        if (!(this.getUdpSocketMulticast() == null) ? false : this.isMulticastEnabled()) {
            throw new IllegalStateException("UdpSocketMulticast is required!");
        }
        this.setPacketAdapterQueue(((PacketPublisher$InQueue)this.getQueue()).getPacketAdapter());
        Queue queueDeferred = this.getDeferredReadyQueue();
        Queue[] aQueue = new Queue[queueDeferred == null ? 3 : 4];
        int iQueue = 0;
        aQueue[iQueue++] = this.getAckQueue();
        aQueue[iQueue++] = this.getPacketAdapterQueue();
        aQueue[iQueue++] = this.getResendQueue();
        if (queueDeferred != null) {
            aQueue[iQueue++] = queueDeferred;
        }
        this.setIncommingPacketQueues(aQueue);
        super.start();
    }

    public synchronized void stop() {
        super.stop();
        try {
            MulticastUdpSocket socket = this.getUdpSocketMulticast();
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ':' + this.formatStats();
    }

    public boolean verifyResendNecessary(MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        long lMsgId = packet.getFromMessageId();
        boolean fLiveMembers = false;
        if (packet.isOutgoingMultipoint()) {
            PacketPublisher$MemberSet setTo = publisher.getMemberSetTemp();
            setTo.addAll((Collection)packet.getToMemberSet());
            int[] anToId = setTo.toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = publisher.getMember(anToId[i]);
                if (member != null) {
                    fLiveMembers = true;
                    if (!(PacketComparator.compare(member.getContiguousToPacketId(), packet) >= 0) ? false : packet.registerAck(member)) {
                        this.onAcknowledgedPacket(member, Collections.singleton(packet));
                    }
                }
                ++i;
            }
        } else {
            Member member = publisher.getMember(packet.getToId());
            if (member != null) {
                fLiveMembers = true;
                if (!(PacketComparator.compare(member.getContiguousToPacketId(), packet) >= 0) ? false : packet.registerAck(member)) {
                    this.onAcknowledgedPacket(member, Collections.singleton(packet));
                }
            }
        }
        return !fLiveMembers ? false : packet.isResendNecessary();
    }
}

