/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.base;

import com.tangosol.coherence.dsltools.base.LeafBaseToken;

public class LiteralBaseToken
extends LeafBaseToken {
    private int m_nType = -1;
    private String m_sValue = "";
    public static final int STRINGLITERAL = 1;
    public static final int INTEGERLITERAL = 2;
    public static final int LONGLITERAL = 3;
    public static final int FLOATLITERAL = 4;
    public static final int DOUBLELITERAL = 5;
    public static final int BOOLEANLITERAL = 6;
    public static final int NULLLITERAL = 7;
    public static final int SHORTLITERAL = 8;

    public LiteralBaseToken(int nType, String s) {
        this.m_nType = nType;
        this.m_sValue = s;
    }

    @Override
    public String getValue() {
        return this.m_sValue;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public int getType() {
        return this.m_nType;
    }

    @Override
    public String toString() {
        String s = "Literal{";
        int nType = this.m_nType;
        if (nType == 1) {
            s = s + "\"";
        }
        s = s + this.getValue();
        if (nType == 5) {
            s = s + "d";
        } else if (nType == 3) {
            s = s + "l";
        } else if (nType == 8) {
            s = s + "s";
        } else if (nType == 1) {
            s = s + "\"";
        }
        return s + "}";
    }

    public static LiteralBaseToken createString(String s) {
        return new LiteralBaseToken(1, s);
    }

    public static LiteralBaseToken createShort(String s) {
        return new LiteralBaseToken(8, s);
    }

    public static LiteralBaseToken createInteger(String s) {
        return new LiteralBaseToken(2, s);
    }

    public static LiteralBaseToken createLong(String s) {
        return new LiteralBaseToken(3, s);
    }

    public static LiteralBaseToken createFloat(String s) {
        return new LiteralBaseToken(4, s);
    }

    public static LiteralBaseToken createDouble(String s) {
        return new LiteralBaseToken(5, s);
    }

    public static LiteralBaseToken createBoolean(String s) {
        return new LiteralBaseToken(6, s);
    }

    public static LiteralBaseToken createNull(String s) {
        return new LiteralBaseToken(7, s);
    }
}

