/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.net.Member;
import com.tangosol.net.partition.PartitionEvent;
import com.tangosol.net.partition.PartitionListener;
import com.tangosol.net.partition.PartitionSet;

public class PartitionMonitor
implements PartitionListener {
    @Override
    public void onPartitionEvent(PartitionEvent evt) {
        int nType = evt.getId();
        switch (nType) {
            case 5: {
                this.handlePartitionsArriving(evt);
                break;
            }
            case 3: {
                this.handlePartitionsLeaving(evt);
                break;
            }
        }
    }

    private void handlePartitionsArriving(PartitionEvent evt) {
        String sService = evt.getService().getInfo().getServiceName();
        Member member = evt.getToMember();
        Member localMember = evt.getService().getCluster().getLocalMember();
        if (localMember.equals(member)) {
            LocalMemberState lms = LocalMemberState.getMemberState(sService);
            PartitionSet ps = evt.getPartitionSet();
            int i = ps.next(0);
            while (i >= 0) {
                lms.ensureLocalPartitionState(i);
                i = ps.next(i + 1);
            }
        }
    }

    private void handlePartitionsLeaving(PartitionEvent evt) {
        String sService = evt.getService().getInfo().getServiceName();
        Member member = evt.getFromMember();
        Member localMember = evt.getService().getCluster().getLocalMember();
        if (localMember.equals(member)) {
            LocalMemberState lms = LocalMemberState.getMemberState(sService);
            PartitionSet ps = evt.getPartitionSet();
            int i = ps.next(0);
            while (i >= 0) {
                lms.removeLocalPartitionState(i);
                i = ps.next(i + 1);
            }
        }
    }
}

