/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Aaload;
import com.tangosol.dev.assembler.Aastore;
import com.tangosol.dev.assembler.AbstractLocalVariableTableAttribute;
import com.tangosol.dev.assembler.Aconst;
import com.tangosol.dev.assembler.Aload;
import com.tangosol.dev.assembler.Anewarray;
import com.tangosol.dev.assembler.Areturn;
import com.tangosol.dev.assembler.Arraylength;
import com.tangosol.dev.assembler.Astore;
import com.tangosol.dev.assembler.Athrow;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Baload;
import com.tangosol.dev.assembler.Bastore;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.Bnewarray;
import com.tangosol.dev.assembler.Caload;
import com.tangosol.dev.assembler.Case;
import com.tangosol.dev.assembler.Castore;
import com.tangosol.dev.assembler.Catch;
import com.tangosol.dev.assembler.Checkcast;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.Cnewarray;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.D2f;
import com.tangosol.dev.assembler.D2i;
import com.tangosol.dev.assembler.D2l;
import com.tangosol.dev.assembler.Dadd;
import com.tangosol.dev.assembler.Daload;
import com.tangosol.dev.assembler.Dastore;
import com.tangosol.dev.assembler.Dcmpg;
import com.tangosol.dev.assembler.Dcmpl;
import com.tangosol.dev.assembler.Dconst;
import com.tangosol.dev.assembler.Ddiv;
import com.tangosol.dev.assembler.Dload;
import com.tangosol.dev.assembler.Dmul;
import com.tangosol.dev.assembler.Dneg;
import com.tangosol.dev.assembler.Dnewarray;
import com.tangosol.dev.assembler.DoubleConstant;
import com.tangosol.dev.assembler.Drem;
import com.tangosol.dev.assembler.Dreturn;
import com.tangosol.dev.assembler.Dstore;
import com.tangosol.dev.assembler.Dsub;
import com.tangosol.dev.assembler.Dup;
import com.tangosol.dev.assembler.Dup2;
import com.tangosol.dev.assembler.Dup2_x1;
import com.tangosol.dev.assembler.Dup2_x2;
import com.tangosol.dev.assembler.Dup_x1;
import com.tangosol.dev.assembler.Dup_x2;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.F2d;
import com.tangosol.dev.assembler.F2i;
import com.tangosol.dev.assembler.F2l;
import com.tangosol.dev.assembler.Fadd;
import com.tangosol.dev.assembler.Faload;
import com.tangosol.dev.assembler.Fastore;
import com.tangosol.dev.assembler.Fcmpg;
import com.tangosol.dev.assembler.Fcmpl;
import com.tangosol.dev.assembler.Fconst;
import com.tangosol.dev.assembler.Fdiv;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Fload;
import com.tangosol.dev.assembler.FloatConstant;
import com.tangosol.dev.assembler.Fmul;
import com.tangosol.dev.assembler.Fneg;
import com.tangosol.dev.assembler.Fnewarray;
import com.tangosol.dev.assembler.Frem;
import com.tangosol.dev.assembler.Freturn;
import com.tangosol.dev.assembler.Fstore;
import com.tangosol.dev.assembler.Fsub;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Getfield;
import com.tangosol.dev.assembler.Getstatic;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.GuardedSection;
import com.tangosol.dev.assembler.I2b;
import com.tangosol.dev.assembler.I2c;
import com.tangosol.dev.assembler.I2d;
import com.tangosol.dev.assembler.I2f;
import com.tangosol.dev.assembler.I2l;
import com.tangosol.dev.assembler.I2s;
import com.tangosol.dev.assembler.Iadd;
import com.tangosol.dev.assembler.Iaload;
import com.tangosol.dev.assembler.Iand;
import com.tangosol.dev.assembler.Iastore;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.Idiv;
import com.tangosol.dev.assembler.If_acmpeq;
import com.tangosol.dev.assembler.If_acmpne;
import com.tangosol.dev.assembler.If_icmpeq;
import com.tangosol.dev.assembler.If_icmpge;
import com.tangosol.dev.assembler.If_icmpgt;
import com.tangosol.dev.assembler.If_icmple;
import com.tangosol.dev.assembler.If_icmplt;
import com.tangosol.dev.assembler.If_icmpne;
import com.tangosol.dev.assembler.Ifeq;
import com.tangosol.dev.assembler.Ifge;
import com.tangosol.dev.assembler.Ifgt;
import com.tangosol.dev.assembler.Ifle;
import com.tangosol.dev.assembler.Iflt;
import com.tangosol.dev.assembler.Ifne;
import com.tangosol.dev.assembler.Ifnonnull;
import com.tangosol.dev.assembler.Ifnull;
import com.tangosol.dev.assembler.Iinc;
import com.tangosol.dev.assembler.Iload;
import com.tangosol.dev.assembler.Imul;
import com.tangosol.dev.assembler.Ineg;
import com.tangosol.dev.assembler.Inewarray;
import com.tangosol.dev.assembler.Instanceof;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.InterfaceConstant;
import com.tangosol.dev.assembler.Invokeinterface;
import com.tangosol.dev.assembler.Invokespecial;
import com.tangosol.dev.assembler.Invokestatic;
import com.tangosol.dev.assembler.Invokevirtual;
import com.tangosol.dev.assembler.Ior;
import com.tangosol.dev.assembler.Irem;
import com.tangosol.dev.assembler.Ireturn;
import com.tangosol.dev.assembler.Ishl;
import com.tangosol.dev.assembler.Ishr;
import com.tangosol.dev.assembler.Istore;
import com.tangosol.dev.assembler.Isub;
import com.tangosol.dev.assembler.Iushr;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Ixor;
import com.tangosol.dev.assembler.Jsr;
import com.tangosol.dev.assembler.L2d;
import com.tangosol.dev.assembler.L2f;
import com.tangosol.dev.assembler.L2i;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Ladd;
import com.tangosol.dev.assembler.Laload;
import com.tangosol.dev.assembler.Land;
import com.tangosol.dev.assembler.Lastore;
import com.tangosol.dev.assembler.Lcmp;
import com.tangosol.dev.assembler.Lconst;
import com.tangosol.dev.assembler.Ldiv;
import com.tangosol.dev.assembler.LineNumberTableAttribute;
import com.tangosol.dev.assembler.Lload;
import com.tangosol.dev.assembler.Lmul;
import com.tangosol.dev.assembler.Lneg;
import com.tangosol.dev.assembler.Lnewarray;
import com.tangosol.dev.assembler.LocalVariableTableAttribute;
import com.tangosol.dev.assembler.LocalVariableTypeTableAttribute;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.Lor;
import com.tangosol.dev.assembler.Lrem;
import com.tangosol.dev.assembler.Lreturn;
import com.tangosol.dev.assembler.Lshl;
import com.tangosol.dev.assembler.Lshr;
import com.tangosol.dev.assembler.Lstore;
import com.tangosol.dev.assembler.Lsub;
import com.tangosol.dev.assembler.Lushr;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.Lxor;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.Monitorenter;
import com.tangosol.dev.assembler.Monitorexit;
import com.tangosol.dev.assembler.Multianewarray;
import com.tangosol.dev.assembler.New;
import com.tangosol.dev.assembler.Nop;
import com.tangosol.dev.assembler.OpBranch;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.Pop;
import com.tangosol.dev.assembler.Pop2;
import com.tangosol.dev.assembler.Putfield;
import com.tangosol.dev.assembler.Putstatic;
import com.tangosol.dev.assembler.Ret;
import com.tangosol.dev.assembler.Return;
import com.tangosol.dev.assembler.Rvar;
import com.tangosol.dev.assembler.Saload;
import com.tangosol.dev.assembler.Sastore;
import com.tangosol.dev.assembler.Snewarray;
import com.tangosol.dev.assembler.StringConstant;
import com.tangosol.dev.assembler.Swap;
import com.tangosol.dev.assembler.Switch;
import com.tangosol.dev.assembler.Try;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.dev.assembler.Znewarray;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.NullImplementation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Op
extends VMStructure
implements Constants {
    private static final String CLASS = "Op";
    private static final byte[] NO_BYTES = new byte[0];
    private static final long BIGPRIME = 1500450271L;
    private static final long INTLIMIT = 0x80000000L;
    private static final String BLANK = "";
    private static final String BLANK_LABEL = "                  ";
    private static final String BLANK_INSTRUCTION = "                        ";
    private static final String SEPARATOR = "  ";
    private static int sm_iLastHash;
    private int m_iOp;
    private int m_of;
    private int m_cb;
    private int m_iLine;
    private Op m_opNext;
    private int m_cwStack = Integer.MIN_VALUE;
    private int m_iHash;

    protected Op(int iOp) {
        this.m_iOp = iOp;
        this.m_iHash = sm_iLastHash = (int)(((long)sm_iLastHash + 1500450271L) % 0x80000000L);
    }

    public static boolean isByteCode(int ub) {
        return ub >= 0 && ub <= 201 && ub != 186;
    }

    protected static OpDeclare getVariable(int iOp, int iVar, OpDeclare[][] aavar) {
        int iType = iOp - 236;
        OpDeclare decl = aavar[iType][iVar];
        if (decl == null) {
            switch (iOp) {
                case 236: {
                    decl = new Ivar(iVar);
                    break;
                }
                case 237: {
                    decl = new Lvar(iVar);
                    break;
                }
                case 238: {
                    decl = new Fvar(iVar);
                    break;
                }
                case 239: {
                    decl = new Dvar(iVar);
                    break;
                }
                case 240: {
                    decl = new Avar(iVar);
                    break;
                }
                case 241: {
                    decl = new Rvar(iVar);
                }
            }
            aavar[iType][iVar] = decl;
        }
        return decl;
    }

    private static Label getLabel(int of, Op[] alabel) throws IOException {
        try {
            Label label = (Label)alabel[of];
            if (label == null) {
                label = new Label(String.valueOf(of));
                label.setOffset(of);
                alabel[of] = label;
            }
            return label;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Op.getLabel:  Illegal label offset -- " + of);
        }
    }

    private static void addTry(int of, Try opTry, Op[] aopDefer) throws IOException {
        Op op;
        opTry.setOffset(of);
        try {
            op = aopDefer[of];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Op.addTry:  Illegal Try offset!");
        }
        if (op == null || op instanceof Try) {
            aopDefer[of] = opTry;
            opTry.setNext(op);
        } else {
            Op opPrev = op;
            Op opNext = opPrev.getNext();
            while (opNext instanceof Catch || opNext instanceof Label) {
                opPrev = opNext;
                opNext = opPrev.getNext();
            }
            opPrev.setNext(opTry);
            opTry.setNext(opNext);
        }
    }

    private static void addCatch(int of, Catch opCatch, Op[] aopDefer) throws IOException {
        Op op;
        opCatch.setOffset(of);
        try {
            op = aopDefer[of];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Op.addCatch:  Illegal Catch offset!");
        }
        if (op instanceof Catch) {
            Op opPrev = op;
            Op opNext = opPrev.getNext();
            while (opNext instanceof Catch) {
                opPrev = opNext;
                opNext = opPrev.getNext();
            }
            opPrev.setNext(opCatch);
            opCatch.setNext(opNext);
        } else {
            aopDefer[of] = opCatch;
            opCatch.setNext(op);
        }
    }

    private static void disassembleVarTable(AbstractLocalVariableTableAttribute attrTable, Op[] aopLabel) throws IOException {
        Enumeration enmr = attrTable.ranges();
        while (enmr.hasMoreElements()) {
            AbstractLocalVariableTableAttribute.Range range = (AbstractLocalVariableTableAttribute.Range)enmr.nextElement();
            int ofInit = range.getOffset();
            int ofStop = ofInit + range.getLength();
            range.setInit(Op.getLabel(ofInit, aopLabel));
            range.setStop(Op.getLabel(ofStop, aopLabel));
        }
    }

    protected static void disassembleOps(byte[] abCode, int cVars, String[] asParam, Vector vectCatch, LineNumberTableAttribute attrLine, LocalVariableTableAttribute attrVar, LocalVariableTypeTableAttribute attrVarType, ConstantPool pool, Op[] aopBounds) throws IOException {
        Begin opPreInit;
        ReadBuffer.BufferInput stream = new ByteArrayReadBuffer(abCode).getBufferInput();
        Enumeration enmrLines = attrLine == null ? NullImplementation.getEnumeration() : attrLine.entries();
        LineNumberTableAttribute.Entry line = enmrLines.hasMoreElements() ? enmrLines.nextElement() : null;
        int iLine = 0;
        OpDeclare[][] aavar = new OpDeclare[6][cVars];
        Op[] aopDefer = new Op[abCode.length + 1];
        boolean fSwitchOp = false;
        OpBranch opSwitch = null;
        int iOpSwitch = 0;
        int cCases = 0;
        int iCase = 0;
        Op opFirst = null;
        Op opLast = null;
        while (true) {
            int ofOp = stream.getOffset();
            Op op = null;
            if (fSwitchOp) {
                Label label;
                if (iOpSwitch == 171) {
                    iCase = stream.readInt();
                }
                if ((label = Op.getLabel(opSwitch.m_of + stream.readInt(), aopDefer)) != opSwitch.getLabel()) {
                    op = new Case(iCase, label);
                }
                ++iCase;
                if (--cCases <= 0) {
                    fSwitchOp = false;
                }
            } else {
                int iOp;
                if (line != null && ofOp >= line.getOffset()) {
                    iLine = line.getLine();
                    line = enmrLines.hasMoreElements() ? enmrLines.nextElement() : null;
                }
                try {
                    iOp = stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    break;
                }
                block1 : switch (iOp) {
                    case 0: {
                        op = new Nop();
                        break;
                    }
                    case 1: {
                        op = new Aconst();
                        break;
                    }
                    case 2: {
                        op = new Iconst(CONSTANT_ICONST_M1);
                        break;
                    }
                    case 3: {
                        op = new Iconst(CONSTANT_ICONST_0);
                        break;
                    }
                    case 4: {
                        op = new Iconst(CONSTANT_ICONST_1);
                        break;
                    }
                    case 5: {
                        op = new Iconst(CONSTANT_ICONST_2);
                        break;
                    }
                    case 6: {
                        op = new Iconst(CONSTANT_ICONST_3);
                        break;
                    }
                    case 7: {
                        op = new Iconst(CONSTANT_ICONST_4);
                        break;
                    }
                    case 8: {
                        op = new Iconst(CONSTANT_ICONST_5);
                        break;
                    }
                    case 9: {
                        op = new Lconst(CONSTANT_LCONST_0);
                        break;
                    }
                    case 10: {
                        op = new Lconst(CONSTANT_LCONST_1);
                        break;
                    }
                    case 11: {
                        op = new Fconst(CONSTANT_FCONST_0);
                        break;
                    }
                    case 12: {
                        op = new Fconst(CONSTANT_FCONST_1);
                        break;
                    }
                    case 13: {
                        op = new Fconst(CONSTANT_FCONST_2);
                        break;
                    }
                    case 14: {
                        op = new Dconst(CONSTANT_DCONST_0);
                        break;
                    }
                    case 15: {
                        op = new Dconst(CONSTANT_DCONST_1);
                        break;
                    }
                    case 16: {
                        op = new Iconst(new IntConstant(stream.readByte()));
                        break;
                    }
                    case 17: {
                        op = new Iconst(new IntConstant(stream.readShort()));
                        break;
                    }
                    case 18: 
                    case 19: {
                        int iConst = iOp == 18 ? stream.readUnsignedByte() : stream.readUnsignedShort();
                        Constant constant = pool.getConstant(iConst);
                        if (constant instanceof StringConstant) {
                            op = new Aconst((StringConstant)constant);
                            break;
                        }
                        if (constant instanceof IntConstant) {
                            op = new Iconst((IntConstant)constant);
                            break;
                        }
                        if (constant instanceof FloatConstant) {
                            op = new Fconst((FloatConstant)constant);
                            break;
                        }
                        if (constant instanceof ClassConstant) {
                            op = new Aconst((ClassConstant)constant);
                            break;
                        }
                        throw new IOException("Op.disassembleOps:  Invalid LDC/LDC_W constant type!");
                    }
                    case 20: {
                        Constant constant = pool.getConstant(stream.readUnsignedShort());
                        if (constant instanceof LongConstant) {
                            op = new Lconst((LongConstant)constant);
                            break;
                        }
                        if (constant instanceof DoubleConstant) {
                            op = new Dconst((DoubleConstant)constant);
                            break;
                        }
                        throw new IOException("Op.disassembleOps:  Invalid LDC2_W constant type!");
                    }
                    case 21: {
                        op = new Iload((Ivar)Op.getVariable(236, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 22: {
                        op = new Lload((Lvar)Op.getVariable(237, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 23: {
                        op = new Fload((Fvar)Op.getVariable(238, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 24: {
                        op = new Dload((Dvar)Op.getVariable(239, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 25: {
                        op = new Aload((Avar)Op.getVariable(240, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        op = new Iload((Ivar)Op.getVariable(236, iOp - 26, aavar));
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        op = new Lload((Lvar)Op.getVariable(237, iOp - 30, aavar));
                        break;
                    }
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        op = new Fload((Fvar)Op.getVariable(238, iOp - 34, aavar));
                        break;
                    }
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        op = new Dload((Dvar)Op.getVariable(239, iOp - 38, aavar));
                        break;
                    }
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        op = new Aload((Avar)Op.getVariable(240, iOp - 42, aavar));
                        break;
                    }
                    case 46: {
                        op = new Iaload();
                        break;
                    }
                    case 47: {
                        op = new Laload();
                        break;
                    }
                    case 48: {
                        op = new Faload();
                        break;
                    }
                    case 49: {
                        op = new Daload();
                        break;
                    }
                    case 50: {
                        op = new Aaload();
                        break;
                    }
                    case 51: {
                        op = new Baload();
                        break;
                    }
                    case 52: {
                        op = new Caload();
                        break;
                    }
                    case 53: {
                        op = new Saload();
                        break;
                    }
                    case 54: {
                        op = new Istore((Ivar)Op.getVariable(236, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 55: {
                        op = new Lstore((Lvar)Op.getVariable(237, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 56: {
                        op = new Fstore((Fvar)Op.getVariable(238, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 57: {
                        op = new Dstore((Dvar)Op.getVariable(239, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 58: {
                        op = new Astore((Avar)Op.getVariable(240, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        op = new Istore((Ivar)Op.getVariable(236, iOp - 59, aavar));
                        break;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: {
                        op = new Lstore((Lvar)Op.getVariable(237, iOp - 63, aavar));
                        break;
                    }
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        op = new Fstore((Fvar)Op.getVariable(238, iOp - 67, aavar));
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        op = new Dstore((Dvar)Op.getVariable(239, iOp - 71, aavar));
                        break;
                    }
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: {
                        op = new Astore((Avar)Op.getVariable(240, iOp - 75, aavar));
                        break;
                    }
                    case 79: {
                        op = new Iastore();
                        break;
                    }
                    case 80: {
                        op = new Lastore();
                        break;
                    }
                    case 81: {
                        op = new Fastore();
                        break;
                    }
                    case 82: {
                        op = new Dastore();
                        break;
                    }
                    case 83: {
                        op = new Aastore();
                        break;
                    }
                    case 84: {
                        op = new Bastore();
                        break;
                    }
                    case 85: {
                        op = new Castore();
                        break;
                    }
                    case 86: {
                        op = new Sastore();
                        break;
                    }
                    case 87: {
                        op = new Pop();
                        break;
                    }
                    case 88: {
                        op = new Pop2();
                        break;
                    }
                    case 89: {
                        op = new Dup();
                        break;
                    }
                    case 90: {
                        op = new Dup_x1();
                        break;
                    }
                    case 91: {
                        op = new Dup_x2();
                        break;
                    }
                    case 92: {
                        op = new Dup2();
                        break;
                    }
                    case 93: {
                        op = new Dup2_x1();
                        break;
                    }
                    case 94: {
                        op = new Dup2_x2();
                        break;
                    }
                    case 95: {
                        op = new Swap();
                        break;
                    }
                    case 96: {
                        op = new Iadd();
                        break;
                    }
                    case 97: {
                        op = new Ladd();
                        break;
                    }
                    case 98: {
                        op = new Fadd();
                        break;
                    }
                    case 99: {
                        op = new Dadd();
                        break;
                    }
                    case 100: {
                        op = new Isub();
                        break;
                    }
                    case 101: {
                        op = new Lsub();
                        break;
                    }
                    case 102: {
                        op = new Fsub();
                        break;
                    }
                    case 103: {
                        op = new Dsub();
                        break;
                    }
                    case 104: {
                        op = new Imul();
                        break;
                    }
                    case 105: {
                        op = new Lmul();
                        break;
                    }
                    case 106: {
                        op = new Fmul();
                        break;
                    }
                    case 107: {
                        op = new Dmul();
                        break;
                    }
                    case 108: {
                        op = new Idiv();
                        break;
                    }
                    case 109: {
                        op = new Ldiv();
                        break;
                    }
                    case 110: {
                        op = new Fdiv();
                        break;
                    }
                    case 111: {
                        op = new Ddiv();
                        break;
                    }
                    case 112: {
                        op = new Irem();
                        break;
                    }
                    case 113: {
                        op = new Lrem();
                        break;
                    }
                    case 114: {
                        op = new Frem();
                        break;
                    }
                    case 115: {
                        op = new Drem();
                        break;
                    }
                    case 116: {
                        op = new Ineg();
                        break;
                    }
                    case 117: {
                        op = new Lneg();
                        break;
                    }
                    case 118: {
                        op = new Fneg();
                        break;
                    }
                    case 119: {
                        op = new Dneg();
                        break;
                    }
                    case 120: {
                        op = new Ishl();
                        break;
                    }
                    case 121: {
                        op = new Lshl();
                        break;
                    }
                    case 122: {
                        op = new Ishr();
                        break;
                    }
                    case 123: {
                        op = new Lshr();
                        break;
                    }
                    case 124: {
                        op = new Iushr();
                        break;
                    }
                    case 125: {
                        op = new Lushr();
                        break;
                    }
                    case 126: {
                        op = new Iand();
                        break;
                    }
                    case 127: {
                        op = new Land();
                        break;
                    }
                    case 128: {
                        op = new Ior();
                        break;
                    }
                    case 129: {
                        op = new Lor();
                        break;
                    }
                    case 130: {
                        op = new Ixor();
                        break;
                    }
                    case 131: {
                        op = new Lxor();
                        break;
                    }
                    case 132: {
                        int iVar = stream.readUnsignedByte();
                        Ivar var = (Ivar)Op.getVariable(236, iVar, aavar);
                        short sInc = stream.readByte();
                        op = new Iinc(var, sInc);
                        break;
                    }
                    case 133: {
                        op = new I2l();
                        break;
                    }
                    case 134: {
                        op = new I2f();
                        break;
                    }
                    case 135: {
                        op = new I2d();
                        break;
                    }
                    case 136: {
                        op = new L2i();
                        break;
                    }
                    case 137: {
                        op = new L2f();
                        break;
                    }
                    case 138: {
                        op = new L2d();
                        break;
                    }
                    case 139: {
                        op = new F2i();
                        break;
                    }
                    case 140: {
                        op = new F2l();
                        break;
                    }
                    case 141: {
                        op = new F2d();
                        break;
                    }
                    case 142: {
                        op = new D2i();
                        break;
                    }
                    case 143: {
                        op = new D2l();
                        break;
                    }
                    case 144: {
                        op = new D2f();
                        break;
                    }
                    case 145: {
                        op = new I2b();
                        break;
                    }
                    case 146: {
                        op = new I2c();
                        break;
                    }
                    case 147: {
                        op = new I2s();
                        break;
                    }
                    case 148: {
                        op = new Lcmp();
                        break;
                    }
                    case 149: {
                        op = new Fcmpl();
                        break;
                    }
                    case 150: {
                        op = new Fcmpg();
                        break;
                    }
                    case 151: {
                        op = new Dcmpl();
                        break;
                    }
                    case 152: {
                        op = new Dcmpg();
                        break;
                    }
                    case 153: {
                        op = new Ifeq(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 154: {
                        op = new Ifne(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 155: {
                        op = new Iflt(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 156: {
                        op = new Ifge(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 157: {
                        op = new Ifgt(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 158: {
                        op = new Ifle(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 159: {
                        op = new If_icmpeq(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 160: {
                        op = new If_icmpne(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 161: {
                        op = new If_icmplt(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 162: {
                        op = new If_icmpge(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 163: {
                        op = new If_icmpgt(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 164: {
                        op = new If_icmple(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 165: {
                        op = new If_acmpeq(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 166: {
                        op = new If_acmpne(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 167: {
                        op = new Goto(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 168: {
                        op = new Jsr(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 169: {
                        op = new Ret((Rvar)Op.getVariable(241, stream.readUnsignedByte(), aavar));
                        break;
                    }
                    case 170: 
                    case 171: {
                        int cbPad = 3 - ofOp % 4;
                        for (int i = 0; i < cbPad; ++i) {
                            int iPad = stream.readUnsignedByte();
                            if (iPad == 0) continue;
                            throw new IOException("Op.disassembleOps:  Illegal padding! (" + iPad + ")");
                        }
                        Label labelDefault = Op.getLabel(ofOp + stream.readInt(), aopDefer);
                        if (iOp == 170) {
                            int iLow = stream.readInt();
                            int iHigh = stream.readInt();
                            cCases = iHigh - iLow + 1;
                            iCase = iLow;
                        } else {
                            cCases = stream.readInt();
                        }
                        opSwitch = new Switch(labelDefault);
                        op = opSwitch;
                        iOpSwitch = iOp;
                        fSwitchOp = cCases > 0;
                        break;
                    }
                    case 172: {
                        op = new Ireturn();
                        break;
                    }
                    case 173: {
                        op = new Lreturn();
                        break;
                    }
                    case 174: {
                        op = new Freturn();
                        break;
                    }
                    case 175: {
                        op = new Dreturn();
                        break;
                    }
                    case 176: {
                        op = new Areturn();
                        break;
                    }
                    case 177: {
                        op = new Return();
                        break;
                    }
                    case 178: {
                        op = new Getstatic((FieldConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 179: {
                        op = new Putstatic((FieldConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 180: {
                        op = new Getfield((FieldConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 181: {
                        op = new Putfield((FieldConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 182: {
                        op = new Invokevirtual((MethodConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 183: {
                        op = new Invokespecial((MethodConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 184: {
                        op = new Invokestatic((MethodConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 185: {
                        op = new Invokeinterface((InterfaceConstant)pool.getConstant(stream.readUnsignedShort()));
                        stream.readUnsignedByte();
                        stream.readUnsignedByte();
                        break;
                    }
                    default: {
                        throw new IOException("Op.disassembleOps:  Illegal byte code! (" + iOp + ")");
                    }
                    case 187: {
                        op = new New((ClassConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 188: {
                        int iType = stream.readUnsignedByte();
                        switch (iType) {
                            case 4: {
                                op = new Znewarray();
                                break block1;
                            }
                            case 5: {
                                op = new Cnewarray();
                                break block1;
                            }
                            case 6: {
                                op = new Fnewarray();
                                break block1;
                            }
                            case 7: {
                                op = new Dnewarray();
                                break block1;
                            }
                            case 8: {
                                op = new Bnewarray();
                                break block1;
                            }
                            case 9: {
                                op = new Snewarray();
                                break block1;
                            }
                            case 10: {
                                op = new Inewarray();
                                break block1;
                            }
                            case 11: {
                                op = new Lnewarray();
                                break block1;
                            }
                        }
                        throw new IOException("Op.disassembleOps:  Unexpected NEWARRAY type (" + iType + ")");
                    }
                    case 189: {
                        op = new Anewarray((ClassConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 190: {
                        op = new Arraylength();
                        break;
                    }
                    case 191: {
                        op = new Athrow();
                        break;
                    }
                    case 192: {
                        op = new Checkcast((ClassConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 193: {
                        op = new Instanceof((ClassConstant)pool.getConstant(stream.readUnsignedShort()));
                        break;
                    }
                    case 194: {
                        op = new Monitorenter();
                        break;
                    }
                    case 195: {
                        op = new Monitorexit();
                        break;
                    }
                    case 196: {
                        iOp = stream.readUnsignedByte();
                        switch (iOp) {
                            case 132: {
                                int iVar = stream.readUnsignedShort();
                                Ivar var = (Ivar)Op.getVariable(236, iVar, aavar);
                                short sInc = stream.readShort();
                                op = new Iinc(var, sInc);
                                break block1;
                            }
                            case 21: {
                                op = new Iload((Ivar)Op.getVariable(236, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 22: {
                                op = new Lload((Lvar)Op.getVariable(237, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 23: {
                                op = new Fload((Fvar)Op.getVariable(238, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 24: {
                                op = new Dload((Dvar)Op.getVariable(239, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 25: {
                                op = new Aload((Avar)Op.getVariable(240, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 54: {
                                op = new Istore((Ivar)Op.getVariable(236, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 55: {
                                op = new Lstore((Lvar)Op.getVariable(237, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 56: {
                                op = new Fstore((Fvar)Op.getVariable(238, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 57: {
                                op = new Dstore((Dvar)Op.getVariable(239, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 58: {
                                op = new Astore((Avar)Op.getVariable(240, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                            case 169: {
                                op = new Ret((Rvar)Op.getVariable(241, stream.readUnsignedShort(), aavar));
                                break block1;
                            }
                        }
                        throw new IOException("Op.disassembleOps:  Illegal byte code modified by WIDE! (" + iOp + ")");
                    }
                    case 197: {
                        int iConst = stream.readUnsignedShort();
                        int cDims = stream.readUnsignedByte();
                        ClassConstant constant = (ClassConstant)pool.getConstant(iConst);
                        op = new Multianewarray(constant, cDims);
                        break;
                    }
                    case 198: {
                        op = new Ifnull(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 199: {
                        op = new Ifnonnull(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 200: {
                        op = new Goto(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                        break;
                    }
                    case 201: {
                        op = new Jsr(Op.getLabel(ofOp + stream.readShort(), aopDefer));
                    }
                }
            }
            int cbOp = stream.getOffset() - ofOp;
            if (op == null) {
                opLast.m_cb += cbOp;
                continue;
            }
            op.m_iLine = iLine;
            op.m_of = ofOp;
            op.m_cb = cbOp;
            if (opFirst == null) {
                opFirst = op;
                opLast = op;
                continue;
            }
            opLast.m_opNext = op;
            opLast = op;
        }
        if (attrVar != null) {
            Op.disassembleVarTable(attrVar, aopDefer);
        }
        if (attrVarType != null) {
            Op.disassembleVarTable(attrVarType, aopDefer);
        }
        Enumeration enmr = vectCatch.elements();
        while (enmr.hasMoreElements()) {
            GuardedSection section = (GuardedSection)enmr.nextElement();
            section.setHandler(Op.getLabel(section.getHandlerOffset(), aopDefer));
        }
        int ofTryPrev = -1;
        int ofCatchPrev = -1;
        Try opTryPrev = null;
        Enumeration enmr2 = vectCatch.elements();
        while (enmr2.hasMoreElements()) {
            Catch opCatch;
            Try opTry;
            GuardedSection section = (GuardedSection)enmr2.nextElement();
            int ofTry = section.getTryOffset();
            int ofCatch = section.getCatchOffset();
            if (ofTry == ofTryPrev && ofCatch == ofCatchPrev) {
                opTry = opTryPrev;
                opCatch = new Catch(opTry, section.getException(), section.getHandler());
                Op.addCatch(ofCatch, opCatch, aopDefer);
                continue;
            }
            opTry = new Try();
            opCatch = new Catch(opTry, section.getException(), section.getHandler());
            Op.addTry(ofTry, opTry, aopDefer);
            Op.addCatch(ofCatch, opCatch, aopDefer);
            ofTryPrev = ofTry;
            ofCatchPrev = ofCatch;
            opTryPrev = opTry;
        }
        int cParams = asParam.length;
        int iVar = 0;
        for (int iParam = 0; iParam < cParams; ++iParam) {
            int nOp;
            char chType = asParam[iParam].charAt(0);
            switch (chType) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    nOp = 236;
                    break;
                }
                case 'J': {
                    nOp = 237;
                    break;
                }
                case 'F': {
                    nOp = 238;
                    break;
                }
                case 'D': {
                    nOp = 239;
                    break;
                }
                case 'L': 
                case '[': {
                    nOp = 240;
                    break;
                }
                case 'V': {
                    throw new IllegalStateException("Parameter cannot be void");
                }
                default: {
                    throw new IllegalStateException("JVM Type Signature cannot start with '" + chType + "'");
                }
            }
            Op.getVariable(nOp, iVar, aavar);
            iVar += OpDeclare.getJavaWidth(chType);
        }
        Op opPreStop = opPreInit = new Begin();
        for (iVar = 0; iVar < cVars; ++iVar) {
            for (int iType = 0; iType < 6; ++iType) {
                OpDeclare decl = aavar[iType][iVar];
                if (decl == null) continue;
                opPreStop.m_opNext = decl;
                opPreStop = decl;
            }
        }
        End opPost = new End();
        opPost.m_of = opLast.m_of + opLast.m_cb;
        opPost.m_iLine = opLast.m_iLine;
        opLast.m_opNext = opPost;
        opLast = opPost;
        int ofPrev = -1;
        Op opPrev = null;
        Op op = opFirst;
        while (op != null) {
            int of = op.m_of;
            if (of > ofPrev) {
                for (int ofSkip = ofPrev + 1; ofSkip < of; ++ofSkip) {
                    if (aopDefer[ofSkip] == null) continue;
                    Op opLabel = aopDefer[ofSkip];
                    StringBuffer sb = new StringBuffer();
                    while (opLabel != null) {
                        sb.append("\n  ").append(opLabel.getClass().getName()).append(' ').append(opLabel);
                        opLabel = opLabel.m_opNext;
                    }
                    throw new IOException("Op.disassembleOps:  Non-alligned label, try, or catch at offset " + ofSkip + ":" + sb + "\n  opPrev=" + opPrev.getClass().getName() + " " + opPrev + " @" + opPrev.m_of + "\n  op=" + op.getClass().getName() + " " + op + " @" + op.m_of);
                }
                ofPrev = of;
                Op opInsert = aopDefer[of];
                if (opInsert != null) {
                    opInsert.m_of = of;
                    opInsert.m_iLine = op.m_iLine;
                    Op opLastInsert = opInsert;
                    while (opLastInsert.m_opNext != null) {
                        opLastInsert = opLastInsert.m_opNext;
                        opLastInsert.m_of = of;
                        opLastInsert.m_iLine = op.m_iLine;
                    }
                    if (opPrev == null) {
                        opFirst = opInsert;
                    } else {
                        opPrev.m_opNext = opInsert;
                    }
                    opLastInsert.m_opNext = op;
                }
            }
            opPrev = op;
            op = opPrev.m_opNext;
        }
        opPreStop.m_opNext = opFirst;
        opFirst = opPreInit;
        aopBounds[0] = opFirst;
        aopBounds[1] = opLast;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
    }

    @Override
    protected void preassemble(ConstantPool pool) {
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        if (this.m_iOp <= 201) {
            stream.write(this.m_iOp);
        }
    }

    public String toString() {
        return Op.format(null, OPNAME[this.m_iOp], null);
    }

    protected static String format(String sLabel, String sInstruction, String sComment) {
        StringBuffer sb = new StringBuffer();
        if (sLabel == null) {
            sLabel = BLANK;
        }
        if (sInstruction == null) {
            sInstruction = BLANK;
        }
        if (sComment == null) {
            sComment = BLANK;
        }
        boolean fLabel = sLabel.length() > 0;
        boolean fInstruction = sInstruction.length() > 0;
        boolean fComment = sComment.length() > 0;
        boolean fOverflow = false;
        if (fLabel) {
            sb.append(sLabel).append(':');
            boolean bl = fOverflow = sb.length() > BLANK_LABEL.length();
        }
        if (fInstruction || fComment) {
            if (fOverflow) {
                sb.append('\n').append(BLANK_LABEL).append(SEPARATOR);
            } else {
                sb.append(BLANK_LABEL.substring(sb.length())).append(SEPARATOR);
            }
            fOverflow = false;
            if (fInstruction) {
                sb.append(sInstruction);
                boolean bl = fOverflow = sInstruction.length() >= BLANK_INSTRUCTION.length();
            }
            if (fComment) {
                if (fOverflow) {
                    sb.append('\n').append(BLANK_LABEL).append(SEPARATOR).append(BLANK_INSTRUCTION).append(SEPARATOR);
                } else {
                    sb.append(BLANK_INSTRUCTION.substring(sInstruction.length())).append(SEPARATOR);
                }
                sb.append("// ").append(sComment);
            }
        }
        return sb.toString();
    }

    public String toJasm() {
        return OPNAME[this.m_iOp];
    }

    public int hashCode() {
        return this.m_iHash;
    }

    public int getValue() {
        return this.m_iOp;
    }

    protected void setValue(int iOp) {
        this.m_iOp = iOp;
    }

    public int getOffset() {
        return this.m_of;
    }

    protected void setOffset(int of) {
        this.m_of = of;
    }

    public boolean hasSize() {
        if (this.m_iOp <= 201) {
            return true;
        }
        switch (this.m_iOp) {
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 251: 
            case 253: 
            case 254: 
            case 255: {
                return false;
            }
        }
        return true;
    }

    public int getSize() {
        return this.m_cb;
    }

    protected void setSize(int cb) {
        this.m_cb = cb;
    }

    protected void calculateSize(ConstantPool pool) {
        this.setSize(this.m_iOp > 201 ? 0 : 1);
    }

    public int getStackChange() {
        return OPEFFECT[this.m_iOp];
    }

    protected int getStackHeight() {
        return this.m_cwStack;
    }

    protected void setStackHeight(int cwStack) {
        int cwStackPrev = this.m_cwStack;
        if (cwStackPrev != Integer.MIN_VALUE && cwStackPrev != cwStack) {
            throw new IllegalStateException("Op.setStackHeight:  Height mismatch (" + cwStack + " vs " + cwStackPrev + ") on " + this.toString() + "!");
        }
        this.m_cwStack = cwStack;
    }

    protected boolean isReachable() {
        return this.m_cwStack != Integer.MIN_VALUE;
    }

    protected boolean isDiscardable() {
        return !this.isReachable();
    }

    public int getLine() {
        return this.m_iLine;
    }

    protected void setLine(int iLine) {
        this.m_iLine = iLine;
    }

    public String getName() {
        return OPNAME[this.m_iOp];
    }

    public Op getNext() {
        return this.m_opNext;
    }

    protected void setNext(Op op) {
        this.m_opNext = op;
    }

    public void print() {
        Op.out('[' + String.valueOf(this.getOffset()) + "] (" + this.getLine() + ") " + this.toString());
    }
}

