/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.net.InetAddressHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.SafeLinkedList;
import java.net.InetAddress;
import java.util.List;

public class InetAddressRangeFilter
implements Filter {
    List<long[]> m_listAuthorizedHost;

    public void addRange(InetAddress addrFrom, InetAddress addrTo) {
        long lFrom = InetAddressHelper.toLong(addrFrom);
        long lTo = InetAddressHelper.toLong(addrTo);
        this.getAuthorizedHostList().add(new long[]{lFrom, lTo});
    }

    @Override
    public boolean evaluate(Object obj) {
        InetAddress addrTarget = (InetAddress)obj;
        long lAddr = InetAddressHelper.toLong(addrTarget);
        List<long[]> listHost = this.getAuthorizedHostList();
        if (listHost != null) {
            for (long[] alAddr : listHost) {
                if (alAddr[0] > lAddr || lAddr > alAddr[1]) continue;
                return true;
            }
        }
        return false;
    }

    protected List<long[]> getAuthorizedHostList() {
        SafeLinkedList listAuthorizedHost = this.m_listAuthorizedHost;
        if (listAuthorizedHost == null) {
            this.m_listAuthorizedHost = listAuthorizedHost = new SafeLinkedList();
        }
        return listAuthorizedHost;
    }
}

