/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.BinaryDeltaCompressor;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.reflect.ComplexPofValue;
import com.tangosol.io.pof.reflect.PofReflectionHelper;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SparseArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractPofValue
extends ExternalizableHelper
implements PofValue {
    private static final Object NO_VALUE = new Object();
    private static final int REPLACE_THRESHOLD = 67;
    private PofValue m_valueParent;
    private PofContext m_ctx;
    private long m_nDecoMask;
    private ReadBuffer m_bufDecorations;
    private ReadBuffer m_bufOriginal;
    private ReadBuffer m_bufValue;
    private int m_of;
    protected int m_nType;
    protected Object m_oValue = NO_VALUE;
    private boolean m_fUniformEncoded;
    private boolean m_fDirty;
    private int m_cDirty;
    private int m_cbDirty;

    public AbstractPofValue(PofValue valueParent, ReadBuffer bufValue, PofContext ctx, int of, int nType) {
        this.m_valueParent = valueParent;
        this.m_bufValue = bufValue;
        this.m_ctx = ctx;
        this.m_nType = nType;
        this.m_of = of;
    }

    @Override
    public int getTypeId() {
        return this.m_nType;
    }

    @Override
    public PofValue getRoot() {
        PofValue value = this;
        PofValue valueParent;
        while ((valueParent = value.getParent()) != null) {
            value = valueParent;
        }
        return value;
    }

    @Override
    public PofValue getParent() {
        return this.m_valueParent;
    }

    @Override
    public Object getValue() {
        return this.getValue(-65);
    }

    @Override
    public Object getValue(Class clz) {
        return this.getValue(clz == null ? -65 : PofHelper.getPofTypeId(clz, this.m_ctx));
    }

    @Override
    public Object getValue(int nType) {
        Object oValue = this.m_oValue;
        int nValueType = this.m_nType;
        if (nType == -65) {
            nType = nValueType;
        }
        if (oValue == NO_VALUE || nType != nValueType) {
            oValue = new PofValueReader().readValue(nType);
            if (nType == nValueType) {
                this.m_oValue = oValue;
            }
        }
        return oValue;
    }

    @Override
    public void setValue(Object oValue) {
        this.m_oValue = oValue;
        this.setDirty();
    }

    @Override
    public Binary applyChanges() {
        ReadBuffer bufNewValue;
        if (!this.isRoot()) {
            throw new UnsupportedOperationException("applyChanges() method can only be invoked on the root PofValue instance.");
        }
        ReadBuffer bufOriginal = this.m_bufOriginal;
        ReadBuffer bufDeco = this.m_bufDecorations;
        ReadBuffer bufDelta = this.getChanges();
        ReadBuffer readBuffer = bufNewValue = bufDelta == null ? bufOriginal : new BinaryDeltaCompressor().applyDelta(bufOriginal, bufDelta);
        if (bufDeco == null) {
            return bufNewValue.toBinary();
        }
        int cbCap = 7 + bufNewValue.length() + bufDeco.length();
        ByteArrayWriteBuffer bufDecoValue = new ByteArrayWriteBuffer(cbCap);
        WriteBuffer.BufferOutput out = bufDecoValue.getBufferOutput();
        try {
            if (Long.highestOneBit(this.m_nDecoMask) < 256L) {
                out.writeByte(18);
                out.writeByte((int)this.m_nDecoMask);
            } else {
                out.writeByte(19);
                out.writePackedLong(this.m_nDecoMask);
            }
            AbstractPofValue.writeInt(out, bufNewValue.length());
            out.writeBuffer(bufNewValue);
            out.writeBuffer(bufDeco);
            return bufDecoValue.toBinary();
        }
        catch (IOException e) {
            throw AbstractPofValue.ensureRuntimeException(e);
        }
    }

    @Override
    public ReadBuffer getChanges() {
        if (!this.isRoot()) {
            throw new UnsupportedOperationException("getChanges() method can only be invoked on the root PofValue instance.");
        }
        if (this.m_cDirty == 0) {
            return null;
        }
        if ((long)this.getDirtyBytesCount() * 100L / (long)this.getSize() > 67L) {
            return new ReplacementEncoder().encode();
        }
        return new BinaryDiffEncoder().encode();
    }

    @Override
    public boolean getBoolean() {
        return (Boolean)this.getValue(-11);
    }

    @Override
    public byte getByte() {
        return (Byte)this.getValue(-12);
    }

    @Override
    public char getChar() {
        return ((Character)this.getValue(-14)).charValue();
    }

    @Override
    public short getShort() {
        return (Short)this.getValue(-1);
    }

    @Override
    public int getInt() {
        return (Integer)this.getValue(-2);
    }

    @Override
    public long getLong() {
        return (Long)this.getValue(-3);
    }

    @Override
    public float getFloat() {
        return ((Float)this.getValue(-5)).floatValue();
    }

    @Override
    public double getDouble() {
        return (Double)this.getValue(-6);
    }

    @Override
    public boolean[] getBooleanArray() {
        return (boolean[])this.getValue(-24);
    }

    @Override
    public byte[] getByteArray() {
        return (byte[])this.getValue(-24);
    }

    @Override
    public char[] getCharArray() {
        return (char[])this.getValue(-24);
    }

    @Override
    public short[] getShortArray() {
        return (short[])this.getValue(-24);
    }

    @Override
    public int[] getIntArray() {
        return (int[])this.getValue(-24);
    }

    @Override
    public long[] getLongArray() {
        return (long[])this.getValue(-24);
    }

    @Override
    public float[] getFloatArray() {
        return (float[])this.getValue(-24);
    }

    @Override
    public double[] getDoubleArray() {
        return (double[])this.getValue(-24);
    }

    @Override
    public BigInteger getBigInteger() {
        return (BigInteger)this.getValue(-4);
    }

    @Override
    public BigDecimal getBigDecimal() {
        return (BigDecimal)this.getValue(-10);
    }

    @Override
    public String getString() {
        return (String)this.getValue(-15);
    }

    @Override
    public Date getDate() {
        return (Date)this.getValue(-16);
    }

    @Override
    public Object[] getObjectArray() {
        return (Object[])this.getValue(-24);
    }

    @Override
    public Collection getCollection(Collection coll) {
        Collection collData = (Collection)this.getValue(-22);
        if (coll == null) {
            coll = collData;
        } else {
            coll.addAll(collData);
        }
        return coll;
    }

    @Override
    public Map getMap(Map map) {
        Map mapData = (Map)this.getValue(-28);
        if (map == null) {
            map = mapData;
        } else {
            map.putAll(mapData);
        }
        return map;
    }

    public PofContext getPofContext() {
        return this.m_ctx;
    }

    public int getOffset() {
        return this.m_of;
    }

    public int getSize() {
        return this.m_bufValue.length();
    }

    public boolean isDirty() {
        return this.m_fDirty;
    }

    protected void setDirty() {
        if (!this.isDirty()) {
            ((AbstractPofValue)this.getRoot()).incrementDirtyValuesCount();
            ((AbstractPofValue)this.getRoot()).incrementDirtyBytesCount(this.getSize());
            this.m_fDirty = true;
        }
    }

    public ReadBuffer getSerializedValue() {
        if (this.isDirty()) {
            try {
                ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(this.getSize());
                PofBufferWriter writer = new PofBufferWriter(buf.getBufferOutput(), this.m_ctx);
                writer.writeObject(this.getPropertyIndex(), this.m_oValue);
                if (this.isUniformEncoded()) {
                    ReadBuffer bufRead = buf.getReadBuffer();
                    ReadBuffer.BufferInput in = bufRead.getBufferInput();
                    in.readPackedInt();
                    int of = in.getOffset();
                    return bufRead.getReadBuffer(of, buf.length() - of);
                }
                return buf.getReadBuffer();
            }
            catch (IOException e) {
                throw AbstractPofValue.ensureRuntimeException(e);
            }
        }
        return this.m_bufValue;
    }

    protected int getPropertyIndex() {
        return 0;
    }

    protected ReadBuffer getOriginalBuffer() {
        return this.m_bufOriginal;
    }

    protected void setOriginalBuffer(ReadBuffer bufValue) {
        this.m_bufOriginal = bufValue;
    }

    protected ReadBuffer getValueBuffer() {
        return this.m_bufValue;
    }

    protected void setDecorations(long nDecoMask, ReadBuffer bufDeco) {
        this.m_nDecoMask = nDecoMask;
        this.m_bufDecorations = bufDeco;
    }

    protected boolean isRoot() {
        return this.getParent() == null;
    }

    protected boolean isUniformEncoded() {
        return this.m_fUniformEncoded;
    }

    protected void setUniformEncoded() {
        this.m_fUniformEncoded = true;
    }

    protected int getDirtyBytesCount() {
        return this.m_cbDirty;
    }

    protected void incrementDirtyValuesCount() {
        ++this.m_cDirty;
    }

    protected void incrementDirtyBytesCount(int cb) {
        this.m_cbDirty += cb;
    }

    class ReplacementEncoder
    extends BinaryDeltaCompressor {
        public ReadBuffer encode() {
            AbstractPofValue value = AbstractPofValue.this;
            ByteArrayWriteBuffer bufDelta = new ByteArrayWriteBuffer(value.getDirtyBytesCount() * 2);
            WriteBuffer.BufferOutput out = bufDelta.getBufferOutput();
            try {
                int pos = 0;
                out.write(-11);
                pos = this.encodeValue(out, value, pos);
                int cbOld = AbstractPofValue.this.getOriginalBuffer().length();
                if (pos < cbOld) {
                    this.copyFromOriginal(out, pos, cbOld - pos);
                }
                return bufDelta.getReadBuffer();
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        protected int encodeValue(WriteBuffer.BufferOutput out, AbstractPofValue value, int pos) {
            if (value.isDirty()) {
                try {
                    int of = value.getOffset();
                    if (pos < of) {
                        this.copyFromOriginal(out, pos, of - pos);
                    }
                    out.writeBuffer(value.getSerializedValue());
                    pos = of + value.getSize();
                }
                catch (IOException e) {
                    throw Base.ensureRuntimeException(e);
                }
            } else if (value instanceof ComplexPofValue) {
                Iterator it = ((ComplexPofValue)value).getChildrenIterator();
                while (it.hasNext()) {
                    pos = this.encodeValue(out, (AbstractPofValue)it.next(), pos);
                }
            }
            return pos;
        }

        protected void copyFromOriginal(WriteBuffer.BufferOutput out, int of, int cb) {
            try {
                out.writeBuffer(AbstractPofValue.this.getOriginalBuffer(), of, cb);
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    class BinaryDiffEncoder
    extends BinaryDeltaCompressor {
        public ReadBuffer encode() {
            AbstractPofValue value = AbstractPofValue.this;
            ByteArrayWriteBuffer bufDelta = new ByteArrayWriteBuffer(value.getDirtyBytesCount() * 2);
            WriteBuffer.BufferOutput out = bufDelta.getBufferOutput();
            try {
                int pos = 0;
                out.write(-12);
                pos = this.encodeValue(out, value, pos);
                int cbOld = AbstractPofValue.this.getOriginalBuffer().length();
                if (pos < cbOld) {
                    this.writeExtract(out, pos, cbOld - pos);
                }
                out.write(3);
                return bufDelta.getReadBuffer();
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        protected int encodeValue(WriteBuffer.BufferOutput out, AbstractPofValue value, int pos) {
            if (value.isDirty()) {
                int of = value.getOffset();
                if (pos < of) {
                    this.writeExtract(out, pos, of - pos);
                }
                this.writeAppend(out, value.getSerializedValue());
                pos = of + value.getSize();
            } else if (value instanceof ComplexPofValue) {
                Iterator it = ((ComplexPofValue)value).getChildrenIterator();
                while (it.hasNext()) {
                    pos = this.encodeValue(out, (AbstractPofValue)it.next(), pos);
                }
            }
            return pos;
        }

        protected WriteBuffer.BufferOutput writeAppend(WriteBuffer.BufferOutput out, ReadBuffer buf) {
            try {
                out.write(2);
                out.writePackedInt(buf.length());
                out.writeBuffer(buf);
                return out;
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        protected WriteBuffer.BufferOutput writeExtract(WriteBuffer.BufferOutput out, int of, int cb) {
            try {
                out.write(1);
                out.writePackedInt(of);
                out.writePackedInt(cb);
                return out;
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    class PofValueReader
    extends PofBufferReader {
        public PofValueReader() {
            super(AbstractPofValue.this.m_bufValue.getBufferInput(), AbstractPofValue.this.m_ctx);
        }

        public Object readValue() {
            try {
                return AbstractPofValue.this.isUniformEncoded() ? super.readAsObject(AbstractPofValue.this.m_nType) : super.readObject(0);
            }
            catch (IOException e) {
                throw PofValueReader.ensureRuntimeException(e);
            }
        }

        public Object readValue(int nType) {
            try {
                if (AbstractPofValue.this.m_nType == -37) {
                    return this.readValue();
                }
                if (AbstractPofValue.this.isUniformEncoded()) {
                    return super.readAsObject(nType);
                }
                switch (nType) {
                    case -1: {
                        return new Short(this.readShort(0));
                    }
                    case -2: {
                        return PofValueReader.makeInteger(this.readInt(0));
                    }
                    case -3: {
                        return PofValueReader.makeLong(this.readLong(0));
                    }
                    case -5: {
                        return new Float(this.readFloat(0));
                    }
                    case -6: {
                        return new Double(this.readDouble(0));
                    }
                    case -11: {
                        return this.readBoolean(0) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case -12: {
                        return new Byte(this.readByte(0));
                    }
                    case -14: {
                        return new Character(this.readChar(0));
                    }
                    case -20: 
                    case -18: 
                    case -16: {
                        return this.readDate(0);
                    }
                    case -65: {
                        return this.readValue();
                    }
                    case -27: 
                    case -25: 
                    case -24: {
                        Object o = this.readValue();
                        if (!o.getClass().isArray() && !(o instanceof SparseArray)) {
                            throw new ClassCastException(o.getClass().getName() + "is not an array");
                        }
                        return o;
                    }
                }
                return PofReflectionHelper.ensureType(this.readValue(), nType, this.m_ctx);
            }
            catch (IOException e) {
                throw PofValueReader.ensureRuntimeException(e);
            }
        }
    }
}

