/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.reflect.Codec;
import com.tangosol.util.Base;
import java.io.IOException;

public class Codecs {
    public static final Codec DEFAULT_CODEC = new DefaultCodec();

    public static <T extends Codec> Codec getCodec(Class<T> clz) {
        Codec codec;
        if (DefaultCodec.class.equals(clz)) {
            codec = DEFAULT_CODEC;
        } else {
            try {
                codec = (Codec)clz.newInstance();
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Could not instantiate custom codec " + clz);
            }
        }
        return codec;
    }

    public static class DefaultCodec
    extends AbstractCodec {
        @Override
        public Object decode(PofReader in, int index) throws IOException {
            return in.readObject(index);
        }
    }

    public static abstract class AbstractCodec
    implements Codec {
        @Override
        public void encode(PofWriter out, int index, Object value) throws IOException {
            out.writeObject(index, value);
        }
    }
}

