/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.CacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CachingMap;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class NearCache
extends CachingMap
implements NamedCache,
ClassLoaderAware {
    protected final String m_sName;
    protected final CacheService m_service;
    protected final MemberListener m_listenerBackService;
    private String m_sTier;

    public NearCache(Map mapFront, NamedCache mapBack) {
        this(mapFront, mapBack, 3);
    }

    public NearCache(Map mapFront, NamedCache mapBack, int nStrategy) {
        super(mapFront, mapBack, nStrategy);
        this.m_sName = mapBack.getCacheName();
        this.m_service = mapBack.getCacheService();
        this.m_listenerBackService = this.registerBackServiceListener();
    }

    public NamedCache getBackCache() {
        return (NamedCache)this.getBackMap();
    }

    public String getRegistrationContext() {
        return this.m_sTier;
    }

    public void setRegistrationContext(String sCtx) {
        this.m_sTier = sCtx;
    }

    @Override
    public String getCacheName() {
        return this.m_sName;
    }

    @Override
    public CacheService getCacheService() {
        return this.m_service;
    }

    @Override
    public boolean isActive() {
        try {
            return this.getFrontMap() != null && this.getBackCache().isActive();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public void release() {
        try {
            this.unregisterBackServiceListener();
            super.release();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        NamedCache cache = this.getBackCache();
        this.release();
        cache.destroy();
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.getBackCache().addMapListener(listener);
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.getBackCache().removeMapListener(listener);
    }

    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.getBackCache().addMapListener(listener, oKey, fLite);
    }

    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        this.getBackCache().removeMapListener(listener, oKey);
    }

    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.getBackCache().addMapListener(listener, filter, fLite);
    }

    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        this.getBackCache().removeMapListener(listener, filter);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        return super.put(oKey, oValue, true, cMillis);
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    @Override
    public boolean lock(Object oKey, long lMillis) {
        if (this.getBackCache().lock(oKey, lMillis)) {
            if (this.getInvalidationStrategy() == 0) {
                this.getFrontMap().remove(oKey);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean unlock(Object oKey) {
        return this.getBackCache().unlock(oKey);
    }

    @Override
    public Set keySet(Filter filter) {
        return this.getBackCache().keySet(filter);
    }

    @Override
    public Set entrySet(Filter filter) {
        return this.getBackCache().entrySet(filter);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getBackCache().entrySet(filter, comparator);
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getBackCache().addIndex(extractor, fOrdered, comparator);
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        this.getBackCache().removeIndex(extractor);
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getBackCache().invoke(oKey, agent);
    }

    @Override
    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return this.getBackCache().invokeAll(collKeys, agent);
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getBackCache().invokeAll(filter, agent);
    }

    @Override
    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return this.getBackCache().aggregate(collKeys, agent);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getBackCache().aggregate(filter, agent);
    }

    protected MemberListener registerBackServiceListener() {
        CacheService service = this.getCacheService();
        if (service != null) {
            try {
                BackServiceListener listener = new BackServiceListener();
                service.addMemberListener(listener);
                return listener;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void unregisterBackServiceListener() {
        try {
            this.getCacheService().removeMemberListener(this.m_listenerBackService);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public ClassLoader getContextClassLoader() {
        NamedCache cacheBack = this.getBackCache();
        return cacheBack instanceof ClassLoaderAware ? ((ClassLoaderAware)((Object)cacheBack)).getContextClassLoader() : Base.getContextClassLoader();
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    protected class BackServiceListener
    implements MemberListener {
        protected BackServiceListener() {
        }

        @Override
        public void memberJoined(MemberEvent evt) {
            if (evt.isLocal()) {
                try {
                    NearCache.this.unregisterFrontListener();
                    NearCache.this.getFrontMap().clear();
                    MBeanHelper.registerCacheMBean(NearCache.this, NearCache.this.getRegistrationContext());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                NearCache.this.resetInvalidationStrategy();
            }
        }

        @Override
        public void memberLeaving(MemberEvent evt) {
        }

        @Override
        public void memberLeft(MemberEvent evt) {
            if (evt.isLocal()) {
                try {
                    NearCache.this.unregisterFrontListener();
                    NearCache.this.getFrontMap().clear();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                NearCache.this.resetInvalidationStrategy();
            }
        }
    }
}

