/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.DistributionManager;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.SimpleAssignmentStrategy;
import java.util.Set;

public class MirroringAssignmentStrategy
extends SimpleAssignmentStrategy {
    protected PartitionedService m_service;
    protected String m_sService;

    public MirroringAssignmentStrategy(String sService) {
        this.m_sService = sService;
    }

    public PartitionedService getService() {
        return this.getManager().getService();
    }

    protected void setAssociatedService(PartitionedService service) {
        this.m_service = service;
    }

    public PartitionedService getAssociatedService() {
        return this.m_service;
    }

    protected boolean validateAssociatedService(PartitionedService service) {
        PartitionedService serviceThis = this.getService();
        return serviceThis.getPartitionCount() == service.getPartitionCount() && serviceThis.getBackupCount() == service.getBackupCount();
    }

    protected void syncAssignments(SimpleAssignmentStrategy.AnalysisContext ctx, PartitionedService serviceThat) {
        Set setOwnersThis = this.getService().getOwnershipEnabledMembers();
        int cPartitions = serviceThat.getPartitionCount();
        int cBackups = serviceThat.getBackupCount();
        block0: for (int iPart = 0; iPart < cPartitions; ++iPart) {
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                Member ownerThat;
                Member member = ownerThat = iStore == 0 ? serviceThat.getPartitionOwner(iPart) : serviceThat.getBackupOwner(iPart, iStore);
                if (ownerThat != null && !setOwnersThis.contains(ownerThat)) {
                    if (iStore == 0) continue block0;
                    ownerThat = null;
                }
                Ownership ownersThis = ctx.getPartitionOwnership(iPart);
                Member ownerCurr = this.getMember(ownersThis.getOwner(iStore));
                if (ownerThat == null || ownerCurr == ownerThat) continue;
                ctx.transitionPartition(iPart, iStore, ownerCurr, ownerThat);
            }
        }
    }

    @Override
    public void init(DistributionManager manager) {
        super.init(manager);
        this.bindService(this.m_sService);
    }

    protected PartitionedService bindService(String sService) {
        Cluster cluster = this.getService().getCluster();
        PartitionedService serviceThat = (PartitionedService)cluster.getService(sService);
        serviceThat = serviceThat == null || !this.validateAssociatedService(serviceThat) ? null : serviceThat;
        this.setAssociatedService(serviceThat);
        return serviceThat;
    }

    @Override
    protected long analyzeDistribution(SimpleAssignmentStrategy.AnalysisContext ctx) {
        PartitionedService serviceThis = this.getService();
        PartitionedService serviceThat = this.getAssociatedService();
        if (serviceThat == null || !serviceThat.isRunning()) {
            serviceThat = this.bindService(this.m_sService);
        }
        if (serviceThat != null) {
            this.syncAssignments(ctx, serviceThat);
        }
        if (this.isRefinementNeeded(ctx, serviceThis, serviceThat)) {
            return super.analyzeDistribution(ctx);
        }
        ctx.suggestDistribution();
        return 2000L;
    }

    protected boolean isRefinementNeeded(SimpleAssignmentStrategy.AnalysisContext ctx, PartitionedService serviceThis, PartitionedService serviceThat) {
        return serviceThat == null || !this.getManager().getOwnershipLeavingMembers().isEmpty() || !((Object)serviceThis.getOwnershipEnabledMembers()).equals(serviceThat.getOwnershipEnabledMembers());
    }
}

