/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;

public class BitHelper
extends Base {
    private static final byte[] BIT_COUNT = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final byte[] BIT_LEFTMOST = new byte[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] BIT_RIGHTMOST = new byte[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    public static byte rotateLeft(byte b, int cBits) {
        int n = b & 0xFF;
        return (byte)(n >>> 8 - (cBits &= 7) | n << cBits);
    }

    public static byte rotateRight(byte b, int cBits) {
        int n = b & 0xFF;
        return (byte)(n >>> (cBits &= 7) | n << 8 - cBits);
    }

    public static int rotateLeft(int n, int cBits) {
        return Integer.rotateLeft(n, cBits);
    }

    public static int rotateRight(int n, int cBits) {
        return Integer.rotateRight(n, cBits);
    }

    public static long rotateLeft(long n, int cBits) {
        return Long.rotateLeft(n, cBits);
    }

    public static long rotateRight(long n, int cBits) {
        return Long.rotateRight(n, cBits);
    }

    public static int countBits(byte b) {
        return BIT_COUNT[b & 0xFF];
    }

    public static int countBits(int n) {
        return Integer.bitCount(n);
    }

    public static int countBits(long l) {
        return Long.bitCount(l);
    }

    public static int indexOfMSB(byte b) {
        return BIT_LEFTMOST[b & 0xFF];
    }

    public static int indexOfMSB(int n) {
        return (long)n == 0L ? -1 : Integer.numberOfTrailingZeros(Integer.highestOneBit(n));
    }

    public static int indexOfMSB(long l) {
        return l == 0L ? -1 : Long.numberOfTrailingZeros(Long.highestOneBit(l));
    }

    public static int indexOfLSB(byte b) {
        return BIT_RIGHTMOST[b & 0xFF];
    }

    public static int indexOfLSB(int n) {
        return (long)n == 0L ? -1 : Integer.numberOfTrailingZeros(Integer.lowestOneBit(n));
    }

    public static int indexOfLSB(long l) {
        return l == 0L ? -1 : Long.numberOfTrailingZeros(Long.lowestOneBit(l));
    }

    public static String toBitString(byte b) {
        char[] ach = new char[8];
        for (int i = 7; i >= 0; --i) {
            ach[i] = (char)(48 + (b & 1));
            b = (byte)(b >>> 1);
        }
        return new String(ach);
    }

    public static String toBitString(int n) {
        char[] ach = new char[32];
        for (int i = 31; i >= 0; --i) {
            ach[i] = (char)(48 + (n & 1));
            n >>>= 1;
        }
        return new String(ach);
    }

    public static String toBitString(long l) {
        char[] ach = new char[64];
        for (int i = 63; i >= 0; --i) {
            ach[i] = (char)(48 + ((int)l & 1));
            l >>>= 1;
        }
        return new String(ach);
    }
}

