/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Date;
import java.util.Random;

public final class UUID
extends Base
implements Comparable,
Externalizable,
ExternalizableLite,
PortableObject {
    private static final int MASK_ALLFLAGS = -268435456;
    private static final int MASK_GENERATED = Integer.MIN_VALUE;
    private static final int MASK_REALADDR = 0x40000000;
    private static final int MASK_IPV6ADDR = 0x20000000;
    private static final int MASK_UNUSED = 0x10000000;
    private static final byte[] NO_BYTES = new byte[0];
    private static final Random s_rnd = UUID.getRandom();
    private static int s_nLastCount = s_rnd.nextInt();
    private static final boolean s_fRealAddress;
    private static final boolean s_fIPv6;
    private static final int s_nAddr1;
    private static final int s_nAddr2;
    private static final int s_nAddr3;
    private static final int s_nAddr4;
    private static final Object LOCK;
    private long m_lDatetime;
    private int m_nAddr1;
    private int m_nAddr2;
    private int m_nAddr3;
    private int m_nAddr4;
    private int m_nPort;
    private int m_nCount;
    private transient int m_nHash;

    public static void main(String[] asArgs) {
        try {
            if (asArgs.length <= 1) {
                int cIds = asArgs.length == 0 ? 1 : Math.max(1, Integer.parseInt(asArgs[0]));
                for (int i = 0; i < cIds; ++i) {
                    UUID uid = new UUID();
                    String sUUID = uid.toString();
                    UUID.azzert(uid.isGenerated());
                    UUID.azzert(uid.equals(new UUID(sUUID)));
                    UUID.out(uid);
                }
            } else {
                InetAddress addr = InetAddress.getByName(asArgs[0]);
                int nPort = Integer.parseInt(asArgs[1]);
                UUID uid = new UUID(new Date().getTime(), addr, nPort, s_nLastCount);
                UUID.out(uid);
            }
        }
        catch (Exception e) {
            try {
                UUID uid = new UUID(asArgs[0]);
                UUID.out("Address  =" + InetAddressHelper.toString(uid.getAddress()));
                UUID.out("Timestamp=" + new Date(uid.getTimestamp()));
                UUID.out("Port     =" + uid.getPort());
                UUID.out("MachineId=" + ((uid.getCount() & 0xFFFF0000) >>> 16));
            }
            catch (Exception ex) {
                UUID.out("Usage:");
                UUID.out("   java com.tangosol.util.UUID <number> | <UUID> | <IP> <port> <count>");
            }
        }
    }

    public UUID() {
    }

    public UUID(long lDatetime, InetAddress addr, int nPort, int nCount) {
        this(lDatetime, addr == null ? null : addr.getAddress(), nPort, nCount);
    }

    public UUID(long lDatetime, byte[] abIP, int nPort, int nCount) {
        this.m_lDatetime = lDatetime;
        this.m_nCount = nCount;
        boolean fAddr = false;
        boolean fIPv6 = false;
        if (abIP != null) {
            switch (abIP.length) {
                default: {
                    throw new IllegalArgumentException("unsupported IP address length: " + abIP.length);
                }
                case 16: {
                    this.m_nAddr4 = (abIP[12] & 0xFF) << 24 | (abIP[13] & 0xFF) << 16 | (abIP[14] & 0xFF) << 8 | abIP[15] & 0xFF;
                    this.m_nAddr3 = (abIP[8] & 0xFF) << 24 | (abIP[9] & 0xFF) << 16 | (abIP[10] & 0xFF) << 8 | abIP[11] & 0xFF;
                    this.m_nAddr2 = (abIP[4] & 0xFF) << 24 | (abIP[5] & 0xFF) << 16 | (abIP[6] & 0xFF) << 8 | abIP[7] & 0xFF;
                    fIPv6 = true;
                }
                case 4: {
                    this.m_nAddr1 = (abIP[0] & 0xFF) << 24 | (abIP[1] & 0xFF) << 16 | (abIP[2] & 0xFF) << 8 | abIP[3] & 0xFF;
                    fAddr = true;
                }
                case 0: 
            }
        }
        this.m_nPort = (fAddr ? 0x40000000 : 0) | (fIPv6 ? 0x20000000 : 0) | nPort & 0xFFFFFFF;
        this.initHashcode();
    }

    public UUID(String s) {
        this(UUID.parseHex(s));
    }

    public UUID(byte[] ab) {
        UUID.azzert(ab != null && ab.length == 32);
        this.m_lDatetime = (long)(ab[0] & 0xFF) << 56 | (long)(ab[1] & 0xFF) << 48 | (long)(ab[2] & 0xFF) << 40 | (long)(ab[3] & 0xFF) << 32 | (long)(ab[4] & 0xFF) << 24 | (long)(ab[5] & 0xFF) << 16 | (long)(ab[6] & 0xFF) << 8 | (long)(ab[7] & 0xFF);
        this.m_nAddr1 = (ab[8] & 0xFF) << 24 | (ab[9] & 0xFF) << 16 | (ab[10] & 0xFF) << 8 | ab[11] & 0xFF;
        this.m_nAddr2 = (ab[12] & 0xFF) << 24 | (ab[13] & 0xFF) << 16 | (ab[14] & 0xFF) << 8 | ab[15] & 0xFF;
        this.m_nAddr3 = (ab[16] & 0xFF) << 24 | (ab[17] & 0xFF) << 16 | (ab[18] & 0xFF) << 8 | ab[19] & 0xFF;
        this.m_nAddr4 = (ab[20] & 0xFF) << 24 | (ab[21] & 0xFF) << 16 | (ab[22] & 0xFF) << 8 | ab[23] & 0xFF;
        this.m_nPort = (ab[24] & 0xFF) << 24 | (ab[25] & 0xFF) << 16 | (ab[26] & 0xFF) << 8 | ab[27] & 0xFF;
        this.m_nCount = (ab[28] & 0xFF) << 24 | (ab[29] & 0xFF) << 16 | (ab[30] & 0xFF) << 8 | ab[31] & 0xFF;
        this.initHashcode();
    }

    public UUID(DataInput stream) throws IOException {
        this.readExternal(stream);
    }

    public boolean isGenerated() {
        this.ensureConstructed();
        return (this.m_nPort & Integer.MIN_VALUE) != 0;
    }

    public long getTimestamp() {
        this.ensureConstructed();
        return this.m_lDatetime;
    }

    public boolean isAddressIncluded() {
        this.ensureConstructed();
        return (this.m_nPort & 0x40000000) != 0;
    }

    public byte[] getAddress() {
        byte[] ab;
        this.ensureConstructed();
        switch (this.m_nPort & 0x60000000) {
            case 0x60000000: {
                int nAddr1 = this.m_nAddr1;
                int nAddr2 = this.m_nAddr2;
                int nAddr3 = this.m_nAddr3;
                int nAddr4 = this.m_nAddr4;
                ab = new byte[]{(byte)(nAddr1 >>> 24), (byte)(nAddr1 >>> 16), (byte)(nAddr1 >>> 8), (byte)nAddr1, (byte)(nAddr2 >>> 24), (byte)(nAddr2 >>> 16), (byte)(nAddr2 >>> 8), (byte)nAddr2, (byte)(nAddr3 >>> 24), (byte)(nAddr3 >>> 16), (byte)(nAddr3 >>> 8), (byte)nAddr3, (byte)(nAddr4 >>> 24), (byte)(nAddr4 >>> 16), (byte)(nAddr4 >>> 8), (byte)nAddr4};
                break;
            }
            case 0x40000000: {
                int nAddr1 = this.m_nAddr1;
                ab = new byte[]{(byte)(nAddr1 >>> 24), (byte)(nAddr1 >>> 16), (byte)(nAddr1 >>> 8), (byte)nAddr1};
                break;
            }
            case 0: {
                ab = NO_BYTES;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ab;
    }

    public int getPort() {
        this.ensureConstructed();
        return this.m_nPort & 0xFFFFFFF;
    }

    public int getCount() {
        this.ensureConstructed();
        return this.m_nCount;
    }

    public byte[] toByteArray() {
        this.ensureConstructed();
        byte[] ab = new byte[32];
        long lDatetime = this.m_lDatetime;
        int nAddr1 = this.m_nAddr1;
        int nAddr2 = this.m_nAddr2;
        int nAddr3 = this.m_nAddr3;
        int nAddr4 = this.m_nAddr4;
        int nPort = this.m_nPort;
        int nCount = this.m_nCount;
        ab[0] = (byte)(lDatetime >>> 56);
        ab[1] = (byte)(lDatetime >>> 48);
        ab[2] = (byte)(lDatetime >>> 40);
        ab[3] = (byte)(lDatetime >>> 32);
        ab[4] = (byte)(lDatetime >>> 24);
        ab[5] = (byte)(lDatetime >>> 16);
        ab[6] = (byte)(lDatetime >>> 8);
        ab[7] = (byte)lDatetime;
        ab[8] = (byte)(nAddr1 >>> 24);
        ab[9] = (byte)(nAddr1 >>> 16);
        ab[10] = (byte)(nAddr1 >>> 8);
        ab[11] = (byte)nAddr1;
        ab[12] = (byte)(nAddr2 >>> 24);
        ab[13] = (byte)(nAddr2 >>> 16);
        ab[14] = (byte)(nAddr2 >>> 8);
        ab[15] = (byte)nAddr2;
        ab[16] = (byte)(nAddr3 >>> 24);
        ab[17] = (byte)(nAddr3 >>> 16);
        ab[18] = (byte)(nAddr3 >>> 8);
        ab[19] = (byte)nAddr3;
        ab[20] = (byte)(nAddr4 >>> 24);
        ab[21] = (byte)(nAddr4 >>> 16);
        ab[22] = (byte)(nAddr4 >>> 8);
        ab[23] = (byte)nAddr4;
        ab[24] = (byte)(nPort >>> 24);
        ab[25] = (byte)(nPort >>> 16);
        ab[26] = (byte)(nPort >>> 8);
        ab[27] = (byte)nPort;
        ab[28] = (byte)(nCount >>> 24);
        ab[29] = (byte)(nCount >>> 16);
        ab[30] = (byte)(nCount >>> 8);
        ab[31] = (byte)nCount;
        return ab;
    }

    public String toString() {
        return UUID.toHexEscape(this.toByteArray());
    }

    public boolean equals(Object o) {
        this.ensureConstructed();
        if (o instanceof UUID) {
            UUID that = (UUID)o;
            return this == that || this.m_nHash == that.m_nHash && this.m_lDatetime == that.m_lDatetime && this.m_nAddr1 == that.m_nAddr1 && this.m_nAddr2 == that.m_nAddr2 && this.m_nAddr3 == that.m_nAddr3 && this.m_nAddr4 == that.m_nAddr4 && this.m_nPort == that.m_nPort && this.m_nCount == that.m_nCount;
        }
        return false;
    }

    public int compareTo(Object o) {
        this.ensureConstructed();
        int nResult = 0;
        UUID that = (UUID)o;
        if (this != that) {
            if (this.m_lDatetime != that.m_lDatetime) {
                nResult = this.m_lDatetime < that.m_lDatetime ? -1 : 1;
            } else if (this.m_nAddr1 != that.m_nAddr1) {
                nResult = this.m_nAddr1 < that.m_nAddr1 ? -1 : 1;
            } else if (this.m_nAddr2 != that.m_nAddr2) {
                nResult = this.m_nAddr2 < that.m_nAddr2 ? -1 : 1;
            } else if (this.m_nAddr3 != that.m_nAddr3) {
                nResult = this.m_nAddr3 < that.m_nAddr3 ? -1 : 1;
            } else if (this.m_nAddr4 != that.m_nAddr4) {
                nResult = this.m_nAddr4 < that.m_nAddr4 ? -1 : 1;
            } else if (this.m_nPort != that.m_nPort) {
                nResult = this.m_nPort < that.m_nPort ? -1 : 1;
            } else if (this.m_nCount != that.m_nCount) {
                nResult = this.m_nCount < that.m_nCount ? -1 : 1;
            }
        }
        return nResult;
    }

    public int hashCode() {
        this.ensureConstructed();
        return this.m_nHash;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        if (this.m_nHash != 0) {
            throw new NotActiveException();
        }
        this.m_lDatetime = in.readLong();
        this.m_nAddr1 = in.readInt();
        this.m_nAddr2 = in.readInt();
        this.m_nAddr3 = in.readInt();
        this.m_nAddr4 = in.readInt();
        this.m_nPort = in.readInt();
        this.m_nCount = in.readInt();
        this.initHashcode();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        this.ensureConstructed();
        out.writeLong(this.m_lDatetime);
        out.writeInt(this.m_nAddr1);
        out.writeInt(this.m_nAddr2);
        out.writeInt(this.m_nAddr3);
        out.writeInt(this.m_nAddr4);
        out.writeInt(this.m_nPort);
        out.writeInt(this.m_nCount);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        if (this.m_nHash != 0) {
            throw new NotActiveException();
        }
        this.m_lDatetime = in.readLong(0);
        this.m_nAddr1 = in.readInt(1);
        this.m_nAddr2 = in.readInt(2);
        this.m_nAddr3 = in.readInt(3);
        this.m_nAddr4 = in.readInt(4);
        this.m_nPort = in.readInt(5);
        this.m_nCount = in.readInt(6);
        this.initHashcode();
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        this.ensureConstructed();
        out.writeLong(0, this.m_lDatetime);
        out.writeInt(1, this.m_nAddr1);
        out.writeInt(2, this.m_nAddr2);
        out.writeInt(3, this.m_nAddr3);
        out.writeInt(4, this.m_nAddr4);
        out.writeInt(5, this.m_nPort);
        out.writeInt(6, this.m_nCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConstructed() {
        if (this.m_nHash == 0) {
            Object object = LOCK;
            synchronized (object) {
                this.m_lDatetime = UUID.getSafeTimeMillis();
                this.m_nCount = ++s_nLastCount;
            }
            boolean fRealAddress = s_fRealAddress;
            boolean fIPv6 = s_fIPv6;
            Random rnd = s_rnd;
            if (fRealAddress) {
                if (fIPv6) {
                    this.m_nAddr1 = s_nAddr1;
                    this.m_nAddr2 = s_nAddr2;
                    this.m_nAddr3 = s_nAddr3;
                    this.m_nAddr4 = s_nAddr4;
                } else {
                    this.m_nAddr1 = s_nAddr1;
                    this.m_nAddr2 = rnd.nextInt();
                    this.m_nAddr3 = rnd.nextInt();
                    this.m_nAddr4 = rnd.nextInt();
                }
            } else {
                this.m_nAddr1 = rnd.nextInt();
                this.m_nAddr2 = rnd.nextInt();
                this.m_nAddr3 = rnd.nextInt();
                this.m_nAddr4 = rnd.nextInt();
            }
            this.m_nPort = Integer.MIN_VALUE | (fRealAddress ? 0x40000000 : 0) | (fIPv6 ? 0x20000000 : 0) | rnd.nextInt() & 0xFFFFFFF;
            this.initHashcode();
        }
    }

    private void initHashcode() {
        int nHash = (int)(this.m_lDatetime >>> 32) ^ (int)this.m_lDatetime ^ this.m_nAddr1 ^ this.m_nAddr2 ^ this.m_nAddr3 ^ this.m_nAddr4 ^ this.m_nPort ^ this.m_nCount;
        if (nHash == 0) {
            nHash = Integer.MAX_VALUE;
        }
        this.m_nHash = nHash;
    }

    static {
        boolean fRealAddress = false;
        boolean fIPv6 = false;
        int nAddr1 = 0;
        int nAddr2 = 0;
        int nAddr3 = 0;
        int nAddr4 = 0;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            try {
                addr = InetAddressHelper.getLocalHost();
            }
            catch (Throwable e) {
                // empty catch block
            }
            byte[] abIP = NO_BYTES;
            if (addr != null) {
                abIP = addr.getAddress();
            }
            switch (abIP.length) {
                case 4: {
                    int nIP = (abIP[0] & 0xFF) << 24 | (abIP[1] & 0xFF) << 16 | (abIP[2] & 0xFF) << 8 | abIP[3] & 0xFF;
                    if (nIP != 0 && nIP != 2130706433) {
                        fRealAddress = true;
                        nAddr1 = nIP;
                    }
                    break;
                }
                case 16: {
                    int nIP1 = (abIP[0] & 0xFF) << 24 | (abIP[1] & 0xFF) << 16 | (abIP[2] & 0xFF) << 8 | abIP[3] & 0xFF;
                    int nIP2 = (abIP[4] & 0xFF) << 24 | (abIP[5] & 0xFF) << 16 | (abIP[6] & 0xFF) << 8 | abIP[7] & 0xFF;
                    int nIP3 = (abIP[8] & 0xFF) << 24 | (abIP[9] & 0xFF) << 16 | (abIP[10] & 0xFF) << 8 | abIP[11] & 0xFF;
                    int nIP4 = (abIP[12] & 0xFF) << 24 | (abIP[13] & 0xFF) << 16 | (abIP[14] & 0xFF) << 8 | abIP[15] & 0xFF;
                    if (nIP1 == 0 && nIP2 == 0 && nIP3 == 0 && (nIP4 == 0 || nIP4 == 1) || (abIP[0] & 0xFF) == 254 && (abIP[1] & 0xC0) == 128) break;
                    fRealAddress = true;
                    fIPv6 = true;
                    nAddr1 = nIP1;
                    nAddr2 = nIP2;
                    nAddr3 = nIP3;
                    nAddr4 = nIP4;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        s_fRealAddress = fRealAddress;
        s_fIPv6 = fIPv6;
        s_nAddr1 = nAddr1;
        s_nAddr2 = nAddr2;
        s_nAddr3 = nAddr3;
        s_nAddr4 = nAddr4;
        LOCK = Object.class;
    }
}

