package org.gridvise

import org.gridvise.mgmtcache.coh.entity.executioncontext.{DefaultExecutionContext, ExecutionContext}
import org.gridvise.mgmtcache.coh.invocation.tasks.runbook.{RunBookLoadTask, RunBookTask, RunActivityTask}
import org.gridvise.mgmtcache.coh.invocation.ManagementInvocationService


object RemoteRunBookAPI {

  var executionContext = new DefaultExecutionContext(RemoteAPI.machineNames())

  def invokeRunBookActivity(runBookId: String, activityId: String, vars: Map[String, String]): String = {
    invokeRunBookActivity(executionContext, runBookId,activityId, vars)
  }

  def invokeRunBookActivity(executionContext: ExecutionContext, runBookId: String, activityId: String, vars: Map[String, String]): String = {
    val r = new RunActivityTask(runBookId, activityId)
    r.setVars(vars)
    r.setExcecutionContext(executionContext)
    ManagementInvocationService.queryOnAllMembers(r).toString
  }

  def invokeRunBook(runBookId: String, vars: Map[String, String]): String =  {
    invokeRunBook(executionContext, runBookId, vars)
  }

  def invokeRunBook(executionContext: ExecutionContext, runBookId: String, vars: Map[String, String]): String =  {
    val r = new RunBookTask(runBookId)
    r.setVars(vars)
    r.setExcecutionContext(executionContext)
    ManagementInvocationService.queryOnAllMembers(r).toString
  }

  def loadRunBook(executionContext: ExecutionContext, runBookId : String): String = {
    val r = new RunBookLoadTask(runBookId)
    r.setExcecutionContext(executionContext)
    ManagementInvocationService.queryOnAllMembers(r).toString
  }

}
